% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk2011.2-data.R
\docType{data}
\encoding{UTF-8}
\name{sk2011.2}
\alias{sk2011.2}
\title{Data from Singmann & Klauer (2011, Experiment 2)}
\format{
A data.frame with 2268 rows and 9 variables.
}
\source{
Singmann, H., & Klauer, K. C. (2011). Deductive and inductive conditional inferences: Two modes of reasoning. Thinking & Reasoning, 17(3), 247-281. doi:10.1080/13546783.2011.572718
}
\usage{
sk2011.2
}
\description{
Singmann and Klauer (2011) were interested in whether or not conditional reasoning can be explained by a single process or whether multiple processes are necessary to explain it. To provide evidence for multiple processes we aimed to establish a double dissociation of two variables: instruction type and problem type. Instruction type was manipulated between-subjects, one group of participants received  deductive instructions (i.e., to treat the premises as given and only draw necessary conclusions) and a second group of participants received probabilistic instructions (i.e., to reason as in an everyday situation; we called this "inductive instruction" in the manuscript). Problem type consisted of two different orthogonally crossed variables that were manipulated within-subjects, validity of the problem (formally valid or formally invalid) and type of the problem. Problem type consistent of three levels: prological problems (i.e., problems in which background knowledge suggested to accept valid but reject invalid conclusions), neutral problems (i.e., in which background knowledge suggested to reject all problems), and counterlogical problems (i.e., problems in which background knowledge suggested to reject valid but accept invalid conclusions).
}
\details{
This data set contains 63 participants in contrast to the originally reported 56 participants. The additional participants were not included in the original studies as they did not meet the inclusion criteria (i.e., no students, prior education in logic, or participated in a similar experiment). The IDs of those additional participants are: 7, 8, 9, 12, 17, 24, 30. The excluded participant reported in the paper has ID 16.

content has the following levels (C = content/conditional):\cr
    1 = Wenn eine Person in ein Schwimmbecken gefallen ist, dann ist sie nass.\cr
    2 = Wenn ein Hund Flöhe hat, dann kratzt er sich hin und wieder.\cr
    3 = Wenn eine Seifenblase mit einer Nadel gestochen wurde, dann platzt sie.\cr
    4 = Wenn ein Mädchen Geschlechtsverkehr vollzogen hat, dann ist es schwanger.\cr
    5 = Wenn eine Pflanze ausreichend gegossen wird, dann bleibt sie grün.\cr
    6 = Wenn sich eine Person die Zähne putzt, dann bekommt sie KEIN Karies.\cr
    7 = Wenn eine Person viel Cola trinkt, dann nimmt sie an Gewicht zu.\cr
    8 = Wenn eine Person die Klimaanlage angeschaltet hat, dann fröstelt sie.\cr
    9 = Wenn eine Person viel lernt, dann wird sie in der Klausur eine gute Note erhalten.
}
\examples{
data("sk2011.2")

## remove excluded participants:

sk2_final <- droplevels(sk2011.2[!(sk2011.2$id \%in\% c(7, 8, 9, 12, 16, 17, 24, 30)),])
str(sk2_final)

## Table 2 (inference = problem):
aov_ez("id", "response", sk2_final[sk2_final$what == "affirmation",], 
       between = "instruction", within = c("inference", "type"),
       anova_table=list(es = "pes"))

aov_ez("id", "response", sk2_final[sk2_final$what == "denial",], 
       between = "instruction", within = c("inference", "type"),
       anova_table=list(es = "pes"))

# Recreate Figure 4 (corrected version):

sk2_aff <- droplevels(sk2_final[sk2_final$what == "affirmation",])
sk2_aff$type2 <- factor(sk2_aff$inference:sk2_aff$type, levels = c("MP:prological", 
                            "MP:neutral", "MP:counterlogical", "AC:counterlogical", 
                            "AC:neutral", "AC:prological"))
a1_b <- aov_ez("id", "response", sk2_aff, 
       between = "instruction", within = c("type2"))

sk2_den <- droplevels(sk2_final[sk2_final$what == "denial",])
sk2_den$type2 <- factor(sk2_den$inference:sk2_den$type, levels = c("MT:prological", 
                            "MT:neutral", "MT:counterlogical", "DA:counterlogical", 
                            "DA:neutral","DA:prological"))
a2_b <- aov_ez("id", "response", sk2_den, 
       between = "instruction", within = c("type2"))

if (requireNamespace("emmeans") && requireNamespace("ggplot2")) {
  afex_plot(a1_b,"type2", "instruction") + 
    ggplot2::coord_cartesian(ylim = c(0, 100))
  afex_plot(a2_b,"type2", "instruction") + 
    ggplot2::coord_cartesian(ylim = c(0, 100))
}
}
\keyword{dataset}
