% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene-relevance-plotting-differential-map.r,
%   R/gene-relevance-plotting-gr-map.r, R/gene-relevance-plotting-rank.r,
%   R/gene-relevance-plotting.r
\name{plot_differential_map}
\alias{plot_differential_map}
\alias{plot_differential_map,matrix,matrix-method}
\alias{plot_differential_map,DiffusionMap,missing-method}
\alias{plot_differential_map,GeneRelevance,missing-method}
\alias{plot_gene_relevance}
\alias{plot_gene_relevance,matrix,matrix-method}
\alias{plot_gene_relevance,DiffusionMap,missing-method}
\alias{plot_gene_relevance,GeneRelevance,missing-method}
\alias{plot_gene_relevance_rank}
\alias{plot_gene_relevance_rank,matrix,matrix-method}
\alias{plot_gene_relevance_rank,DiffusionMap,missing-method}
\alias{plot_gene_relevance_rank,GeneRelevance,missing-method}
\alias{Gene Relevance plotting}
\alias{plot,GeneRelevance,character-method}
\alias{plot,GeneRelevance,numeric-method}
\alias{plot,GeneRelevance,missing-method}
\title{Plot gene relevance or differential map}
\usage{
plot_differential_map(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  pal = hcl.colors,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_differential_map}{matrix,matrix}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  pal = hcl.colors,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_differential_map}{DiffusionMap,missing}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  pal = hcl.colors,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_differential_map}{GeneRelevance,missing}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  pal = hcl.colors,
  faceter = facet_wrap(~Gene)
)

plot_gene_relevance(
  coords,
  exprs,
  ...,
  iter_smooth = 2L,
  n_top = 10L,
  genes = NULL,
  dims = 1:2,
  pal = palette(),
  col_na = "grey",
  limit = TRUE
)

\S4method{plot_gene_relevance}{matrix,matrix}(
  coords,
  exprs,
  ...,
  iter_smooth = 2L,
  n_top = 10L,
  genes = NULL,
  dims = 1:2,
  pal = palette(),
  col_na = "grey",
  limit = TRUE
)

\S4method{plot_gene_relevance}{DiffusionMap,missing}(
  coords,
  exprs,
  ...,
  iter_smooth = 2L,
  n_top = 10L,
  genes = NULL,
  dims = 1:2,
  pal = palette(),
  col_na = "grey",
  limit = TRUE
)

\S4method{plot_gene_relevance}{GeneRelevance,missing}(
  coords,
  exprs,
  ...,
  iter_smooth = 2L,
  n_top = 10L,
  genes = NULL,
  dims = 1:2,
  pal = palette(),
  col_na = "grey",
  limit = TRUE
)

plot_gene_relevance_rank(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  n_top = 10L,
  pal = c("#3B99B1", "#F5191C"),
  bins = 10L,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_gene_relevance_rank}{matrix,matrix}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  n_top = 10L,
  pal = c("#3B99B1", "#F5191C"),
  bins = 10L,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_gene_relevance_rank}{DiffusionMap,missing}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  n_top = 10L,
  pal = c("#3B99B1", "#F5191C"),
  bins = 10L,
  faceter = facet_wrap(~Gene)
)

\S4method{plot_gene_relevance_rank}{GeneRelevance,missing}(
  coords,
  exprs,
  ...,
  genes,
  dims = 1:2,
  n_top = 10L,
  pal = c("#3B99B1", "#F5191C"),
  bins = 10L,
  faceter = facet_wrap(~Gene)
)

\S4method{plot}{GeneRelevance,character}(x, y, ...)

\S4method{plot}{GeneRelevance,numeric}(x, y, ...)

\S4method{plot}{GeneRelevance,missing}(x, y, ...)
}
\arguments{
\item{coords}{A \code{\link{DiffusionMap}}/\code{\link[=gene_relevance]{GeneRelevance}} object or a cells \eqn{\times} dims \code{\link{matrix}}.}

\item{exprs}{An cells \eqn{\times} genes \code{\link{matrix}}. Only provide if \code{coords} is a matrix.}

\item{...}{Passed to \code{plot_differential_map}/\code{plot_gene_relevance}.}

\item{genes}{Genes to base relevance map on (vector of strings).
You can also pass an index into the gene names (vector of numbers or logicals with length > 1).
The default NULL means all genes.}

\item{dims}{Names or indices of dimensions to plot. When not plotting a \code{\link[=gene_relevance]{GeneRelevance}} object, the relevance for the dimensions \code{1:max(dims)} will be calculated.}

\item{pal}{Palette. Either A colormap function or a list of colors.}

\item{faceter}{A ggplot faceter like \code{\link[ggplot2]{facet_wrap}(~ Gene)}.}

\item{iter_smooth}{Number of label smoothing iterations to perform on relevance map.
The higher the more homogenous and the less local structure.}

\item{n_top}{Number the top n genes per cell count towards the score defining which genes to return and plot in the relevance map.}

\item{col_na}{Color for cells that end up with no most relevant gene.}

\item{limit}{Limit the amount of displayed gene labels to the amount of available colors in \code{pal}?}

\item{bins}{Number of hexagonal bins for \code{plot_gene_relevance_rank}.}

\item{x}{\code{\link[=gene_relevance]{GeneRelevance}} object.}

\item{y}{Gene name(s) or index/indices to create differential map for. (integer or character)}
}
\value{
ggplot2 plot, when plotting a relevance map with a list member \code{$ids} containing the gene IDs used.
}
\description{
\code{plot(gene_relevance, 'Gene')} plots the differential map of this/these gene(s),
\code{plot(gene_relevance)} a relevance map of a selection of genes.
Alternatively, you can use \code{plot_differential_map} or \code{plot_gene_relevance} on a \code{\link[=gene_relevance]{GeneRelevance}} or \code{\link{DiffusionMap}} object, or with two matrices.
}
\examples{
data(guo_norm)
dm <- DiffusionMap(guo_norm)
gr <- gene_relevance(dm)
plot(gr)          # or plot_gene_relevance(dm)
plot(gr, 'Fgf4')  # or plot_differential_map(dm, 'Fgf4')

guo_norm_mat <- t(Biobase::exprs(guo_norm))
pca <- prcomp(guo_norm_mat)$x
plot_gene_relevance(pca, guo_norm_mat, dims = 2:3)
plot_differential_map(pca, guo_norm_mat, genes = c('Fgf4', 'Nanog'))

}
\seealso{
\code{\link{gene_relevance}}, \link{Gene Relevance methods}
}
