/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "tcpreceiverthread.h"

TcpReceiverThread::TcpReceiverThread(QObject *parent)
 : ReceiverThread(parent)
{
}


TcpReceiverThread::~TcpReceiverThread()
{
}

void TcpReceiverThread::run()
{
  m_socket = new QChatSocket(this);

//   m_socket->moveToThread(this);

  connect(m_socket, SIGNAL(newDtgrm()), this, SLOT(receiving()));
//   connect(m_socket, SIGNAL(loginFinished(int, QString)), this, SLOT(loginFinished(int, QString)));
  connect(m_socket, SIGNAL(disconnected()), this, SIGNAL(disconnected()));
  exec();
}

void TcpReceiverThread::changePort(quint16 /*port*/)
{

}

int TcpReceiverThread::readData(char* buffer, uint bufferSize)
{
  int dataSize = -2;

  if(m_socket->state() == QAbstractSocket::ConnectedState)
    dataSize = m_socket->readDtgrm(buffer, bufferSize);

  return dataSize;
}

void TcpReceiverThread::login(const QString & nick, const QHostAddress & addr, uint port, const QString& pwd)
{
  m_socket->disconnectFromHost();

  qDebug("[TcpReceiverThread::login]: connecting to %s:%d", addr.toString().toAscii().data(), port);

  m_socket->connectToHost(addr, port);

  if(m_socket->waitForConnected(10000))
    m_socket->login(nick, pwd);
  else
    emit loginFinished(1);
}
