/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SHORTCUTBUTTON_H
#define SHORTCUTBUTTON_H

#include <QPushButton>
#include <QKeyEvent>
#include <QKeySequence>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class ShortcutButton : public QPushButton
{
  Q_OBJECT
  private:
    QKeySequence m_sequence;

  private:
    int validKey(int);
    void setShortcutText(QKeyEvent*);

  public:
    ShortcutButton(QWidget *parent = 0);
    ~ShortcutButton();

  protected:
    void keyPressEvent(QKeyEvent*);
    void keyReleaseEvent(QKeyEvent*);

  signals:
    void sequenceAccepted(const QKeySequence&);
};

#endif
