
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_HAsciiString.hxx>
#include <Transfer_FinderProcess.hxx>
#include <TopoDS_Shape.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Shape.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_BrepWithVoids.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Solid.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <StepShape_FacetedBrep.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Shell.hxx>
#include <Transfer_FinderProcess.hxx>
#include <TopoDS_Solid.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_FacetedBrepAndBrepWithVoids.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Solid.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_GeometricCurveSet.hxx>
#include <TopoDS_Shape.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <StepShape_ManifoldSolidBrep.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Shell.hxx>
#include <Transfer_FinderProcess.hxx>
#include <TopoDS_Solid.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_ShellBasedSurfaceModel.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Face.hxx>
#include <Transfer_FinderProcess.hxx>
#include <TopoDS_Shell.hxx>
#include <TopoDS_Solid.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Shell.hxx>
#include <Transfer_FinderProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_StepModel.hxx>
#include <StepShape_TopologicalRepresentationItem.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_Factors.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <Transfer_FinderProcess.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>

// module includes
#include <TopoDSToStep.hxx>
#include <TopoDSToStep_Builder.hxx>
#include <TopoDSToStep_BuilderError.hxx>
#include <TopoDSToStep_FacetedError.hxx>
#include <TopoDSToStep_FacetedTool.hxx>
#include <TopoDSToStep_MakeBrepWithVoids.hxx>
#include <TopoDSToStep_MakeEdgeError.hxx>
#include <TopoDSToStep_MakeFaceError.hxx>
#include <TopoDSToStep_MakeFacetedBrep.hxx>
#include <TopoDSToStep_MakeFacetedBrepAndBrepWithVoids.hxx>
#include <TopoDSToStep_MakeGeometricCurveSet.hxx>
#include <TopoDSToStep_MakeManifoldSolidBrep.hxx>
#include <TopoDSToStep_MakeShellBasedSurfaceModel.hxx>
#include <TopoDSToStep_MakeStepEdge.hxx>
#include <TopoDSToStep_MakeStepFace.hxx>
#include <TopoDSToStep_MakeStepVertex.hxx>
#include <TopoDSToStep_MakeStepWire.hxx>
#include <TopoDSToStep_MakeTessellatedItem.hxx>
#include <TopoDSToStep_MakeVertexError.hxx>
#include <TopoDSToStep_MakeWireError.hxx>
#include <TopoDSToStep_Root.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <TopoDSToStep_WireframeBuilder.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_TopoDSToStep(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("TopoDSToStep"));
py::object klass;

//Python trampoline classes

// classes

    // Class TopoDSToStep from ./opencascade/TopoDSToStep.hxx
    klass = m.attr("TopoDSToStep");

    // default constructor
    register_default_constructor<TopoDSToStep , shared_ptr<TopoDSToStep>>(m,"TopoDSToStep");

    // nested enums

    static_cast<py::class_<TopoDSToStep , shared_ptr<TopoDSToStep>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DecodeBuilderError_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_BuilderError  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_BuilderError  ) >(&TopoDSToStep::DecodeBuilderError),
                    R"#(None)#"  , py::arg("E")
          )
        .def_static("DecodeFaceError_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeFaceError  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeFaceError  ) >(&TopoDSToStep::DecodeFaceError),
                    R"#(None)#"  , py::arg("E")
          )
        .def_static("DecodeWireError_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeWireError  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeWireError  ) >(&TopoDSToStep::DecodeWireError),
                    R"#(None)#"  , py::arg("E")
          )
        .def_static("DecodeEdgeError_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeEdgeError  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeEdgeError  ) >(&TopoDSToStep::DecodeEdgeError),
                    R"#(None)#"  , py::arg("E")
          )
        .def_static("DecodeVertexError_s",
                    (opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeVertexError  ) ) static_cast<opencascade::handle<TCollection_HAsciiString> (*)( const TopoDSToStep_MakeVertexError  ) >(&TopoDSToStep::DecodeVertexError),
                    R"#(Returns a new shape without undirect surfaces.)#"  , py::arg("E")
          )
        .def_static("AddResult_s",
                    (void (*)( const opencascade::handle<Transfer_FinderProcess> & ,  const TopoDS_Shape & ,  const opencascade::handle<Standard_Transient> &  ) ) static_cast<void (*)( const opencascade::handle<Transfer_FinderProcess> & ,  const TopoDS_Shape & ,  const opencascade::handle<Standard_Transient> &  ) >(&TopoDSToStep::AddResult),
                    R"#(Adds an entity into the list of results (binders) for shape stored in FinderProcess)#"  , py::arg("FP"),  py::arg("Shape"),  py::arg("entity")
          )
        .def_static("AddResult_s",
                    (void (*)( const opencascade::handle<Transfer_FinderProcess> & ,  const TopoDSToStep_Tool &  ) ) static_cast<void (*)( const opencascade::handle<Transfer_FinderProcess> & ,  const TopoDSToStep_Tool &  ) >(&TopoDSToStep::AddResult),
                    R"#(Adds all entities recorded in Tool into the map of results (binders) stored in FinderProcess)#"  , py::arg("FP"),  py::arg("Tool")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopoDSToStep_FacetedTool from ./opencascade/TopoDSToStep_FacetedTool.hxx
    klass = m.attr("TopoDSToStep_FacetedTool");

    // default constructor
    register_default_constructor<TopoDSToStep_FacetedTool , shared_ptr<TopoDSToStep_FacetedTool>>(m,"TopoDSToStep_FacetedTool");

    // nested enums

    static_cast<py::class_<TopoDSToStep_FacetedTool , shared_ptr<TopoDSToStep_FacetedTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("CheckTopoDSShape_s",
                    (TopoDSToStep_FacetedError (*)( const TopoDS_Shape &  ) ) static_cast<TopoDSToStep_FacetedError (*)( const TopoDS_Shape &  ) >(&TopoDSToStep_FacetedTool::CheckTopoDSShape),
                    R"#(None)#"  , py::arg("SH")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopoDSToStep_Root from ./opencascade/TopoDSToStep_Root.hxx
    klass = m.attr("TopoDSToStep_Root");


    // nested enums

    static_cast<py::class_<TopoDSToStep_Root , shared_ptr<TopoDSToStep_Root>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsDone",
             (Standard_Boolean (TopoDSToStep_Root::*)() const) static_cast<Standard_Boolean (TopoDSToStep_Root::*)() const>(&TopoDSToStep_Root::IsDone),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def_property("Tolerance",
                     [](TopoDSToStep_Root& self){return self.Tolerance();} ,
                     [](TopoDSToStep_Root& self, Standard_Real  val){self.Tolerance() = val;},                      R"#(Returns (modifiable) the tolerance to be used for writing If not set, starts at 0.0001)#"
         )
;

    // Class TopoDSToStep_Tool from ./opencascade/TopoDSToStep_Tool.hxx
    klass = m.attr("TopoDSToStep_Tool");


    // nested enums

    static_cast<py::class_<TopoDSToStep_Tool , shared_ptr<TopoDSToStep_Tool>  >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<StepData_StepModel> & >()  , py::arg("theModel") )
        .def(py::init<  const NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> &,const Standard_Boolean,Standard_Integer >()  , py::arg("M"),  py::arg("FacetedContext"),  py::arg("theSurfCurveMode") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_Tool::*)(  const NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  const Standard_Boolean ,  Standard_Integer  ) ) static_cast<void (TopoDSToStep_Tool::*)(  const NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  const Standard_Boolean ,  Standard_Integer  ) >(&TopoDSToStep_Tool::Init),
             R"#(None)#"  , py::arg("M"),  py::arg("FacetedContext"),  py::arg("theSurfCurveMode")
          )
        .def("IsBound",
             (Standard_Boolean (TopoDSToStep_Tool::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (TopoDSToStep_Tool::*)( const TopoDS_Shape &  ) >(&TopoDSToStep_Tool::IsBound),
             R"#(None)#"  , py::arg("S")
          )
        .def("Bind",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Shape & ,  const opencascade::handle<StepShape_TopologicalRepresentationItem> &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Shape & ,  const opencascade::handle<StepShape_TopologicalRepresentationItem> &  ) >(&TopoDSToStep_Tool::Bind),
             R"#(None)#"  , py::arg("S"),  py::arg("T")
          )
        .def("Find",
             (opencascade::handle<StepShape_TopologicalRepresentationItem> (TopoDSToStep_Tool::*)( const TopoDS_Shape &  ) ) static_cast<opencascade::handle<StepShape_TopologicalRepresentationItem> (TopoDSToStep_Tool::*)( const TopoDS_Shape &  ) >(&TopoDSToStep_Tool::Find),
             R"#(None)#"  , py::arg("S")
          )
        .def("Faceted",
             (Standard_Boolean (TopoDSToStep_Tool::*)() const) static_cast<Standard_Boolean (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::Faceted),
             R"#(None)#" 
          )
        .def("SetCurrentShell",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Shell &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Shell &  ) >(&TopoDSToStep_Tool::SetCurrentShell),
             R"#(None)#"  , py::arg("S")
          )
        .def("SetCurrentFace",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Face &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Face &  ) >(&TopoDSToStep_Tool::SetCurrentFace),
             R"#(None)#"  , py::arg("F")
          )
        .def("SetCurrentWire",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Wire &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Wire &  ) >(&TopoDSToStep_Tool::SetCurrentWire),
             R"#(None)#"  , py::arg("W")
          )
        .def("SetCurrentEdge",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Edge &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Edge &  ) >(&TopoDSToStep_Tool::SetCurrentEdge),
             R"#(None)#"  , py::arg("E")
          )
        .def("SetCurrentVertex",
             (void (TopoDSToStep_Tool::*)( const TopoDS_Vertex &  ) ) static_cast<void (TopoDSToStep_Tool::*)( const TopoDS_Vertex &  ) >(&TopoDSToStep_Tool::SetCurrentVertex),
             R"#(None)#"  , py::arg("V")
          )
        .def("Lowest3DTolerance",
             (Standard_Real (TopoDSToStep_Tool::*)() const) static_cast<Standard_Real (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::Lowest3DTolerance),
             R"#(None)#" 
          )
        .def("SetSurfaceReversed",
             (void (TopoDSToStep_Tool::*)( const Standard_Boolean  ) ) static_cast<void (TopoDSToStep_Tool::*)( const Standard_Boolean  ) >(&TopoDSToStep_Tool::SetSurfaceReversed),
             R"#(None)#"  , py::arg("B")
          )
        .def("SurfaceReversed",
             (Standard_Boolean (TopoDSToStep_Tool::*)() const) static_cast<Standard_Boolean (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::SurfaceReversed),
             R"#(None)#" 
          )
        .def("PCurveMode",
             (Standard_Integer (TopoDSToStep_Tool::*)() const) static_cast<Standard_Integer (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::PCurveMode),
             R"#(Returns mode for writing pcurves (initialized by parameter write.surfacecurve.mode))#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("CurrentShell",
             (const TopoDS_Shell & (TopoDSToStep_Tool::*)() const) static_cast<const TopoDS_Shell & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::CurrentShell),
             R"#(None)#"
             
         )
       .def("CurrentFace",
             (const TopoDS_Face & (TopoDSToStep_Tool::*)() const) static_cast<const TopoDS_Face & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::CurrentFace),
             R"#(None)#"
             
         )
       .def("CurrentWire",
             (const TopoDS_Wire & (TopoDSToStep_Tool::*)() const) static_cast<const TopoDS_Wire & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::CurrentWire),
             R"#(None)#"
             
         )
       .def("CurrentEdge",
             (const TopoDS_Edge & (TopoDSToStep_Tool::*)() const) static_cast<const TopoDS_Edge & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::CurrentEdge),
             R"#(None)#"
             
         )
       .def("CurrentVertex",
             (const TopoDS_Vertex & (TopoDSToStep_Tool::*)() const) static_cast<const TopoDS_Vertex & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::CurrentVertex),
             R"#(None)#"
             
         )
       .def("Map",
             (const MoniTool_DataMapOfShapeTransient & (TopoDSToStep_Tool::*)() const) static_cast<const MoniTool_DataMapOfShapeTransient & (TopoDSToStep_Tool::*)() const>(&TopoDSToStep_Tool::Map),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_Builder from ./opencascade/TopoDSToStep_Builder.hxx
    klass = m.attr("TopoDSToStep_Builder");


    // nested enums

    static_cast<py::class_<TopoDSToStep_Builder , shared_ptr<TopoDSToStep_Builder>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Shape &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const Standard_Integer,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("T"),  py::arg("FP"),  py::arg("theTessellatedGeomParam"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_Builder::*)( const TopoDS_Shape & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Standard_Integer ,  const StepData_Factors & ,  const Message_ProgressRange &  ) ) static_cast<void (TopoDSToStep_Builder::*)( const TopoDS_Shape & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Standard_Integer ,  const StepData_Factors & ,  const Message_ProgressRange &  ) >(&TopoDSToStep_Builder::Init),
             R"#(None)#"  , py::arg("S"),  py::arg("T"),  py::arg("FP"),  py::arg("theTessellatedGeomParam"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Error",
             (TopoDSToStep_BuilderError (TopoDSToStep_Builder::*)() const) static_cast<TopoDSToStep_BuilderError (TopoDSToStep_Builder::*)() const>(&TopoDSToStep_Builder::Error),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_Builder::*)() const) static_cast<const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_Builder::*)() const>(&TopoDSToStep_Builder::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_Builder::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_Builder::*)() const>(&TopoDSToStep_Builder::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeBrepWithVoids from ./opencascade/TopoDSToStep_MakeBrepWithVoids.hxx
    klass = m.attr("TopoDSToStep_MakeBrepWithVoids");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeBrepWithVoids , shared_ptr<TopoDSToStep_MakeBrepWithVoids>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Solid &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_BrepWithVoids> & (TopoDSToStep_MakeBrepWithVoids::*)() const) static_cast<const opencascade::handle<StepShape_BrepWithVoids> & (TopoDSToStep_MakeBrepWithVoids::*)() const>(&TopoDSToStep_MakeBrepWithVoids::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeBrepWithVoids::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeBrepWithVoids::*)() const>(&TopoDSToStep_MakeBrepWithVoids::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeFacetedBrep from ./opencascade/TopoDSToStep_MakeFacetedBrep.hxx
    klass = m.attr("TopoDSToStep_MakeFacetedBrep");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeFacetedBrep , shared_ptr<TopoDSToStep_MakeFacetedBrep>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shell &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
        .def(py::init< const TopoDS_Solid &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_FacetedBrep> & (TopoDSToStep_MakeFacetedBrep::*)() const) static_cast<const opencascade::handle<StepShape_FacetedBrep> & (TopoDSToStep_MakeFacetedBrep::*)() const>(&TopoDSToStep_MakeFacetedBrep::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeFacetedBrep::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeFacetedBrep::*)() const>(&TopoDSToStep_MakeFacetedBrep::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeFacetedBrepAndBrepWithVoids from ./opencascade/TopoDSToStep_MakeFacetedBrepAndBrepWithVoids.hxx
    klass = m.attr("TopoDSToStep_MakeFacetedBrepAndBrepWithVoids");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeFacetedBrepAndBrepWithVoids , shared_ptr<TopoDSToStep_MakeFacetedBrepAndBrepWithVoids>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Solid &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_FacetedBrepAndBrepWithVoids> & (TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::*)() const) static_cast<const opencascade::handle<StepShape_FacetedBrepAndBrepWithVoids> & (TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::*)() const>(&TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::*)() const>(&TopoDSToStep_MakeFacetedBrepAndBrepWithVoids::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeGeometricCurveSet from ./opencascade/TopoDSToStep_MakeGeometricCurveSet.hxx
    klass = m.attr("TopoDSToStep_MakeGeometricCurveSet");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeGeometricCurveSet , shared_ptr<TopoDSToStep_MakeGeometricCurveSet>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shape &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors & >()  , py::arg("SH"),  py::arg("FP"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_GeometricCurveSet> & (TopoDSToStep_MakeGeometricCurveSet::*)() const) static_cast<const opencascade::handle<StepShape_GeometricCurveSet> & (TopoDSToStep_MakeGeometricCurveSet::*)() const>(&TopoDSToStep_MakeGeometricCurveSet::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeManifoldSolidBrep from ./opencascade/TopoDSToStep_MakeManifoldSolidBrep.hxx
    klass = m.attr("TopoDSToStep_MakeManifoldSolidBrep");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeManifoldSolidBrep , shared_ptr<TopoDSToStep_MakeManifoldSolidBrep>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shell &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
        .def(py::init< const TopoDS_Solid &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_ManifoldSolidBrep> & (TopoDSToStep_MakeManifoldSolidBrep::*)() const) static_cast<const opencascade::handle<StepShape_ManifoldSolidBrep> & (TopoDSToStep_MakeManifoldSolidBrep::*)() const>(&TopoDSToStep_MakeManifoldSolidBrep::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeManifoldSolidBrep::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeManifoldSolidBrep::*)() const>(&TopoDSToStep_MakeManifoldSolidBrep::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeShellBasedSurfaceModel from ./opencascade/TopoDSToStep_MakeShellBasedSurfaceModel.hxx
    klass = m.attr("TopoDSToStep_MakeShellBasedSurfaceModel");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeShellBasedSurfaceModel , shared_ptr<TopoDSToStep_MakeShellBasedSurfaceModel>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init< const TopoDS_Face &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("F"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
        .def(py::init< const TopoDS_Shell &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
        .def(py::init< const TopoDS_Solid &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors &,const Message_ProgressRange & >()  , py::arg("S"),  py::arg("FP"),  py::arg("theLocalFactors"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_ShellBasedSurfaceModel> & (TopoDSToStep_MakeShellBasedSurfaceModel::*)() const) static_cast<const opencascade::handle<StepShape_ShellBasedSurfaceModel> & (TopoDSToStep_MakeShellBasedSurfaceModel::*)() const>(&TopoDSToStep_MakeShellBasedSurfaceModel::Value),
             R"#(None)#"
             
         )
       .def("TessellatedValue",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeShellBasedSurfaceModel::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeShellBasedSurfaceModel::*)() const>(&TopoDSToStep_MakeShellBasedSurfaceModel::TessellatedValue),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeStepEdge from ./opencascade/TopoDSToStep_MakeStepEdge.hxx
    klass = m.attr("TopoDSToStep_MakeStepEdge");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeStepEdge , shared_ptr<TopoDSToStep_MakeStepEdge>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Edge &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors & >()  , py::arg("E"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_MakeStepEdge::*)( const TopoDS_Edge & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) ) static_cast<void (TopoDSToStep_MakeStepEdge::*)( const TopoDS_Edge & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) >(&TopoDSToStep_MakeStepEdge::Init),
             R"#(None)#"  , py::arg("E"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors")
          )
        .def("Error",
             (TopoDSToStep_MakeEdgeError (TopoDSToStep_MakeStepEdge::*)() const) static_cast<TopoDSToStep_MakeEdgeError (TopoDSToStep_MakeStepEdge::*)() const>(&TopoDSToStep_MakeStepEdge::Error),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepEdge::*)() const) static_cast<const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepEdge::*)() const>(&TopoDSToStep_MakeStepEdge::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeStepFace from ./opencascade/TopoDSToStep_MakeStepFace.hxx
    klass = m.attr("TopoDSToStep_MakeStepFace");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeStepFace , shared_ptr<TopoDSToStep_MakeStepFace>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Face &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors & >()  , py::arg("F"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_MakeStepFace::*)( const TopoDS_Face & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) ) static_cast<void (TopoDSToStep_MakeStepFace::*)( const TopoDS_Face & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) >(&TopoDSToStep_MakeStepFace::Init),
             R"#(None)#"  , py::arg("F"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors")
          )
        .def("Error",
             (TopoDSToStep_MakeFaceError (TopoDSToStep_MakeStepFace::*)() const) static_cast<TopoDSToStep_MakeFaceError (TopoDSToStep_MakeStepFace::*)() const>(&TopoDSToStep_MakeStepFace::Error),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepFace::*)() const) static_cast<const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepFace::*)() const>(&TopoDSToStep_MakeStepFace::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeStepVertex from ./opencascade/TopoDSToStep_MakeStepVertex.hxx
    klass = m.attr("TopoDSToStep_MakeStepVertex");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeStepVertex , shared_ptr<TopoDSToStep_MakeStepVertex>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Vertex &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors & >()  , py::arg("V"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_MakeStepVertex::*)( const TopoDS_Vertex & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) ) static_cast<void (TopoDSToStep_MakeStepVertex::*)( const TopoDS_Vertex & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) >(&TopoDSToStep_MakeStepVertex::Init),
             R"#(None)#"  , py::arg("V"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors")
          )
        .def("Error",
             (TopoDSToStep_MakeVertexError (TopoDSToStep_MakeStepVertex::*)() const) static_cast<TopoDSToStep_MakeVertexError (TopoDSToStep_MakeStepVertex::*)() const>(&TopoDSToStep_MakeStepVertex::Error),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepVertex::*)() const) static_cast<const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepVertex::*)() const>(&TopoDSToStep_MakeStepVertex::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeStepWire from ./opencascade/TopoDSToStep_MakeStepWire.hxx
    klass = m.attr("TopoDSToStep_MakeStepWire");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeStepWire , shared_ptr<TopoDSToStep_MakeStepWire>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Wire &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const StepData_Factors & >()  , py::arg("W"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_MakeStepWire::*)( const TopoDS_Wire & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) ) static_cast<void (TopoDSToStep_MakeStepWire::*)( const TopoDS_Wire & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const StepData_Factors &  ) >(&TopoDSToStep_MakeStepWire::Init),
             R"#(None)#"  , py::arg("W"),  py::arg("T"),  py::arg("FP"),  py::arg("theLocalFactors")
          )
        .def("Error",
             (TopoDSToStep_MakeWireError (TopoDSToStep_MakeStepWire::*)() const) static_cast<TopoDSToStep_MakeWireError (TopoDSToStep_MakeStepWire::*)() const>(&TopoDSToStep_MakeStepWire::Error),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepWire::*)() const) static_cast<const opencascade::handle<StepShape_TopologicalRepresentationItem> & (TopoDSToStep_MakeStepWire::*)() const>(&TopoDSToStep_MakeStepWire::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_MakeTessellatedItem from ./opencascade/TopoDSToStep_MakeTessellatedItem.hxx
    klass = m.attr("TopoDSToStep_MakeTessellatedItem");


    // nested enums

    static_cast<py::class_<TopoDSToStep_MakeTessellatedItem , shared_ptr<TopoDSToStep_MakeTessellatedItem>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Face &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const Standard_Boolean,const Message_ProgressRange & >()  , py::arg("theFace"),  py::arg("theTool"),  py::arg("theFP"),  py::arg("theToPreferSurfaceSet"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
        .def(py::init< const TopoDS_Shell &,TopoDSToStep_Tool &,const opencascade::handle<Transfer_FinderProcess> &,const Message_ProgressRange & >()  , py::arg("theShell"),  py::arg("theTool"),  py::arg("theFP"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_MakeTessellatedItem::*)( const TopoDS_Face & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Standard_Boolean ,  const Message_ProgressRange &  ) ) static_cast<void (TopoDSToStep_MakeTessellatedItem::*)( const TopoDS_Face & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Standard_Boolean ,  const Message_ProgressRange &  ) >(&TopoDSToStep_MakeTessellatedItem::Init),
             R"#(None)#"  , py::arg("theFace"),  py::arg("theTool"),  py::arg("theFP"),  py::arg("theToPreferSurfaceSet"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (TopoDSToStep_MakeTessellatedItem::*)( const TopoDS_Shell & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Message_ProgressRange &  ) ) static_cast<void (TopoDSToStep_MakeTessellatedItem::*)( const TopoDS_Shell & ,  TopoDSToStep_Tool & ,  const opencascade::handle<Transfer_FinderProcess> & ,  const Message_ProgressRange &  ) >(&TopoDSToStep_MakeTessellatedItem::Init),
             R"#(None)#"  , py::arg("theShell"),  py::arg("theTool"),  py::arg("theFP"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeTessellatedItem::*)() const) static_cast<const opencascade::handle<StepVisual_TessellatedItem> & (TopoDSToStep_MakeTessellatedItem::*)() const>(&TopoDSToStep_MakeTessellatedItem::Value),
             R"#(None)#"
             
         )
;

    // Class TopoDSToStep_WireframeBuilder from ./opencascade/TopoDSToStep_WireframeBuilder.hxx
    klass = m.attr("TopoDSToStep_WireframeBuilder");


    // nested enums

    static_cast<py::class_<TopoDSToStep_WireframeBuilder , shared_ptr<TopoDSToStep_WireframeBuilder>  , TopoDSToStep_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const TopoDS_Shape &,TopoDSToStep_Tool &,const StepData_Factors & >()  , py::arg("S"),  py::arg("T"),  py::arg("theLocalFactors") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Shape & ,  TopoDSToStep_Tool & ,  const StepData_Factors &  ) ) static_cast<void (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Shape & ,  TopoDSToStep_Tool & ,  const StepData_Factors &  ) >(&TopoDSToStep_WireframeBuilder::Init),
             R"#(None)#"  , py::arg("S"),  py::arg("T"),  py::arg("theLocalFactors")
          )
        .def("Error",
             (TopoDSToStep_BuilderError (TopoDSToStep_WireframeBuilder::*)() const) static_cast<TopoDSToStep_BuilderError (TopoDSToStep_WireframeBuilder::*)() const>(&TopoDSToStep_WireframeBuilder::Error),
             R"#(None)#" 
          )
        .def("GetTrimmedCurveFromEdge",
             (Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const) static_cast<Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const>(&TopoDSToStep_WireframeBuilder::GetTrimmedCurveFromEdge),
             R"#(Extraction of Trimmed Curves from TopoDS_Edge for the Creation of a GeometricallyBoundedWireframeRepresentation)#"  , py::arg("E"),  py::arg("F"),  py::arg("M"),  py::arg("L"),  py::arg("theLocalFactors")
          )
        .def("GetTrimmedCurveFromFace",
             (Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Face & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const) static_cast<Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Face & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const>(&TopoDSToStep_WireframeBuilder::GetTrimmedCurveFromFace),
             R"#(Extraction of Trimmed Curves from TopoDS_Face for the Creation of a GeometricallyBoundedWireframeRepresentation)#"  , py::arg("F"),  py::arg("M"),  py::arg("L"),  py::arg("theLocalFactors")
          )
        .def("GetTrimmedCurveFromShape",
             (Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Shape & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const) static_cast<Standard_Boolean (TopoDSToStep_WireframeBuilder::*)( const TopoDS_Shape & ,  NCollection_DataMap<TopoDS_Shape, opencascade::handle<Standard_Transient>, TopTools_ShapeMapHasher> & ,  opencascade::handle<TColStd_HSequenceOfTransient> & ,  const StepData_Factors &  ) const>(&TopoDSToStep_WireframeBuilder::GetTrimmedCurveFromShape),
             R"#(Extraction of Trimmed Curves from any TopoDS_Shape for the Creation of a GeometricallyBoundedWireframeRepresentation)#"  , py::arg("S"),  py::arg("M"),  py::arg("L"),  py::arg("theLocalFactors")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const opencascade::handle<TColStd_HSequenceOfTransient> & (TopoDSToStep_WireframeBuilder::*)() const) static_cast<const opencascade::handle<TColStd_HSequenceOfTransient> & (TopoDSToStep_WireframeBuilder::*)() const>(&TopoDSToStep_WireframeBuilder::Value),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
;

// functions
// ./opencascade/TopoDSToStep.hxx
// ./opencascade/TopoDSToStep_Builder.hxx
// ./opencascade/TopoDSToStep_BuilderError.hxx
// ./opencascade/TopoDSToStep_FacetedError.hxx
// ./opencascade/TopoDSToStep_FacetedTool.hxx
// ./opencascade/TopoDSToStep_MakeBrepWithVoids.hxx
// ./opencascade/TopoDSToStep_MakeEdgeError.hxx
// ./opencascade/TopoDSToStep_MakeFaceError.hxx
// ./opencascade/TopoDSToStep_MakeFacetedBrep.hxx
// ./opencascade/TopoDSToStep_MakeFacetedBrepAndBrepWithVoids.hxx
// ./opencascade/TopoDSToStep_MakeGeometricCurveSet.hxx
// ./opencascade/TopoDSToStep_MakeManifoldSolidBrep.hxx
// ./opencascade/TopoDSToStep_MakeShellBasedSurfaceModel.hxx
// ./opencascade/TopoDSToStep_MakeStepEdge.hxx
// ./opencascade/TopoDSToStep_MakeStepFace.hxx
// ./opencascade/TopoDSToStep_MakeStepVertex.hxx
// ./opencascade/TopoDSToStep_MakeStepWire.hxx
// ./opencascade/TopoDSToStep_MakeTessellatedItem.hxx
// ./opencascade/TopoDSToStep_MakeVertexError.hxx
// ./opencascade/TopoDSToStep_MakeWireError.hxx
// ./opencascade/TopoDSToStep_Root.hxx
// ./opencascade/TopoDSToStep_Tool.hxx
// ./opencascade/TopoDSToStep_WireframeBuilder.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
