#!/usr/bin/python

from arsenal.arsenal_lib import *
from lpltk import LaunchpadService

if len(sys.argv) < 2:
    sys.stderr.write("Usage: %s <source-package>\n" %(sys.argv[0]) )
    sys.exit(1)

total_count = 0
source_pkgs = sys.argv[1:]
lp          = LaunchpadService(config={'read_only':True})
d           = lp.launchpad.distributions["ubuntu"]
tags        = {}

for source_pkg in source_pkgs:
    s = d.getSourcePackage(name = source_pkg)

    print source_pkg

    if s.upstream_product is None:
        print "  No upstream product"
        continue

    bugtracker = s.upstream_product.bug_tracker
    if bugtracker is None:
        # Maybe there's one on the project group
        project_group = s.upstream_product.project_group
        if project_group is not None:
            bugtracker = project_group.bug_tracker
    if bugtracker is not None:
        print "  upstream bugtracker:", bugtracker.name
        print "   - base_url:", bugtracker.base_url
        print "   - type:", bugtracker.bug_tracker_type
        print "   - lp_plugin:", bugtracker.has_lp_plugin
        print "   - remote_product:", s.upstream_product.remote_product
        print "   - sourceforge:", s.upstream_product.sourceforge_project
    else:
        print "  No upstream bug tracker registered"
    if s.upstream_product.project_group is not None:
        print "  project_group:", s.upstream_product.project_group.name
    if s.upstream_product.development_focus is not None:
        print "  development focus:", s.upstream_product.development_focus.name
    print "  wiki:", s.upstream_product.wiki_url
    print

