# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAzureDevOpsProjectsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_dev_ops_projects_list(self, resource_group):
        response = self.client.azure_dev_ops_projects.list(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            org_name="str",
            api_version="2025-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_dev_ops_projects_get(self, resource_group):
        response = await self.client.azure_dev_ops_projects.get(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            org_name="str",
            project_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_dev_ops_projects_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.azure_dev_ops_projects.begin_create_or_update(
                resource_group_name=resource_group.name,
                security_connector_name="str",
                org_name="str",
                project_name="str",
                azure_dev_ops_project={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "actionableRemediation": {
                            "branchConfiguration": {"annotateDefaultBranch": "str", "branchNames": ["str"]},
                            "categoryConfigurations": [{"category": "str", "minimumSeverityLevel": "str"}],
                            "inheritFromParentState": "str",
                            "state": "str",
                        },
                        "onboardingState": "str",
                        "parentOrgName": "str",
                        "projectId": "str",
                        "provisioningState": "str",
                        "provisioningStatusMessage": "str",
                        "provisioningStatusUpdateTimeUtc": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_dev_ops_projects_begin_update(self, resource_group):
        response = await (
            await self.client.azure_dev_ops_projects.begin_update(
                resource_group_name=resource_group.name,
                security_connector_name="str",
                org_name="str",
                project_name="str",
                azure_dev_ops_project={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "actionableRemediation": {
                            "branchConfiguration": {"annotateDefaultBranch": "str", "branchNames": ["str"]},
                            "categoryConfigurations": [{"category": "str", "minimumSeverityLevel": "str"}],
                            "inheritFromParentState": "str",
                            "state": "str",
                        },
                        "onboardingState": "str",
                        "parentOrgName": "str",
                        "projectId": "str",
                        "provisioningState": "str",
                        "provisioningStatusMessage": "str",
                        "provisioningStatusUpdateTimeUtc": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
