# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python put_governance_assignment_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.governance_assignments.create_or_update(
        scope="subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012",
        assessment_name="6b9421dd-5555-2251-9b3d-2be58e2f82cd",
        assignment_key="6634ff9f-127b-4bf2-8e6e-b1737f5e789c",
        governance_assignment={
            "properties": {
                "additionalData": {"ticketLink": "https://snow.com", "ticketNumber": 123123, "ticketStatus": "Active"},
                "governanceEmailNotification": {
                    "disableManagerEmailNotification": False,
                    "disableOwnerEmailNotification": False,
                },
                "isGracePeriod": True,
                "owner": "user@contoso.com",
                "remediationDueDate": "2022-01-07T13:00:00.0000000Z",
                "remediationEta": {"eta": "2022-01-08T13:00:00.0000000Z", "justification": "Justification of ETA"},
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceAssignments/PutGovernanceAssignment_example.json
if __name__ == "__main__":
    main()
