# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery.aio import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationProtectedItemsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_list_by_replication_protection_containers(self, resource_group):
        response = self.client.replication_protected_items.list_by_replication_protection_containers(
            fabric_name="str",
            protection_container_name="str",
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_get(self, resource_group):
        response = await self.client.replication_protected_items.get(
            fabric_name="str",
            protection_container_name="str",
            replicated_protected_item_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_create(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_create(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                input={
                    "properties": {
                        "policyId": "str",
                        "protectableItemId": "str",
                        "providerSpecificDetails": "enable_protection_provider_specific_input",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_purge(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_purge(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_update(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_update(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                update_protection_input={
                    "properties": {
                        "enableRdpOnTargetOption": "str",
                        "licenseType": "str",
                        "providerSpecificDetails": "update_replication_protected_item_provider_input",
                        "recoveryAvailabilitySetId": "str",
                        "recoveryAzureVMName": "str",
                        "recoveryAzureVMSize": "str",
                        "selectedRecoveryAzureNetworkId": "str",
                        "selectedSourceNicId": "str",
                        "selectedTfoAzureNetworkId": "str",
                        "vmNics": [
                            {
                                "enableAcceleratedNetworkingOnRecovery": bool,
                                "enableAcceleratedNetworkingOnTfo": bool,
                                "ipConfigs": [
                                    {
                                        "ipConfigName": "str",
                                        "isPrimary": bool,
                                        "isSeletedForFailover": bool,
                                        "recoveryLBBackendAddressPoolIds": ["str"],
                                        "recoveryPublicIPAddressId": "str",
                                        "recoveryStaticIPAddress": "str",
                                        "recoverySubnetName": "str",
                                        "tfoLBBackendAddressPoolIds": ["str"],
                                        "tfoPublicIPAddressId": "str",
                                        "tfoStaticIPAddress": "str",
                                        "tfoSubnetName": "str",
                                    }
                                ],
                                "nicId": "str",
                                "recoveryNetworkSecurityGroupId": "str",
                                "recoveryNicName": "str",
                                "recoveryNicResourceGroupName": "str",
                                "reuseExistingNic": bool,
                                "selectionType": "str",
                                "targetNicName": "str",
                                "tfoNetworkSecurityGroupId": "str",
                                "tfoNicName": "str",
                                "tfoNicResourceGroupName": "str",
                                "tfoReuseExistingNic": bool,
                            }
                        ],
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_add_disks(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_add_disks(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                add_disks_input={"properties": {"providerSpecificDetails": "add_disks_provider_specific_input"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_apply_recovery_point(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_apply_recovery_point(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                apply_recovery_point_input={
                    "properties": {
                        "providerSpecificDetails": "apply_recovery_point_provider_specific_input",
                        "recoveryPointId": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_failover_cancel(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_failover_cancel(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_failover_commit(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_failover_commit(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_planned_failover(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_planned_failover(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                failover_input={
                    "properties": {
                        "failoverDirection": "str",
                        "providerSpecificDetails": "planned_failover_provider_specific_failover_input",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_delete(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_delete(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                disable_protection_input={
                    "properties": {
                        "disableProtectionReason": "str",
                        "replicationProviderInput": "disable_protection_provider_specific_input",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_remove_disks(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_remove_disks(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                remove_disks_input={"properties": {"providerSpecificDetails": "remove_disks_provider_specific_input"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_repair_replication(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_repair_replication(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_reprotect(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_reprotect(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                reprotect_input={
                    "properties": {
                        "failoverDirection": "str",
                        "providerSpecificDetails": "reverse_replication_provider_specific_input",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_resolve_health_errors(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_resolve_health_errors(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                resolve_health_input={"properties": {"healthErrors": [{"healthErrorId": "str"}]}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_switch_provider(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_switch_provider(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                switch_provider_input={
                    "properties": {
                        "providerSpecificDetails": "switch_provider_specific_input",
                        "targetInstanceType": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_test_failover(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_test_failover(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                testfailover_input={
                    "properties": {
                        "failoverDirection": "str",
                        "networkId": "str",
                        "networkType": "str",
                        "providerSpecificDetails": "test_failover_provider_specific_input",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_test_failover_cleanup(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_test_failover_cleanup(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                cleanup_input={"properties": {"comments": "str"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_unplanned_failover(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_unplanned_failover(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                failover_input={
                    "properties": {
                        "failoverDirection": "str",
                        "providerSpecificDetails": "unplanned_failover_provider_specific_input",
                        "sourceSiteOperations": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_update_appliance(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_update_appliance(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                appliance_update_input={
                    "properties": {
                        "providerSpecificDetails": "update_appliance_for_replication_protected_item_provider_specific_input",
                        "targetApplianceId": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_begin_update_mobility_service(self, resource_group):
        response = await (
            await self.client.replication_protected_items.begin_update_mobility_service(
                fabric_name="str",
                protection_container_name="str",
                replicated_protected_item_name="str",
                update_mobility_service_request={"properties": {"runAsAccountId": "str"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_protected_items_list(self, resource_group):
        response = self.client.replication_protected_items.list(
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
