# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNatGatewaysOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_begin_delete(self, resource_group):
        response = self.client.nat_gateways.begin_delete(
            resource_group_name=resource_group.name,
            nat_gateway_name="str",
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_get(self, resource_group):
        response = self.client.nat_gateways.get(
            resource_group_name=resource_group.name,
            nat_gateway_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_begin_create_or_update(self, resource_group):
        response = self.client.nat_gateways.begin_create_or_update(
            resource_group_name=resource_group.name,
            nat_gateway_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "idleTimeoutInMinutes": 0,
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "publicIpAddresses": [{"id": "str"}],
                "publicIpAddressesV6": [{"id": "str"}],
                "publicIpPrefixes": [{"id": "str"}],
                "publicIpPrefixesV6": [{"id": "str"}],
                "resourceGuid": "str",
                "sku": {"name": "str"},
                "sourceVirtualNetwork": {"id": "str"},
                "subnets": [{"id": "str"}],
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_update_tags(self, resource_group):
        response = self.client.nat_gateways.update_tags(
            resource_group_name=resource_group.name,
            nat_gateway_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_list_all(self, resource_group):
        response = self.client.nat_gateways.list_all(
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_nat_gateways_list(self, resource_group):
        response = self.client.nat_gateways.list(
            resource_group_name=resource_group.name,
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
