# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementElasticVolumesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_get(self, resource_group):
        response = await self.client.elastic_volumes.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.elastic_volumes.begin_create_or_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={
                    "location": "str",
                    "eTag": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "filePath": "str",
                        "protocolTypes": ["str"],
                        "size": 0,
                        "availabilityStatus": "str",
                        "backupResourceId": "str",
                        "dataProtection": {
                            "backup": {
                                "elasticBackupPolicyResourceId": "str",
                                "elasticBackupVaultResourceId": "str",
                                "policyEnforcement": "str",
                            },
                            "snapshot": {"snapshotPolicyResourceId": "str"},
                        },
                        "exportPolicy": {
                            "rules": [
                                {
                                    "allowedClients": ["str"],
                                    "nfsv3": "str",
                                    "nfsv4": "str",
                                    "rootAccess": "str",
                                    "ruleIndex": 0,
                                    "unixAccessRule": "str",
                                }
                            ]
                        },
                        "mountTargets": [{"ipAddress": "str", "smbServerFqdn": "str"}],
                        "provisioningState": "str",
                        "restorationState": "str",
                        "smbProperties": {"smbEncryption": "str"},
                        "snapshotDirectoryVisibility": "str",
                        "snapshotResourceId": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_begin_update(self, resource_group):
        response = await (
            await self.client.elastic_volumes.begin_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={
                    "properties": {
                        "dataProtection": {
                            "backup": {
                                "elasticBackupPolicyResourceId": "str",
                                "elasticBackupVaultResourceId": "str",
                                "policyEnforcement": "str",
                            },
                            "snapshot": {"snapshotPolicyResourceId": "str"},
                        },
                        "exportPolicy": {
                            "rules": [
                                {
                                    "allowedClients": ["str"],
                                    "nfsv3": "str",
                                    "nfsv4": "str",
                                    "rootAccess": "str",
                                    "ruleIndex": 0,
                                    "unixAccessRule": "str",
                                }
                            ]
                        },
                        "size": 0,
                        "smbProperties": {"smbEncryption": "str"},
                        "snapshotDirectoryVisibility": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_begin_delete(self, resource_group):
        response = await (
            await self.client.elastic_volumes.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_list_by_elastic_pool(self, resource_group):
        response = self.client.elastic_volumes.list_by_elastic_pool(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_elastic_volumes_begin_revert(self, resource_group):
        response = await (
            await self.client.elastic_volumes.begin_revert(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                body={"snapshotResourceId": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
