# ---------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# ---------------------------------------------------------

import random

SUFFIX_LENGTH = 10
ALLOWED_CHARS = "bcdfghjklmnpqrstvwxyz0123456789"

ALLOWED_ADJECTIVES = [
    "affable",
    "amiable",
    "amusing",
    "ashy",
    "blue",
    "bold",
    "boring",
    "brave",
    "bright",
    "bubbly",
    "busy",
    "calm",
    "careful",
    "clever",
    "cool",
    "coral",
    "crimson",
    "cyan",
    "dreamy",
    "dynamic",
    "eager",
    "elated",
    "epic",
    "frank",
    "frosty",
    "funny",
    "gentle",
    "gifted",
    "good",
    "goofy",
    "gray",
    "great",
    "green",
    "happy",
    "helpful",
    "heroic",
    "honest",
    "hungry",
    "icy",
    "ivory",
    "jolly",
    "jovial",
    "joyful",
    "keen",
    "khaki",
    "kind",
    "lemon",
    "lime",
    "loving",
    "loyal",
    "lucid",
    "magenta",
    "mango",
    "maroon",
    "mighty",
    "modest",
    "musing",
    "neat",
    "nice",
    "nifty",
    "olden",
    "olive",
    "orange",
    "patient",
    "placid",
    "plucky",
    "plum",
    "polite",
    "purple",
    "quiet",
    "quirky",
    "red",
    "sad",
    "salmon",
    "serene",
    "sharp",
    "shy",
    "silly",
    "silver",
    "sincere",
    "sleepy",
    "stoic",
    "strong",
    "sweet",
    "teal",
    "tender",
    "tidy",
    "tough",
    "upbeat",
    "wheat",
    "willing",
    "witty",
    "yellow",
    "zen",
]

ALLOWED_NOUNS = [
    "actor",
    "airport",
    "angle",
    "animal",
    "answer",
    "ant",
    "apple",
    "apricot",
    "arch",
    "arm",
    "atemoya",
    "avocado",
    "bag",
    "ball",
    "balloon",
    "band",
    "basil",
    "basin",
    "basket",
    "battery",
    "beach",
    "bean",
    "bear",
    "beard",
    "bee",
    "beet",
    "bell",
    "berry",
    "bird",
    "board",
    "boat",
    "bone",
    "boniato",
    "book",
    "boot",
    "bottle",
    "box",
    "brain",
    "brake",
    "branch",
    "bread",
    "brick",
    "bridge",
    "brush",
    "bucket",
    "bulb",
    "button",
    "cabbage",
    "cake",
    "calypso",
    "camel",
    "camera",
    "candle",
    "car",
    "caravan",
    "card",
    "carnival",
    "carpet",
    "carrot",
    "cart",
    "cartoon",
    "cassava",
    "cat",
    "celery",
    "chaconia",
    "chain",
    "chayote",
    "cheese",
    "cheetah",
    "cherry",
    "chicken",
    "chin",
    "circle",
    "clock",
    "cloud",
    "coat",
    "coconut",
    "collar",
    "comb",
    "cord",
    "corn",
    "cow",
    "crayon",
    "crowd",
    "cumin",
    "cup",
    "curtain",
    "cushion",
    "date",
    "deer",
    "diamond",
    "dinner",
    "dog",
    "dolphin",
    "door",
    "double",
    "drain",
    "drawer",
    "dream",
    "dress",
    "drop",
    "duck",
    "eagle",
    "ear",
    "egg",
    "endive",
    "energy",
    "engine",
    "evening",
    "eye",
    "farm",
    "feast",
    "feather",
    "feijoa",
    "fennel",
    "fig",
    "fish",
    "flag",
    "floor",
    "flower",
    "fly",
    "foot",
    "forest",
    "fork",
    "fowl",
    "fox",
    "frame",
    "frog",
    "garage",
    "garden",
    "garlic",
    "gas",
    "ghost",
    "giraffe",
    "glass",
    "glove",
    "goat",
    "gold",
    "grape",
    "grass",
    "guava",
    "guitar",
    "gyro",
    "hair",
    "hamster",
    "hand",
    "hat",
    "head",
    "heart",
    "helmet",
    "holiday",
    "hominy",
    "honey",
    "hook",
    "horse",
    "house",
    "ice",
    "insect",
    "iron",
    "island",
    "jackal",
    "jelly",
    "jewel",
    "jicama",
    "juice",
    "kale",
    "kettle",
    "key",
    "king",
    "kitchen",
    "kite",
    "kitten",
    "kiwi",
    "knee",
    "knot",
    "kumquat",
    "lamp",
    "leaf",
    "leather",
    "leek",
    "leg",
    "lemon",
    "lettuce",
    "library",
    "lime",
    "line",
    "lion",
    "lizard",
    "lobster",
    "lock",
    "longan",
    "loquat",
    "lunch",
    "lychee",
    "machine",
    "malanga",
    "mango",
    "mangos",
    "map",
    "market",
    "match",
    "melon",
    "milk",
    "monkey",
    "moon",
    "morning",
    "muscle",
    "music",
    "nail",
    "napa",
    "napkin",
    "neck",
    "needle",
    "nerve",
    "nest",
    "net",
    "night",
    "nose",
    "nut",
    "nutmeg",
    "ocean",
    "octopus",
    "office",
    "oil",
    "okra",
    "onion",
    "orange",
    "oregano",
    "oven",
    "owl",
    "oxygen",
    "oyster",
    "panda",
    "papaya",
    "parang",
    "parcel",
    "parrot",
    "parsnip",
    "pasta",
    "pea",
    "peach",
    "pear",
    "pen",
    "pencil",
    "pepper",
    "piano",
    "picture",
    "pig",
    "pillow",
    "pin",
    "pipe",
    "pizza",
    "plane",
    "planet",
    "plastic",
    "plate",
    "plow",
    "plum",
    "pocket",
    "pot",
    "potato",
    "prune",
    "pummelo",
    "pump",
    "pumpkin",
    "puppy",
    "queen",
    "quill",
    "quince",
    "rabbit",
    "rail",
    "rain",
    "rainbow",
    "raisin",
    "rat",
    "receipt",
    "reggae",
    "rhubarb",
    "rhythm",
    "rice",
    "ring",
    "river",
    "rocket",
    "rod",
    "roof",
    "room",
    "root",
    "rose",
    "roti",
    "sail",
    "salt",
    "sand",
    "school",
    "scooter",
    "screw",
    "seal",
    "seed",
    "shampoo",
    "shark",
    "sheep",
    "shelf",
    "ship",
    "shirt",
    "shoe",
    "skin",
    "snail",
    "snake",
    "soca",
    "soccer",
    "sock",
    "soursop",
    "spade",
    "spider",
    "spinach",
    "sponge",
    "spoon",
    "spring",
    "sprout",
    "square",
    "squash",
    "stamp",
    "star",
    "station",
    "steelpan",
    "stem",
    "stick",
    "stomach",
    "stone",
    "store",
    "street",
    "sugar",
    "sun",
    "table",
    "tail",
    "tangelo",
    "tent",
    "thread",
    "ticket",
    "tiger",
    "toe",
    "tomato",
    "tongue",
    "tooth",
    "town",
    "train",
    "tray",
    "tree",
    "truck",
    "turnip",
    "turtle",
    "van",
    "vase",
    "vinegar",
    "vulture",
    "wall",
    "watch",
    "whale",
    "wheel",
    "whistle",
    "window",
    "wing",
    "wire",
    "wolf",
    "worm",
    "yacht",
    "yak",
    "yam",
    "yogurt",
    "yuca",
    "zebra",
    "zoo",
]


def generate_job_name() -> str:
    adj = random.choice(ALLOWED_ADJECTIVES)
    noun = random.choice(ALLOWED_NOUNS)
    suffix = "".join(random.choices(ALLOWED_CHARS, k=SUFFIX_LENGTH))

    return "_".join([adj, noun, suffix])
