# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computeschedule import ComputeScheduleMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computeschedule
# USAGE
    python scheduled_actions_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeScheduleMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.scheduled_actions.update(
        resource_group_name="rgcomputeschedule",
        scheduled_action_name="myScheduledAction",
        properties={
            "properties": {
                "actionType": "Start",
                "disabled": True,
                "endTime": "2025-04-17T00:23:58.149Z",
                "notificationSettings": [
                    {"destination": "wbhryycyolvnypjxzlawwvb", "disabled": True, "language": "en-us", "type": "Email"}
                ],
                "resourceType": "VirtualMachine",
                "schedule": {
                    "deadlineType": "Unknown",
                    "executionParameters": {
                        "optimizationPreference": "Cost",
                        "retryPolicy": {"retryCount": 17, "retryWindowInMinutes": 29},
                    },
                    "requestedDaysOfTheMonth": [15],
                    "requestedMonths": ["January"],
                    "requestedWeekDays": ["Monday"],
                    "scheduledTime": "19:00:00",
                    "timeZone": "bni",
                },
                "startTime": "2025-04-17T00:23:58.149Z",
            },
            "tags": {"key9989": "tryjidk"},
        },
    )
    print(response)


# x-ms-original-file: 2025-04-15-preview/ScheduledActions_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
