# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementNamespaceTopicsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_get(self, resource_group):
        response = await self.client.namespace_topics.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.namespace_topics.begin_create_or_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                namespace_topic_info={
                    "eventRetentionInDays": 0,
                    "id": "str",
                    "inputSchema": "CloudEventSchemaV1_0",
                    "name": "str",
                    "provisioningState": "str",
                    "publisherType": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_begin_delete(self, resource_group):
        response = await (
            await self.client.namespace_topics.begin_delete(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_begin_update(self, resource_group):
        response = await (
            await self.client.namespace_topics.begin_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                namespace_topic_update_parameters={"eventRetentionInDays": 0},
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_list_by_namespace(self, resource_group):
        response = self.client.namespace_topics.list_by_namespace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2025-02-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_list_shared_access_keys(self, resource_group):
        response = await self.client.namespace_topics.list_shared_access_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topics_begin_regenerate_key(self, resource_group):
        response = await (
            await self.client.namespace_topics.begin_regenerate_key(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                regenerate_key_request={"keyName": "str"},
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
