# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerinstance.aio import ContainerInstanceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerInstanceManagementContainerGroupProfileOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerInstanceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_all_revisions(self, resource_group):
        response = self.client.container_group_profile.list_all_revisions(
            resource_group_name=resource_group.name,
            container_group_profile_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_revision_number(self, resource_group):
        response = await self.client.container_group_profile.get_by_revision_number(
            resource_group_name=resource_group.name,
            container_group_profile_name="str",
            revision_number="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
