# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Iterable, Optional, TypeVar
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_by_sql_assessment_v2_request(
    resource_group_name: str,
    project_name: str,
    group_name: str,
    assessment_name: str,
    subscription_id: str,
    *,
    filter: Optional[str] = None,
    page_size: Optional[int] = None,
    continuation_token_parameter: Optional[str] = None,
    total_record_count: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-03-15"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/sqlAssessments/{assessmentName}/assessedSqlMachines",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "projectName": _SERIALIZER.url("project_name", project_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
        "groupName": _SERIALIZER.url("group_name", group_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
        "assessmentName": _SERIALIZER.url("assessment_name", assessment_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if page_size is not None:
        _params["pageSize"] = _SERIALIZER.query("page_size", page_size, "int")
    if continuation_token_parameter is not None:
        _params["continuationToken"] = _SERIALIZER.query(
            "continuation_token_parameter", continuation_token_parameter, "str"
        )
    if total_record_count is not None:
        _params["totalRecordCount"] = _SERIALIZER.query("total_record_count", total_record_count, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str,
    project_name: str,
    group_name: str,
    assessment_name: str,
    assessed_sql_machine_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-03-15"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/sqlAssessments/{assessmentName}/assessedSqlMachines/{assessedSqlMachineName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "projectName": _SERIALIZER.url("project_name", project_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
        "groupName": _SERIALIZER.url("group_name", group_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
        "assessmentName": _SERIALIZER.url("assessment_name", assessment_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"),
        "assessedSqlMachineName": _SERIALIZER.url(
            "assessed_sql_machine_name", assessed_sql_machine_name, "str", pattern=r"^[^<>&:\?/#]{1,260}$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class AssessedSqlMachinesOperationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.migrationassessment.MigrationAssessmentMgmtClient`'s
        :attr:`assessed_sql_machines_operations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_sql_assessment_v2(
        self,
        resource_group_name: str,
        project_name: str,
        group_name: str,
        assessment_name: str,
        filter: Optional[str] = None,
        page_size: Optional[int] = None,
        continuation_token_parameter: Optional[str] = None,
        total_record_count: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable["_models.AssessedSqlMachine"]:
        """List AssessedSqlMachine resources by SqlAssessmentV2.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param project_name: Assessment Project Name. Required.
        :type project_name: str
        :param group_name: Group ARM name. Required.
        :type group_name: str
        :param assessment_name: SQL Assessment arm name. Required.
        :type assessment_name: str
        :param filter: Filter query. Default value is None.
        :type filter: str
        :param page_size: Optional parameter for page size. Default value is None.
        :type page_size: int
        :param continuation_token_parameter: Optional parameter for continuation token. Default value
         is None.
        :type continuation_token_parameter: str
        :param total_record_count: Total record count. Default value is None.
        :type total_record_count: int
        :return: An iterator like instance of either AssessedSqlMachine or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.migrationassessment.models.AssessedSqlMachine]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.AssessedSqlMachineListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_sql_assessment_v2_request(
                    resource_group_name=resource_group_name,
                    project_name=project_name,
                    group_name=group_name,
                    assessment_name=assessment_name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    page_size=page_size,
                    continuation_token_parameter=continuation_token_parameter,
                    total_record_count=total_record_count,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("AssessedSqlMachineListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get(
        self,
        resource_group_name: str,
        project_name: str,
        group_name: str,
        assessment_name: str,
        assessed_sql_machine_name: str,
        **kwargs: Any
    ) -> _models.AssessedSqlMachine:
        """Get a AssessedSqlMachine.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param project_name: Assessment Project Name. Required.
        :type project_name: str
        :param group_name: Group ARM name. Required.
        :type group_name: str
        :param assessment_name: SQL Assessment arm name. Required.
        :type assessment_name: str
        :param assessed_sql_machine_name: Sql assessment Assessed Machine ARM name. Required.
        :type assessed_sql_machine_name: str
        :return: AssessedSqlMachine or the result of cls(response)
        :rtype: ~azure.mgmt.migrationassessment.models.AssessedSqlMachine
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.AssessedSqlMachine] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            project_name=project_name,
            group_name=group_name,
            assessment_name=assessment_name,
            assessed_sql_machine_name=assessed_sql_machine_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AssessedSqlMachine", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
