# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.redisenterprise import RedisEnterpriseManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-redisenterprise
# USAGE
    python redis_enterprise_databases_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = RedisEnterpriseManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.databases.begin_create(
        resource_group_name="rg1",
        cluster_name="cache1",
        database_name="default",
        parameters={
            "properties": {
                "clientProtocol": "Encrypted",
                "clusteringPolicy": "EnterpriseCluster",
                "evictionPolicy": "AllKeysLRU",
                "modules": [
                    {"args": "ERROR_RATE 0.00 INITIAL_SIZE 400", "name": "RedisBloom"},
                    {"args": "RETENTION_POLICY 20", "name": "RedisTimeSeries"},
                    {"name": "RediSearch"},
                ],
                "persistence": {"aofEnabled": True, "aofFrequency": "1s"},
                "port": 10000,
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/redisenterprise/resource-manager/Microsoft.Cache/preview/2023-03-01-preview/examples/RedisEnterpriseDatabasesCreate.json
if __name__ == "__main__":
    main()
