# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._reports_operations import build_get_latency_scorecards_request, build_get_timeseries_request

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ReportsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.frontdoor.aio.FrontDoorManagementClient`'s
        :attr:`reports` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_latency_scorecards(
        self,
        resource_group_name: str,
        profile_name: str,
        experiment_name: str,
        aggregation_interval: Union[str, _models.LatencyScorecardAggregationInterval],
        end_date_time_utc: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> _models.LatencyScorecard:
        """Gets a Latency Scorecard for a given Experiment.

        Gets a Latency Scorecard for a given Experiment.

        :param resource_group_name: Name of the Resource group within the Azure subscription. Required.
        :type resource_group_name: str
        :param profile_name: The Profile identifier associated with the Tenant and Partner. Required.
        :type profile_name: str
        :param experiment_name: The Experiment identifier associated with the Experiment. Required.
        :type experiment_name: str
        :param aggregation_interval: The aggregation interval of the Latency Scorecard. Known values
         are: "Daily", "Weekly", and "Monthly". Required.
        :type aggregation_interval: str or
         ~azure.mgmt.frontdoor.models.LatencyScorecardAggregationInterval
        :param end_date_time_utc: The end DateTime of the Latency Scorecard in UTC. Default value is
         None.
        :type end_date_time_utc: str
        :param country: The country associated with the Latency Scorecard. Values are country ISO codes
         as specified here- https://www.iso.org/iso-3166-country-codes.html. Default value is None.
        :type country: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LatencyScorecard or the result of cls(response)
        :rtype: ~azure.mgmt.frontdoor.models.LatencyScorecard
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2019-11-01"))
        cls: ClsType[_models.LatencyScorecard] = kwargs.pop("cls", None)

        request = build_get_latency_scorecards_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            experiment_name=experiment_name,
            subscription_id=self._config.subscription_id,
            aggregation_interval=aggregation_interval,
            end_date_time_utc=end_date_time_utc,
            country=country,
            api_version=api_version,
            template_url=self.get_latency_scorecards.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LatencyScorecard", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_latency_scorecards.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}/LatencyScorecard"
    }

    @distributed_trace_async
    async def get_timeseries(
        self,
        resource_group_name: str,
        profile_name: str,
        experiment_name: str,
        start_date_time_utc: datetime.datetime,
        end_date_time_utc: datetime.datetime,
        aggregation_interval: Union[str, _models.TimeseriesAggregationInterval],
        timeseries_type: Union[str, _models.TimeseriesType],
        endpoint: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> _models.Timeseries:
        """Gets a Timeseries for a given Experiment.

        Gets a Timeseries for a given Experiment.

        :param resource_group_name: Name of the Resource group within the Azure subscription. Required.
        :type resource_group_name: str
        :param profile_name: The Profile identifier associated with the Tenant and Partner. Required.
        :type profile_name: str
        :param experiment_name: The Experiment identifier associated with the Experiment. Required.
        :type experiment_name: str
        :param start_date_time_utc: The start DateTime of the Timeseries in UTC. Required.
        :type start_date_time_utc: ~datetime.datetime
        :param end_date_time_utc: The end DateTime of the Timeseries in UTC. Required.
        :type end_date_time_utc: ~datetime.datetime
        :param aggregation_interval: The aggregation interval of the Timeseries. Known values are:
         "Hourly" and "Daily". Required.
        :type aggregation_interval: str or ~azure.mgmt.frontdoor.models.TimeseriesAggregationInterval
        :param timeseries_type: The type of Timeseries. Known values are: "MeasurementCounts",
         "LatencyP50", "LatencyP75", and "LatencyP95". Required.
        :type timeseries_type: str or ~azure.mgmt.frontdoor.models.TimeseriesType
        :param endpoint: The specific endpoint. Default value is None.
        :type endpoint: str
        :param country: The country associated with the Timeseries. Values are country ISO codes as
         specified here- https://www.iso.org/iso-3166-country-codes.html. Default value is None.
        :type country: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Timeseries or the result of cls(response)
        :rtype: ~azure.mgmt.frontdoor.models.Timeseries
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2019-11-01"))
        cls: ClsType[_models.Timeseries] = kwargs.pop("cls", None)

        request = build_get_timeseries_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            experiment_name=experiment_name,
            subscription_id=self._config.subscription_id,
            start_date_time_utc=start_date_time_utc,
            end_date_time_utc=end_date_time_utc,
            aggregation_interval=aggregation_interval,
            timeseries_type=timeseries_type,
            endpoint=endpoint,
            country=country,
            api_version=api_version,
            template_url=self.get_timeseries.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Timeseries", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_timeseries.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}/Timeseries"
    }
