# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PasswordProfile(Model):
    """The password profile associated with a user.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param password: Required. Password
    :type password: str
    :param force_change_password_next_login: Whether to force a password
     change on next login.
    :type force_change_password_next_login: bool
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'password': {'key': 'password', 'type': 'str'},
        'force_change_password_next_login': {'key': 'forceChangePasswordNextLogin', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PasswordProfile, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.password = kwargs.get('password', None)
        self.force_change_password_next_login = kwargs.get('force_change_password_next_login', None)
