# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRights(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessRights."""

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"


class ApplicationGroupPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Application Group Policy types."""

    THROTTLING_POLICY = "ThrottlingPolicy"


class ClusterSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of this SKU."""

    DEDICATED = "Dedicated"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DefaultAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Default Action for Network Rule Set."""

    ALLOW = "Allow"
    DENY = "Deny"


class EncodingCaptureDescription(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the possible values for the encoding format of capture description. Note:
    'AvroDeflate' will be deprecated in New API Version.
    """

    AVRO = "Avro"
    AVRO_DEFLATE = "AvroDeflate"


class EndPointProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Private Endpoint Connection."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class EntityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the possible values for the status of the Event Hub."""

    ACTIVE = "Active"
    DISABLED = "Disabled"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    CREATING = "Creating"
    DELETING = "Deleting"
    RENAMING = "Renaming"
    UNKNOWN = "Unknown"


class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The access key to regenerate."""

    PRIMARY_KEY = "PrimaryKey"
    SECONDARY_KEY = "SecondaryKey"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class MetricId(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering
    over Metric in the Metrics section of Event Hub Namespace inside Azure Portal.
    """

    INCOMING_BYTES = "IncomingBytes"
    OUTGOING_BYTES = "OutgoingBytes"
    INCOMING_MESSAGES = "IncomingMessages"
    OUTGOING_MESSAGES = "OutgoingMessages"


class NetworkRuleIPAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IP Filter Action."""

    ALLOW = "Allow"


class NetworkSecurityPerimeterConfigurationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of NetworkSecurityPerimeter configuration propagation."""

    UNKNOWN = "Unknown"
    CREATING = "Creating"
    UPDATING = "Updating"
    ACCEPTED = "Accepted"
    INVALID_RESPONSE = "InvalidResponse"
    SUCCEEDED = "Succeeded"
    SUCCEEDED_WITH_ISSUES = "SucceededWithIssues"
    FAILED = "Failed"
    DELETING = "Deleting"
    DELETED = "Deleted"
    CANCELED = "Canceled"


class NspAccessRuleDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Direction of Access Rule."""

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class PrivateLinkConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class ProvisioningStateDR(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted'
    or 'Succeeded' or 'Failed'.
    """

    ACCEPTED = "Accepted"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines if traffic is allowed over public network. By default it is enabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    SECURED_BY_PERIMETER = "SecuredByPerimeter"


class PublicNetworkAccessFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines if traffic is allowed over public network. By default it is enabled. If value
    is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network
    security perimeter and profile's access rules.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    SECURED_BY_PERIMETER = "SecuredByPerimeter"


class ResourceAssociationAccessMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access Mode of the resource association."""

    NO_ASSOCIATION_MODE = "NoAssociationMode"
    ENFORCED_MODE = "EnforcedMode"
    LEARNING_MODE = "LearningMode"
    AUDIT_MODE = "AuditMode"
    UNSPECIFIED_MODE = "UnspecifiedMode"


class RoleDisasterRecovery(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or
    'Secondary'.
    """

    PRIMARY = "Primary"
    PRIMARY_NOT_REPLICATING = "PrimaryNotReplicating"
    SECONDARY = "Secondary"


class SchemaCompatibility(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SchemaCompatibility."""

    NONE = "None"
    BACKWARD = "Backward"
    FORWARD = "Forward"


class SchemaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SchemaType."""

    UNKNOWN = "Unknown"
    AVRO = "Avro"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of this SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing tier of this particular SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class TlsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The minimum TLS version for the cluster to support, e.g. '1.2'."""

    ONE0 = "1.0"
    ONE1 = "1.1"
    ONE2 = "1.2"


class UnavailableReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reason for the unavailability of the service."""

    NONE = "None"
    INVALID_NAME = "InvalidName"
    SUBSCRIPTION_IS_DISABLED = "SubscriptionIsDisabled"
    NAME_IN_USE = "NameInUse"
    NAME_IN_LOCKDOWN = "NameInLockdown"
    TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = "TooManyNamespaceInCurrentSubscription"
