# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from .._serialization import Serializer, Deserializer
from typing import Any, AsyncIterable, IO, Optional, Union

from azure.core.async_paging import AsyncItemPaged
from azure.core.polling import AsyncLROPoller

from .. import models as _models


class EdgeOrderManagementClientOperationsMixin(object):

    async def begin_create_address(
        self,
        address_name: str,
        resource_group_name: str,
        address_resource: Union[_models.AddressResource, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddressResource]:
        """Creates a new address with the specified parameters. Existing address can be updated with this
        API.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only. Required.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param address_resource: Address details from request body. Is either a AddressResource type or
         a IO type. Required.
        :type address_resource: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AddressResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_create_address')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_create_address'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_create_address(address_name, resource_group_name, address_resource, **kwargs)

    async def begin_create_order_item(
        self,
        order_item_name: str,
        resource_group_name: str,
        order_item_resource: Union[_models.OrderItemResource, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.OrderItemResource]:
        """Creates an order item. Existing order item cannot be updated with this api and should instead
        be updated with the Update order item API.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param order_item_resource: Order item details from request body. Is either a OrderItemResource
         type or a IO type. Required.
        :type order_item_resource: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either OrderItemResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_create_order_item')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_create_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_create_order_item(order_item_name, resource_group_name, order_item_resource, **kwargs)

    async def begin_delete_address_by_name(
        self,
        address_name: str,
        resource_group_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes an address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only. Required.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_delete_address_by_name')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_delete_address_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_delete_address_by_name(address_name, resource_group_name, **kwargs)

    async def begin_delete_order_item_by_name(
        self,
        order_item_name: str,
        resource_group_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes an order item.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_delete_order_item_by_name')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_delete_order_item_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_delete_order_item_by_name(order_item_name, resource_group_name, **kwargs)

    async def begin_return_order_item(
        self,
        order_item_name: str,
        resource_group_name: str,
        return_order_item_details: Union[_models.ReturnOrderItemDetails, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Return order item.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param return_order_item_details: Return order item CurrentStatus. Is either a
         ReturnOrderItemDetails type or a IO type. Required.
        :type return_order_item_details:
         ~azure.mgmt.edgeorder.v2021_12_01.models.ReturnOrderItemDetails or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_return_order_item')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_return_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_return_order_item(order_item_name, resource_group_name, return_order_item_details, **kwargs)

    async def begin_update_address(
        self,
        address_name: str,
        resource_group_name: str,
        address_update_parameter: Union[_models.AddressUpdateParameter, IO],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AddressResource]:
        """Updates the properties of an existing address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only. Required.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param address_update_parameter: Address update parameters from request body. Is either a
         AddressUpdateParameter type or a IO type. Required.
        :type address_update_parameter: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressUpdateParameter
         or IO
        :param if_match: Defines the If-Match condition. The patch will be performed only if the ETag
         of the job on the server matches this value. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AddressResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_update_address')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_update_address'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_update_address(address_name, resource_group_name, address_update_parameter, if_match, **kwargs)

    async def begin_update_order_item(
        self,
        order_item_name: str,
        resource_group_name: str,
        order_item_update_parameter: Union[_models.OrderItemUpdateParameter, IO],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.OrderItemResource]:
        """Updates the properties of an existing order item.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param order_item_update_parameter: order item update parameters from request body. Is either a
         OrderItemUpdateParameter type or a IO type. Required.
        :type order_item_update_parameter:
         ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemUpdateParameter or IO
        :param if_match: Defines the If-Match condition. The patch will be performed only if the ETag
         of the order on the server matches this value. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either OrderItemResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_update_order_item')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_update_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.begin_update_order_item(order_item_name, resource_group_name, order_item_update_parameter, if_match, **kwargs)

    async def cancel_order_item(  # pylint: disable=inconsistent-return-statements
        self,
        order_item_name: str,
        resource_group_name: str,
        cancellation_reason: Union[_models.CancellationReason, IO],
        **kwargs: Any
    ) -> None:
        """Cancel order item.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cancellation_reason: Reason for cancellation. Is either a CancellationReason type or a
         IO type. Required.
        :type cancellation_reason: ~azure.mgmt.edgeorder.v2021_12_01.models.CancellationReason or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('cancel_order_item')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'cancel_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.cancel_order_item(order_item_name, resource_group_name, cancellation_reason, **kwargs)

    async def get_address_by_name(
        self,
        address_name: str,
        resource_group_name: str,
        **kwargs: Any
    ) -> _models.AddressResource:
        """Gets information about the specified address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only. Required.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AddressResource or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('get_address_by_name')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_address_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_address_by_name(address_name, resource_group_name, **kwargs)

    async def get_order_by_name(
        self,
        order_name: str,
        resource_group_name: str,
        location: str,
        **kwargs: Any
    ) -> _models.OrderResource:
        """Gets an order.

        :param order_name: The name of the order. Required.
        :type order_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The name of Azure region. Required.
        :type location: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrderResource or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('get_order_by_name')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_order_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_order_by_name(order_name, resource_group_name, location, **kwargs)

    async def get_order_item_by_name(
        self,
        order_item_name: str,
        resource_group_name: str,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.OrderItemResource:
        """Gets an order item.

        :param order_item_name: The name of the order item. Required.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively. Default value is
         None.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrderItemResource or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('get_order_item_by_name')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_order_item_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_order_item_by_name(order_item_name, resource_group_name, expand, **kwargs)

    def list_addresses_at_resource_group_level(
        self,
        resource_group_name: str,
        filter: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.AddressResource"]:
        """Lists all the addresses available under the given resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param filter: $filter is supported to filter based on shipping address properties. Filter
         supports only equals operation. Default value is None.
        :type filter: str
        :param skip_token: $skipToken is supported on Get list of addresses, which provides the next
         page in the list of address. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AddressResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_addresses_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_addresses_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_addresses_at_resource_group_level(resource_group_name, filter, skip_token, **kwargs)

    def list_addresses_at_subscription_level(
        self,
        filter: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.AddressResource"]:
        """Lists all the addresses available under the subscription.

        :param filter: $filter is supported to filter based on shipping address properties. Filter
         supports only equals operation. Default value is None.
        :type filter: str
        :param skip_token: $skipToken is supported on Get list of addresses, which provides the next
         page in the list of addresses. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AddressResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_addresses_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_addresses_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_addresses_at_subscription_level(filter, skip_token, **kwargs)

    def list_configurations(
        self,
        configurations_request: Union[_models.ConfigurationsRequest, IO],
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Configuration"]:
        """This method provides the list of configurations for the given product family, product line and
        product under subscription.

        :param configurations_request: Filters for showing the configurations. Is either a
         ConfigurationsRequest type or a IO type. Required.
        :type configurations_request: ~azure.mgmt.edgeorder.v2021_12_01.models.ConfigurationsRequest or
         IO
        :param skip_token: $skipToken is supported on list of configurations, which provides the next
         page in the list of configurations. Default value is None.
        :type skip_token: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Configuration or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.Configuration]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_configurations')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_configurations'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_configurations(configurations_request, skip_token, **kwargs)

    def list_operations(
        self,
        **kwargs: Any
    ) -> AsyncIterable["_models.Operation"]:
        """This method gets all the operations that are exposed for customer.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Operation or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_operations')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_operations'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_operations(**kwargs)

    def list_order_at_resource_group_level(
        self,
        resource_group_name: str,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.OrderResource"]:
        """Lists order at resource group level.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param skip_token: $skipToken is supported on Get list of order, which provides the next page
         in the list of order. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_order_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_at_resource_group_level(resource_group_name, skip_token, **kwargs)

    def list_order_at_subscription_level(
        self,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.OrderResource"]:
        """Lists order at subscription level.

        :param skip_token: $skipToken is supported on Get list of order, which provides the next page
         in the list of order. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_order_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_at_subscription_level(skip_token, **kwargs)

    def list_order_items_at_resource_group_level(
        self,
        resource_group_name: str,
        filter: Optional[str] = None,
        expand: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.OrderItemResource"]:
        """Lists order item at resource group level.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param filter: $filter is supported to filter based on order id. Filter supports only equals
         operation. Default value is None.
        :type filter: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively. Default value is
         None.
        :type expand: str
        :param skip_token: $skipToken is supported on Get list of order items, which provides the next
         page in the list of order items. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderItemResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_order_items_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_items_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_items_at_resource_group_level(resource_group_name, filter, expand, skip_token, **kwargs)

    def list_order_items_at_subscription_level(
        self,
        filter: Optional[str] = None,
        expand: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.OrderItemResource"]:
        """Lists order item at subscription level.

        :param filter: $filter is supported to filter based on order id. Filter supports only equals
         operation. Default value is None.
        :type filter: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively. Default value is
         None.
        :type expand: str
        :param skip_token: $skipToken is supported on Get list of order items, which provides the next
         page in the list of order items. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderItemResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_order_items_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_items_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_items_at_subscription_level(filter, expand, skip_token, **kwargs)

    def list_product_families(
        self,
        product_families_request: Union[_models.ProductFamiliesRequest, IO],
        expand: Optional[str] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ProductFamily"]:
        """This method provides the list of product families for the given subscription.

        :param product_families_request: Filters for showing the product families. Is either a
         ProductFamiliesRequest type or a IO type. Required.
        :type product_families_request: ~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamiliesRequest
         or IO
        :param expand: $expand is supported on configurations parameter for product, which provides
         details on the configurations for the product. Default value is None.
        :type expand: str
        :param skip_token: $skipToken is supported on list of product families, which provides the next
         page in the list of product families. Default value is None.
        :type skip_token: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProductFamily or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamily]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_product_families')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_product_families'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_product_families(product_families_request, expand, skip_token, **kwargs)

    def list_product_families_metadata(
        self,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ProductFamiliesMetadataDetails"]:
        """This method provides the list of product families metadata for the given subscription.

        :param skip_token: $skipToken is supported on list of product families metadata, which provides
         the next page in the list of product families metadata. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProductFamiliesMetadataDetails or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamiliesMetadataDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('list_product_families_metadata')
        if api_version == '2020-12-01-preview':
            from ..v2020_12_01_preview.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from ..v2021_12_01.aio.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_product_families_metadata'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_product_families_metadata(skip_token, **kwargs)
