# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AdditionalCapabilities(_serialization.Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :vartype ultra_ssd_enabled: bool
    :ivar hibernation_enabled: The flag that enables or disables hibernation capability on the VM.
    :vartype hibernation_enabled: bool
    """

    _attribute_map = {
        "ultra_ssd_enabled": {"key": "ultraSSDEnabled", "type": "bool"},
        "hibernation_enabled": {"key": "hibernationEnabled", "type": "bool"},
    }

    def __init__(
        self, *, ultra_ssd_enabled: Optional[bool] = None, hibernation_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
         managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
         storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
         set only if this property is enabled.
        :paramtype ultra_ssd_enabled: bool
        :keyword hibernation_enabled: The flag that enables or disables hibernation capability on the
         VM.
        :paramtype hibernation_enabled: bool
        """
        super().__init__(**kwargs)
        self.ultra_ssd_enabled = ultra_ssd_enabled
        self.hibernation_enabled = hibernation_enabled


class AdditionalUnattendContent(_serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file,
    which is used by Windows Setup. Contents are defined by setting name, component name, and the
    pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.compute.v2021_11_01.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    _attribute_map = {
        "pass_name": {"key": "passName", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "setting_name": {"key": "settingName", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
         value is "OobeSystem".
        :paramtype pass_name: str
        :keyword component_name: The component name. Currently, the only allowable value is
         Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
        :paramtype component_name: str
        :keyword setting_name: Specifies the name of the setting to which the content applies. Possible
         values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
         "FirstLogonCommands".
        :paramtype setting_name: str or ~azure.mgmt.compute.v2021_11_01.models.SettingNames
        :keyword content: Specifies the XML formatted content that is added to the unattend.xml file
         for the specified path and component. The XML must be less than 4KB and must include the root
         element for the setting or feature that is being inserted.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content


class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2021_11_01.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2021_11_01.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2021_11_01.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2021_11_01.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ApplicationProfile(_serialization.Model):
    """Contains the list of gallery applications that should be made available to the VM/VMSS.

    :ivar gallery_applications: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype gallery_applications:
     list[~azure.mgmt.compute.v2021_11_01.models.VMGalleryApplication]
    """

    _attribute_map = {
        "gallery_applications": {"key": "galleryApplications", "type": "[VMGalleryApplication]"},
    }

    def __init__(
        self, *, gallery_applications: Optional[List["_models.VMGalleryApplication"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword gallery_applications: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype gallery_applications:
         list[~azure.mgmt.compute.v2021_11_01.models.VMGalleryApplication]
        """
        super().__init__(**kwargs)
        self.gallery_applications = gallery_applications


class AutomaticOSUpgradePolicy(_serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
     Windows based scale sets, `enableAutomaticUpdates
     <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
     is automatically set to false and cannot be set to true.
    :vartype enable_automatic_os_upgrade: bool
    :ivar disable_automatic_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :vartype disable_automatic_rollback: bool
    """

    _attribute_map = {
        "enable_automatic_os_upgrade": {"key": "enableAutomaticOSUpgrade", "type": "bool"},
        "disable_automatic_rollback": {"key": "disableAutomaticRollback", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_automatic_os_upgrade: Optional[bool] = None,
        disable_automatic_rollback: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
         applied to scale set instances in a rolling fashion when a newer version of the OS image
         becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
         Windows based scale sets, `enableAutomaticUpdates
         <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
         is automatically set to false and cannot be set to true.
        :paramtype enable_automatic_os_upgrade: bool
        :keyword disable_automatic_rollback: Whether OS image rollback feature should be disabled.
         Default value is false.
        :paramtype disable_automatic_rollback: bool
        """
        super().__init__(**kwargs)
        self.enable_automatic_os_upgrade = enable_automatic_os_upgrade
        self.disable_automatic_rollback = disable_automatic_rollback


class AutomaticOSUpgradeProperties(_serialization.Model):
    """Describes automatic OS upgrade properties on the image.

    All required parameters must be populated in order to send to Azure.

    :ivar automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
     the image. Required.
    :vartype automatic_os_upgrade_supported: bool
    """

    _validation = {
        "automatic_os_upgrade_supported": {"required": True},
    }

    _attribute_map = {
        "automatic_os_upgrade_supported": {"key": "automaticOSUpgradeSupported", "type": "bool"},
    }

    def __init__(self, *, automatic_os_upgrade_supported: bool, **kwargs: Any) -> None:
        """
        :keyword automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
         the image. Required.
        :paramtype automatic_os_upgrade_supported: bool
        """
        super().__init__(**kwargs)
        self.automatic_os_upgrade_supported = automatic_os_upgrade_supported


class AutomaticRepairsPolicy(_serialization.Model):
    """Specifies the configuration parameters for automatic repairs on the virtual machine scale set.

    :ivar enabled: Specifies whether automatic repairs should be enabled on the virtual machine
     scale set. The default value is false.
    :vartype enabled: bool
    :ivar grace_period: The amount of time for which automatic repairs are suspended due to a state
     change on VM. The grace time starts after the state change has completed. This helps avoid
     premature or accidental repairs. The time duration should be specified in ISO 8601 format. The
     minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The
     maximum allowed grace period is 90 minutes (PT90M).
    :vartype grace_period: str
    :ivar repair_action: Type of repair action (replace, restart, reimage) that will be used for
     repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
     are: "Replace", "Restart", and "Reimage".
    :vartype repair_action: str or ~azure.mgmt.compute.v2021_11_01.models.RepairAction
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "grace_period": {"key": "gracePeriod", "type": "str"},
        "repair_action": {"key": "repairAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        grace_period: Optional[str] = None,
        repair_action: Optional[Union[str, "_models.RepairAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether automatic repairs should be enabled on the virtual machine
         scale set. The default value is false.
        :paramtype enabled: bool
        :keyword grace_period: The amount of time for which automatic repairs are suspended due to a
         state change on VM. The grace time starts after the state change has completed. This helps
         avoid premature or accidental repairs. The time duration should be specified in ISO 8601
         format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default
         value. The maximum allowed grace period is 90 minutes (PT90M).
        :paramtype grace_period: str
        :keyword repair_action: Type of repair action (replace, restart, reimage) that will be used for
         repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
         are: "Replace", "Restart", and "Reimage".
        :paramtype repair_action: str or ~azure.mgmt.compute.v2021_11_01.models.RepairAction
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.grace_period = grace_period
        self.repair_action = repair_action


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AvailabilitySet(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Virtual machines specified in the same availability set are allocated to different nodes to
    maximize availability. For more information about availability sets, see `Availability sets
    overview <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
    :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
    and updates for Virtual Machines in Azure
    <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
    :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
    time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set, only name is required to be set. See
     AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
     managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
     'Classic'.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set, only name is required to be set. See
         AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
         managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
         'Classic'.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class AvailabilitySetListResult(_serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of availability sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.AvailabilitySet]
    :ivar next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvailabilitySet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of availability sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.AvailabilitySet]
        :keyword next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with
         this URI to fetch the next page of AvailabilitySets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResource(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _validation = {
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class AvailablePatchSummary(_serialization.Model):
    """Describes the properties of an virtual machine instance view for available patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_11_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "assessment_activity_id": {"readonly": True},
        "reboot_pending": {"readonly": True},
        "critical_and_security_patch_count": {"readonly": True},
        "other_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "assessment_activity_id": {"key": "assessmentActivityId", "type": "str"},
        "reboot_pending": {"key": "rebootPending", "type": "bool"},
        "critical_and_security_patch_count": {"key": "criticalAndSecurityPatchCount", "type": "int"},
        "other_patch_count": {"key": "otherPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None


class BillingProfile(_serialization.Model):
    """Specifies the billing related details of a Azure Spot VM or VMSS.
    :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.

    :ivar max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS.
     This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with the
     current Azure Spot price for the VM size. Also, the prices are compared at the time of
     create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
     greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
     used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
     after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
     :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
     :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
     should not be evicted for price reasons. Also, the default max price is -1 if it is not
     provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype max_price: float
    """

    _attribute_map = {
        "max_price": {"key": "maxPrice", "type": "float"},
    }

    def __init__(self, *, max_price: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword max_price: Specifies the maximum price you are willing to pay for a Azure Spot
         VM/VMSS. This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with
         the current Azure Spot price for the VM size. Also, the prices are compared at the time of
         create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
         greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
         used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
         after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
         :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
         :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
         should not be evicted for price reasons. Also, the default max price is -1 if it is not
         provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype max_price: float
        """
        super().__init__(**kwargs)
        self.max_price = max_price


class BootDiagnostics(_serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
    to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console
    log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
    hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
     diagnostics, managed storage will be used.
    :vartype storage_uri: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, storage_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :paramtype enabled: bool
        :keyword storage_uri: Uri of the storage account to use for placing the console output and
         screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
         diagnostics, managed storage will be used.
        :paramtype storage_uri: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(_serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob Uri.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. :code:`<br>`:code:`<br>`
     NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None
        self.status = None


class CapacityReservation(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the capacity reservation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the resource for which capacity needs be reserved. The SKU name and capacity
     is required to be set. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
     in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
     values. Required.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar zones: Availability Zone to use for this capacity reservation. The zone has to be single
     value and also should be part for the list of zones specified during the capacity reservation
     group creation. The zone can be assigned only during creation. If not provided, the reservation
     supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity
     reservation to be in same zone.
    :vartype zones: list[str]
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationInstanceView
    :ivar time_created: Specifies the time at which the Capacity Reservation resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "reservation_id": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "zones": {"key": "zones", "type": "[str]"},
        "reservation_id": {"key": "properties.reservationId", "type": "str"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the resource for which capacity needs be reserved. The SKU name and
         capacity is required to be set. Currently VM Skus with the capability called
         'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
         in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
         values. Required.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword zones: Availability Zone to use for this capacity reservation. The zone has to be
         single value and also should be part for the list of zones specified during the capacity
         reservation group creation. The zone can be assigned only during creation. If not provided, the
         reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this
         capacity reservation to be in same zone.
        :paramtype zones: list[str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.zones = zones
        self.reservation_id = None
        self.virtual_machines_associated = None
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None


class CapacityReservationGroup(Resource):
    """Specifies information about the capacity reservation group that the capacity reservations
    should be assigned to. :code:`<br>`:code:`<br>` Currently, a capacity reservation can only be
    added to a capacity reservation group at creation time. An existing capacity reservation cannot
    be added or moved to another capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zones to use for this capacity reservation group. The zones can be
     assigned only during creation. If not provided, the group supports only regional resources in
     the region. If provided, enforces each capacity reservation in the group to be in one of the
     zones.
    :vartype zones: list[str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationGroupInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "capacity_reservations": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "capacity_reservations": {"key": "properties.capacityReservations", "type": "[SubResourceReadOnly]"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationGroupInstanceView"},
    }

    def __init__(
        self, *, location: str, tags: Optional[Dict[str, str]] = None, zones: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zones to use for this capacity reservation group. The zones can be
         assigned only during creation. If not provided, the group supports only regional resources in
         the region. If provided, enforces each capacity reservation in the group to be in one of the
         zones.
        :paramtype zones: list[str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.capacity_reservations = None
        self.virtual_machines_associated = None
        self.instance_view = None


class CapacityReservationGroupInstanceView(_serialization.Model):
    """CapacityReservationGroupInstanceView.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity_reservations: List of instance view of the capacity reservations under the
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_11_01.models.CapacityReservationInstanceViewWithName]
    """

    _validation = {
        "capacity_reservations": {"readonly": True},
    }

    _attribute_map = {
        "capacity_reservations": {"key": "capacityReservations", "type": "[CapacityReservationInstanceViewWithName]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.capacity_reservations = None


class CapacityReservationGroupListResult(_serialization.Model):
    """The List capacity reservation group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of capacity reservation groups. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.CapacityReservationGroup]
    :ivar next_link: The URI to fetch the next page of capacity reservation groups. Call ListNext()
     with this URI to fetch the next page of capacity reservation groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapacityReservationGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CapacityReservationGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of capacity reservation groups. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.CapacityReservationGroup]
        :keyword next_link: The URI to fetch the next page of capacity reservation groups. Call
         ListNext() with this URI to fetch the next page of capacity reservation groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationGroupUpdate(UpdateResource):
    """Specifies information about the capacity reservation group. Only tags can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationGroupInstanceView
    """

    _validation = {
        "capacity_reservations": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "capacity_reservations": {"key": "properties.capacityReservations", "type": "[SubResourceReadOnly]"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationGroupInstanceView"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)
        self.capacity_reservations = None
        self.virtual_machines_associated = None
        self.instance_view = None


class CapacityReservationInstanceView(_serialization.Model):
    """The instance view of a capacity reservation that provides as snapshot of the runtime properties
    of the capacity reservation that is managed by the platform and can change outside of control
    plane operations.

    :ivar utilization_info: Unutilized capacity of the capacity reservation.
    :vartype utilization_info:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationUtilization
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "utilization_info": {"key": "utilizationInfo", "type": "CapacityReservationUtilization"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["_models.CapacityReservationUtilization"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utilization_info: Unutilized capacity of the capacity reservation.
        :paramtype utilization_info:
         ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationUtilization
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.utilization_info = utilization_info
        self.statuses = statuses


class CapacityReservationInstanceViewWithName(CapacityReservationInstanceView):
    """The instance view of a capacity reservation that includes the name of the capacity reservation.
    It is used for the response to the instance view of a capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar utilization_info: Unutilized capacity of the capacity reservation.
    :vartype utilization_info:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationUtilization
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar name: The name of the capacity reservation.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "utilization_info": {"key": "utilizationInfo", "type": "CapacityReservationUtilization"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["_models.CapacityReservationUtilization"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utilization_info: Unutilized capacity of the capacity reservation.
        :paramtype utilization_info:
         ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationUtilization
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(utilization_info=utilization_info, statuses=statuses, **kwargs)
        self.name = None


class CapacityReservationListResult(_serialization.Model):
    """The list capacity reservation operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of capacity reservations. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.CapacityReservation]
    :ivar next_link: The URI to fetch the next page of capacity reservations. Call ListNext() with
     this URI to fetch the next page of capacity reservations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapacityReservation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CapacityReservation"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of capacity reservations. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.CapacityReservation]
        :keyword next_link: The URI to fetch the next page of capacity reservations. Call ListNext()
         with this URI to fetch the next page of capacity reservations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationProfile(_serialization.Model):
    """The parameters of a capacity reservation Profile.

    :ivar capacity_reservation_group: Specifies the capacity reservation group resource id that
     should be used for allocating the virtual machine or scaleset vm instances provided enough
     capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more
     details.
    :vartype capacity_reservation_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    """

    _attribute_map = {
        "capacity_reservation_group": {"key": "capacityReservationGroup", "type": "SubResource"},
    }

    def __init__(self, *, capacity_reservation_group: Optional["_models.SubResource"] = None, **kwargs: Any) -> None:
        """
        :keyword capacity_reservation_group: Specifies the capacity reservation group resource id that
         should be used for allocating the virtual machine or scaleset vm instances provided enough
         capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more
         details.
        :paramtype capacity_reservation_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.capacity_reservation_group = capacity_reservation_group


class CapacityReservationUpdate(UpdateResource):
    """Specifies information about the capacity reservation. Only tags and sku.capacity can be
    updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the resource for which capacity needs be reserved. The SKU name and capacity
     is required to be set. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
     in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
     values.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationInstanceView
    :ivar time_created: Specifies the time at which the Capacity Reservation resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "reservation_id": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "reservation_id": {"key": "properties.reservationId", "type": "str"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.Sku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the resource for which capacity needs be reserved. The SKU name and
         capacity is required to be set. Currently VM Skus with the capability called
         'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
         in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
         values.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.reservation_id = None
        self.virtual_machines_associated = None
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None


class CapacityReservationUtilization(_serialization.Model):
    """Represents the capacity reservation utilization in terms of resources allocated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machines_allocated: A list of all virtual machines resource ids allocated against
     the capacity reservation.
    :vartype virtual_machines_allocated:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    """

    _validation = {
        "virtual_machines_allocated": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machines_allocated": {"key": "virtualMachinesAllocated", "type": "[SubResourceReadOnly]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.virtual_machines_allocated = None


class ComputeOperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.ComputeOperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ComputeOperationValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class ComputeOperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class DataDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
    :ivar to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :vartype to_be_detached: bool
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_m_bps_read_write: int
    :ivar detach_option: Specifies the detach behavior to be used while detaching a disk or which
     is already in the process of detachment from the virtual machine. Supported values:
     **ForceDetach**. :code:`<br>`:code:`<br>` detachOption: **ForceDetach** is applicable only for
     managed data disks. If a previous detachment attempt of the data disk did not complete due to
     an unexpected failure from the virtual machine and the disk is still not released then use
     force-detach as a last resort option to detach the disk forcibly from the VM. All writes might
     not have been flushed when using this detach behavior. :code:`<br>`:code:`<br>` This feature is
     still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data
     disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     "ForceDetach"
    :vartype detach_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDetachOptionTypes
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion.:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the data disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach**
     If this value is used, the data disk is retained after VM is deleted.:code:`<br>`:code:`<br>`
     The default value is set to **detach**. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDeleteOptionTypes
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
        "disk_iops_read_write": {"readonly": True},
        "disk_m_bps_read_write": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "to_be_detached": {"key": "toBeDetached", "type": "bool"},
        "disk_iops_read_write": {"key": "diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "diskMBpsReadWrite", "type": "int"},
        "detach_option": {"key": "detachOption", "type": "str"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        to_be_detached: Optional[bool] = None,
        detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
        :keyword to_be_detached: Specifies whether the data disk is in process of detachment from the
         VirtualMachine/VirtualMachineScaleset.
        :paramtype to_be_detached: bool
        :keyword detach_option: Specifies the detach behavior to be used while detaching a disk or
         which is already in the process of detachment from the virtual machine. Supported values:
         **ForceDetach**. :code:`<br>`:code:`<br>` detachOption: **ForceDetach** is applicable only for
         managed data disks. If a previous detachment attempt of the data disk did not complete due to
         an unexpected failure from the virtual machine and the disk is still not released then use
         force-detach as a last resort option to detach the disk forcibly from the VM. All writes might
         not have been flushed when using this detach behavior. :code:`<br>`:code:`<br>` This feature is
         still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data
         disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
         "ForceDetach"
        :paramtype detach_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDetachOptionTypes
        :keyword delete_option: Specifies whether data disk should be deleted or detached upon VM
         deletion.:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
         value is used, the data disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach**
         If this value is used, the data disk is retained after VM is deleted.:code:`<br>`:code:`<br>`
         The default value is set to **detach**. Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.to_be_detached = to_be_detached
        self.disk_iops_read_write = None
        self.disk_m_bps_read_write = None
        self.detach_option = detach_option
        self.delete_option = delete_option


class DataDiskImage(_serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.lun = None


class DedicatedHost(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the Dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
     required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "platform_fault_domain": {"minimum": 0},
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
         required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
         :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
         **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostLicenseTypes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None


class DedicatedHostAllocatableVM(_serialization.Model):
    """Represents the dedicated host unutilized capacity in terms of a specific VM size.

    :ivar vm_size: VM size in terms of which the unutilized capacity is represented.
    :vartype vm_size: str
    :ivar count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
     remaining capacity.
    :vartype count: float
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "count": {"key": "count", "type": "float"},
    }

    def __init__(self, *, vm_size: Optional[str] = None, count: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size: VM size in terms of which the unutilized capacity is represented.
        :paramtype vm_size: str
        :keyword count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
         remaining capacity.
        :paramtype count: float
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.count = count


class DedicatedHostAvailableCapacity(_serialization.Model):
    """Dedicated host unutilized capacity.

    :ivar allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms of
     each VM size that is allowed to be deployed to the dedicated host.
    :vartype allocatable_v_ms:
     list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAllocatableVM]
    """

    _attribute_map = {
        "allocatable_v_ms": {"key": "allocatableVMs", "type": "[DedicatedHostAllocatableVM]"},
    }

    def __init__(
        self, *, allocatable_v_ms: Optional[List["_models.DedicatedHostAllocatableVM"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms
         of each VM size that is allowed to be deployed to the dedicated host.
        :paramtype allocatable_v_ms:
         list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAllocatableVM]
        """
        super().__init__(**kwargs)
        self.allocatable_v_ms = allocatable_v_ms


class DedicatedHostGroup(Resource):
    """Specifies information about the dedicated host group that the dedicated hosts should be
    assigned to. :code:`<br>`:code:`<br>` Currently, a dedicated host can only be added to a
    dedicated host group at creation time. An existing dedicated host cannot be added to another
    dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zone to use for this host group. Only single zone is supported.
         The zone can be assigned only during creation. If not provided, the group supports all zones in
         the region. If provided, enforces each host in the group to be in the same zone.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
         api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement


class DedicatedHostGroupInstanceView(_serialization.Model):
    """DedicatedHostGroupInstanceView.

    :ivar hosts: List of instance view of the dedicated hosts under the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostInstanceViewWithName]
    """

    _attribute_map = {
        "hosts": {"key": "hosts", "type": "[DedicatedHostInstanceViewWithName]"},
    }

    def __init__(
        self, *, hosts: Optional[List["_models.DedicatedHostInstanceViewWithName"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword hosts: List of instance view of the dedicated hosts under the dedicated host group.
        :paramtype hosts:
         list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostInstanceViewWithName]
        """
        super().__init__(**kwargs)
        self.hosts = hosts


class DedicatedHostGroupListResult(_serialization.Model):
    """The List Dedicated Host Group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of dedicated host groups. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostGroup]
    :ivar next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with
     this URI to fetch the next page of Dedicated Host Groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHostGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DedicatedHostGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of dedicated host groups. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHostGroup]
        :keyword next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext()
         with this URI to fetch the next page of Dedicated Host Groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostGroupUpdate(UpdateResource):
    """Specifies information about the dedicated host group that the dedicated host should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    """

    _validation = {
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zone to use for this host group. Only single zone is supported.
         The zone can be assigned only during creation. If not provided, the group supports all zones in
         the region. If provided, enforces each host in the group to be in the same zone.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
         api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        """
        super().__init__(tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement


class DedicatedHostInstanceView(_serialization.Model):
    """The instance view of a dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity:
     ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _validation = {
        "asset_id": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity:
         ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.asset_id = None
        self.available_capacity = available_capacity
        self.statuses = statuses


class DedicatedHostInstanceViewWithName(DedicatedHostInstanceView):
    """The instance view of a dedicated host that includes the name of the dedicated host. It is used
    for the response to the instance view of a dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity:
     ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar name: The name of the dedicated host.
    :vartype name: str
    """

    _validation = {
        "asset_id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity:
         ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(available_capacity=available_capacity, statuses=statuses, **kwargs)
        self.name = None


class DedicatedHostListResult(_serialization.Model):
    """The list dedicated host operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of dedicated hosts. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHost]
    :ivar next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with this
     URI to fetch the next page of dedicated hosts.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DedicatedHost"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of dedicated hosts. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.DedicatedHost]
        :keyword next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with
         this URI to fetch the next page of dedicated hosts.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostUpdate(UpdateResource):
    """Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType
    may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_11_01.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "platform_fault_domain": {"minimum": 0},
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
         :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
         **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.DedicatedHostLicenseTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None


class DiagnosticsProfile(_serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version:
    2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`\ **NOTE**\ : If storageUri is
     being specified then ensure that the storage account is in the same region and subscription as
     the VM. :code:`<br>`:code:`<br>` You can easily view the output of your console log.
     :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
     hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnostics
    """

    _attribute_map = {
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnostics"},
    }

    def __init__(self, *, boot_diagnostics: Optional["_models.BootDiagnostics"] = None, **kwargs: Any) -> None:
        """
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`\ **NOTE**\ : If storageUri is
         being specified then ensure that the storage account is in the same region and subscription as
         the VM. :code:`<br>`:code:`<br>` You can easily view the output of your console log.
         :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
         hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnostics
        """
        super().__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class DiffDiskSettings(_serialization.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system
    disk. :code:`<br>`:code:`<br>` NOTE: The ephemeral disk settings can only be specified for
    managed disk.

    :ivar option: Specifies the ephemeral disk settings for operating system disk. "Local"
    :vartype option: str or ~azure.mgmt.compute.v2021_11_01.models.DiffDiskOptions
    :ivar placement: Specifies the ephemeral disk placement for operating system
     disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
     :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
     one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
     Refer to VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
     cache disk. Known values are: "CacheDisk" and "ResourceDisk".
    :vartype placement: str or ~azure.mgmt.compute.v2021_11_01.models.DiffDiskPlacement
    """

    _attribute_map = {
        "option": {"key": "option", "type": "str"},
        "placement": {"key": "placement", "type": "str"},
    }

    def __init__(
        self,
        *,
        option: Optional[Union[str, "_models.DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword option: Specifies the ephemeral disk settings for operating system disk. "Local"
        :paramtype option: str or ~azure.mgmt.compute.v2021_11_01.models.DiffDiskOptions
        :keyword placement: Specifies the ephemeral disk placement for operating system
         disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
         :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
         one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
         Refer to VM size documentation for Windows VM at
         https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
         https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
         cache disk. Known values are: "CacheDisk" and "ResourceDisk".
        :paramtype placement: str or ~azure.mgmt.compute.v2021_11_01.models.DiffDiskPlacement
        """
        super().__init__(**kwargs)
        self.option = option
        self.placement = placement


class DisallowedConfiguration(_serialization.Model):
    """Specifies the disallowed configuration for a virtual machine image.

    :ivar vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
     "Unmanaged".
    :vartype vm_disk_type: str or ~azure.mgmt.compute.v2021_11_01.models.VmDiskTypes
    """

    _attribute_map = {
        "vm_disk_type": {"key": "vmDiskType", "type": "str"},
    }

    def __init__(self, *, vm_disk_type: Optional[Union[str, "_models.VmDiskTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
         "Unmanaged".
        :paramtype vm_disk_type: str or ~azure.mgmt.compute.v2021_11_01.models.VmDiskTypes
        """
        super().__init__(**kwargs)
        self.vm_disk_type = vm_disk_type


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be
    specified for disk. :code:`<br>`:code:`<br>` NOTE: The disk encryption set resource id can only
    be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more
    details.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)


class DiskEncryptionSettings(_serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key: ~azure.mgmt.compute.v2021_11_01.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.compute.v2021_11_01.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
         Vault Secret.
        :paramtype disk_encryption_key: ~azure.mgmt.compute.v2021_11_01.models.KeyVaultSecretReference
        :keyword key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        :paramtype key_encryption_key: ~azure.mgmt.compute.v2021_11_01.models.KeyVaultKeyReference
        :keyword enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskInstanceView(_serialization.Model):
    """The instance view of the disk.

    :ivar name: The disk name.
    :vartype name: str
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings:
     list[~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[DiskEncryptionSettings]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[List["_models.DiskEncryptionSettings"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings:
         list[~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses


class DiskRestorePointInstanceView(_serialization.Model):
    """The instance view of a disk restore point.

    :ivar id: Disk restore point Id.
    :vartype id: str
    :ivar replication_status: The disk restore point replication status information.
    :vartype replication_status: JSON
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "replication_status": {"key": "replicationStatus", "type": "object"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        replication_status: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Disk restore point Id.
        :paramtype id: str
        :keyword replication_status: The disk restore point replication status information.
        :paramtype replication_status: JSON
        """
        super().__init__(**kwargs)
        self.id = id
        self.replication_status = replication_status


class DiskRestorePointReplicationStatus(_serialization.Model):
    """The instance view of a disk restore point.

    :ivar status: The resource status information.
    :vartype status: JSON
    """

    _attribute_map = {
        "status": {"key": "status", "type": "object"},
    }

    def __init__(self, *, status: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword status: The resource status information.
        :paramtype status: JSON
        """
        super().__init__(**kwargs)
        self.status = status


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :ivar vm_size: Specifies the size of the virtual machine. :code:`<br>`:code:`<br>` The enum
     data type is currently deprecated and will be removed by December 23rd 2023.
     :code:`<br>`:code:`<br>` Recommended way to get the list of available sizes is using these
     APIs: :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_ :code:`<br>`:code:`<br>`
     `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
     information about virtual machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. :code:`<br>`:code:`<br>` The
     available VM sizes depend on region and availability set. Known values are: "Basic_A0",
     "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2",
     "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8",
     "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2_v2",
     "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2",
     "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
     "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
     "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3",
     "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3",
     "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
     "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2",
     "Standard_D15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4",
     "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2",
     "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2",
     "Standard_DS13-4_v2", "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2",
     "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
     "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
     "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
     "Standard_NV24".
    :vartype vm_size: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineSizeTypes
    :ivar vm_size_properties: Specifies the properties for customizing the size of the virtual
     machine. Minimum api-version: 2021-07-01. :code:`<br>`:code:`<br>` This feature is still in
     preview mode and is not supported for VirtualMachineScaleSet. :code:`<br>`:code:`<br>` Please
     follow the instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more
     details.
    :vartype vm_size_properties: ~azure.mgmt.compute.v2021_11_01.models.VMSizeProperties
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "vm_size_properties": {"key": "vmSizeProperties", "type": "VMSizeProperties"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None,
        vm_size_properties: Optional["_models.VMSizeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Specifies the size of the virtual machine. :code:`<br>`:code:`<br>` The enum
         data type is currently deprecated and will be removed by December 23rd 2023.
         :code:`<br>`:code:`<br>` Recommended way to get the list of available sizes is using these
         APIs: :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
         <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
         :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
         <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_ :code:`<br>`:code:`<br>`
         `List all available virtual machine sizes for resizing
         <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
         information about virtual machine sizes, see `Sizes for virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. :code:`<br>`:code:`<br>` The
         available VM sizes depend on region and availability set. Known values are: "Basic_A0",
         "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2",
         "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8",
         "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2_v2",
         "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2",
         "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms", "Standard_B4ms",
         "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
         "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
         "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3",
         "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3",
         "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
         "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2",
         "Standard_D15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4",
         "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2",
         "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
         "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2",
         "Standard_DS13-4_v2", "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2",
         "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
         "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
         "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
         "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
         "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
         "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
         "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
         "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
         "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
         "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
         "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
         "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
         "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
         "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
         "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
         "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
         "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
         "Standard_NV24".
        :paramtype vm_size: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineSizeTypes
        :keyword vm_size_properties: Specifies the properties for customizing the size of the virtual
         machine. Minimum api-version: 2021-07-01. :code:`<br>`:code:`<br>` This feature is still in
         preview mode and is not supported for VirtualMachineScaleSet. :code:`<br>`:code:`<br>` Please
         follow the instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more
         details.
        :paramtype vm_size_properties: ~azure.mgmt.compute.v2021_11_01.models.VMSizeProperties
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.vm_size_properties = vm_size_properties


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
    attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
    must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Image.
    :vartype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Image.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation


class ImageDisk(_serialization.Model):
    """Describes a image disk.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
     "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
    }

    def __init__(
        self,
        *,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
         "StandardSSD_ZRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        """
        super().__init__(**kwargs)
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set


class ImageDataDisk(ImageDisk):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
     "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
         "StandardSSD_ZRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.lun = lun


class ImageListResult(_serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of Images. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.Image]
    :ivar next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Image"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of Images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.Image]
        :keyword next_link: The uri to fetch the next page of Images. Call ListNext() with this to
         fetch the next page of Images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(ImageDisk):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
     "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    :ivar os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemStateTypes
    """

    _validation = {
        "os_type": {"required": True},
        "os_state": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "os_type": {"key": "osType", "type": "str"},
        "os_state": {"key": "osState", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        os_state: Union[str, "_models.OperatingSystemStateTypes"],
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
         "StandardSSD_ZRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        :keyword os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemStateTypes
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.os_type = os_type
        self.os_state = os_state


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available. Please do not use field 'version' for gallery
     image deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
     in the 'id' field without version input.
    :vartype version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version', only if
     the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    :ivar shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment.
     This can be fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: Specified the community gallery image unique id for vm
     deployment. This can be fetched from community gallery image GET call.
    :vartype community_gallery_image_id: str
    """

    _validation = {
        "exact_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "shared_gallery_image_id": {"key": "sharedGalleryImageId", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available. Please do not use field 'version'
         for gallery image deployment, gallery image should always use 'id' field for deployment, to use
         'latest' version of gallery image, just set
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
         in the 'id' field without version input.
        :paramtype version: str
        :keyword shared_gallery_image_id: Specified the shared gallery image unique id for vm
         deployment. This can be fetched from shared gallery image GET call.
        :paramtype shared_gallery_image_id: str
        :keyword community_gallery_image_id: Specified the community gallery image unique id for vm
         deployment. This can be fetched from community gallery image GET call.
        :paramtype community_gallery_image_id: str
        """
        super().__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.exact_version = None
        self.shared_gallery_image_id = shared_gallery_image_id
        self.community_gallery_image_id = community_gallery_image_id


class ImageStorageProfile(_serialization.Model):
    """Describes a storage profile.

    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2021_11_01.models.ImageOSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.v2021_11_01.models.ImageDataDisk]
    :ivar zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :vartype zone_resilient: bool
    """

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "ImageOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[ImageDataDisk]"},
        "zone_resilient": {"key": "zoneResilient", "type": "bool"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.ImageOSDisk"] = None,
        data_disks: Optional[List["_models.ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2021_11_01.models.ImageOSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.v2021_11_01.models.ImageDataDisk]
        :keyword zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
         Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        :paramtype zone_resilient: bool
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.v2021_11_01.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.v2021_11_01.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword key_url: The URL referencing a key encryption key in Key Vault. Required.
        :paramtype key_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the key. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(_serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    """

    _validation = {
        "secret_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, secret_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword secret_url: The URL referencing a secret in a Key Vault. Required.
        :paramtype secret_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LastPatchInstallationSummary(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes the properties of the last installed patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_11_01.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar maintenance_window_exceeded: Describes whether the operation ran out of time before it
     completed all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar not_selected_patch_count: The number of all available patches but not going to be
     installed because it didn't match a classification or inclusion list entry.
    :vartype not_selected_patch_count: int
    :ivar excluded_patch_count: The number of all available patches but excluded explicitly by a
     customer-specified exclusion list match.
    :vartype excluded_patch_count: int
    :ivar pending_patch_count: The number of all available patches expected to be installed over
     the course of the patch installation operation.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The count of patches that successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The count of patches that failed installation.
    :vartype failed_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "installation_activity_id": {"readonly": True},
        "maintenance_window_exceeded": {"readonly": True},
        "not_selected_patch_count": {"readonly": True},
        "excluded_patch_count": {"readonly": True},
        "pending_patch_count": {"readonly": True},
        "installed_patch_count": {"readonly": True},
        "failed_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "installation_activity_id": {"key": "installationActivityId", "type": "str"},
        "maintenance_window_exceeded": {"key": "maintenanceWindowExceeded", "type": "bool"},
        "not_selected_patch_count": {"key": "notSelectedPatchCount", "type": "int"},
        "excluded_patch_count": {"key": "excludedPatchCount", "type": "int"},
        "pending_patch_count": {"key": "pendingPatchCount", "type": "int"},
        "installed_patch_count": {"key": "installedPatchCount", "type": "int"},
        "failed_patch_count": {"key": "failedPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.maintenance_window_exceeded = None
        self.not_selected_patch_count = None
        self.excluded_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None


class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine.
    :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
    Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.compute.v2021_11_01.models.SshConfiguration
    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :vartype patch_settings: ~azure.mgmt.compute.v2021_11_01.models.LinuxPatchSettings
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "patch_settings": {"key": "patchSettings", "type": "LinuxPatchSettings"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["_models.LinuxPatchSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.compute.v2021_11_01.models.SshConfiguration
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
         Linux.
        :paramtype patch_settings: ~azure.mgmt.compute.v2021_11_01.models.LinuxPatchSettings
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.provision_vm_agent = provision_vm_agent
        self.patch_settings = patch_settings


class LinuxParameters(_serialization.Model):
    """Input for InstallPatches on a Linux VM, as directly received by the API.

    :ivar classifications_to_include: The update classifications to select when installing patches
     for Linux.
    :vartype classifications_to_include: list[str or
     ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchClassificationLinux]
    :ivar package_name_masks_to_include: packages to include in the patch operation. Format:
     packageName_packageVersion.
    :vartype package_name_masks_to_include: list[str]
    :ivar package_name_masks_to_exclude: packages to exclude in the patch operation. Format:
     packageName_packageVersion.
    :vartype package_name_masks_to_exclude: list[str]
    :ivar maintenance_run_id: This is used as a maintenance run identifier for Auto VM Guest
     Patching in Linux.
    :vartype maintenance_run_id: str
    """

    _attribute_map = {
        "classifications_to_include": {"key": "classificationsToInclude", "type": "[str]"},
        "package_name_masks_to_include": {"key": "packageNameMasksToInclude", "type": "[str]"},
        "package_name_masks_to_exclude": {"key": "packageNameMasksToExclude", "type": "[str]"},
        "maintenance_run_id": {"key": "maintenanceRunId", "type": "str"},
    }

    def __init__(
        self,
        *,
        classifications_to_include: Optional[List[Union[str, "_models.VMGuestPatchClassificationLinux"]]] = None,
        package_name_masks_to_include: Optional[List[str]] = None,
        package_name_masks_to_exclude: Optional[List[str]] = None,
        maintenance_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword classifications_to_include: The update classifications to select when installing
         patches for Linux.
        :paramtype classifications_to_include: list[str or
         ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchClassificationLinux]
        :keyword package_name_masks_to_include: packages to include in the patch operation. Format:
         packageName_packageVersion.
        :paramtype package_name_masks_to_include: list[str]
        :keyword package_name_masks_to_exclude: packages to exclude in the patch operation. Format:
         packageName_packageVersion.
        :paramtype package_name_masks_to_exclude: list[str]
        :keyword maintenance_run_id: This is used as a maintenance run identifier for Auto VM Guest
         Patching in Linux.
        :paramtype maintenance_run_id: str
        """
        super().__init__(**kwargs)
        self.classifications_to_include = classifications_to_include
        self.package_name_masks_to_include = package_name_masks_to_include
        self.package_name_masks_to_exclude = package_name_masks_to_exclude
        self.maintenance_run_id = maintenance_run_id


class LinuxPatchSettings(_serialization.Model):
    """Specifies settings related to VM Guest Patching on Linux.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **ImageDefault** - The
     virtual machine's default patching configuration is used. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform.
     The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.compute.v2021_11_01.models.LinuxVMGuestPatchMode
    :ivar assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You control the timing of patch assessments on a virtual machine. :code:`<br
     />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
     assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or
     ~azure.mgmt.compute.v2021_11_01.models.LinuxPatchAssessmentMode
    """

    _attribute_map = {
        "patch_mode": {"key": "patchMode", "type": "str"},
        "assessment_mode": {"key": "assessmentMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = None,
        assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
         machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **ImageDefault** - The
         virtual machine's default patching configuration is used. :code:`<br />`:code:`<br />`
         **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform.
         The property provisionVMAgent must be true. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype patch_mode: str or ~azure.mgmt.compute.v2021_11_01.models.LinuxVMGuestPatchMode
        :keyword assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
         machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
         **ImageDefault** - You control the timing of patch assessments on a virtual machine. :code:`<br
         />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
         assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype assessment_mode: str or
         ~azure.mgmt.compute.v2021_11_01.models.LinuxPatchAssessmentMode
        """
        super().__init__(**kwargs)
        self.patch_mode = patch_mode
        self.assessment_mode = assessment_mode


class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of compute resource usages. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of compute resource usages. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsInputBase(_serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        """
        super().__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name
        self.group_by_client_application_id = group_by_client_application_id
        self.group_by_user_agent = group_by_user_agent


class LogAnalyticsOperationResult(_serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.v2021_11_01.models.LogAnalyticsOutput
    """

    _validation = {
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "LogAnalyticsOutput"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties = None


class LogAnalyticsOutput(_serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        "output": {"readonly": True},
    }

    _attribute_map = {
        "output": {"key": "output", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.output = None


class MaintenanceRedeployStatus(_serialization.Model):
    """Maintenance Operation Status.

    :ivar is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :vartype is_customer_initiated_maintenance_allowed: bool
    :ivar pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_start_time: ~datetime.datetime
    :ivar pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_end_time: ~datetime.datetime
    :ivar maintenance_window_start_time: Start Time for the Maintenance Window.
    :vartype maintenance_window_start_time: ~datetime.datetime
    :ivar maintenance_window_end_time: End Time for the Maintenance Window.
    :vartype maintenance_window_end_time: ~datetime.datetime
    :ivar last_operation_result_code: The Last Maintenance Operation Result Code. Known values are:
     "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
    :vartype last_operation_result_code: str or
     ~azure.mgmt.compute.v2021_11_01.models.MaintenanceOperationResultCodeTypes
    :ivar last_operation_message: Message returned for the last Maintenance Operation.
    :vartype last_operation_message: str
    """

    _attribute_map = {
        "is_customer_initiated_maintenance_allowed": {"key": "isCustomerInitiatedMaintenanceAllowed", "type": "bool"},
        "pre_maintenance_window_start_time": {"key": "preMaintenanceWindowStartTime", "type": "iso-8601"},
        "pre_maintenance_window_end_time": {"key": "preMaintenanceWindowEndTime", "type": "iso-8601"},
        "maintenance_window_start_time": {"key": "maintenanceWindowStartTime", "type": "iso-8601"},
        "maintenance_window_end_time": {"key": "maintenanceWindowEndTime", "type": "iso-8601"},
        "last_operation_result_code": {"key": "lastOperationResultCode", "type": "str"},
        "last_operation_message": {"key": "lastOperationMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "_models.MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
         Maintenance.
        :paramtype is_customer_initiated_maintenance_allowed: bool
        :keyword pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_start_time: ~datetime.datetime
        :keyword pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_end_time: ~datetime.datetime
        :keyword maintenance_window_start_time: Start Time for the Maintenance Window.
        :paramtype maintenance_window_start_time: ~datetime.datetime
        :keyword maintenance_window_end_time: End Time for the Maintenance Window.
        :paramtype maintenance_window_end_time: ~datetime.datetime
        :keyword last_operation_result_code: The Last Maintenance Operation Result Code. Known values
         are: "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
        :paramtype last_operation_result_code: str or
         ~azure.mgmt.compute.v2021_11_01.models.MaintenanceOperationResultCodeTypes
        :keyword last_operation_message: Message returned for the last Maintenance Operation.
        :paramtype last_operation_message: str
        """
        super().__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
     "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.VMDiskSecurityProfile
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "security_profile": {"key": "securityProfile", "type": "VMDiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
         "StandardSSD_ZRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        :keyword security_profile: Specifies the security profile for the managed disk.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.VMDiskSecurityProfile
        """
        super().__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set
        self.security_profile = security_profile


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.primary = primary
        self.delete_option = delete_option


class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces or the networking configuration of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.compute.v2021_11_01.models.NetworkInterfaceReference]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
    :ivar network_interface_configurations: Specifies the networking configurations that will be
     used to create the virtual machine networking resources.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceConfiguration]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceReference]"},
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineNetworkInterfaceConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["_models.NetworkInterfaceReference"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineNetworkInterfaceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the virtual machine.
        :paramtype network_interfaces:
         list[~azure.mgmt.compute.v2021_11_01.models.NetworkInterfaceReference]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
        :keyword network_interface_configurations: Specifies the networking configurations that will be
         used to create the virtual machine networking resources.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces
        self.network_api_version = network_api_version
        self.network_interface_configurations = network_interface_configurations


class OrchestrationServiceStateInput(_serialization.Model):
    """The input for OrchestrationServiceState.

    All required parameters must be populated in order to send to Azure.

    :ivar service_name: The name of the service. Required. "AutomaticRepairs"
    :vartype service_name: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceNames
    :ivar action: The action to be performed. Required. Known values are: "Resume" and "Suspend".
    :vartype action: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceStateAction
    """

    _validation = {
        "service_name": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_name: Union[str, "_models.OrchestrationServiceNames"],
        action: Union[str, "_models.OrchestrationServiceStateAction"],
        **kwargs: Any
    ) -> None:
        """
        :keyword service_name: The name of the service. Required. "AutomaticRepairs"
        :paramtype service_name: str or
         ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceNames
        :keyword action: The action to be performed. Required. Known values are: "Resume" and
         "Suspend".
        :paramtype action: str or
         ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceStateAction
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.action = action


class OrchestrationServiceSummary(_serialization.Model):
    """Summary for an orchestration service of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The name of the service. "AutomaticRepairs"
    :vartype service_name: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceNames
    :ivar service_state: The current state of the service. Known values are: "NotRunning",
     "Running", and "Suspended".
    :vartype service_state: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceState
    """

    _validation = {
        "service_name": {"readonly": True},
        "service_state": {"readonly": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "service_state": {"key": "serviceState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.service_name = None
        self.service_state = None


class OSDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the operating system disk used by the virtual machine.
    :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure
    virtual machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings: ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
     storage. **ReadOnly** for Premium storage. Known values are: "None", "ReadOnly", and
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :vartype diff_disk_settings: ~azure.mgmt.compute.v2021_11_01.models.DiffDiskSettings
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion.
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach** If this
     value is used, the os disk is retained after VM is deleted. :code:`<br>`:code:`<br>` The
     default value is set to **detach**. For an ephemeral OS Disk, the default value is set to
     **Delete**. User cannot change the delete option for ephemeral OS Disk. Known values are:
     "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDeleteOptionTypes
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "diff_disk_settings": {"key": "diffDiskSettings", "type": "DiffDiskSettings"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings: ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
         storage. **ReadOnly** for Premium storage. Known values are: "None", "ReadOnly", and
         "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system
         disk used by the virtual machine.
        :paramtype diff_disk_settings: ~azure.mgmt.compute.v2021_11_01.models.DiffDiskSettings
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
        :keyword delete_option: Specifies whether OS Disk should be deleted or detached upon VM
         deletion. :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
         value is used, the OS disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach** If
         this value is used, the os disk is retained after VM is deleted. :code:`<br>`:code:`<br>` The
         default value is set to **detach**. For an ephemeral OS Disk, the default value is set to
         **Delete**. User cannot change the delete option for ephemeral OS Disk. Known values are:
         "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.diff_disk_settings = diff_disk_settings
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.delete_option = delete_option


class OSDiskImage(_serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :ivar operating_system: The operating system of the osDiskImage. Required. Known values are:
     "Windows" and "Linux".
    :vartype operating_system: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    """

    _validation = {
        "operating_system": {"required": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
    }

    def __init__(self, *, operating_system: Union[str, "_models.OperatingSystemTypes"], **kwargs: Any) -> None:
        """
        :keyword operating_system: The operating system of the osDiskImage. Required. Known values are:
         "Windows" and "Linux".
        :paramtype operating_system: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.operating_system = operating_system


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     This property cannot be updated after the VM is created. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file, for more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
     To install certificates on a virtual machine it is recommended to use the `Azure Key Vault
     virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no extensions
     are present on the virtual machine.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
        "allow_extension_operations": {"key": "allowExtensionOperations", "type": "bool"},
        "require_guest_provision_signal": {"key": "requireGuestProvisionSignal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: Specifies the host OS name of the virtual machine.
         :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
         restrictions see `Azure infrastructure services implementation guidelines
         <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
        :paramtype computer_name: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` This property cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
         secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
         updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
         saved as a file, for more information see `Custom Data on Azure VMs
         <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_
         :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
         customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machine. To install certificates on a virtual machine it is recommended to use the `Azure Key
         Vault virtual machine extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
        :keyword allow_extension_operations: Specifies whether extension operations should be allowed
         on the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no
         extensions are present on the virtual machine.
        :paramtype allow_extension_operations: bool
        :keyword require_guest_provision_signal: Optional property which must either be set to True or
         omitted.
        :paramtype require_guest_provision_signal: bool
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations
        self.require_guest_provision_signal = require_guest_provision_signal


class PatchInstallationDetail(_serialization.Model):
    """Information about a specific patch that was encountered during an installation action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version string of the package. It may conform to Semantic Versioning. Only
     applies to Linux.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar installation_state: The state of the patch after the installation operation completed.
     Known values are: "Unknown", "Installed", "Failed", "Excluded", "NotSelected", and "Pending".
    :vartype installation_state: str or
     ~azure.mgmt.compute.v2021_11_01.models.PatchInstallationState
    """

    _validation = {
        "patch_id": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
        "kb_id": {"readonly": True},
        "classifications": {"readonly": True},
        "installation_state": {"readonly": True},
    }

    _attribute_map = {
        "patch_id": {"key": "patchId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "kb_id": {"key": "kbId", "type": "str"},
        "classifications": {"key": "classifications", "type": "[str]"},
        "installation_state": {"key": "installationState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kb_id = None
        self.classifications = None
        self.installation_state = None


class PatchSettings(_serialization.Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of patches to a virtual machine. You do this by applying patches manually
     inside the VM. In this mode, automatic updates are disabled; the property
     WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
     **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
     WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
     properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known
     values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.compute.v2021_11_01.models.WindowsVMGuestPatchMode
    :ivar enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
     be set to 'AutomaticByPlatform'.
    :vartype enable_hotpatching: bool
    :ivar assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You control the timing of patch assessments on a virtual machine.:code:`<br
     />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
     assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or
     ~azure.mgmt.compute.v2021_11_01.models.WindowsPatchAssessmentMode
    """

    _attribute_map = {
        "patch_mode": {"key": "patchMode", "type": "str"},
        "enable_hotpatching": {"key": "enableHotpatching", "type": "bool"},
        "assessment_mode": {"key": "assessmentMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
         machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of patches to a virtual machine. You do this by applying patches manually
         inside the VM. In this mode, automatic updates are disabled; the property
         WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
         **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
         WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
         **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
         properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known
         values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
        :paramtype patch_mode: str or ~azure.mgmt.compute.v2021_11_01.models.WindowsVMGuestPatchMode
        :keyword enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
         reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
         be set to 'AutomaticByPlatform'.
        :paramtype enable_hotpatching: bool
        :keyword assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
         machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
         **ImageDefault** - You control the timing of patch assessments on a virtual machine.:code:`<br
         />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
         assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype assessment_mode: str or
         ~azure.mgmt.compute.v2021_11_01.models.WindowsPatchAssessmentMode
        """
        super().__init__(**kwargs)
        self.patch_mode = patch_mode
        self.enable_hotpatching = enable_hotpatching
        self.assessment_mode = assessment_mode


class Plan(_serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This
    element is only used for marketplace images. Before you can use a marketplace image from an
    API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace
    image that you want to use and then click **Want to deploy programmatically, Get Started ->**.
    Enter any required information and then click **Save**.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class ProximityPlacementGroup(Resource):
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar proximity_placement_group_type: Specifies the type of the proximity placement group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
     resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
     future use. Known values are: "Standard" and "Ultra".
    :vartype proximity_placement_group_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceWithColocationStatus]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceWithColocationStatus]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResourceWithColocationStatus]
    :ivar colocation_status: Describes colocation status of the Proximity Placement Group.
    :vartype colocation_status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "virtual_machines": {"readonly": True},
        "virtual_machine_scale_sets": {"readonly": True},
        "availability_sets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "proximity_placement_group_type": {"key": "properties.proximityPlacementGroupType", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceWithColocationStatus]"},
        "virtual_machine_scale_sets": {
            "key": "properties.virtualMachineScaleSets",
            "type": "[SubResourceWithColocationStatus]",
        },
        "availability_sets": {"key": "properties.availabilitySets", "type": "[SubResourceWithColocationStatus]"},
        "colocation_status": {"key": "properties.colocationStatus", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        proximity_placement_group_type: Optional[Union[str, "_models.ProximityPlacementGroupType"]] = None,
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword proximity_placement_group_type: Specifies the type of the proximity placement group.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
         resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
         future use. Known values are: "Standard" and "Ultra".
        :paramtype proximity_placement_group_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.ProximityPlacementGroupType
        :keyword colocation_status: Describes colocation status of the Proximity Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.proximity_placement_group_type = proximity_placement_group_type
        self.virtual_machines = None
        self.virtual_machine_scale_sets = None
        self.availability_sets = None
        self.colocation_status = colocation_status


class ProximityPlacementGroupListResult(_serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of proximity placement groups. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.ProximityPlacementGroup]
    :ivar next_link: The URI to fetch the next page of proximity placement groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProximityPlacementGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ProximityPlacementGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of proximity placement groups. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.ProximityPlacementGroup]
        :keyword next_link: The URI to fetch the next page of proximity placement groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)


class ProxyResource(_serialization.Model):
    """The resource model definition for an Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class PublicIPAddressSku(_serialization.Model):
    """Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.

    :ivar name: Specify public IP sku name. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSkuName
    :ivar tier: Specify public IP sku tier. Known values are: "Regional", "Global", and "Global".
    :vartype tier: str or ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Specify public IP sku name. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSkuName
        :keyword tier: Specify public IP sku tier. Known values are: "Regional", "Global", and
         "Global".
        :paramtype tier: str or ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class PurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    """

    _validation = {
        "publisher": {"required": True},
        "name": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(self, *, publisher: str, name: str, product: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class RecoveryWalkResponse(_serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        "walk_performed": {"readonly": True},
        "next_platform_update_domain": {"readonly": True},
    }

    _attribute_map = {
        "walk_performed": {"key": "walkPerformed", "type": "bool"},
        "next_platform_update_domain": {"key": "nextPlatformUpdateDomain", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    :ivar interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
     Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
    :vartype interval_length: str or ~azure.mgmt.compute.v2021_11_01.models.IntervalInMins
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
        "interval_length": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
        "interval_length": {"key": "intervalLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "_models.IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        :keyword interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
         Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
        :paramtype interval_length: str or ~azure.mgmt.compute.v2021_11_01.models.IntervalInMins
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            group_by_client_application_id=group_by_client_application_id,
            group_by_user_agent=group_by_user_agent,
            **kwargs
        )
        self.interval_length = interval_length


class RestorePoint(ProxyResource):
    """Restore Point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar exclude_disks: List of disk resource ids that the customer wishes to exclude from the
     restore point. If no disks are specified, all disks will be included.
    :vartype exclude_disks: list[~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference]
    :ivar source_metadata: Gets the details of the VM captured at the time of the restore point
     creation.
    :vartype source_metadata: ~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceMetadata
    :ivar provisioning_state: Gets the provisioning state of the restore point.
    :vartype provisioning_state: str
    :ivar consistency_mode: Gets the consistency mode for the restore point. Please refer to
     https://aka.ms/RestorePoints for more details. Known values are: "CrashConsistent",
     "FileSystemConsistent", and "ApplicationConsistent".
    :vartype consistency_mode: str or ~azure.mgmt.compute.v2021_11_01.models.ConsistencyModeTypes
    :ivar time_created: Gets the creation time of the restore point.
    :vartype time_created: ~datetime.datetime
    :ivar source_restore_point: Resource Id of the source restore point from which a copy needs to
     be created.
    :vartype source_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    :ivar instance_view: The restore point instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.RestorePointInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "source_metadata": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "consistency_mode": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "exclude_disks": {"key": "properties.excludeDisks", "type": "[ApiEntityReference]"},
        "source_metadata": {"key": "properties.sourceMetadata", "type": "RestorePointSourceMetadata"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "consistency_mode": {"key": "properties.consistencyMode", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "source_restore_point": {"key": "properties.sourceRestorePoint", "type": "ApiEntityReference"},
        "instance_view": {"key": "properties.instanceView", "type": "RestorePointInstanceView"},
    }

    def __init__(
        self,
        *,
        exclude_disks: Optional[List["_models.ApiEntityReference"]] = None,
        time_created: Optional[datetime.datetime] = None,
        source_restore_point: Optional["_models.ApiEntityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exclude_disks: List of disk resource ids that the customer wishes to exclude from the
         restore point. If no disks are specified, all disks will be included.
        :paramtype exclude_disks: list[~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference]
        :keyword time_created: Gets the creation time of the restore point.
        :paramtype time_created: ~datetime.datetime
        :keyword source_restore_point: Resource Id of the source restore point from which a copy needs
         to be created.
        :paramtype source_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        """
        super().__init__(**kwargs)
        self.exclude_disks = exclude_disks
        self.source_metadata = None
        self.provisioning_state = None
        self.consistency_mode = None
        self.time_created = time_created
        self.source_restore_point = source_restore_point
        self.instance_view = None


class RestorePointCollection(Resource):
    """Create or update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The properties of the source resource that this restore point collection is
     created from.
    :vartype source: ~azure.mgmt.compute.v2021_11_01.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.v2021_11_01.models.RestorePoint]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "restore_point_collection_id": {"readonly": True},
        "restore_points": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "RestorePointCollectionSourceProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "restore_point_collection_id": {"key": "properties.restorePointCollectionId", "type": "str"},
        "restore_points": {"key": "properties.restorePoints", "type": "[RestorePoint]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.RestorePointCollectionSourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The properties of the source resource that this restore point collection is
         created from.
        :paramtype source:
         ~azure.mgmt.compute.v2021_11_01.models.RestorePointCollectionSourceProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.provisioning_state = None
        self.restore_point_collection_id = None
        self.restore_points = None


class RestorePointCollectionListResult(_serialization.Model):
    """The List restore point collection operation response.

    :ivar value: Gets the list of restore point collections.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.RestorePointCollection]
    :ivar next_link: The uri to fetch the next page of RestorePointCollections. Call ListNext()
     with this to fetch the next page of RestorePointCollections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorePointCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RestorePointCollection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of restore point collections.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.RestorePointCollection]
        :keyword next_link: The uri to fetch the next page of RestorePointCollections. Call ListNext()
         with this to fetch the next page of RestorePointCollections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RestorePointCollectionSourceProperties(_serialization.Model):
    """The properties of the source resource that this restore point collection is created from.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the source resource used to create this restore point collection.
    :vartype location: str
    :ivar id: Resource Id of the source resource used to create this restore point collection.
    :vartype id: str
    """

    _validation = {
        "location": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id of the source resource used to create this restore point collection.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.location = None
        self.id = id


class RestorePointCollectionUpdate(UpdateResource):
    """Update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The properties of the source resource that this restore point collection is
     created from.
    :vartype source: ~azure.mgmt.compute.v2021_11_01.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.v2021_11_01.models.RestorePoint]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "restore_point_collection_id": {"readonly": True},
        "restore_points": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "RestorePointCollectionSourceProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "restore_point_collection_id": {"key": "properties.restorePointCollectionId", "type": "str"},
        "restore_points": {"key": "properties.restorePoints", "type": "[RestorePoint]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.RestorePointCollectionSourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The properties of the source resource that this restore point collection is
         created from.
        :paramtype source:
         ~azure.mgmt.compute.v2021_11_01.models.RestorePointCollectionSourceProperties
        """
        super().__init__(tags=tags, **kwargs)
        self.source = source
        self.provisioning_state = None
        self.restore_point_collection_id = None
        self.restore_points = None


class RestorePointInstanceView(_serialization.Model):
    """The instance view of a restore point.

    :ivar disk_restore_points: The disk restore points information.
    :vartype disk_restore_points:
     list[~azure.mgmt.compute.v2021_11_01.models.DiskRestorePointInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "disk_restore_points": {"key": "diskRestorePoints", "type": "[DiskRestorePointInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        disk_restore_points: Optional[List["_models.DiskRestorePointInstanceView"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_restore_points: The disk restore points information.
        :paramtype disk_restore_points:
         list[~azure.mgmt.compute.v2021_11_01.models.DiskRestorePointInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.disk_restore_points = disk_restore_points
        self.statuses = statuses


class RestorePointSourceMetadata(_serialization.Model):
    """Describes the properties of the Virtual Machine for which the restore point was created. The
    properties provided are a subset and the snapshot of the overall Virtual Machine properties
    captured at the time of the restore point creation.

    :ivar hardware_profile: Gets the hardware profile.
    :vartype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
    :ivar storage_profile: Gets the storage profile.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMStorageProfile
    :ivar os_profile: Gets the OS profile.
    :vartype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
    :ivar diagnostics_profile: Gets the diagnostics profile.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar license_type: Gets the license type, which is for bring your own license scenario.
    :vartype license_type: str
    :ivar vm_id: Gets the virtual machine unique id.
    :vartype vm_id: str
    :ivar security_profile: Gets the security profile.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar location: Location of the VM from which the restore point was created.
    :vartype location: str
    """

    _attribute_map = {
        "hardware_profile": {"key": "hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "storageProfile", "type": "RestorePointSourceVMStorageProfile"},
        "os_profile": {"key": "osProfile", "type": "OSProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "vm_id": {"key": "vmId", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.RestorePointSourceVMStorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        license_type: Optional[str] = None,
        vm_id: Optional[str] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hardware_profile: Gets the hardware profile.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
        :keyword storage_profile: Gets the storage profile.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMStorageProfile
        :keyword os_profile: Gets the OS profile.
        :paramtype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
        :keyword diagnostics_profile: Gets the diagnostics profile.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword license_type: Gets the license type, which is for bring your own license scenario.
        :paramtype license_type: str
        :keyword vm_id: Gets the virtual machine unique id.
        :paramtype vm_id: str
        :keyword security_profile: Gets the security profile.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword location: Location of the VM from which the restore point was created.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.diagnostics_profile = diagnostics_profile
        self.license_type = license_type
        self.vm_id = vm_id
        self.security_profile = security_profile
        self.location = location


class RestorePointSourceVMDataDisk(_serialization.Model):
    """Describes a data disk.

    :ivar lun: Gets the logical unit number.
    :vartype lun: int
    :ivar name: Gets the disk name.
    :vartype name: str
    :ivar caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar disk_size_gb: Gets the initial disk size in GB for blank data disks, and the new desired
     size for existing OS and Data disks.
    :vartype disk_size_gb: int
    :ivar managed_disk: Gets the managed disk details.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
    :ivar disk_restore_point: Gets the disk restore point Id.
    :vartype disk_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    """

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "disk_restore_point": {"key": "diskRestorePoint", "type": "ApiEntityReference"},
    }

    def __init__(
        self,
        *,
        lun: Optional[int] = None,
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        disk_restore_point: Optional["_models.ApiEntityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Gets the logical unit number.
        :paramtype lun: int
        :keyword name: Gets the disk name.
        :paramtype name: str
        :keyword caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword disk_size_gb: Gets the initial disk size in GB for blank data disks, and the new
         desired size for existing OS and Data disks.
        :paramtype disk_size_gb: int
        :keyword managed_disk: Gets the managed disk details.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
        :keyword disk_restore_point: Gets the disk restore point Id.
        :paramtype disk_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point


class RestorePointSourceVMOSDisk(_serialization.Model):
    """Describes an Operating System disk.

    :ivar os_type: Gets the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemType
    :ivar encryption_settings: Gets the disk encryption settings.
    :vartype encryption_settings: ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings
    :ivar name: Gets the disk name.
    :vartype name: str
    :ivar caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar disk_size_gb: Gets the disk size in GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: Gets the managed disk details.
    :vartype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
    :ivar disk_restore_point: Gets the disk restore point Id.
    :vartype disk_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    """

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "disk_restore_point": {"key": "diskRestorePoint", "type": "ApiEntityReference"},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "_models.OperatingSystemType"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        disk_restore_point: Optional["_models.ApiEntityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: Gets the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemType
        :keyword encryption_settings: Gets the disk encryption settings.
        :paramtype encryption_settings: ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSettings
        :keyword name: Gets the disk name.
        :paramtype name: str
        :keyword caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword disk_size_gb: Gets the disk size in GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: Gets the managed disk details.
        :paramtype managed_disk: ~azure.mgmt.compute.v2021_11_01.models.ManagedDiskParameters
        :keyword disk_restore_point: Gets the disk restore point Id.
        :paramtype disk_restore_point: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point


class RestorePointSourceVMStorageProfile(_serialization.Model):
    """Describes the storage profile.

    :ivar os_disk: Gets the OS disk of the VM captured at the time of the restore point creation.
    :vartype os_disk: ~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMOSDisk
    :ivar data_disks: Gets the data disks of the VM captured at the time of the restore point
     creation.
    :vartype data_disks: list[~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMDataDisk]
    """

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "RestorePointSourceVMOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[RestorePointSourceVMDataDisk]"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.RestorePointSourceVMOSDisk"] = None,
        data_disks: Optional[List["_models.RestorePointSourceVMDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Gets the OS disk of the VM captured at the time of the restore point
         creation.
        :paramtype os_disk: ~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMOSDisk
        :keyword data_disks: Gets the data disks of the VM captured at the time of the restore point
         creation.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2021_11_01.models.RestorePointSourceVMDataDisk]
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks


class RetrieveBootDiagnosticsDataResult(_serialization.Model):
    """The SAS URIs of the console screenshot and serial log blobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob URI.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class RollbackStatusInfo(_serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "successfully_rolledback_instance_count": {"readonly": True},
        "failed_rolledback_instance_count": {"readonly": True},
        "rollback_error": {"readonly": True},
    }

    _attribute_map = {
        "successfully_rolledback_instance_count": {"key": "successfullyRolledbackInstanceCount", "type": "int"},
        "failed_rolledback_instance_count": {"key": "failedRolledbackInstanceCount", "type": "int"},
        "rollback_error": {"key": "rollbackError", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None


class RollingUpgradePolicy(_serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :vartype pause_time_between_batches: str
    :ivar enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size.
    :vartype enable_cross_zone_upgrade: bool
    :ivar prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any
     healthy instances.
    :vartype prioritize_unhealthy_instances: bool
    """

    _validation = {
        "max_batch_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_upgraded_instance_percent": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "max_batch_instance_percent": {"key": "maxBatchInstancePercent", "type": "int"},
        "max_unhealthy_instance_percent": {"key": "maxUnhealthyInstancePercent", "type": "int"},
        "max_unhealthy_upgraded_instance_percent": {"key": "maxUnhealthyUpgradedInstancePercent", "type": "int"},
        "pause_time_between_batches": {"key": "pauseTimeBetweenBatches", "type": "str"},
        "enable_cross_zone_upgrade": {"key": "enableCrossZoneUpgrade", "type": "bool"},
        "prioritize_unhealthy_instances": {"key": "prioritizeUnhealthyInstances", "type": "bool"},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        enable_cross_zone_upgrade: Optional[bool] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_batch_instance_percent: The maximum percent of total virtual machine instances
         that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
         unhealthy instances in previous or future batches can cause the percentage of instances in a
         batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :paramtype max_batch_instance_percent: int
        :keyword max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
         instances in the scale set that can be simultaneously unhealthy, either as a result of being
         upgraded, or by being found in an unhealthy state by the virtual machine health checks before
         the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_instance_percent: int
        :keyword max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
         machine instances that can be found to be in an unhealthy state. This check will happen after
         each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_upgraded_instance_percent: int
        :keyword pause_time_between_batches: The wait time between completing the update for all
         virtual machines in one batch and starting the next batch. The time duration should be
         specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        :paramtype pause_time_between_batches: str
        :keyword enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing
         upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to
         determine the batch size.
        :paramtype enable_cross_zone_upgrade: bool
        :keyword prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before
         any healthy instances.
        :paramtype prioritize_unhealthy_instances: bool
        """
        super().__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches
        self.enable_cross_zone_upgrade = enable_cross_zone_upgrade
        self.prioritize_unhealthy_instances = prioritize_unhealthy_instances


class RollingUpgradeProgressInfo(_serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        "successful_instance_count": {"readonly": True},
        "failed_instance_count": {"readonly": True},
        "in_progress_instance_count": {"readonly": True},
        "pending_instance_count": {"readonly": True},
    }

    _attribute_map = {
        "successful_instance_count": {"key": "successfulInstanceCount", "type": "int"},
        "failed_instance_count": {"key": "failedInstanceCount", "type": "int"},
        "in_progress_instance_count": {"key": "inProgressInstanceCount", "type": "int"},
        "pending_instance_count": {"key": "pendingInstanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None


class RollingUpgradeRunningStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Known values are: "Start"
     and "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_time": {"key": "lastActionTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None


class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "policy": {"readonly": True},
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "policy": {"key": "properties.policy", "type": "RollingUpgradePolicy"},
        "running_status": {"key": "properties.runningStatus", "type": "RollingUpgradeRunningStatus"},
        "progress": {"key": "properties.progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "properties.error", "type": "ApiError"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None


class RunCommandDocumentBase(_serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    :ivar script: The script to be executed. Required.
    :vartype script: list[str]
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandParameterDefinition]
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandParameterDefinition]"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        script: List[str],
        parameters: Optional[List["_models.RunCommandParameterDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        :keyword script: The script to be executed. Required.
        :paramtype script: list[str]
        :keyword parameters: The parameters used by the script.
        :paramtype parameters:
         list[~azure.mgmt.compute.v2021_11_01.models.RunCommandParameterDefinition]
        """
        super().__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters


class RunCommandInput(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar command_id: The run command id. Required.
    :vartype command_id: str
    :ivar script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :vartype script: list[str]
    :ivar parameters: The run command parameters.
    :vartype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
    """

    _validation = {
        "command_id": {"required": True},
    }

    _attribute_map = {
        "command_id": {"key": "commandId", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandInputParameter]"},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[List[str]] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword command_id: The run command id. Required.
        :paramtype command_id: str
        :keyword script: Optional. The script to be executed.  When this value is given, the given
         script will override the default script of the command.
        :paramtype script: list[str]
        :keyword parameters: The run command parameters.
        :paramtype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
        """
        super().__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters


class RunCommandInputParameter(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar value: The run command parameter value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword value: The run command parameter value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RunCommandListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine run commands. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandDocumentBase]
    :ivar next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RunCommandDocumentBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.RunCommandDocumentBase"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandDocumentBase]
        :keyword next_link: The uri to fetch the next page of run commands. Call ListNext() with this
         to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunCommandParameterDefinition(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar type: The run command parameter type. Required.
    :vartype type: str
    :ivar default_value: The run command parameter default value.
    :vartype default_value: str
    :ivar required: The run command parameter required.
    :vartype required: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(
        self, *, name: str, type: str, default_value: Optional[str] = None, required: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword type: The run command parameter type. Required.
        :paramtype type: str
        :keyword default_value: The run command parameter default value.
        :paramtype default_value: str
        :keyword required: The run command parameter required.
        :paramtype required: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required


class RunCommandResult(_serialization.Model):
    """RunCommandResult.

    :ivar value: Run command operation response.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InstanceViewStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Run command operation response.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class ScaleInPolicy(_serialization.Model):
    """Describes a scale-in policy for a virtual machine scale set.

    :ivar rules: The rules to be followed when scaling-in a virtual machine scale set.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
     virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
     is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
     each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
     protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
     is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the oldest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
     being scaled-in, the newest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the newest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>`.
    :vartype rules: list[str or
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetScaleInRules]
    :ivar force_deletion: This property allows you to specify if virtual machines chosen for
     removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
     in Preview).
    :vartype force_deletion: bool
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[str]"},
        "force_deletion": {"key": "forceDeletion", "type": "bool"},
    }

    def __init__(
        self,
        *,
        rules: Optional[List[Union[str, "_models.VirtualMachineScaleSetScaleInRules"]]] = None,
        force_deletion: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rules: The rules to be followed when scaling-in a virtual machine scale set.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
         virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
         is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
         each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
         protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
         is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
         chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
         across zones. Within each zone, the oldest virtual machines that are not protected will be
         chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
         being scaled-in, the newest virtual machines that are not protected from scale-in will be
         chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
         across zones. Within each zone, the newest virtual machines that are not protected will be
         chosen for removal. :code:`<br>`:code:`<br>`.
        :paramtype rules: list[str or
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetScaleInRules]
        :keyword force_deletion: This property allows you to specify if virtual machines chosen for
         removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
         in Preview).
        :paramtype force_deletion: bool
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.force_deletion = force_deletion


class ScheduledEventsProfile(_serialization.Model):
    """ScheduledEventsProfile.

    :ivar terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :vartype terminate_notification_profile:
     ~azure.mgmt.compute.v2021_11_01.models.TerminateNotificationProfile
    """

    _attribute_map = {
        "terminate_notification_profile": {
            "key": "terminateNotificationProfile",
            "type": "TerminateNotificationProfile",
        },
    }

    def __init__(
        self, *, terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword terminate_notification_profile: Specifies Terminate Scheduled Event related
         configurations.
        :paramtype terminate_notification_profile:
         ~azure.mgmt.compute.v2021_11_01.models.TerminateNotificationProfile
        """
        super().__init__(**kwargs)
        self.terminate_notification_profile = terminate_notification_profile


class SecurityProfile(_serialization.Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :vartype uefi_settings: ~azure.mgmt.compute.v2021_11_01.models.UefiSettings
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself.
     :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
     is set to true for the resource.
    :vartype encryption_at_host: bool
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. :code:`<br>`:code:`<br>` Default: UefiSettings will not
     be enabled unless this property is set. Known values are: "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.compute.v2021_11_01.models.SecurityTypes
    """

    _attribute_map = {
        "uefi_settings": {"key": "uefiSettings", "type": "UefiSettings"},
        "encryption_at_host": {"key": "encryptionAtHost", "type": "bool"},
        "security_type": {"key": "securityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uefi_settings: Specifies the security settings like secure boot and vTPM used while
         creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
        :paramtype uefi_settings: ~azure.mgmt.compute.v2021_11_01.models.UefiSettings
        :keyword encryption_at_host: This property can be used by user in the request to enable or
         disable the Host Encryption for the virtual machine or virtual machine scale set. This will
         enable the encryption for all the disks including Resource/Temp disk at host itself.
         :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
         is set to true for the resource.
        :paramtype encryption_at_host: bool
        :keyword security_type: Specifies the SecurityType of the virtual machine. It has to be set to
         any specified value to enable UefiSettings. :code:`<br>`:code:`<br>` Default: UefiSettings will
         not be enabled unless this property is set. Known values are: "TrustedLaunch" and
         "ConfidentialVM".
        :paramtype security_type: str or ~azure.mgmt.compute.v2021_11_01.models.SecurityTypes
        """
        super().__init__(**kwargs)
        self.uefi_settings = uefi_settings
        self.encryption_at_host = encryption_at_host
        self.security_type = security_type


class Sku(_serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the
    hardware the scale set is currently on, you need to deallocate the VMs in the scale set before
    you modify the SKU name.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name.
        :paramtype name: str
        :keyword tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br
         />` Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
         **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of virtual machines in the scale set.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SpotRestorePolicy(_serialization.Model):
    """Specifies the Spot-Try-Restore properties for the virtual machine scale set.
    :code:`<br>`:code:`<br>` With this property customer can enable or disable automatic restore of
    the evicted Spot VMSS VM instances opportunistically based on capacity availability and pricing
    constraint.

    :ivar enabled: Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be
     tried to be restored opportunistically based on capacity availability and pricing constraints.
    :vartype enabled: bool
    :ivar restore_timeout: Timeout value expressed as an ISO 8601 time duration after which the
     platform will not try to restore the VMSS SPOT instances.
    :vartype restore_timeout: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "restore_timeout": {"key": "restoreTimeout", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, restore_timeout: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will
         be tried to be restored opportunistically based on capacity availability and pricing
         constraints.
        :paramtype enabled: bool
        :keyword restore_timeout: Timeout value expressed as an ISO 8601 time duration after which the
         platform will not try to restore the VMSS SPOT instances.
        :paramtype restore_timeout: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.restore_timeout = restore_timeout


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.compute.v2021_11_01.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.compute.v2021_11_01.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
         <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class SshPublicKeyGenerateKeyPairResult(_serialization.Model):
    """Response from generation of an SSH key pair.

    All required parameters must be populated in order to send to Azure.

    :ivar private_key: Private key portion of the key pair used to authenticate to a virtual
     machine through ssh. The private key is returned in RFC3447 format and should be treated as a
     secret. Required.
    :vartype private_key: str
    :ivar public_key: Public key portion of the key pair used to authenticate to a virtual machine
     through ssh. The public key is in ssh-rsa format. Required.
    :vartype public_key: str
    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
     Required.
    :vartype id: str
    """

    _validation = {
        "private_key": {"required": True},
        "public_key": {"required": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "private_key": {"key": "privateKey", "type": "str"},
        "public_key": {"key": "publicKey", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self, *, private_key: str, public_key: str, id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword private_key: Private key portion of the key pair used to authenticate to a virtual
         machine through ssh. The private key is returned in RFC3447 format and should be treated as a
         secret. Required.
        :paramtype private_key: str
        :keyword public_key: Public key portion of the key pair used to authenticate to a virtual
         machine through ssh. The public key is in ssh-rsa format. Required.
        :paramtype public_key: str
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
         Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.private_key = private_key
        self.public_key = public_key
        self.id = id


class SshPublicKeyResource(Resource):
    """Specifies information about the SSH public key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, location: str, tags: Optional[Dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.public_key = public_key


class SshPublicKeysGroupListResult(_serialization.Model):
    """The list SSH public keys operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of SSH public keys. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.SshPublicKeyResource]
    :ivar next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with this
     URI to fetch the next page of SSH public keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SshPublicKeyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SshPublicKeyResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of SSH public keys. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.SshPublicKeyResource]
        :keyword next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with
         this URI to fetch the next page of SSH public keys.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SshPublicKeyUpdateResource(UpdateResource):
    """Specifies information about the SSH public key.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(tags=tags, **kwargs)
        self.public_key = public_key


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2021_11_01.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.v2021_11_01.models.DataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2021_11_01.models.OSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.v2021_11_01.models.DataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class SubResourceWithColocationStatus(SubResource):
    """SubResourceWithColocationStatus.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar colocation_status: Describes colocation status of a resource in the Proximity Placement
     Group.
    :vartype colocation_status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "colocation_status": {"key": "colocationStatus", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword colocation_status: Describes colocation status of a resource in the Proximity
         Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
        """
        super().__init__(id=id, **kwargs)
        self.colocation_status = colocation_status


class TerminateNotificationProfile(_serialization.Model):
    """TerminateNotificationProfile.

    :ivar not_before_timeout: Configurable length of time a Virtual Machine being deleted will have
     to potentially approve the Terminate Scheduled Event before the event is auto approved (timed
     out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes
     (PT5M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    _attribute_map = {
        "not_before_timeout": {"key": "notBeforeTimeout", "type": "str"},
        "enable": {"key": "enable", "type": "bool"},
    }

    def __init__(
        self, *, not_before_timeout: Optional[str] = None, enable: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword not_before_timeout: Configurable length of time a Virtual Machine being deleted will
         have to potentially approve the Terminate Scheduled Event before the event is auto approved
         (timed out). The configuration must be specified in ISO 8601 format, the default value is 5
         minutes (PT5M).
        :paramtype not_before_timeout: str
        :keyword enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
        :paramtype enable: bool
        """
        super().__init__(**kwargs)
        self.not_before_timeout = not_before_timeout
        self.enable = enable


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            group_by_client_application_id=group_by_client_application_id,
            group_by_user_agent=group_by_user_agent,
            **kwargs
        )


class UefiSettings(_serialization.Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
    machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :vartype secure_boot_enabled: bool
    :ivar v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :vartype v_tpm_enabled: bool
    """

    _attribute_map = {
        "secure_boot_enabled": {"key": "secureBootEnabled", "type": "bool"},
        "v_tpm_enabled": {"key": "vTpmEnabled", "type": "bool"},
    }

    def __init__(
        self, *, secure_boot_enabled: Optional[bool] = None, v_tpm_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
         machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
        :paramtype secure_boot_enabled: bool
        :keyword v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
         :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
        :paramtype v_tpm_enabled: bool
        """
        super().__init__(**kwargs)
        self.secure_boot_enabled = secure_boot_enabled
        self.v_tpm_enabled = v_tpm_enabled


class UpgradeOperationHistoricalStatusInfo(_serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.v2021_11_01.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "properties": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "UpgradeOperationHistoricalStatusInfoProperties"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None


class UpgradeOperationHistoricalStatusInfoProperties(_serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.v2021_11_01.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Known values are: "Unknown", "User", and
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.v2021_11_01.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.v2021_11_01.models.RollbackStatusInfo
    """

    _validation = {
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
        "started_by": {"readonly": True},
        "target_image_reference": {"readonly": True},
        "rollback_info": {"readonly": True},
    }

    _attribute_map = {
        "running_status": {"key": "runningStatus", "type": "UpgradeOperationHistoryStatus"},
        "progress": {"key": "progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "error", "type": "ApiError"},
        "started_by": {"key": "startedBy", "type": "str"},
        "target_image_reference": {"key": "targetImageReference", "type": "ImageReference"},
        "rollback_info": {"key": "rollbackInfo", "type": "RollbackStatusInfo"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None


class UpgradeOperationHistoryStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2021_11_01.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None


class UpgradePolicy(_serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
     and "Rolling".
    :vartype mode: str or ~azure.mgmt.compute.v2021_11_01.models.UpgradeMode
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradePolicy
    :ivar automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :vartype automatic_os_upgrade_policy:
     ~azure.mgmt.compute.v2021_11_01.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "rolling_upgrade_policy": {"key": "rollingUpgradePolicy", "type": "RollingUpgradePolicy"},
        "automatic_os_upgrade_policy": {"key": "automaticOSUpgradePolicy", "type": "AutomaticOSUpgradePolicy"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
        automatic_os_upgrade_policy: Optional["_models.AutomaticOSUpgradePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of updates to virtual machines in the scale set. You do this by using the
         manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
         scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
         and "Rolling".
        :paramtype mode: str or ~azure.mgmt.compute.v2021_11_01.models.UpgradeMode
        :keyword rolling_upgrade_policy: The configuration parameters used while performing a rolling
         upgrade.
        :paramtype rolling_upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.RollingUpgradePolicy
        :keyword automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
         Upgrade.
        :paramtype automatic_os_upgrade_policy:
         ~azure.mgmt.compute.v2021_11_01.models.AutomaticOSUpgradePolicy
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade_policy = automatic_os_upgrade_policy


class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.compute.v2021_11_01.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name: "_models.UsageName", **kwargs: Any) -> None:
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: int
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.compute.v2021_11_01.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :vartype certificate_store: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "certificate_store": {"key": "certificateStore", "type": "str"},
    }

    def __init__(
        self, *, certificate_url: Optional[str] = None, certificate_store: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
         virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
         Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
         `Azure Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype certificate_url: str
        :keyword certificate_store: For Windows VMs, specifies the certificate store on the Virtual
         Machine to which the certificate should be added. The specified certificate store is implicitly
         in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
         placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
         for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
         these files are .pem formatted.
        :paramtype certificate_store: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.compute.v2021_11_01.models.VaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[VaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.VaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates: list[~azure.mgmt.compute.v2021_11_01.models.VaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class VirtualMachine(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtension]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :vartype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar virtual_machine_scale_set: Specifies information about the virtual machine scale set that
     the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :vartype virtual_machine_scale_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar priority: Specifies the priority for the virtual machine. :code:`<br>`:code:`<br>`Minimum
     api-version: 2019-03-01. Known values are: "Regular", "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
    :ivar host: Specifies information about the dedicated host that the virtual machine resides in.
     :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :vartype host: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :vartype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    :ivar platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :vartype platform_fault_domain: int
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
    :ivar time_created: Specifies the time at which the Virtual Machine resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "virtual_machine_scale_set": {"key": "properties.virtualMachineScaleSet", "type": "SubResource"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "priority": {"key": "properties.priority", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "billing_profile": {"key": "properties.billingProfile", "type": "BillingProfile"},
        "host": {"key": "properties.host", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "extensions_time_budget": {"key": "properties.extensionsTimeBudget", "type": "str"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "scheduled_events_profile": {"key": "properties.scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "capacity_reservation": {"key": "properties.capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "properties.applicationProfile", "type": "ApplicationProfile"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        virtual_machine_scale_set: Optional["_models.SubResource"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        host: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings used while creating the virtual
         machine. Some of the settings cannot be changed once VM is provisioned.
        :paramtype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. The availability set to which the VM is being added should be under the same resource
         group as the availability set resource. An existing VM cannot be added to an availability set.
         :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
         properties.virtualMachineScaleSet reference.
        :paramtype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword virtual_machine_scale_set: Specifies information about the virtual machine scale set
         that the virtual machine should be assigned to. Virtual machines specified in the same virtual
         machine scale set are allocated to different nodes to maximize availability. Currently, a VM
         can only be added to virtual machine scale set at creation time. An existing VM cannot be added
         to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
         non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
         2019‐03‐01.
        :paramtype virtual_machine_scale_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword priority: Specifies the priority for the virtual machine.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Known values are: "Regular", "Low",
         and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot virtual
         machine. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
        :keyword host: Specifies information about the dedicated host that the virtual machine resides
         in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
        :paramtype host: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
         :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
        :paramtype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        :keyword platform_fault_domain: Specifies the scale set logical fault domain into which the
         Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
         to a fault domain that best maintains balance across available fault
         domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
         property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
         referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
         updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
         in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
        :paramtype platform_fault_domain: int
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies information about the capacity reservation that is
         used to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.time_created = None


class VirtualMachineAgentInstanceView(_serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :ivar vm_agent_version: The VM Agent full version.
    :vartype vm_agent_version: str
    :ivar extension_handlers: The virtual machine extension handler instance view.
    :vartype extension_handlers:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionHandlerInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "vm_agent_version": {"key": "vmAgentVersion", "type": "str"},
        "extension_handlers": {"key": "extensionHandlers", "type": "[VirtualMachineExtensionHandlerInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["_models.VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_agent_version: The VM Agent full version.
        :paramtype vm_agent_version: str
        :keyword extension_handlers: The virtual machine extension handler instance view.
        :paramtype extension_handlers:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionHandlerInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses


class VirtualMachineAssessPatchesResult(_serialization.Model):
    """Describes the properties of an AssessPatches result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_11_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar available_patches: The list of patches that have been detected as available for
     installation.
    :vartype available_patches:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineSoftwarePatchProperties]
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "assessment_activity_id": {"readonly": True},
        "reboot_pending": {"readonly": True},
        "critical_and_security_patch_count": {"readonly": True},
        "other_patch_count": {"readonly": True},
        "start_date_time": {"readonly": True},
        "available_patches": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "assessment_activity_id": {"key": "assessmentActivityId", "type": "str"},
        "reboot_pending": {"key": "rebootPending", "type": "bool"},
        "critical_and_security_patch_count": {"key": "criticalAndSecurityPatchCount", "type": "int"},
        "other_patch_count": {"key": "otherPatchCount", "type": "int"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "available_patches": {"key": "availablePatches", "type": "[VirtualMachineSoftwarePatchProperties]"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_date_time = None
        self.available_patches = None
        self.error = None


class VirtualMachineCaptureParameters(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar vhd_prefix: The captured virtual hard disk's name prefix. Required.
    :vartype vhd_prefix: str
    :ivar destination_container_name: The destination container name. Required.
    :vartype destination_container_name: str
    :ivar overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in case
     of conflict. Required.
    :vartype overwrite_vhds: bool
    """

    _validation = {
        "vhd_prefix": {"required": True},
        "destination_container_name": {"required": True},
        "overwrite_vhds": {"required": True},
    }

    _attribute_map = {
        "vhd_prefix": {"key": "vhdPrefix", "type": "str"},
        "destination_container_name": {"key": "destinationContainerName", "type": "str"},
        "overwrite_vhds": {"key": "overwriteVhds", "type": "bool"},
    }

    def __init__(
        self, *, vhd_prefix: str, destination_container_name: str, overwrite_vhds: bool, **kwargs: Any
    ) -> None:
        """
        :keyword vhd_prefix: The captured virtual hard disk's name prefix. Required.
        :paramtype vhd_prefix: str
        :keyword destination_container_name: The destination container name. Required.
        :paramtype destination_container_name: str
        :keyword overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in
         case of conflict. Required.
        :paramtype overwrite_vhds: bool
        """
        super().__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds


class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar schema: the schema of the captured virtual machine.
    :vartype schema: str
    :ivar content_version: the version of the content.
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine.
    :vartype parameters: JSON
    :ivar resources: a list of resource items of the captured virtual machine.
    :vartype resources: list[JSON]
    """

    _validation = {
        "schema": {"readonly": True},
        "content_version": {"readonly": True},
        "parameters": {"readonly": True},
        "resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "schema": {"key": "$schema", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
        "parameters": {"key": "parameters", "type": "object"},
        "resources": {"key": "resources", "type": "[object]"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None


class VirtualMachineExtension(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineExtensionHandlerInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension handler.

    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar status: The extension handler status.
    :vartype status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword status: The extension handler status.
        :paramtype status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar operating_system: The operating system this extension supports.
    :vartype operating_system: str
    :ivar compute_role: The type of role (IaaS or PaaS) this extension supports.
    :vartype compute_role: str
    :ivar handler_schema: The schema defined by publisher, where extension consumers should provide
     settings in a matching schema.
    :vartype handler_schema: str
    :ivar vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :vartype vm_scale_set_enabled: bool
    :ivar supports_multiple_extensions: Whether the handler can support multiple extensions.
    :vartype supports_multiple_extensions: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "operating_system": {"key": "properties.operatingSystem", "type": "str"},
        "compute_role": {"key": "properties.computeRole", "type": "str"},
        "handler_schema": {"key": "properties.handlerSchema", "type": "str"},
        "vm_scale_set_enabled": {"key": "properties.vmScaleSetEnabled", "type": "bool"},
        "supports_multiple_extensions": {"key": "properties.supportsMultipleExtensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword operating_system: The operating system this extension supports.
        :paramtype operating_system: str
        :keyword compute_role: The type of role (IaaS or PaaS) this extension supports.
        :paramtype compute_role: str
        :keyword handler_schema: The schema defined by publisher, where extension consumers should
         provide settings in a matching schema.
        :paramtype handler_schema: str
        :keyword vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
         existing extensions are usable on scalesets, but there might be cases where a publisher wants
         to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
        :paramtype vm_scale_set_enabled: bool
        :keyword supports_multiple_extensions: Whether the handler can support multiple extensions.
        :paramtype supports_multiple_extensions: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions


class VirtualMachineExtensionInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension.

    :ivar name: The virtual machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar substatuses: The resource status information.
    :vartype substatuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "substatuses": {"key": "substatuses", "type": "[InstanceViewStatus]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["_models.InstanceViewStatus"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The virtual machine extension name.
        :paramtype name: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword substatuses: The resource status information.
        :paramtype substatuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses


class VirtualMachineExtensionsListResult(_serialization.Model):
    """The List Extension operation response.

    :ivar value: The list of extensions.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineExtension]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineExtension"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of extensions.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtension]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineExtensionUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Extension.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineHealthStatus(_serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None


class VirtualMachineIdentity(_serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Known values
     are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.v2021_11_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Virtual
     Machine. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2021_11_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the virtual machine. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the virtual machine. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.v2021_11_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the Virtual
         Machine. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.v2021_11_01.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.extended_location = extended_location


class VirtualMachineImage(VirtualMachineImageResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
    :ivar plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.PurchasePlan
    :ivar os_disk_image: Contains the os disk image information.
    :vartype os_disk_image: ~azure.mgmt.compute.v2021_11_01.models.OSDiskImage
    :ivar data_disk_images:
    :vartype data_disk_images: list[~azure.mgmt.compute.v2021_11_01.models.DataDiskImage]
    :ivar automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the image.
    :vartype automatic_os_upgrade_properties:
     ~azure.mgmt.compute.v2021_11_01.models.AutomaticOSUpgradeProperties
    :ivar hyper_v_generation: Specifies the HyperVGeneration Type. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
    :ivar disallowed: Specifies disallowed configuration for the VirtualMachine created from the
     image.
    :vartype disallowed: ~azure.mgmt.compute.v2021_11_01.models.DisallowedConfiguration
    :ivar features:
    :vartype features: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineImageFeature]
    :ivar architecture: Specifies the Architecture Type. Known values are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2021_11_01.models.ArchitectureTypes
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "plan": {"key": "properties.plan", "type": "PurchasePlan"},
        "os_disk_image": {"key": "properties.osDiskImage", "type": "OSDiskImage"},
        "data_disk_images": {"key": "properties.dataDiskImages", "type": "[DataDiskImage]"},
        "automatic_os_upgrade_properties": {
            "key": "properties.automaticOSUpgradeProperties",
            "type": "AutomaticOSUpgradeProperties",
        },
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "disallowed": {"key": "properties.disallowed", "type": "DisallowedConfiguration"},
        "features": {"key": "properties.features", "type": "[VirtualMachineImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        plan: Optional["_models.PurchasePlan"] = None,
        os_disk_image: Optional["_models.OSDiskImage"] = None,
        data_disk_images: Optional[List["_models.DataDiskImage"]] = None,
        automatic_os_upgrade_properties: Optional["_models.AutomaticOSUpgradeProperties"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        disallowed: Optional["_models.DisallowedConfiguration"] = None,
        features: Optional[List["_models.VirtualMachineImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.ArchitectureTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
        :keyword plan: Used for establishing the purchase context of any 3rd Party artifact through
         MarketPlace.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.PurchasePlan
        :keyword os_disk_image: Contains the os disk image information.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2021_11_01.models.OSDiskImage
        :keyword data_disk_images:
        :paramtype data_disk_images: list[~azure.mgmt.compute.v2021_11_01.models.DataDiskImage]
        :keyword automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the
         image.
        :paramtype automatic_os_upgrade_properties:
         ~azure.mgmt.compute.v2021_11_01.models.AutomaticOSUpgradeProperties
        :keyword hyper_v_generation: Specifies the HyperVGeneration Type. Known values are: "V1" and
         "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationTypes
        :keyword disallowed: Specifies disallowed configuration for the VirtualMachine created from the
         image.
        :paramtype disallowed: ~azure.mgmt.compute.v2021_11_01.models.DisallowedConfiguration
        :keyword features:
        :paramtype features: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineImageFeature]
        :keyword architecture: Specifies the Architecture Type. Known values are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2021_11_01.models.ArchitectureTypes
        """
        super().__init__(id=id, name=name, location=location, tags=tags, extended_location=extended_location, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images
        self.automatic_os_upgrade_properties = automatic_os_upgrade_properties
        self.hyper_v_generation = hyper_v_generation
        self.disallowed = disallowed
        self.features = features
        self.architecture = architecture


class VirtualMachineImageFeature(_serialization.Model):
    """Specifies additional capabilities supported by the image.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar value: The corresponding value for the feature.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the feature.
        :paramtype name: str
        :keyword value: The corresponding value for the feature.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class VirtualMachineInstallPatchesParameters(_serialization.Model):
    """Input for InstallPatches as directly received by the API.

    All required parameters must be populated in order to send to Azure.

    :ivar maximum_duration: Specifies the maximum amount of time that the operation will run. It
     must be an ISO 8601-compliant duration string such as PT4H (4 hours).
    :vartype maximum_duration: str
    :ivar reboot_setting: Defines when it is acceptable to reboot a VM during a software update
     operation. Required. Known values are: "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchRebootSetting
    :ivar windows_parameters: Input for InstallPatches on a Windows VM, as directly received by the
     API.
    :vartype windows_parameters: ~azure.mgmt.compute.v2021_11_01.models.WindowsParameters
    :ivar linux_parameters: Input for InstallPatches on a Linux VM, as directly received by the
     API.
    :vartype linux_parameters: ~azure.mgmt.compute.v2021_11_01.models.LinuxParameters
    """

    _validation = {
        "reboot_setting": {"required": True},
    }

    _attribute_map = {
        "maximum_duration": {"key": "maximumDuration", "type": "str"},
        "reboot_setting": {"key": "rebootSetting", "type": "str"},
        "windows_parameters": {"key": "windowsParameters", "type": "WindowsParameters"},
        "linux_parameters": {"key": "linuxParameters", "type": "LinuxParameters"},
    }

    def __init__(
        self,
        *,
        reboot_setting: Union[str, "_models.VMGuestPatchRebootSetting"],
        maximum_duration: Optional[str] = None,
        windows_parameters: Optional["_models.WindowsParameters"] = None,
        linux_parameters: Optional["_models.LinuxParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword maximum_duration: Specifies the maximum amount of time that the operation will run. It
         must be an ISO 8601-compliant duration string such as PT4H (4 hours).
        :paramtype maximum_duration: str
        :keyword reboot_setting: Defines when it is acceptable to reboot a VM during a software update
         operation. Required. Known values are: "IfRequired", "Never", and "Always".
        :paramtype reboot_setting: str or
         ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchRebootSetting
        :keyword windows_parameters: Input for InstallPatches on a Windows VM, as directly received by
         the API.
        :paramtype windows_parameters: ~azure.mgmt.compute.v2021_11_01.models.WindowsParameters
        :keyword linux_parameters: Input for InstallPatches on a Linux VM, as directly received by the
         API.
        :paramtype linux_parameters: ~azure.mgmt.compute.v2021_11_01.models.LinuxParameters
        """
        super().__init__(**kwargs)
        self.maximum_duration = maximum_duration
        self.reboot_setting = reboot_setting
        self.windows_parameters = windows_parameters
        self.linux_parameters = linux_parameters


class VirtualMachineInstallPatchesResult(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The result summary of an installation operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Failed", "Succeeded", "Unknown" or
     "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded", and
     "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_11_01.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar reboot_status: The reboot state of the VM following completion of the operation. Known
     values are: "Unknown", "NotNeeded", "Required", "Started", "Failed", and "Completed".
    :vartype reboot_status: str or ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchRebootStatus
    :ivar maintenance_window_exceeded: Whether the operation ran out of time before it completed
     all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar excluded_patch_count: The number of patches that were not installed due to the user
     blocking their installation.
    :vartype excluded_patch_count: int
    :ivar not_selected_patch_count: The number of patches that were detected as available for
     install, but did not meet the operation's criteria.
    :vartype not_selected_patch_count: int
    :ivar pending_patch_count: The number of patches that were identified as meeting the
     installation criteria, but were not able to be installed. Typically this happens when
     maintenanceWindowExceeded == true.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The number of patches successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The number of patches that could not be installed due to some issue.
     See errors for details.
    :vartype failed_patch_count: int
    :ivar patches: The patches that were installed during the operation.
    :vartype patches: list[~azure.mgmt.compute.v2021_11_01.models.PatchInstallationDetail]
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_11_01.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "installation_activity_id": {"readonly": True},
        "reboot_status": {"readonly": True},
        "maintenance_window_exceeded": {"readonly": True},
        "excluded_patch_count": {"readonly": True},
        "not_selected_patch_count": {"readonly": True},
        "pending_patch_count": {"readonly": True},
        "installed_patch_count": {"readonly": True},
        "failed_patch_count": {"readonly": True},
        "patches": {"readonly": True},
        "start_date_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "installation_activity_id": {"key": "installationActivityId", "type": "str"},
        "reboot_status": {"key": "rebootStatus", "type": "str"},
        "maintenance_window_exceeded": {"key": "maintenanceWindowExceeded", "type": "bool"},
        "excluded_patch_count": {"key": "excludedPatchCount", "type": "int"},
        "not_selected_patch_count": {"key": "notSelectedPatchCount", "type": "int"},
        "pending_patch_count": {"key": "pendingPatchCount", "type": "int"},
        "installed_patch_count": {"key": "installedPatchCount", "type": "int"},
        "failed_patch_count": {"key": "failedPatchCount", "type": "int"},
        "patches": {"key": "patches", "type": "[PatchInstallationDetail]"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.reboot_status = None
        self.maintenance_window_exceeded = None
        self.excluded_patch_count = None
        self.not_selected_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.patches = None
        self.start_date_time = None
        self.error = None


class VirtualMachineInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: Specifies the update domain of the virtual machine.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: Specifies the fault domain of the virtual machine.
    :vartype platform_fault_domain: int
    :ivar computer_name: The computer name assigned to the virtual machine.
    :vartype computer_name: str
    :ivar os_name: The Operating System running on the virtual machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the virtual machine.
    :vartype os_version: str
    :ivar hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationType
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.v2021_11_01.models.MaintenanceRedeployStatus
    :ivar disks: The virtual machine disk information.
    :vartype disks: list[~azure.mgmt.compute.v2021_11_01.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineHealthStatus
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnosticsInstanceView
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar patch_status: [Preview Feature] The status of virtual machine patch operations.
    :vartype patch_status: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePatchStatus
    """

    _validation = {
        "vm_health": {"readonly": True},
        "assigned_host": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "computer_name": {"key": "computerName", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "vm_health": {"key": "vmHealth", "type": "VirtualMachineHealthStatus"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "assigned_host": {"key": "assignedHost", "type": "str"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "patch_status": {"key": "patchStatus", "type": "VirtualMachinePatchStatus"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationType"]] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        patch_status: Optional["_models.VirtualMachinePatchStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: Specifies the update domain of the virtual machine.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: Specifies the fault domain of the virtual machine.
        :paramtype platform_fault_domain: int
        :keyword computer_name: The computer name assigned to the virtual machine.
        :paramtype computer_name: str
        :keyword os_name: The Operating System running on the virtual machine.
        :paramtype os_name: str
        :keyword os_version: The version of Operating System running on the virtual machine.
        :paramtype os_version: str
        :keyword hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource.
         Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.v2021_11_01.models.HyperVGenerationType
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.v2021_11_01.models.MaintenanceRedeployStatus
        :keyword disks: The virtual machine disk information.
        :paramtype disks: list[~azure.mgmt.compute.v2021_11_01.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        :keyword patch_status: [Preview Feature] The status of virtual machine patch operations.
        :paramtype patch_status: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePatchStatus
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.hyper_v_generation = hyper_v_generation
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.assigned_host = None
        self.statuses = statuses
        self.patch_status = patch_status


class VirtualMachineIpTag(_serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class VirtualMachineListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machines. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachine]
    :ivar next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machines. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachine]
        :keyword next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to
         fetch the next page of Virtual Machines.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineNetworkInterfaceConfiguration(_serialization.Model):
    """Describes a virtual machine network interface configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The network interface configuration name. Required.
    :vartype name: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration
    :ivar ip_configurations: Specifies the IP configurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceIPConfiguration]
    :ivar dscp_configuration:
    :vartype dscp_configuration: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "enable_fpga": {"key": "properties.enableFpga", "type": "bool"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineNetworkInterfaceDnsSettingsConfiguration",
        },
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[VirtualMachineNetworkInterfaceIPConfiguration]",
        },
        "dscp_configuration": {"key": "properties.dscpConfiguration", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        name: str,
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineNetworkInterfaceIPConfiguration"]] = None,
        dscp_configuration: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The network interface configuration name. Required.
        :paramtype name: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :paramtype enable_fpga: bool
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration
        :keyword ip_configurations: Specifies the IP configurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineNetworkInterfaceIPConfiguration]
        :keyword dscp_configuration:
        :paramtype dscp_configuration: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.name = name
        self.primary = primary
        self.delete_option = delete_option
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.enable_ip_forwarding = enable_ip_forwarding
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.dscp_configuration = dscp_configuration


class VirtualMachineNetworkInterfaceDnsSettingsConfiguration(_serialization.Model):
    """Describes a virtual machines network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: List of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineNetworkInterfaceIPConfiguration(_serialization.Model):
    """Describes a virtual machine network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersions
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A virtual machine can reference backend address pools of
     multiple application gateways. Multiple virtual machines cannot use the same application
     gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A virtual machine can reference backend address pools of one public
     and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load
     balancer].
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachinePublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_security_groups": {"key": "properties.applicationSecurityGroups", "type": "[SubResource]"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
    }

    def __init__(
        self,
        *,
        name: str,
        subnet: Optional["_models.SubResource"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachinePublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The IP configuration name. Required.
        :paramtype name: str
        :keyword subnet: Specifies the identifier of the subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersions
        :keyword application_security_groups: Specifies an array of references to application security
         group.
        :paramtype application_security_groups:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword application_gateway_backend_address_pools: Specifies an array of references to backend
         address pools of application gateways. A virtual machine can reference backend address pools of
         multiple application gateways. Multiple virtual machines cannot use the same application
         gateway.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword load_balancer_backend_address_pools: Specifies an array of references to backend
         address pools of load balancers. A virtual machine can reference backend address pools of one
         public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku
         load balancer].
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        """
        super().__init__(**kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_security_groups = application_security_groups
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools


class VirtualMachinePatchStatus(_serialization.Model):
    """The status of virtual machine patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_patch_summary: The available patch summary of the latest assessment operation
     for the virtual machine.
    :vartype available_patch_summary: ~azure.mgmt.compute.v2021_11_01.models.AvailablePatchSummary
    :ivar last_patch_installation_summary: The installation summary of the latest installation
     operation for the virtual machine.
    :vartype last_patch_installation_summary:
     ~azure.mgmt.compute.v2021_11_01.models.LastPatchInstallationSummary
    :ivar configuration_statuses: The enablement status of the specified patchMode.
    :vartype configuration_statuses:
     list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _validation = {
        "configuration_statuses": {"readonly": True},
    }

    _attribute_map = {
        "available_patch_summary": {"key": "availablePatchSummary", "type": "AvailablePatchSummary"},
        "last_patch_installation_summary": {
            "key": "lastPatchInstallationSummary",
            "type": "LastPatchInstallationSummary",
        },
        "configuration_statuses": {"key": "configurationStatuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        available_patch_summary: Optional["_models.AvailablePatchSummary"] = None,
        last_patch_installation_summary: Optional["_models.LastPatchInstallationSummary"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_patch_summary: The available patch summary of the latest assessment
         operation for the virtual machine.
        :paramtype available_patch_summary:
         ~azure.mgmt.compute.v2021_11_01.models.AvailablePatchSummary
        :keyword last_patch_installation_summary: The installation summary of the latest installation
         operation for the virtual machine.
        :paramtype last_patch_installation_summary:
         ~azure.mgmt.compute.v2021_11_01.models.LastPatchInstallationSummary
        """
        super().__init__(**kwargs)
        self.available_patch_summary = available_patch_summary
        self.last_patch_installation_summary = last_patch_installation_summary
        self.configuration_statuses = None


class VirtualMachinePublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar sku: Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSku
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar delete_option: Specify what happens to the public IP address when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePublicIPAddressDnsSettingsConfiguration
    :ivar ip_tags: The list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIpTag]
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersions
    :ivar public_ip_allocation_method: Specify the public IP allocation type. Known values are:
     "Dynamic" and "Static".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.compute.v2021_11_01.models.PublicIPAllocationMethod
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "PublicIPAddressSku"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachinePublicIPAddressDnsSettingsConfiguration",
        },
        "ip_tags": {"key": "properties.ipTags", "type": "[VirtualMachineIpTag]"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "public_ip_allocation_method": {"key": "properties.publicIPAllocationMethod", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        dns_settings: Optional["_models.VirtualMachinePublicIPAddressDnsSettingsConfiguration"] = None,
        ip_tags: Optional[List["_models.VirtualMachineIpTag"]] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersions"]] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.PublicIPAllocationMethod"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The publicIP address configuration name. Required.
        :paramtype name: str
        :keyword sku: Describes the public IP Sku. It can only be set with OrchestrationMode as
         Flexible.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSku
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword delete_option: Specify what happens to the public IP address when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePublicIPAddressDnsSettingsConfiguration
        :keyword ip_tags: The list of IP tags associated with the public IP address.
        :paramtype ip_tags: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIpTag]
        :keyword public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :paramtype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersions
        :keyword public_ip_allocation_method: Specify the public IP allocation type. Known values are:
         "Dynamic" and "Static".
        :paramtype public_ip_allocation_method: str or
         ~azure.mgmt.compute.v2021_11_01.models.PublicIPAllocationMethod
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.delete_option = delete_option
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.public_ip_prefix = public_ip_prefix
        self.public_ip_address_version = public_ip_address_version
        self.public_ip_allocation_method = public_ip_allocation_method


class VirtualMachinePublicIPAddressDnsSettingsConfiguration(_serialization.Model):
    """Describes a virtual machines network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name_label: The Domain name label prefix of the PublicIPAddress resources that
     will be created. The generated name label is the concatenation of the domain name label and vm
     network profile unique ID. Required.
    :vartype domain_name_label: str
    """

    _validation = {
        "domain_name_label": {"required": True},
    }

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
    }

    def __init__(self, *, domain_name_label: str, **kwargs: Any) -> None:
        """
        :keyword domain_name_label: The Domain name label prefix of the PublicIPAddress resources that
         will be created. The generated name label is the concatenation of the domain name label and vm
         network profile unique ID. Required.
        :paramtype domain_name_label: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineReimageParameters(_serialization.Model):
    """Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be
    reimaged.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
    }

    def __init__(self, *, temp_disk: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        """
        super().__init__(**kwargs)
        self.temp_disk = temp_disk


class VirtualMachineRunCommand(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The source of the run command script.
    :vartype source: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandScriptSource
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
    :ivar protected_parameters: The parameters used by the script.
    :vartype protected_parameters:
     list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
    :ivar async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :vartype async_execution: bool
    :ivar run_as_user: Specifies the user account on the VM when executing the run command.
    :vartype run_as_user: str
    :ivar run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :vartype run_as_password: str
    :ivar timeout_in_seconds: The timeout in seconds to execute the run command.
    :vartype timeout_in_seconds: int
    :ivar output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :vartype output_blob_uri: str
    :ivar error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :vartype error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "VirtualMachineRunCommandScriptSource"},
        "parameters": {"key": "properties.parameters", "type": "[RunCommandInputParameter]"},
        "protected_parameters": {"key": "properties.protectedParameters", "type": "[RunCommandInputParameter]"},
        "async_execution": {"key": "properties.asyncExecution", "type": "bool"},
        "run_as_user": {"key": "properties.runAsUser", "type": "str"},
        "run_as_password": {"key": "properties.runAsPassword", "type": "str"},
        "timeout_in_seconds": {"key": "properties.timeoutInSeconds", "type": "int"},
        "output_blob_uri": {"key": "properties.outputBlobUri", "type": "str"},
        "error_blob_uri": {"key": "properties.errorBlobUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineRunCommandInstanceView"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        async_execution: bool = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The source of the run command script.
        :paramtype source: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandScriptSource
        :keyword parameters: The parameters used by the script.
        :paramtype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
        :keyword protected_parameters: The parameters used by the script.
        :paramtype protected_parameters:
         list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
        :keyword async_execution: Optional. If set to true, provisioning will complete as soon as the
         script starts and will not wait for script to complete.
        :paramtype async_execution: bool
        :keyword run_as_user: Specifies the user account on the VM when executing the run command.
        :paramtype run_as_user: str
        :keyword run_as_password: Specifies the user account password on the VM when executing the run
         command.
        :paramtype run_as_password: str
        :keyword timeout_in_seconds: The timeout in seconds to execute the run command.
        :paramtype timeout_in_seconds: int
        :keyword output_blob_uri: Specifies the Azure storage blob where script output stream will be
         uploaded.
        :paramtype output_blob_uri: str
        :keyword error_blob_uri: Specifies the Azure storage blob where script error stream will be
         uploaded.
        :paramtype error_blob_uri: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineRunCommandInstanceView(_serialization.Model):
    """The instance view of a virtual machine run command.

    :ivar execution_state: Script execution status. Known values are: "Unknown", "Pending",
     "Running", "Failed", "Succeeded", "TimedOut", and "Canceled".
    :vartype execution_state: str or ~azure.mgmt.compute.v2021_11_01.models.ExecutionState
    :ivar execution_message: Communicate script configuration errors or execution messages.
    :vartype execution_message: str
    :ivar exit_code: Exit code returned from script execution.
    :vartype exit_code: int
    :ivar output: Script output stream.
    :vartype output: str
    :ivar error: Script error stream.
    :vartype error: str
    :ivar start_time: Script start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Script end time.
    :vartype end_time: ~datetime.datetime
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "execution_state": {"key": "executionState", "type": "str"},
        "execution_message": {"key": "executionMessage", "type": "str"},
        "exit_code": {"key": "exitCode", "type": "int"},
        "output": {"key": "output", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        execution_state: Optional[Union[str, "_models.ExecutionState"]] = None,
        execution_message: Optional[str] = None,
        exit_code: Optional[int] = None,
        output: Optional[str] = None,
        error: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword execution_state: Script execution status. Known values are: "Unknown", "Pending",
         "Running", "Failed", "Succeeded", "TimedOut", and "Canceled".
        :paramtype execution_state: str or ~azure.mgmt.compute.v2021_11_01.models.ExecutionState
        :keyword execution_message: Communicate script configuration errors or execution messages.
        :paramtype execution_message: str
        :keyword exit_code: Exit code returned from script execution.
        :paramtype exit_code: int
        :keyword output: Script output stream.
        :paramtype output: str
        :keyword error: Script error stream.
        :paramtype error: str
        :keyword start_time: Script start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Script end time.
        :paramtype end_time: ~datetime.datetime
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.execution_state = execution_state
        self.execution_message = execution_message
        self.exit_code = exit_code
        self.output = output
        self.error = error
        self.start_time = start_time
        self.end_time = end_time
        self.statuses = statuses


class VirtualMachineRunCommandScriptSource(_serialization.Model):
    """Describes the script sources for run command.

    :ivar script: Specifies the script content to be executed on the VM.
    :vartype script: str
    :ivar script_uri: Specifies the script download location.
    :vartype script_uri: str
    :ivar command_id: Specifies a commandId of predefined built-in script.
    :vartype command_id: str
    """

    _attribute_map = {
        "script": {"key": "script", "type": "str"},
        "script_uri": {"key": "scriptUri", "type": "str"},
        "command_id": {"key": "commandId", "type": "str"},
    }

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        script_uri: Optional[str] = None,
        command_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword script: Specifies the script content to be executed on the VM.
        :paramtype script: str
        :keyword script_uri: Specifies the script download location.
        :paramtype script_uri: str
        :keyword command_id: Specifies a commandId of predefined built-in script.
        :paramtype command_id: str
        """
        super().__init__(**kwargs)
        self.script = script
        self.script_uri = script_uri
        self.command_id = command_id


class VirtualMachineRunCommandsListResult(_serialization.Model):
    """The List run command operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of run commands. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommand]
    :ivar next_link: The uri to fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineRunCommand]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineRunCommand"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommand]
        :keyword next_link: The uri to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineRunCommandUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The source of the run command script.
    :vartype source: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandScriptSource
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
    :ivar protected_parameters: The parameters used by the script.
    :vartype protected_parameters:
     list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
    :ivar async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :vartype async_execution: bool
    :ivar run_as_user: Specifies the user account on the VM when executing the run command.
    :vartype run_as_user: str
    :ivar run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :vartype run_as_password: str
    :ivar timeout_in_seconds: The timeout in seconds to execute the run command.
    :vartype timeout_in_seconds: int
    :ivar output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :vartype output_blob_uri: str
    :ivar error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :vartype error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "VirtualMachineRunCommandScriptSource"},
        "parameters": {"key": "properties.parameters", "type": "[RunCommandInputParameter]"},
        "protected_parameters": {"key": "properties.protectedParameters", "type": "[RunCommandInputParameter]"},
        "async_execution": {"key": "properties.asyncExecution", "type": "bool"},
        "run_as_user": {"key": "properties.runAsUser", "type": "str"},
        "run_as_password": {"key": "properties.runAsPassword", "type": "str"},
        "timeout_in_seconds": {"key": "properties.timeoutInSeconds", "type": "int"},
        "output_blob_uri": {"key": "properties.outputBlobUri", "type": "str"},
        "error_blob_uri": {"key": "properties.errorBlobUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineRunCommandInstanceView"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        async_execution: bool = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The source of the run command script.
        :paramtype source: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineRunCommandScriptSource
        :keyword parameters: The parameters used by the script.
        :paramtype parameters: list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
        :keyword protected_parameters: The parameters used by the script.
        :paramtype protected_parameters:
         list[~azure.mgmt.compute.v2021_11_01.models.RunCommandInputParameter]
        :keyword async_execution: Optional. If set to true, provisioning will complete as soon as the
         script starts and will not wait for script to complete.
        :paramtype async_execution: bool
        :keyword run_as_user: Specifies the user account on the VM when executing the run command.
        :paramtype run_as_user: str
        :keyword run_as_password: Specifies the user account password on the VM when executing the run
         command.
        :paramtype run_as_password: str
        :keyword timeout_in_seconds: The timeout in seconds to execute the run command.
        :paramtype timeout_in_seconds: int
        :keyword output_blob_uri: Specifies the Azure storage blob where script output stream will be
         uploaded.
        :paramtype output_blob_uri: str
        :keyword error_blob_uri: Specifies the Azure storage blob where script error stream will be
         uploaded.
        :paramtype error_blob_uri: str
        """
        super().__init__(tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineScaleSet(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentity
    :ivar zones: The virtual machine scale set zones. NOTE: Availability zones can only be set when
     you create the scale set.
    :vartype zones: list[str]
    :ivar extended_location: The extended location of the Virtual Machine Scale Set.
    :vartype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.UpgradePolicy
    :ivar automatic_repairs_policy: Policy for automatic repairs.
    :vartype automatic_repairs_policy:
     ~azure.mgmt.compute.v2021_11_01.models.AutomaticRepairsPolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :vartype do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :vartype single_placement_group: bool
    :ivar zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage. zoneBalance property can only be set if the zones property of the
     scale set contains more than one zone. If there are no zones or only one zone specified, then
     zoneBalance property should not be set.
    :vartype zone_balance: bool
    :ivar platform_fault_domain_count: Fault Domain count for each placement group.
    :vartype platform_fault_domain_count: int
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
    :vartype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :vartype additional_capabilities: ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
    :ivar scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in the
     Virtual Machine Scale Set.
    :vartype scale_in_policy: ~azure.mgmt.compute.v2021_11_01.models.ScaleInPolicy
    :ivar orchestration_mode: Specifies the orchestration mode for the virtual machine scale set.
     Known values are: "Uniform" and "Flexible".
    :vartype orchestration_mode: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationMode
    :ivar spot_restore_policy: Specifies the Spot Restore properties for the virtual machine scale
     set.
    :vartype spot_restore_policy: ~azure.mgmt.compute.v2021_11_01.models.SpotRestorePolicy
    :ivar time_created: Specifies the time at which the Virtual Machine Scale Set resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "automatic_repairs_policy": {"key": "properties.automaticRepairsPolicy", "type": "AutomaticRepairsPolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetVMProfile",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "do_not_run_extensions_on_overprovisioned_v_ms": {
            "key": "properties.doNotRunExtensionsOnOverprovisionedVMs",
            "type": "bool",
        },
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
        "zone_balance": {"key": "properties.zoneBalance", "type": "bool"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "scale_in_policy": {"key": "properties.scaleInPolicy", "type": "ScaleInPolicy"},
        "orchestration_mode": {"key": "properties.orchestrationMode", "type": "str"},
        "spot_restore_policy": {"key": "properties.spotRestorePolicy", "type": "SpotRestorePolicy"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["_models.AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        zone_balance: Optional[bool] = None,
        platform_fault_domain_count: Optional[int] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        scale_in_policy: Optional["_models.ScaleInPolicy"] = None,
        orchestration_mode: Optional[Union[str, "_models.OrchestrationMode"]] = None,
        spot_restore_policy: Optional["_models.SpotRestorePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentity
        :keyword zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
         when you create the scale set.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location of the Virtual Machine Scale Set.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_11_01.models.ExtendedLocation
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.UpgradePolicy
        :keyword automatic_repairs_policy: Policy for automatic repairs.
        :paramtype automatic_repairs_policy:
         ~azure.mgmt.compute.v2021_11_01.models.AutomaticRepairsPolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled,
         extensions are launched only on the requested number of VMs which are finally kept. This
         property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :paramtype do_not_run_extensions_on_overprovisioned_v_ms: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be
         modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :paramtype single_placement_group: bool
        :keyword zone_balance: Whether to force strictly even Virtual Machine distribution cross
         x-zones in case there is zone outage. zoneBalance property can only be set if the zones
         property of the scale set contains more than one zone. If there are no zones or only one zone
         specified, then zoneBalance property should not be set.
        :paramtype zone_balance: bool
        :keyword platform_fault_domain_count: Fault Domain count for each placement group.
        :paramtype platform_fault_domain_count: int
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
         api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
        :paramtype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
         have the capability to support attaching managed data disks with UltraSSD_LRS storage account
         type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
        :keyword scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in
         the Virtual Machine Scale Set.
        :paramtype scale_in_policy: ~azure.mgmt.compute.v2021_11_01.models.ScaleInPolicy
        :keyword orchestration_mode: Specifies the orchestration mode for the virtual machine scale
         set. Known values are: "Uniform" and "Flexible".
        :paramtype orchestration_mode: str or ~azure.mgmt.compute.v2021_11_01.models.OrchestrationMode
        :keyword spot_restore_policy: Specifies the Spot Restore properties for the virtual machine
         scale set.
        :paramtype spot_restore_policy: ~azure.mgmt.compute.v2021_11_01.models.SpotRestorePolicy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.unique_id = None
        self.single_placement_group = single_placement_group
        self.zone_balance = zone_balance
        self.platform_fault_domain_count = platform_fault_domain_count
        self.proximity_placement_group = proximity_placement_group
        self.host_group = host_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.orchestration_mode = orchestration_mode
        self.spot_restore_policy = spot_restore_policy
        self.time_created = None


class VirtualMachineScaleSetDataDisk(_serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: The create option. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
     Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB.
    :vartype disk_m_bps_read_write: int
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
        "disk_iops_read_write": {"key": "diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "diskMBpsReadWrite", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: The create option. Required. Known values are: "FromImage", "Empty",
         and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
        :keyword disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be
         used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
         assigned based on diskSizeGB.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
         Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
         would be assigned based on diskSizeGB.
        :paramtype disk_m_bps_read_write: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write


class VirtualMachineScaleSetExtension(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provision_after_extensions": {"key": "properties.provisionAfterExtensions", "type": "[str]"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        provision_after_extensions: Optional[List[str]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineScaleSetExtensionListResult(_serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of VM scale set extensions. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtension]
    :ivar next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetExtension"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of VM scale set extensions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtension]
        :keyword next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
         with this to fetch the next page of VM scale set extensions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetExtensionProfile(_serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :ivar extensions: The virtual machine scale set child extension resources.
    :vartype extensions:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtension]
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetExtension]"},
        "extensions_time_budget": {"key": "extensionsTimeBudget", "type": "str"},
    }

    def __init__(
        self,
        *,
        extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = None,
        extensions_time_budget: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extensions: The virtual machine scale set child extension resources.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtension]
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        """
        super().__init__(**kwargs)
        self.extensions = extensions
        self.extensions_time_budget = extensions_time_budget


class VirtualMachineScaleSetExtensionUpdate(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provision_after_extensions": {"key": "properties.provisionAfterExtensions", "type": "[str]"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        provision_after_extensions: Optional[List[str]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineScaleSetHardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine scale set.

    :ivar vm_size_properties: Specifies the properties for customizing the size of the virtual
     machine. Minimum api-version: 2021-11-01. :code:`<br>`:code:`<br>` Please follow the
     instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more details.
    :vartype vm_size_properties: ~azure.mgmt.compute.v2021_11_01.models.VMSizeProperties
    """

    _attribute_map = {
        "vm_size_properties": {"key": "vmSizeProperties", "type": "VMSizeProperties"},
    }

    def __init__(self, *, vm_size_properties: Optional["_models.VMSizeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size_properties: Specifies the properties for customizing the size of the virtual
         machine. Minimum api-version: 2021-11-01. :code:`<br>`:code:`<br>` Please follow the
         instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more details.
        :paramtype vm_size_properties: ~azure.mgmt.compute.v2021_11_01.models.VMSizeProperties
        """
        super().__init__(**kwargs)
        self.vm_size_properties = vm_size_properties


class VirtualMachineScaleSetIdentity(_serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.compute.v2021_11_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the virtual machine
     scale set. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[str, "_models.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the virtual machine scale set. The type
         'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
         assigned identities. The type 'None' will remove any identities from the virtual machine scale
         set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.compute.v2021_11_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the virtual
         machine scale set. The user identity dictionary key references will be ARM resource ids in the
         form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue(_serialization.Model):
    """VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualMachineScaleSetInstanceView(_serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMExtensionsSummary]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar orchestration_services: The orchestration services information.
    :vartype orchestration_services:
     list[~azure.mgmt.compute.v2021_11_01.models.OrchestrationServiceSummary]
    """

    _validation = {
        "virtual_machine": {"readonly": True},
        "extensions": {"readonly": True},
        "orchestration_services": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine": {"key": "virtualMachine", "type": "VirtualMachineScaleSetInstanceViewStatusesSummary"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetVMExtensionsSummary]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "orchestration_services": {"key": "orchestrationServices", "type": "[OrchestrationServiceSummary]"},
    }

    def __init__(self, *, statuses: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses
        self.orchestration_services = None


class VirtualMachineScaleSetInstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of
     the load balancers. A scale set can reference inbound nat pools of one public and one internal
     load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetPublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "application_security_groups": {"key": "properties.applicationSecurityGroups", "type": "[SubResource]"},
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name. Required.
        :paramtype name: str
        :keyword subnet: Specifies the identifier of the subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
        :keyword application_gateway_backend_address_pools: Specifies an array of references to backend
         address pools of application gateways. A scale set can reference backend address pools of
         multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword application_security_groups: Specifies an array of references to application security
         group.
        :paramtype application_security_groups:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword load_balancer_backend_address_pools: Specifies an array of references to backend
         address pools of load balancers. A scale set can reference backend address pools of one public
         and one internal load balancer. Multiple scale sets cannot use the same basic sku load
         balancer.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
         of the load balancers. A scale set can reference inbound nat pools of one public and one
         internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetIpTag(_serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class VirtualMachineScaleSetListOSUpgradeHistory(_serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of OS upgrades performed on the virtual machine scale set. Required.
    :vartype value:
     list[~azure.mgmt.compute.v2021_11_01.models.UpgradeOperationHistoricalStatusInfo]
    :ivar next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpgradeOperationHistoricalStatusInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.UpgradeOperationHistoricalStatusInfo"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of OS upgrades performed on the virtual machine scale set. Required.
        :paramtype value:
         list[~azure.mgmt.compute.v2021_11_01.models.UpgradeOperationHistoricalStatusInfo]
        :keyword next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
         this to fetch the next page of history of upgrades.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of VMSS.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListSkusResult(_serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of skus available for the virtual machine scale set. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetSku]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetSku"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of skus available for the virtual machine scale set. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetSku]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
         ListNext() with this to fetch the next page of VMSS Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListWithLinkResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of Virtual Machine Scale Sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetManagedDiskParameters(_serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
     "StandardSSD_ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.VMDiskSecurityProfile
    """

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "security_profile": {"key": "securityProfile", "type": "VMDiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", and
         "StandardSSD_ZRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        :keyword security_profile: Specifies the security profile for the managed disk.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.VMDiskSecurityProfile
        """
        super().__init__(**kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set
        self.security_profile = security_profile


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name. Required.
    :vartype name: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: Specifies the IP configurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "enable_fpga": {"key": "properties.enableFpga", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualMachineScaleSetIPConfiguration]"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name. Required.
        :paramtype name: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :paramtype enable_fpga: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: Specifies the IP configurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: List of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineScaleSetNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :vartype health_probe: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfiguration]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
    """

    _attribute_map = {
        "health_probe": {"key": "healthProbe", "type": "ApiEntityReference"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_probe: A reference to a load balancer probe used to determine the health of an
         instance in the virtual machine scale set. The reference will be in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :paramtype health_probe: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfiguration]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
         orchestration mode 'Flexible'. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
        """
        super().__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version


class VirtualMachineScaleSetOSDisk(_serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     "FromImage", "Empty", and "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
    :ivar diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk
     used by the virtual machine scale set.
    :vartype diff_disk_settings: ~azure.mgmt.compute.v2021_11_01.models.DiffDiskSettings
    :ivar disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
    :ivar image: Specifies information about the unmanaged user image to base the scale set on.
    :vartype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "diff_disk_settings": {"key": "diffDiskSettings", "type": "DiffDiskSettings"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machines in the scale set should be
         created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
         used when you are using an image to create the virtual machine. If you are using a platform
         image, you also use the imageReference element described above. If you are using a marketplace
         image, you  also use the plan element previously described. Required. Known values are:
         "FromImage", "Empty", and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2021_11_01.models.DiskCreateOptionTypes
        :keyword diff_disk_settings: Specifies the ephemeral disk Settings for the operating system
         disk used by the virtual machine scale set.
        :paramtype diff_disk_settings: ~azure.mgmt.compute.v2021_11_01.models.DiffDiskSettings
        :keyword disk_size_gb: Specifies the size of the operating system disk in gigabytes. This
         element can be used to overwrite the size of the disk in a virtual machine image.
         :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_11_01.models.OperatingSystemTypes
        :keyword image: Specifies information about the unmanaged user image to base the scale set on.
        :paramtype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword vhd_containers: Specifies the container urls that are used to store operating system
         disks for the scale set.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.diff_disk_settings = diff_disk_settings
        self.disk_size_gb = disk_size_gb
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :vartype computer_name_prefix: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machines
     in the scale set. To install certificates on a virtual machine it is recommended to use the
     `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine scale set. :code:`<br>`:code:`<br>`This may only be set to False when no
     extensions are present on the virtual machine scale set.
    :vartype allow_extension_operations: bool
    """

    _attribute_map = {
        "computer_name_prefix": {"key": "computerNamePrefix", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
        "allow_extension_operations": {"key": "allowExtensionOperations", "type": "bool"},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name_prefix: Specifies the computer name prefix for all of the virtual
         machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :paramtype computer_name_prefix: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
         your VM, see `Using cloud-init to customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machines in the scale set. To install certificates on a virtual machine it is recommended to
         use the `Azure Key Vault virtual machine extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
        :keyword allow_extension_operations: Specifies whether extension operations should be allowed
         on the virtual machine scale set. :code:`<br>`:code:`<br>`This may only be set to False when no
         extensions are present on the virtual machine scale set.
        :paramtype allow_extension_operations: bool
        """
        super().__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations


class VirtualMachineScaleSetPublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar sku: Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSku
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :ivar ip_tags: The list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIpTag]
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
    :ivar delete_option: Specify what happens to the public IP when the VM is deleted. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "PublicIPAddressSku"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
        "ip_tags": {"key": "properties.ipTags", "type": "[VirtualMachineScaleSetIpTag]"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        ip_tags: Optional[List["_models.VirtualMachineScaleSetIpTag"]] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The publicIP address configuration name. Required.
        :paramtype name: str
        :keyword sku: Describes the public IP Sku. It can only be set with OrchestrationMode as
         Flexible.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.PublicIPAddressSku
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        :keyword ip_tags: The list of IP tags associated with the public IP address.
        :paramtype ip_tags: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIpTag]
        :keyword public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :paramtype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
        :keyword delete_option: Specify what happens to the public IP when the VM is deleted. Known
         values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.public_ip_prefix = public_ip_prefix
        self.public_ip_address_version = public_ip_address_version
        self.delete_option = delete_option


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name_label: The Domain name label.The concatenation of the domain name label and
     vm index will be the domain name labels of the PublicIPAddress resources that will be created.
     Required.
    :vartype domain_name_label: str
    """

    _validation = {
        "domain_name_label": {"required": True},
    }

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
    }

    def __init__(self, *, domain_name_label: str, **kwargs: Any) -> None:
        """
        :keyword domain_name_label: The Domain name label.The concatenation of the domain name label
         and vm index will be the domain name labels of the PublicIPAddress resources that will be
         created. Required.
        :paramtype domain_name_label: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineScaleSetVMReimageParameters(VirtualMachineReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
    }

    def __init__(self, *, temp_disk: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        """
        super().__init__(temp_disk=temp_disk, **kwargs)


class VirtualMachineScaleSetReimageParameters(VirtualMachineScaleSetVMReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(
        self, *, temp_disk: Optional[bool] = None, instance_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(temp_disk=temp_disk, **kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetSku(_serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "capacity": {"key": "capacity", "type": "VirtualMachineScaleSetSkuCapacity"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(_serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic" and
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default_capacity": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default_capacity": {"key": "defaultCapacity", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetOSDisk
    :ivar data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetOSDisk
        :keyword data_disks: Specifies the parameters that are used to add data disks to the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetDataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentity
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.UpgradePolicy
    :ivar automatic_repairs_policy: Policy for automatic repairs.
    :vartype automatic_repairs_policy:
     ~azure.mgmt.compute.v2021_11_01.models.AutomaticRepairsPolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateVMProfile
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :vartype do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :vartype single_placement_group: bool
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :vartype additional_capabilities: ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
    :ivar scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in the
     Virtual Machine Scale Set.
    :vartype scale_in_policy: ~azure.mgmt.compute.v2021_11_01.models.ScaleInPolicy
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "automatic_repairs_policy": {"key": "properties.automaticRepairsPolicy", "type": "AutomaticRepairsPolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetUpdateVMProfile",
        },
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "do_not_run_extensions_on_overprovisioned_v_ms": {
            "key": "properties.doNotRunExtensionsOnOverprovisionedVMs",
            "type": "bool",
        },
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "scale_in_policy": {"key": "properties.scaleInPolicy", "type": "ScaleInPolicy"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["_models.AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetUpdateVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        scale_in_policy: Optional["_models.ScaleInPolicy"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
        :keyword plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
         images.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetIdentity
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.v2021_11_01.models.UpgradePolicy
        :keyword automatic_repairs_policy: Policy for automatic repairs.
        :paramtype automatic_repairs_policy:
         ~azure.mgmt.compute.v2021_11_01.models.AutomaticRepairsPolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled,
         extensions are launched only on the requested number of VMs which are finally kept. This
         property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :paramtype do_not_run_extensions_on_overprovisioned_v_ms: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be
         modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :paramtype single_placement_group: bool
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
         have the capability to support attaching managed data disks with UltraSSD_LRS storage account
         type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
        :keyword scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in
         the Virtual Machine Scale Set.
        :paramtype scale_in_policy: ~azure.mgmt.compute.v2021_11_01.models.ScaleInPolicy
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
         api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.single_placement_group = single_placement_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.proximity_placement_group = proximity_placement_group


class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration. NOTE: The subnet of a
    scale set may be modified as long as the original subnet and the new subnet are in the same
    virtual network.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name.
    :vartype name: str
    :ivar subnet: The subnet.
    :vartype subnet: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    :ivar primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
    :ivar application_gateway_backend_address_pools: The application gateway backend address pools.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar load_balancer_backend_address_pools: The load balancer backend address pools.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetUpdatePublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "application_security_groups": {"key": "properties.applicationSecurityGroups", "type": "[SubResource]"},
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional[
            "_models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration"
        ] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name.
        :paramtype name: str
        :keyword subnet: The subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        :keyword primary: Specifies the primary IP Configuration in case the network interface has more
         than one IP Configuration.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.v2021_11_01.models.IPVersion
        :keyword application_gateway_backend_address_pools: The application gateway backend address
         pools.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword application_security_groups: Specifies an array of references to application security
         group.
        :paramtype application_security_groups:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword load_balancer_backend_address_pools: The load balancer backend address pools.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.v2021_11_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name.
    :vartype name: str
    :ivar primary: Whether this is a primary NIC on a virtual machine.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: The virtual machine scale set IP Configuration.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "enable_fpga": {"key": "properties.enableFpga", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[VirtualMachineScaleSetUpdateIPConfiguration]",
        },
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetUpdateIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name.
        :paramtype name: str
        :keyword primary: Whether this is a primary NIC on a virtual machine.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :paramtype enable_fpga: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: The virtual machine scale set IP Configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option


class VirtualMachineScaleSetUpdateNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :vartype health_probe: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
    """

    _attribute_map = {
        "health_probe": {"key": "healthProbe", "type": "ApiEntityReference"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetUpdateNetworkConfiguration]",
        },
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[
            List["_models.VirtualMachineScaleSetUpdateNetworkConfiguration"]
        ] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_probe: A reference to a load balancer probe used to determine the health of an
         instance in the virtual machine scale set. The reference will be in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :paramtype health_probe: ~azure.mgmt.compute.v2021_11_01.models.ApiEntityReference
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
         orchestration mode 'Flexible'. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.v2021_11_01.models.NetworkApiVersion
        """
        super().__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version


class VirtualMachineScaleSetUpdateOSDisk(_serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used
    for Updating VMSS OS Disk.

    :ivar caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :vartype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
    :ivar vhd_containers: The list of virtual hard disk container uris.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _attribute_map = {
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2021_11_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword disk_size_gb: Specifies the size of the operating system disk in gigabytes. This
         element can be used to overwrite the size of the disk in a virtual machine image.
         :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied
         before using it to attach to the Virtual Machine. If SourceImage is provided, the destination
         VirtualHardDisk should not exist.
        :paramtype image: ~azure.mgmt.compute.v2021_11_01.models.VirtualHardDisk
        :keyword vhd_containers: The list of virtual hard disk container uris.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.disk_size_gb = disk_size_gb
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetUpdateOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar custom_data: A base-64 encoded string of custom data.
    :vartype custom_data: str
    :ivar windows_configuration: The Windows Configuration of the OS profile.
    :vartype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
    :ivar linux_configuration: The Linux Configuration of the OS profile.
    :vartype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
    :ivar secrets: The List of certificates for addition to the VM.
    :vartype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_data: A base-64 encoded string of custom data.
        :paramtype custom_data: str
        :keyword windows_configuration: The Windows Configuration of the OS profile.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2021_11_01.models.WindowsConfiguration
        :keyword linux_configuration: The Linux Configuration of the OS profile.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2021_11_01.models.LinuxConfiguration
        :keyword secrets: The List of certificates for addition to the VM.
        :paramtype secrets: list[~azure.mgmt.compute.v2021_11_01.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :ivar name: The publicIP address configuration name.
    :vartype name: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar delete_option: Specify what happens to the public IP when the VM is deleted. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The publicIP address configuration name.
        :paramtype name: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        :keyword public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :paramtype public_ip_prefix: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword delete_option: Specify what happens to the public IP when the VM is deleted. Known
         values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.v2021_11_01.models.DeleteOptions
        """
        super().__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.public_ip_prefix = public_ip_prefix
        self.delete_option = delete_option


class VirtualMachineScaleSetUpdateStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: The image reference.
    :vartype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
    :ivar os_disk: The OS disk.
    :vartype os_disk: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateOSDisk
    :ivar data_disks: The data disks.
    :vartype data_disks:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetUpdateOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetUpdateOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: The image reference.
        :paramtype image_reference: ~azure.mgmt.compute.v2021_11_01.models.ImageReference
        :keyword os_disk: The OS disk.
        :paramtype os_disk: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateOSDisk
        :keyword data_disks: The data disks.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetDataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdateVMProfile(_serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: The virtual machine scale set OS profile.
    :vartype os_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateOSProfile
    :ivar storage_profile: The virtual machine scale set storage profile.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateStorageProfile
    :ivar network_profile: The virtual machine scale set network profile.
    :vartype network_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateNetworkProfile
    :ivar security_profile: The virtual machine scale set Security profile.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar diagnostics_profile: The virtual machine scale set diagnostics profile.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar extension_profile: The virtual machine scale set extension profile.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: The license type, which is for bring your own license scenario.
    :vartype license_type: str
    :ivar billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetUpdateOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetUpdateStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetUpdateNetworkProfile"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "billing_profile": {"key": "billingProfile", "type": "BillingProfile"},
        "scheduled_events_profile": {"key": "scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "userData", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetUpdateOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetUpdateStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetUpdateNetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_profile: The virtual machine scale set OS profile.
        :paramtype os_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateOSProfile
        :keyword storage_profile: The virtual machine scale set storage profile.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateStorageProfile
        :keyword network_profile: The virtual machine scale set network profile.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetUpdateNetworkProfile
        :keyword security_profile: The virtual machine scale set Security profile.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword diagnostics_profile: The virtual machine scale set diagnostics profile.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword extension_profile: The virtual machine scale set extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: The license type, which is for bring your own license scenario.
        :paramtype license_type: str
        :keyword billing_profile: Specifies the billing related details of a Azure Spot VMSS.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data


class VirtualMachineScaleSetVM(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2021_11_01.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtension]
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMInstanceView
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine in the scale set. For instance: whether the virtual machine has the capability
     to support attaching managed data disks with UltraSSD_LRS storage account type.
    :vartype additional_capabilities: ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
    :ivar network_profile_configuration: Specifies the network profile configuration of the virtual
     machine.
    :vartype network_profile_configuration:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar model_definition_applied: Specifies whether the model applied to the virtual machine is
     the model of the virtual machine scale set or the customized model for the virtual machine.
    :vartype model_definition_applied: str
    :ivar protection_policy: Specifies the protection policy of the virtual machine.
    :vartype protection_policy:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMProtectionPolicy
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "instance_id": {"readonly": True},
        "sku": {"readonly": True},
        "resources": {"readonly": True},
        "zones": {"readonly": True},
        "latest_model_applied": {"readonly": True},
        "vm_id": {"readonly": True},
        "instance_view": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "model_definition_applied": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "zones": {"key": "zones", "type": "[str]"},
        "latest_model_applied": {"key": "properties.latestModelApplied", "type": "bool"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineScaleSetVMInstanceView"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "network_profile_configuration": {
            "key": "properties.networkProfileConfiguration",
            "type": "VirtualMachineScaleSetVMNetworkProfileConfiguration",
        },
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "model_definition_applied": {"key": "properties.modelDefinitionApplied", "type": "str"},
        "protection_policy": {"key": "properties.protectionPolicy", "type": "VirtualMachineScaleSetVMProtectionPolicy"},
        "user_data": {"key": "properties.userData", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        network_profile_configuration: Optional["_models.VirtualMachineScaleSetVMNetworkProfileConfiguration"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        protection_policy: Optional["_models.VirtualMachineScaleSetVMProtectionPolicy"] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine in the scale set. For instance: whether the virtual machine has the capability
         to support attaching managed data disks with UltraSSD_LRS storage account type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
        :keyword network_profile_configuration: Specifies the network profile configuration of the
         virtual machine.
        :paramtype network_profile_configuration:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword protection_policy: Specifies the protection policy of the virtual machine.
        :paramtype protection_policy:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMProtectionPolicy
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.zones = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.security_profile = security_profile
        self.network_profile = network_profile
        self.network_profile_configuration = network_profile_configuration
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type
        self.model_definition_applied = None
        self.protection_policy = protection_policy
        self.user_data = user_data


class VirtualMachineScaleSetVMExtension(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineScaleSetVMExtensionsListResult(_serialization.Model):
    """The List VMSS VM Extension operation response.

    :ivar value: The list of VMSS VM extensions.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVMExtension]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualMachineScaleSetVMExtension"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of VMSS VM extensions.
        :paramtype value:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVMExtension]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineScaleSetVMExtensionsSummary(_serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "name": {"readonly": True},
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMExtensionUpdate(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {"key": "properties.protectedSettingsFromKeyVault", "type": "object"},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault: JSON
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault


class VirtualMachineScaleSetVMInstanceIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceRequiredIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_ids: The virtual machine scale set instance ids. Required.
    :vartype instance_ids: list[str]
    """

    _validation = {
        "instance_ids": {"required": True},
    }

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: List[str], **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Required.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain count.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain count.
    :vartype platform_fault_domain: int
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.v2021_11_01.models.MaintenanceRedeployStatus
    :ivar disks: The disks information.
    :vartype disks: list[~azure.mgmt.compute.v2021_11_01.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineHealthStatus
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :ivar placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :vartype placement_group_id: str
    """

    _validation = {
        "vm_health": {"readonly": True},
        "assigned_host": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "vm_health": {"key": "vmHealth", "type": "VirtualMachineHealthStatus"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "assigned_host": {"key": "assignedHost", "type": "str"},
        "placement_group_id": {"key": "placementGroupId", "type": "str"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: The Update Domain count.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: The Fault Domain count.
        :paramtype platform_fault_domain: int
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.v2021_11_01.models.MaintenanceRedeployStatus
        :keyword disks: The disks information.
        :paramtype disks: list[~azure.mgmt.compute.v2021_11_01.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2021_11_01.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2021_11_01.models.InstanceViewStatus]
        :keyword placement_group_id: The placement group in which the VM is running. If the VM is
         deallocated it will not have a placementGroupId.
        :paramtype placement_group_id: str
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.assigned_host = None
        self.placement_group_id = placement_group_id


class VirtualMachineScaleSetVMListResult(_serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets VMs. Required.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVM]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVM]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetVM"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets VMs. Required.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetVM]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
         ListNext() with this to fetch the next page of VMSS VMs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetVMNetworkProfileConfiguration(_serialization.Model):
    """Describes a virtual machine scale set VM network profile.

    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetVMProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: Specifies the operating system settings for the virtual machines in the scale
     set.
    :vartype os_profile: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetOSProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetStorageProfile
    :ivar network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :vartype network_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machines in the scale set.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar extension_profile: Specifies a collection of settings for extensions installed on virtual
     machines in the scale set.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular",
     "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
    :ivar user_data: UserData for the virtual machines in the scale set, which must be base-64
     encoded. Customer should not pass any secrets in here. :code:`<br>`:code:`<br>`Minimum
     api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies the capacity reservation related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
    :ivar hardware_profile: Specifies the hardware profile related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype hardware_profile:
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetHardwareProfile
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetNetworkProfile"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "priority": {"key": "priority", "type": "str"},
        "eviction_policy": {"key": "evictionPolicy", "type": "str"},
        "billing_profile": {"key": "billingProfile", "type": "BillingProfile"},
        "scheduled_events_profile": {"key": "scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "userData", "type": "str"},
        "capacity_reservation": {"key": "capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "applicationProfile", "type": "ApplicationProfile"},
        "hardware_profile": {"key": "hardwareProfile", "type": "VirtualMachineScaleSetHardwareProfile"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        hardware_profile: Optional["_models.VirtualMachineScaleSetHardwareProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_profile: Specifies the operating system settings for the virtual machines in the
         scale set.
        :paramtype os_profile: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetOSProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetStorageProfile
        :keyword network_profile: Specifies properties of the network interfaces of the virtual
         machines in the scale set.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetNetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machines in the scale set.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword extension_profile: Specifies a collection of settings for extensions installed on
         virtual machines in the scale set.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword priority: Specifies the priority for the virtual machines in the scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular",
         "Low", and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot VMSS.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
        :keyword user_data: UserData for the virtual machines in the scale set, which must be base-64
         encoded. Customer should not pass any secrets in here. :code:`<br>`:code:`<br>`Minimum
         api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies the capacity reservation related details of a scale
         set. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
        :keyword hardware_profile: Specifies the hardware profile related details of a scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
        :paramtype hardware_profile:
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineScaleSetHardwareProfile
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.hardware_profile = hardware_profile


class VirtualMachineScaleSetVMProtectionPolicy(_serialization.Model):
    """The protection policy of a virtual machine scale set VM.

    :ivar protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
     considered for deletion during a scale-in operation.
    :vartype protect_from_scale_in: bool
    :ivar protect_from_scale_set_actions: Indicates that model updates or actions (including
     scale-in) initiated on the virtual machine scale set should not be applied to the virtual
     machine scale set VM.
    :vartype protect_from_scale_set_actions: bool
    """

    _attribute_map = {
        "protect_from_scale_in": {"key": "protectFromScaleIn", "type": "bool"},
        "protect_from_scale_set_actions": {"key": "protectFromScaleSetActions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        protect_from_scale_in: Optional[bool] = None,
        protect_from_scale_set_actions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
         considered for deletion during a scale-in operation.
        :paramtype protect_from_scale_in: bool
        :keyword protect_from_scale_set_actions: Indicates that model updates or actions (including
         scale-in) initiated on the virtual machine scale set should not be applied to the virtual
         machine scale set VM.
        :paramtype protect_from_scale_set_actions: bool
        """
        super().__init__(**kwargs)
        self.protect_from_scale_in = protect_from_scale_in
        self.protect_from_scale_set_actions = protect_from_scale_set_actions


class VirtualMachineSize(_serialization.Model):
    """Describes the properties of a VM size.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar number_of_cores: The number of cores supported by the virtual machine size. For
     Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM
     uses. For accurate vCPU count, please refer to
     https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or
     https://docs.microsoft.com/rest/api/compute/resourceskus/list.
    :vartype number_of_cores: int
    :ivar os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :vartype os_disk_size_in_mb: int
    :ivar resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :vartype resource_disk_size_in_mb: int
    :ivar memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :vartype memory_in_mb: int
    :ivar max_data_disk_count: The maximum number of data disks that can be attached to the virtual
     machine size.
    :vartype max_data_disk_count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "os_disk_size_in_mb": {"key": "osDiskSizeInMB", "type": "int"},
        "resource_disk_size_in_mb": {"key": "resourceDiskSizeInMB", "type": "int"},
        "memory_in_mb": {"key": "memoryInMB", "type": "int"},
        "max_data_disk_count": {"key": "maxDataDiskCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the virtual machine size.
        :paramtype name: str
        :keyword number_of_cores: The number of cores supported by the virtual machine size. For
         Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM
         uses. For accurate vCPU count, please refer to
         https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or
         https://docs.microsoft.com/rest/api/compute/resourceskus/list.
        :paramtype number_of_cores: int
        :keyword os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
        :paramtype os_disk_size_in_mb: int
        :keyword resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual
         machine size.
        :paramtype resource_disk_size_in_mb: int
        :keyword memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
        :paramtype memory_in_mb: int
        :keyword max_data_disk_count: The maximum number of data disks that can be attached to the
         virtual machine size.
        :paramtype max_data_disk_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count


class VirtualMachineSizeListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    :ivar value: The list of virtual machine sizes.
    :vartype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineSize]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineSize]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineSize"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of virtual machine sizes.
        :paramtype value: list[~azure.mgmt.compute.v2021_11_01.models.VirtualMachineSize]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineSoftwarePatchProperties(_serialization.Model):
    """Describes the properties of a Virtual Machine software patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version number of the patch. This property applies only to Linux patches.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar reboot_behavior: Describes the reboot requirements of the patch. Known values are:
     "Unknown", "NeverReboots", "AlwaysRequiresReboot", and "CanRequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchRebootBehavior
    :ivar activity_id: The activity ID of the operation that produced this result. It is used to
     correlate across CRP and extension logs.
    :vartype activity_id: str
    :ivar published_date: The UTC timestamp when the repository published this patch.
    :vartype published_date: ~datetime.datetime
    :ivar last_modified_date_time: The UTC timestamp of the last update to this patch record.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar assessment_state: Describes the availability of a given patch. Known values are:
     "Unknown" and "Available".
    :vartype assessment_state: str or ~azure.mgmt.compute.v2021_11_01.models.PatchAssessmentState
    """

    _validation = {
        "patch_id": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
        "kb_id": {"readonly": True},
        "classifications": {"readonly": True},
        "reboot_behavior": {"readonly": True},
        "activity_id": {"readonly": True},
        "published_date": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "assessment_state": {"readonly": True},
    }

    _attribute_map = {
        "patch_id": {"key": "patchId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "kb_id": {"key": "kbId", "type": "str"},
        "classifications": {"key": "classifications", "type": "[str]"},
        "reboot_behavior": {"key": "rebootBehavior", "type": "str"},
        "activity_id": {"key": "activityId", "type": "str"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "last_modified_date_time": {"key": "lastModifiedDateTime", "type": "iso-8601"},
        "assessment_state": {"key": "assessmentState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kb_id = None
        self.classifications = None
        self.reboot_behavior = None
        self.activity_id = None
        self.published_date = None
        self.last_modified_date_time = None
        self.assessment_state = None


class VirtualMachineStatusCodeCount(_serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None


class VirtualMachineUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :vartype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar virtual_machine_scale_set: Specifies information about the virtual machine scale set that
     the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :vartype virtual_machine_scale_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar priority: Specifies the priority for the virtual machine. :code:`<br>`:code:`<br>`Minimum
     api-version: 2019-03-01. Known values are: "Regular", "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
    :ivar host: Specifies information about the dedicated host that the virtual machine resides in.
     :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :vartype host: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :vartype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    :ivar platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :vartype platform_fault_domain: int
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
    :ivar time_created: Specifies the time at which the Virtual Machine resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "virtual_machine_scale_set": {"key": "properties.virtualMachineScaleSet", "type": "SubResource"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "priority": {"key": "properties.priority", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "billing_profile": {"key": "properties.billingProfile", "type": "BillingProfile"},
        "host": {"key": "properties.host", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "extensions_time_budget": {"key": "properties.extensionsTimeBudget", "type": "str"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "scheduled_events_profile": {"key": "properties.scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "capacity_reservation": {"key": "properties.capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "properties.applicationProfile", "type": "ApplicationProfile"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        virtual_machine_scale_set: Optional["_models.SubResource"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        host: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2021_11_01.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2021_11_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2021_11_01.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.v2021_11_01.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings used while creating the virtual
         machine. Some of the settings cannot be changed once VM is provisioned.
        :paramtype os_profile: ~azure.mgmt.compute.v2021_11_01.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2021_11_01.models.NetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_11_01.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2021_11_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. The availability set to which the VM is being added should be under the same resource
         group as the availability set resource. An existing VM cannot be added to an availability set.
         :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
         properties.virtualMachineScaleSet reference.
        :paramtype availability_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword virtual_machine_scale_set: Specifies information about the virtual machine scale set
         that the virtual machine should be assigned to. Virtual machines specified in the same virtual
         machine scale set are allocated to different nodes to maximize availability. Currently, a VM
         can only be added to virtual machine scale set at creation time. An existing VM cannot be added
         to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
         non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
         2019‐03‐01.
        :paramtype virtual_machine_scale_set: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword priority: Specifies the priority for the virtual machine.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Known values are: "Regular", "Low",
         and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.v2021_11_01.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.v2021_11_01.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot virtual
         machine. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.v2021_11_01.models.BillingProfile
        :keyword host: Specifies information about the dedicated host that the virtual machine resides
         in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
        :paramtype host: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
         :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
        :paramtype host_group: ~azure.mgmt.compute.v2021_11_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        :keyword platform_fault_domain: Specifies the scale set logical fault domain into which the
         Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
         to a fault domain that best maintains balance across available fault
         domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
         property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
         referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
         updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
         in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
        :paramtype platform_fault_domain: int
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.v2021_11_01.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies information about the capacity reservation that is
         used to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.v2021_11_01.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.v2021_11_01.models.ApplicationProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.time_created = None


class VMDiskSecurityProfile(_serialization.Model):
    """Specifies the security profile settings for the managed disk. :code:`<br>`:code:`<br>` NOTE: It
    can only be set for Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. :code:`<br>`
     It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState
     blob, and VMGuestStateOnly for encryption of just the VMGuestState blob.
     :code:`<br>`:code:`<br>` NOTE: It can be set for only Confidential VMs. Known values are:
     "VMGuestStateOnly" and "DiskWithVMGuestState".
    :vartype security_encryption_type: str or
     ~azure.mgmt.compute.v2021_11_01.models.SecurityEncryptionTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
     VMGuest blob.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        "security_encryption_type": {"key": "securityEncryptionType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
    }

    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_encryption_type: Specifies the EncryptionType of the managed disk.
         :code:`<br>` It is set to DiskWithVMGuestState for encryption of the managed disk along with
         VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob.
         :code:`<br>`:code:`<br>` NOTE: It can be set for only Confidential VMs. Known values are:
         "VMGuestStateOnly" and "DiskWithVMGuestState".
        :paramtype security_encryption_type: str or
         ~azure.mgmt.compute.v2021_11_01.models.SecurityEncryptionTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
         VMGuest blob.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.v2021_11_01.models.DiskEncryptionSetParameters
        """
        super().__init__(**kwargs)
        self.security_encryption_type = security_encryption_type
        self.disk_encryption_set = disk_encryption_set


class VMGalleryApplication(_serialization.Model):
    """Specifies the required information to reference a compute gallery application version.

    All required parameters must be populated in order to send to Azure.

    :ivar tags: Optional, Specifies a passthrough value for more generic context.
    :vartype tags: str
    :ivar order: Optional, Specifies the order in which the packages have to be installed.
    :vartype order: int
    :ivar package_reference_id: Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     Required.
    :vartype package_reference_id: str
    :ivar configuration_reference: Optional, Specifies the uri to an azure blob that will replace
     the default configuration for the package if provided.
    :vartype configuration_reference: str
    """

    _validation = {
        "package_reference_id": {"required": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "package_reference_id": {"key": "packageReferenceId", "type": "str"},
        "configuration_reference": {"key": "configurationReference", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_reference_id: str,
        tags: Optional[str] = None,
        order: Optional[int] = None,
        configuration_reference: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Optional, Specifies a passthrough value for more generic context.
        :paramtype tags: str
        :keyword order: Optional, Specifies the order in which the packages have to be installed.
        :paramtype order: int
        :keyword package_reference_id: Specifies the GalleryApplicationVersion resource id on the form
         of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
         Required.
        :paramtype package_reference_id: str
        :keyword configuration_reference: Optional, Specifies the uri to an azure blob that will
         replace the default configuration for the package if provided.
        :paramtype configuration_reference: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.order = order
        self.package_reference_id = package_reference_id
        self.configuration_reference = configuration_reference


class VMScaleSetConvertToSinglePlacementGroupInput(_serialization.Model):
    """VMScaleSetConvertToSinglePlacementGroupInput.

    :ivar active_placement_group_id: Id of the placement group in which you want future virtual
     machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
     Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
     machine instances.
    :vartype active_placement_group_id: str
    """

    _attribute_map = {
        "active_placement_group_id": {"key": "activePlacementGroupId", "type": "str"},
    }

    def __init__(self, *, active_placement_group_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword active_placement_group_id: Id of the placement group in which you want future virtual
         machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
         Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
         machine instances.
        :paramtype active_placement_group_id: str
        """
        super().__init__(**kwargs)
        self.active_placement_group_id = active_placement_group_id


class VMSizeProperties(_serialization.Model):
    """Specifies VM Size Property settings on the virtual machine.

    :ivar v_cpus_available: Specifies the number of vCPUs available for the VM.
     :code:`<br>`:code:`<br>` When this property is not specified in the request body the default
     behavior is to set it to the value of vCPUs available for that VM size exposed in api response
     of `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_ .
    :vartype v_cpus_available: int
    :ivar v_cpus_per_core: Specifies the vCPU to physical core ratio. :code:`<br>`:code:`<br>` When
     this property is not specified in the request body the default behavior is set to the value of
     vCPUsPerCore for the VM Size exposed in api response of `List all available virtual machine
     sizes in a region <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_
     :code:`<br>`:code:`<br>` Setting this property to 1 also means that hyper-threading is
     disabled.
    :vartype v_cpus_per_core: int
    """

    _attribute_map = {
        "v_cpus_available": {"key": "vCPUsAvailable", "type": "int"},
        "v_cpus_per_core": {"key": "vCPUsPerCore", "type": "int"},
    }

    def __init__(
        self, *, v_cpus_available: Optional[int] = None, v_cpus_per_core: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword v_cpus_available: Specifies the number of vCPUs available for the VM.
         :code:`<br>`:code:`<br>` When this property is not specified in the request body the default
         behavior is to set it to the value of vCPUs available for that VM size exposed in api response
         of `List all available virtual machine sizes in a region
         <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_ .
        :paramtype v_cpus_available: int
        :keyword v_cpus_per_core: Specifies the vCPU to physical core ratio. :code:`<br>`:code:`<br>`
         When this property is not specified in the request body the default behavior is set to the
         value of vCPUsPerCore for the VM Size exposed in api response of `List all available virtual
         machine sizes in a region
         <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_
         :code:`<br>`:code:`<br>` Setting this property to 1 also means that hyper-threading is
         disabled.
        :paramtype v_cpus_per_core: int
        """
        super().__init__(**kwargs)
        self.v_cpus_available = v_cpus_available
        self.v_cpus_per_core = v_cpus_per_core


class WindowsConfiguration(_serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine scale
     sets, this property can be updated and updates will take effect on OS reprovisioning.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
     from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.compute.v2021_11_01.models.AdditionalUnattendContent]
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Windows.
    :vartype patch_settings: ~azure.mgmt.compute.v2021_11_01.models.PatchSettings
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.compute.v2021_11_01.models.WinRMConfiguration
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "enable_automatic_updates": {"key": "enableAutomaticUpdates", "type": "bool"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "additional_unattend_content": {"key": "additionalUnattendContent", "type": "[AdditionalUnattendContent]"},
        "patch_settings": {"key": "patchSettings", "type": "PatchSettings"},
        "win_rm": {"key": "winRM", "type": "WinRMConfiguration"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = None,
        patch_settings: Optional["_models.PatchSettings"] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword enable_automatic_updates: Indicates whether Automatic Updates is enabled for the
         Windows virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine
         scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        :paramtype enable_automatic_updates: bool
        :keyword time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard
         Time". :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
         <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
         from time zones returned by `TimeZoneInfo.GetSystemTimeZones
         <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
        :paramtype time_zone: str
        :keyword additional_unattend_content: Specifies additional base-64 encoded XML formatted
         information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :paramtype additional_unattend_content:
         list[~azure.mgmt.compute.v2021_11_01.models.AdditionalUnattendContent]
        :keyword patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
         Windows.
        :paramtype patch_settings: ~azure.mgmt.compute.v2021_11_01.models.PatchSettings
        :keyword win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
         PowerShell.
        :paramtype win_rm: ~azure.mgmt.compute.v2021_11_01.models.WinRMConfiguration
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.patch_settings = patch_settings
        self.win_rm = win_rm


class WindowsParameters(_serialization.Model):
    """Input for InstallPatches on a Windows VM, as directly received by the API.

    :ivar classifications_to_include: The update classifications to select when installing patches
     for Windows.
    :vartype classifications_to_include: list[str or
     ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchClassificationWindows]
    :ivar kb_numbers_to_include: Kbs to include in the patch operation.
    :vartype kb_numbers_to_include: list[str]
    :ivar kb_numbers_to_exclude: Kbs to exclude in the patch operation.
    :vartype kb_numbers_to_exclude: list[str]
    :ivar exclude_kbs_requiring_reboot: Filters out Kbs that don't have an
     InstallationRebootBehavior of 'NeverReboots' when this is set to true.
    :vartype exclude_kbs_requiring_reboot: bool
    :ivar max_patch_publish_date: This is used to install patches that were published on or before
     this given max published date.
    :vartype max_patch_publish_date: ~datetime.datetime
    """

    _attribute_map = {
        "classifications_to_include": {"key": "classificationsToInclude", "type": "[str]"},
        "kb_numbers_to_include": {"key": "kbNumbersToInclude", "type": "[str]"},
        "kb_numbers_to_exclude": {"key": "kbNumbersToExclude", "type": "[str]"},
        "exclude_kbs_requiring_reboot": {"key": "excludeKbsRequiringReboot", "type": "bool"},
        "max_patch_publish_date": {"key": "maxPatchPublishDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        classifications_to_include: Optional[List[Union[str, "_models.VMGuestPatchClassificationWindows"]]] = None,
        kb_numbers_to_include: Optional[List[str]] = None,
        kb_numbers_to_exclude: Optional[List[str]] = None,
        exclude_kbs_requiring_reboot: Optional[bool] = None,
        max_patch_publish_date: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword classifications_to_include: The update classifications to select when installing
         patches for Windows.
        :paramtype classifications_to_include: list[str or
         ~azure.mgmt.compute.v2021_11_01.models.VMGuestPatchClassificationWindows]
        :keyword kb_numbers_to_include: Kbs to include in the patch operation.
        :paramtype kb_numbers_to_include: list[str]
        :keyword kb_numbers_to_exclude: Kbs to exclude in the patch operation.
        :paramtype kb_numbers_to_exclude: list[str]
        :keyword exclude_kbs_requiring_reboot: Filters out Kbs that don't have an
         InstallationRebootBehavior of 'NeverReboots' when this is set to true.
        :paramtype exclude_kbs_requiring_reboot: bool
        :keyword max_patch_publish_date: This is used to install patches that were published on or
         before this given max published date.
        :paramtype max_patch_publish_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.classifications_to_include = classifications_to_include
        self.kb_numbers_to_include = kb_numbers_to_include
        self.kb_numbers_to_exclude = kb_numbers_to_exclude
        self.exclude_kbs_requiring_reboot = exclude_kbs_requiring_reboot
        self.max_patch_publish_date = max_patch_publish_date


class WinRMConfiguration(_serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.compute.v2021_11_01.models.WinRMListener]
    """

    _attribute_map = {
        "listeners": {"key": "listeners", "type": "[WinRMListener]"},
    }

    def __init__(self, *, listeners: Optional[List["_models.WinRMListener"]] = None, **kwargs: Any) -> None:
        """
        :keyword listeners: The list of Windows Remote Management listeners.
        :paramtype listeners: list[~azure.mgmt.compute.v2021_11_01.models.WinRMListener]
        """
        super().__init__(**kwargs)
        self.listeners = listeners


class WinRMListener(_serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http"
     and "Https".
    :vartype protocol: str or ~azure.mgmt.compute.v2021_11_01.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
         values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.compute.v2021_11_01.models.ProtocolTypes
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
         virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
         Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
         `Azure Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url
