# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class CheckTrafficManagerRelativeDnsNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters supplied to check Traffic Manager name operation.

    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckTrafficManagerRelativeDnsNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CloudErrorBody(msrest.serialization.Model):
    """The content of an error returned by the Azure Resource Manager.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param details: Error details.
    :type details: list[~azure.mgmt.trafficmanager.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class DeleteOperationResult(msrest.serialization.Model):
    """The result of the request or operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_result: The result of the operation or request.
    :vartype operation_result: bool
    """

    _validation = {
        'operation_result': {'readonly': True},
    }

    _attribute_map = {
        'operation_result': {'key': 'boolean', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteOperationResult, self).__init__(**kwargs)
        self.operation_result = None


class DnsConfig(msrest.serialization.Model):
    """Class containing DNS settings in a Traffic Manager profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param relative_name: The relative DNS name provided by this Traffic Manager profile. This
     value is combined with the DNS domain name used by Azure Traffic Manager to form the
     fully-qualified domain name (FQDN) of the profile.
    :type relative_name: str
    :ivar fqdn: The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is
     formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic
     Manager.
    :vartype fqdn: str
    :param ttl: The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and
     DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
    :type ttl: long
    """

    _validation = {
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'relative_name': {'key': 'relativeName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ttl': {'key': 'ttl', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DnsConfig, self).__init__(**kwargs)
        self.relative_name = kwargs.get('relative_name', None)
        self.fqdn = None
        self.ttl = kwargs.get('ttl', None)


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Endpoint(ProxyResource):
    """Class representing a Traffic Manager endpoint.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param target_resource_id: The Azure Resource URI of the of the endpoint. Not applicable to
     endpoints of type 'ExternalEndpoints'.
    :type target_resource_id: str
    :param target: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager
     returns this value in DNS responses to direct traffic to this endpoint.
    :type target: str
    :param endpoint_status: The status of the endpoint. If the endpoint is Enabled, it is probed
     for endpoint health and is included in the traffic routing method. Possible values include:
     "Enabled", "Disabled".
    :type endpoint_status: str or ~azure.mgmt.trafficmanager.models.EndpointStatus
    :param weight: The weight of this endpoint when using the 'Weighted' traffic routing method.
     Possible values are from 1 to 1000.
    :type weight: long
    :param priority: The priority of this endpoint when using the 'Priority' traffic routing
     method. Possible values are from 1 to 1000, lower values represent higher priority. This is an
     optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints
     can share the same priority value.
    :type priority: long
    :param endpoint_location: Specifies the location of the external or nested endpoints when using
     the 'Performance' traffic routing method.
    :type endpoint_location: str
    :param endpoint_monitor_status: The monitoring status of the endpoint. Possible values include:
     "CheckingEndpoint", "Online", "Degraded", "Disabled", "Inactive", "Stopped".
    :type endpoint_monitor_status: str or ~azure.mgmt.trafficmanager.models.EndpointMonitorStatus
    :param min_child_endpoints: The minimum number of endpoints that must be available in the child
     profile in order for the parent profile to be considered available. Only applicable to endpoint
     of type 'NestedEndpoints'.
    :type min_child_endpoints: long
    :param min_child_endpoints_i_pv4: The minimum number of IPv4 (DNS record type A) endpoints that
     must be available in the child profile in order for the parent profile to be considered
     available. Only applicable to endpoint of type 'NestedEndpoints'.
    :type min_child_endpoints_i_pv4: long
    :param min_child_endpoints_i_pv6: The minimum number of IPv6 (DNS record type AAAA) endpoints
     that must be available in the child profile in order for the parent profile to be considered
     available. Only applicable to endpoint of type 'NestedEndpoints'.
    :type min_child_endpoints_i_pv6: long
    :param geo_mapping: The list of countries/regions mapped to this endpoint when using the
     'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation
     for a full list of accepted values.
    :type geo_mapping: list[str]
    :param subnets: The list of subnets, IP addresses, and/or address ranges mapped to this
     endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges
     not covered by other endpoints.
    :type subnets: list[~azure.mgmt.trafficmanager.models.EndpointPropertiesSubnetsItem]
    :param custom_headers: List of custom headers.
    :type custom_headers:
     list[~azure.mgmt.trafficmanager.models.EndpointPropertiesCustomHeadersItem]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'endpoint_status': {'key': 'properties.endpointStatus', 'type': 'str'},
        'weight': {'key': 'properties.weight', 'type': 'long'},
        'priority': {'key': 'properties.priority', 'type': 'long'},
        'endpoint_location': {'key': 'properties.endpointLocation', 'type': 'str'},
        'endpoint_monitor_status': {'key': 'properties.endpointMonitorStatus', 'type': 'str'},
        'min_child_endpoints': {'key': 'properties.minChildEndpoints', 'type': 'long'},
        'min_child_endpoints_i_pv4': {'key': 'properties.minChildEndpointsIPv4', 'type': 'long'},
        'min_child_endpoints_i_pv6': {'key': 'properties.minChildEndpointsIPv6', 'type': 'long'},
        'geo_mapping': {'key': 'properties.geoMapping', 'type': '[str]'},
        'subnets': {'key': 'properties.subnets', 'type': '[EndpointPropertiesSubnetsItem]'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '[EndpointPropertiesCustomHeadersItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Endpoint, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.target = kwargs.get('target', None)
        self.endpoint_status = kwargs.get('endpoint_status', None)
        self.weight = kwargs.get('weight', None)
        self.priority = kwargs.get('priority', None)
        self.endpoint_location = kwargs.get('endpoint_location', None)
        self.endpoint_monitor_status = kwargs.get('endpoint_monitor_status', None)
        self.min_child_endpoints = kwargs.get('min_child_endpoints', None)
        self.min_child_endpoints_i_pv4 = kwargs.get('min_child_endpoints_i_pv4', None)
        self.min_child_endpoints_i_pv6 = kwargs.get('min_child_endpoints_i_pv6', None)
        self.geo_mapping = kwargs.get('geo_mapping', None)
        self.subnets = kwargs.get('subnets', None)
        self.custom_headers = kwargs.get('custom_headers', None)


class EndpointPropertiesCustomHeadersItem(msrest.serialization.Model):
    """Custom header name and value.

    :param name: Header name.
    :type name: str
    :param value: Header value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointPropertiesCustomHeadersItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class EndpointPropertiesSubnetsItem(msrest.serialization.Model):
    """Subnet first address, scope, and/or last address.

    :param first: First address in the subnet.
    :type first: str
    :param last: Last address in the subnet.
    :type last: str
    :param scope: Block size (number of leading bits in the subnet mask).
    :type scope: int
    """

    _attribute_map = {
        'first': {'key': 'first', 'type': 'str'},
        'last': {'key': 'last', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointPropertiesSubnetsItem, self).__init__(**kwargs)
        self.first = kwargs.get('first', None)
        self.last = kwargs.get('last', None)
        self.scope = kwargs.get('scope', None)


class HeatMapEndpoint(msrest.serialization.Model):
    """Class which is a sparse representation of a Traffic Manager endpoint.

    :param resource_id: The ARM Resource ID of this Traffic Manager endpoint.
    :type resource_id: str
    :param endpoint_id: A number uniquely identifying this endpoint in query experiences.
    :type endpoint_id: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HeatMapEndpoint, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.endpoint_id = kwargs.get('endpoint_id', None)


class HeatMapModel(ProxyResource):
    """Class representing a Traffic Manager HeatMap.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param start_time: The beginning of the time window for this HeatMap, inclusive.
    :type start_time: ~datetime.datetime
    :param end_time: The ending of the time window for this HeatMap, exclusive.
    :type end_time: ~datetime.datetime
    :param endpoints: The endpoints used in this HeatMap calculation.
    :type endpoints: list[~azure.mgmt.trafficmanager.models.HeatMapEndpoint]
    :param traffic_flows: The traffic flows produced in this HeatMap calculation.
    :type traffic_flows: list[~azure.mgmt.trafficmanager.models.TrafficFlow]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[HeatMapEndpoint]'},
        'traffic_flows': {'key': 'properties.trafficFlows', 'type': '[TrafficFlow]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HeatMapModel, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.traffic_flows = kwargs.get('traffic_flows', None)


class MonitorConfig(msrest.serialization.Model):
    """Class containing endpoint monitoring settings in a Traffic Manager profile.

    :param profile_monitor_status: The profile-level monitoring status of the Traffic Manager
     profile. Possible values include: "CheckingEndpoints", "Online", "Degraded", "Disabled",
     "Inactive".
    :type profile_monitor_status: str or ~azure.mgmt.trafficmanager.models.ProfileMonitorStatus
    :param protocol: The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health. Possible
     values include: "HTTP", "HTTPS", "TCP".
    :type protocol: str or ~azure.mgmt.trafficmanager.models.MonitorProtocol
    :param port: The TCP port used to probe for endpoint health.
    :type port: long
    :param path: The path relative to the endpoint domain name used to probe for endpoint health.
    :type path: str
    :param interval_in_seconds: The monitor interval for endpoints in this profile. This is the
     interval at which Traffic Manager will check the health of each endpoint in this profile.
    :type interval_in_seconds: long
    :param timeout_in_seconds: The monitor timeout for endpoints in this profile. This is the time
     that Traffic Manager allows endpoints in this profile to response to the health check.
    :type timeout_in_seconds: long
    :param tolerated_number_of_failures: The number of consecutive failed health check that Traffic
     Manager tolerates before declaring an endpoint in this profile Degraded after the next failed
     health check.
    :type tolerated_number_of_failures: long
    :param custom_headers: List of custom headers.
    :type custom_headers: list[~azure.mgmt.trafficmanager.models.MonitorConfigCustomHeadersItem]
    :param expected_status_code_ranges: List of expected status code ranges.
    :type expected_status_code_ranges:
     list[~azure.mgmt.trafficmanager.models.MonitorConfigExpectedStatusCodeRangesItem]
    """

    _attribute_map = {
        'profile_monitor_status': {'key': 'profileMonitorStatus', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'long'},
        'path': {'key': 'path', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'long'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'tolerated_number_of_failures': {'key': 'toleratedNumberOfFailures', 'type': 'long'},
        'custom_headers': {'key': 'customHeaders', 'type': '[MonitorConfigCustomHeadersItem]'},
        'expected_status_code_ranges': {'key': 'expectedStatusCodeRanges', 'type': '[MonitorConfigExpectedStatusCodeRangesItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitorConfig, self).__init__(**kwargs)
        self.profile_monitor_status = kwargs.get('profile_monitor_status', None)
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)
        self.path = kwargs.get('path', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.timeout_in_seconds = kwargs.get('timeout_in_seconds', None)
        self.tolerated_number_of_failures = kwargs.get('tolerated_number_of_failures', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.expected_status_code_ranges = kwargs.get('expected_status_code_ranges', None)


class MonitorConfigCustomHeadersItem(msrest.serialization.Model):
    """Custom header name and value.

    :param name: Header name.
    :type name: str
    :param value: Header value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitorConfigCustomHeadersItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class MonitorConfigExpectedStatusCodeRangesItem(msrest.serialization.Model):
    """Min and max value of a status code range.

    :param min: Min status code.
    :type min: int
    :param max: Max status code.
    :type max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitorConfigExpectedStatusCodeRangesItem, self).__init__(**kwargs)
        self.min = kwargs.get('min', None)
        self.max = kwargs.get('max', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)


class Profile(TrackedResource):
    """Class representing a Traffic Manager profile.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param profile_status: The status of the Traffic Manager profile. Possible values include:
     "Enabled", "Disabled".
    :type profile_status: str or ~azure.mgmt.trafficmanager.models.ProfileStatus
    :param traffic_routing_method: The traffic routing method of the Traffic Manager profile.
     Possible values include: "Performance", "Priority", "Weighted", "Geographic", "MultiValue",
     "Subnet".
    :type traffic_routing_method: str or ~azure.mgmt.trafficmanager.models.TrafficRoutingMethod
    :param dns_config: The DNS settings of the Traffic Manager profile.
    :type dns_config: ~azure.mgmt.trafficmanager.models.DnsConfig
    :param monitor_config: The endpoint monitoring settings of the Traffic Manager profile.
    :type monitor_config: ~azure.mgmt.trafficmanager.models.MonitorConfig
    :param endpoints: The list of endpoints in the Traffic Manager profile.
    :type endpoints: list[~azure.mgmt.trafficmanager.models.Endpoint]
    :param traffic_view_enrollment_status: Indicates whether Traffic View is 'Enabled' or
     'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature
     will increase the cost of the Traffic Manage profile. Possible values include: "Enabled",
     "Disabled".
    :type traffic_view_enrollment_status: str or
     ~azure.mgmt.trafficmanager.models.TrafficViewEnrollmentStatus
    :param allowed_endpoint_record_types: The list of allowed endpoint record types.
    :type allowed_endpoint_record_types: list[str or
     ~azure.mgmt.trafficmanager.models.AllowedEndpointRecordType]
    :param max_return: Maximum number of endpoints to be returned for MultiValue routing type.
    :type max_return: long
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'profile_status': {'key': 'properties.profileStatus', 'type': 'str'},
        'traffic_routing_method': {'key': 'properties.trafficRoutingMethod', 'type': 'str'},
        'dns_config': {'key': 'properties.dnsConfig', 'type': 'DnsConfig'},
        'monitor_config': {'key': 'properties.monitorConfig', 'type': 'MonitorConfig'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'traffic_view_enrollment_status': {'key': 'properties.trafficViewEnrollmentStatus', 'type': 'str'},
        'allowed_endpoint_record_types': {'key': 'properties.allowedEndpointRecordTypes', 'type': '[str]'},
        'max_return': {'key': 'properties.maxReturn', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Profile, self).__init__(**kwargs)
        self.profile_status = kwargs.get('profile_status', None)
        self.traffic_routing_method = kwargs.get('traffic_routing_method', None)
        self.dns_config = kwargs.get('dns_config', None)
        self.monitor_config = kwargs.get('monitor_config', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.traffic_view_enrollment_status = kwargs.get('traffic_view_enrollment_status', None)
        self.allowed_endpoint_record_types = kwargs.get('allowed_endpoint_record_types', None)
        self.max_return = kwargs.get('max_return', None)


class ProfileListResult(msrest.serialization.Model):
    """The list Traffic Manager profiles operation response.

    :param value: Gets the list of Traffic manager profiles.
    :type value: list[~azure.mgmt.trafficmanager.models.Profile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProfileListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class QueryExperience(msrest.serialization.Model):
    """Class representing a Traffic Manager HeatMap query experience properties.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_id: Required. The id of the endpoint from the 'endpoints' array which these
     queries were routed to.
    :type endpoint_id: int
    :param query_count: Required. The number of queries originating from this location.
    :type query_count: int
    :param latency: The latency experienced by queries originating from this location.
    :type latency: float
    """

    _validation = {
        'endpoint_id': {'required': True},
        'query_count': {'required': True},
    }

    _attribute_map = {
        'endpoint_id': {'key': 'endpointId', 'type': 'int'},
        'query_count': {'key': 'queryCount', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryExperience, self).__init__(**kwargs)
        self.endpoint_id = kwargs['endpoint_id']
        self.query_count = kwargs['query_count']
        self.latency = kwargs.get('latency', None)


class Region(msrest.serialization.Model):
    """Class representing a region in the Geographic hierarchy used with the Geographic traffic routing method.

    :param code: The code of the region.
    :type code: str
    :param name: The name of the region.
    :type name: str
    :param regions: The list of Regions grouped under this Region in the Geographic Hierarchy.
    :type regions: list[~azure.mgmt.trafficmanager.models.Region]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'regions': {'key': 'regions', 'type': '[Region]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Region, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.name = kwargs.get('name', None)
        self.regions = kwargs.get('regions', None)


class TrafficFlow(msrest.serialization.Model):
    """Class representing a Traffic Manager HeatMap traffic flow properties.

    :param source_ip: The IP address that this query experience originated from.
    :type source_ip: str
    :param latitude: The approximate latitude that these queries originated from.
    :type latitude: float
    :param longitude: The approximate longitude that these queries originated from.
    :type longitude: float
    :param query_experiences: The query experiences produced in this HeatMap calculation.
    :type query_experiences: list[~azure.mgmt.trafficmanager.models.QueryExperience]
    """

    _attribute_map = {
        'source_ip': {'key': 'sourceIp', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'float'},
        'longitude': {'key': 'longitude', 'type': 'float'},
        'query_experiences': {'key': 'queryExperiences', 'type': '[QueryExperience]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficFlow, self).__init__(**kwargs)
        self.source_ip = kwargs.get('source_ip', None)
        self.latitude = kwargs.get('latitude', None)
        self.longitude = kwargs.get('longitude', None)
        self.query_experiences = kwargs.get('query_experiences', None)


class TrafficManagerGeographicHierarchy(ProxyResource):
    """Class representing the Geographic hierarchy used with the Geographic traffic routing method.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param geographic_hierarchy: The region at the root of the hierarchy from all the regions in
     the hierarchy can be retrieved.
    :type geographic_hierarchy: ~azure.mgmt.trafficmanager.models.Region
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'geographic_hierarchy': {'key': 'properties.geographicHierarchy', 'type': 'Region'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficManagerGeographicHierarchy, self).__init__(**kwargs)
        self.geographic_hierarchy = kwargs.get('geographic_hierarchy', None)


class TrafficManagerNameAvailability(msrest.serialization.Model):
    """Class representing a Traffic Manager Name Availability response.

    :param name: The relative name.
    :type name: str
    :param type: Traffic Manager profile resource type.
    :type type: str
    :param name_available: Describes whether the relative name is available or not.
    :type name_available: bool
    :param reason: The reason why the name is not available, when applicable.
    :type reason: str
    :param message: Descriptive message that explains why the name is not available, when
     applicable.
    :type message: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrafficManagerNameAvailability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class UserMetricsModel(ProxyResource):
    """Class representing Traffic Manager User Metrics.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param key: The key returned by the User Metrics operation.
    :type key: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserMetricsModel, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
