# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnalysisInput(msrest.serialization.Model):
    """AnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :ivar analysis_input: Required. Contains a set of input documents to be analyzed by the
     service.
    :vartype analysis_input: ~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageBatchInput
    """

    _validation = {
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageBatchInput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword analysis_input: Required. Contains a set of input documents to be analyzed by the
         service.
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageBatchInput
        """
        super(AnalysisInput, self).__init__(**kwargs)
        self.analysis_input = kwargs['analysis_input']


class JobManifest(msrest.serialization.Model):
    """JobManifest.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :vartype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.JobManifestTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tasks: Required. The set of tasks to execute on the input documents. Cannot specify
         the same task more than once.
        :paramtype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.JobManifestTasks
        """
        super(JobManifest, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']


class JobDescriptor(msrest.serialization.Model):
    """JobDescriptor.

    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        """
        super(JobDescriptor, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class AnalyzeBatchInput(JobDescriptor, AnalysisInput, JobManifest):
    """AnalyzeBatchInput.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :vartype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.JobManifestTasks
    :ivar analysis_input: Required. Contains a set of input documents to be analyzed by the
     service.
    :vartype analysis_input: ~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageBatchInput
    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    """

    _validation = {
        'tasks': {'required': True},
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageBatchInput'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tasks: Required. The set of tasks to execute on the input documents. Cannot specify
         the same task more than once.
        :paramtype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.JobManifestTasks
        :keyword analysis_input: Required. Contains a set of input documents to be analyzed by the
         service.
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageBatchInput
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        """
        super(AnalyzeBatchInput, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']
        self.analysis_input = kwargs['analysis_input']
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.analysis_input = kwargs['analysis_input']
        self.display_name = kwargs.get('display_name', None)


class AnalyzeJobDisplayName(msrest.serialization.Model):
    """AnalyzeJobDisplayName.

    :ivar display_name:
    :vartype display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        """
        super(AnalyzeJobDisplayName, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class AnalyzeJobErrorsAndStatistics(msrest.serialization.Model):
    """AnalyzeJobErrorsAndStatistics.

    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        """
        super(AnalyzeJobErrorsAndStatistics, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)


class JobMetadata(msrest.serialization.Model):
    """JobMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(JobMetadata, self).__init__(**kwargs)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class AnalyzeJobMetadata(JobMetadata, AnalyzeJobDisplayName):
    """AnalyzeJobMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(AnalyzeJobMetadata, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class Pagination(msrest.serialization.Model):
    """Pagination.

    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super(Pagination, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)


class TasksState(msrest.serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasks
        """
        super(TasksState, self).__init__(**kwargs)
        self.tasks = kwargs['tasks']


class AnalyzeJobState(AnalyzeJobMetadata, TasksState, AnalyzeJobErrorsAndStatistics, Pagination):
    """AnalyzeJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasks
    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasks
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(AnalyzeJobState, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.tasks = kwargs['tasks']
        self.next_link = kwargs.get('next_link', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.next_link = kwargs.get('next_link', None)
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.tasks = kwargs['tasks']
        self.display_name = kwargs.get('display_name', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class ClassificationResult(msrest.serialization.Model):
    """ClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Required. Classification type.
    :vartype category: str
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the recognized
     classification.
    :vartype confidence_score: float
    """

    _validation = {
        'category': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Required. Classification type.
        :paramtype category: str
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the recognized
         classification.
        :paramtype confidence_score: float
        """
        super(ClassificationResult, self).__init__(**kwargs)
        self.category = kwargs['category']
        self.confidence_score = kwargs['confidence_score']


class CustomEntitiesResult(msrest.serialization.Model):
    """CustomEntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        """
        super(CustomEntitiesResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']


class CustomEntitiesTask(msrest.serialization.Model):
    """CustomEntitiesTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'CustomEntitiesTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(CustomEntitiesTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class CustomEntitiesTaskParameters(msrest.serialization.Model):
    """CustomEntitiesTaskParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'project_name': {'key': 'project-name', 'type': 'str'},
        'deployment_name': {'key': 'deployment-name', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        """
        super(CustomEntitiesTaskParameters, self).__init__(**kwargs)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class CustomEntitiesTaskResult(msrest.serialization.Model):
    """CustomEntitiesTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomEntitiesResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesResult
        """
        super(CustomEntitiesTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class CustomMultiClassificationResult(msrest.serialization.Model):
    """CustomMultiClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.MultiClassificationDocument]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiClassificationDocument]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.MultiClassificationDocument]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        """
        super(CustomMultiClassificationResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']


class CustomMultiClassificationTask(msrest.serialization.Model):
    """CustomMultiClassificationTask.

    :ivar parameters:
    :vartype parameters:
     ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'CustomMultiClassificationTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(CustomMultiClassificationTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class CustomMultiClassificationTaskParameters(msrest.serialization.Model):
    """CustomMultiClassificationTaskParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'project_name': {'key': 'project-name', 'type': 'str'},
        'deployment_name': {'key': 'deployment-name', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super(CustomMultiClassificationTaskParameters, self).__init__(**kwargs)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']
        self.logging_opt_out = kwargs.get('logging_opt_out', False)


class CustomMultiClassificationTaskResult(msrest.serialization.Model):
    """CustomMultiClassificationTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomMultiClassificationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationResult
        """
        super(CustomMultiClassificationTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class CustomSingleClassificationResult(msrest.serialization.Model):
    """CustomSingleClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.SingleClassificationDocument]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[SingleClassificationDocument]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.SingleClassificationDocument]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        """
        super(CustomSingleClassificationResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']


class CustomSingleClassificationTask(msrest.serialization.Model):
    """CustomSingleClassificationTask.

    :ivar parameters:
    :vartype parameters:
     ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'CustomSingleClassificationTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(CustomSingleClassificationTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class CustomSingleClassificationTaskParameters(msrest.serialization.Model):
    """CustomSingleClassificationTaskParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'project_name': {'key': 'project-name', 'type': 'str'},
        'deployment_name': {'key': 'deployment-name', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super(CustomSingleClassificationTaskParameters, self).__init__(**kwargs)
        self.project_name = kwargs['project_name']
        self.deployment_name = kwargs['deployment_name']
        self.logging_opt_out = kwargs.get('logging_opt_out', False)


class CustomSingleClassificationTaskResult(msrest.serialization.Model):
    """CustomSingleClassificationTaskResult.

    :ivar results:
    :vartype results:
     ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomSingleClassificationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationResult
        """
        super(CustomSingleClassificationTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class DetectedLanguage(msrest.serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Long name of a detected language (e.g. English, French).
    :vartype name: str
    :ivar iso6391_name: Required. A two letter representation of the detected language according to
     the ISO 639-1 standard (e.g. en, fr).
    :vartype iso6391_name: str
    :ivar confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
     indicate 100% certainty that the identified language is true.
    :vartype confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. Long name of a detected language (e.g. English, French).
        :paramtype name: str
        :keyword iso6391_name: Required. A two letter representation of the detected language according
         to the ISO 639-1 standard (e.g. en, fr).
        :paramtype iso6391_name: str
        :keyword confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
         indicate 100% certainty that the identified language is true.
        :paramtype confidence_score: float
        """
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.iso6391_name = kwargs['iso6391_name']
        self.confidence_score = kwargs['confidence_score']


class DocumentEntities(msrest.serialization.Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.Entity]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.Entity]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(DocumentEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Document Id.
    :vartype id: str
    :ivar error: Required. Document Error.
    :vartype error: ~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Document Id.
        :paramtype id: str
        :keyword error: Required. Document Error.
        :paramtype error: ~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError
        """
        super(DocumentError, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.error = kwargs['error']


class DocumentHealthcareEntities(msrest.serialization.Model):
    """DocumentHealthcareEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar entities: Required. Healthcare entities.
    :vartype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntity]
    :ivar relations: Required. Healthcare entity relations.
    :vartype relations: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareRelation]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareEntity]'},
        'relations': {'key': 'relations', 'type': '[HealthcareRelation]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword entities: Required. Healthcare entities.
        :paramtype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntity]
        :keyword relations: Required. Healthcare entity relations.
        :paramtype relations: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareRelation]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(DocumentHealthcareEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.relations = kwargs['relations']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentKeyPhrases(msrest.serialization.Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :vartype key_phrases: list[str]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword key_phrases: Required. A list of representative words or phrases. The number of key
         phrases returned is proportional to the number of words in the input document.
        :paramtype key_phrases: list[str]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(DocumentKeyPhrases, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.key_phrases = kwargs['key_phrases']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentLanguage(msrest.serialization.Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar detected_language: Required. Detected Language.
    :vartype detected_language: ~azure.ai.textanalytics.v3_2_preview_2.models.DetectedLanguage
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_language': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'DetectedLanguage'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword detected_language: Required. Detected Language.
        :paramtype detected_language: ~azure.ai.textanalytics.v3_2_preview_2.models.DetectedLanguage
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(DocumentLanguage, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.detected_language = kwargs['detected_language']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentLinkedEntities(msrest.serialization.Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar entities: Required. Recognized well known entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.LinkedEntity]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword entities: Required. Recognized well known entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.LinkedEntity]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(DocumentLinkedEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class DocumentSentiment(msrest.serialization.Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Possible values include: "positive", "neutral", "negative", "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentSentimentValue
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    :ivar confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Required. Sentence level sentiment analysis.
    :vartype sentences: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceSentiment]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
         Mixed). Possible values include: "positive", "neutral", "negative", "mixed".
        :paramtype sentiment: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentSentimentValue
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        :keyword confidence_scores: Required. Document level sentiment confidence scores between 0 and
         1 for each sentiment class.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Required. Sentence level sentiment analysis.
        :paramtype sentences: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceSentiment]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        """
        super(DocumentSentiment, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.sentiment = kwargs['sentiment']
        self.statistics = kwargs.get('statistics', None)
        self.confidence_scores = kwargs['confidence_scores']
        self.sentences = kwargs['sentences']
        self.warnings = kwargs['warnings']


class DocumentStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :ivar characters_count: Required. Number of text elements recognized in the document.
    :vartype characters_count: int
    :ivar transactions_count: Required. Number of transactions for the document.
    :vartype transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword characters_count: Required. Number of text elements recognized in the document.
        :paramtype characters_count: int
        :keyword transactions_count: Required. Number of transactions for the document.
        :paramtype transactions_count: int
        """
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = kwargs['characters_count']
        self.transactions_count = kwargs['transactions_count']


class EntitiesResult(msrest.serialization.Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(EntitiesResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class EntitiesTask(msrest.serialization.Model):
    """EntitiesTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'EntitiesTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(EntitiesTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class EntitiesTaskParameters(msrest.serialization.Model):
    """EntitiesTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        """
        super(EntitiesTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class EntitiesTaskResult(msrest.serialization.Model):
    """EntitiesTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesResult
        """
        super(EntitiesTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class Entity(msrest.serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Entity type.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :vartype offset: int
    :ivar length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Entity type.
        :paramtype category: str
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Required. Start position for the entity text. Use of different
         'stringIndexType' values can affect the offset returned.
        :paramtype offset: int
        :keyword length: Required. Length for the entity text. Use of different 'stringIndexType'
         values can affect the length returned.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        """
        super(Entity, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class EntityLinkingResult(msrest.serialization.Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentLinkedEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLinkedEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentLinkedEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(EntityLinkingResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class EntityLinkingTask(msrest.serialization.Model):
    """EntityLinkingTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'EntityLinkingTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(EntityLinkingTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class EntityLinkingTaskParameters(msrest.serialization.Model):
    """EntityLinkingTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        """
        super(EntityLinkingTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class EntityLinkingTaskResult(msrest.serialization.Model):
    """EntityLinkingTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingResult
        """
        super(EntityLinkingTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. Document Error.
    :vartype error: ~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: Required. Document Error.
        :paramtype error: ~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs['error']


class ExtractedDocumentSummary(msrest.serialization.Model):
    """ExtractedDocumentSummary.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar sentences: Required. A ranked list of sentences representing the extracted summary.
    :vartype sentences:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractedSummarySentence]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentences': {'key': 'sentences', 'type': '[ExtractedSummarySentence]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword sentences: Required. A ranked list of sentences representing the extracted summary.
        :paramtype sentences:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractedSummarySentence]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(ExtractedDocumentSummary, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.sentences = kwargs['sentences']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class ExtractedSummarySentence(msrest.serialization.Model):
    """ExtractedSummarySentence.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The extracted sentence text.
    :vartype text: str
    :ivar rank_score: Required. A double value representing the relevance of the sentence within
     the summary. Higher values indicate higher importance.
    :vartype rank_score: float
    :ivar offset: Required. The sentence offset from the start of the document, based on the value
     of the parameter StringIndexType.
    :vartype offset: int
    :ivar length: Required. The length of the sentence.
    :vartype length: int
    """

    _validation = {
        'text': {'required': True},
        'rank_score': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'rank_score': {'key': 'rankScore', 'type': 'float'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The extracted sentence text.
        :paramtype text: str
        :keyword rank_score: Required. A double value representing the relevance of the sentence within
         the summary. Higher values indicate higher importance.
        :paramtype rank_score: float
        :keyword offset: Required. The sentence offset from the start of the document, based on the
         value of the parameter StringIndexType.
        :paramtype offset: int
        :keyword length: Required. The length of the sentence.
        :paramtype length: int
        """
        super(ExtractedSummarySentence, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.rank_score = kwargs['rank_score']
        self.offset = kwargs['offset']
        self.length = kwargs['length']


class ExtractiveSummarizationResult(msrest.serialization.Model):
    """ExtractiveSummarizationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractedDocumentSummary]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[ExtractedDocumentSummary]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractedDocumentSummary]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(ExtractiveSummarizationResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class ExtractiveSummarizationTask(msrest.serialization.Model):
    """ExtractiveSummarizationTask.

    :ivar parameters:
    :vartype parameters:
     ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'ExtractiveSummarizationTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(ExtractiveSummarizationTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class ExtractiveSummarizationTaskParameters(msrest.serialization.Model):
    """ExtractiveSummarizationTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    :ivar sentence_count:
    :vartype sentence_count: int
    :ivar sort_by: Possible values include: "Offset", "Rank". Default value: "Offset".
    :vartype sort_by: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTaskParametersSortBy
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
        'sentence_count': {'key': 'sentenceCount', 'type': 'int'},
        'sort_by': {'key': 'sortBy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        :keyword sentence_count:
        :paramtype sentence_count: int
        :keyword sort_by: Possible values include: "Offset", "Rank". Default value: "Offset".
        :paramtype sort_by: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTaskParametersSortBy
        """
        super(ExtractiveSummarizationTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.string_index_type = kwargs.get('string_index_type', None)
        self.sentence_count = kwargs.get('sentence_count', 3)
        self.sort_by = kwargs.get('sort_by', "Offset")


class ExtractiveSummarizationTaskResult(msrest.serialization.Model):
    """ExtractiveSummarizationTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'ExtractiveSummarizationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationResult
        """
        super(ExtractiveSummarizationTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class HealthcareAssertion(msrest.serialization.Model):
    """HealthcareAssertion.

    :ivar conditionality: Describes any conditionality on the entity. Possible values include:
     "hypothetical", "conditional".
    :vartype conditionality: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Conditionality
    :ivar certainty: Describes the entities certainty and polarity. Possible values include:
     "positive", "positivePossible", "neutralPossible", "negativePossible", "negative".
    :vartype certainty: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Certainty
    :ivar association: Describes if the entity is the subject of the text or if it describes
     someone else. Possible values include: "subject", "other".
    :vartype association: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Association
    """

    _attribute_map = {
        'conditionality': {'key': 'conditionality', 'type': 'str'},
        'certainty': {'key': 'certainty', 'type': 'str'},
        'association': {'key': 'association', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword conditionality: Describes any conditionality on the entity. Possible values include:
         "hypothetical", "conditional".
        :paramtype conditionality: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Conditionality
        :keyword certainty: Describes the entities certainty and polarity. Possible values include:
         "positive", "positivePossible", "neutralPossible", "negativePossible", "negative".
        :paramtype certainty: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Certainty
        :keyword association: Describes if the entity is the subject of the text or if it describes
         someone else. Possible values include: "subject", "other".
        :paramtype association: str or ~azure.ai.textanalytics.v3_2_preview_2.models.Association
        """
        super(HealthcareAssertion, self).__init__(**kwargs)
        self.conditionality = kwargs.get('conditionality', None)
        self.certainty = kwargs.get('certainty', None)
        self.association = kwargs.get('association', None)


class HealthcareLinkingProperties(msrest.serialization.Model):
    """HealthcareLinkingProperties.

    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityLink]
    """

    _attribute_map = {
        'assertion': {'key': 'assertion', 'type': 'HealthcareAssertion'},
        'name': {'key': 'name', 'type': 'str'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityLink]
        """
        super(HealthcareLinkingProperties, self).__init__(**kwargs)
        self.assertion = kwargs.get('assertion', None)
        self.name = kwargs.get('name', None)
        self.links = kwargs.get('links', None)


class HealthcareEntityProperties(msrest.serialization.Model):
    """HealthcareEntityProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Healthcare Entity Category. Possible values include:
     "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
     "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
     "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
     "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
     "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
    :vartype category: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :vartype offset: int
    :ivar length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Healthcare Entity Category. Possible values include:
         "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
         "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
         "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
         "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
         "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
        :paramtype category: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Required. Start position for the entity text. Use of different
         'stringIndexType' values can affect the offset returned.
        :paramtype offset: int
        :keyword length: Required. Length for the entity text. Use of different 'stringIndexType'
         values can affect the length returned.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        """
        super(HealthcareEntityProperties, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class HealthcareEntity(HealthcareEntityProperties, HealthcareLinkingProperties):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityLink]
    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Healthcare Entity Category. Possible values include:
     "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
     "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
     "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
     "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
     "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
    :vartype category: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :vartype offset: int
    :ivar length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'assertion': {'key': 'assertion', 'type': 'HealthcareAssertion'},
        'name': {'key': 'name', 'type': 'str'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityLink]
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Healthcare Entity Category. Possible values include:
         "BODY_STRUCTURE", "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY",
         "MEASUREMENT_VALUE", "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN",
         "VARIANT", "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
         "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
         "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
        :paramtype category: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Required. Start position for the entity text. Use of different
         'stringIndexType' values can affect the offset returned.
        :paramtype offset: int
        :keyword length: Required. Length for the entity text. Use of different 'stringIndexType'
         values can affect the length returned.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        """
        super(HealthcareEntity, self).__init__(**kwargs)
        self.assertion = kwargs.get('assertion', None)
        self.name = kwargs.get('name', None)
        self.links = kwargs.get('links', None)
        self.text = kwargs['text']
        self.category = kwargs['category']
        self.subcategory = kwargs.get('subcategory', None)
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.confidence_score = kwargs['confidence_score']


class HealthcareEntityLink(msrest.serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
    :vartype data_source: str
    :ivar id: Required. Entity id in the given source catalog.
    :vartype id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
        :paramtype data_source: str
        :keyword id: Required. Entity id in the given source catalog.
        :paramtype id: str
        """
        super(HealthcareEntityLink, self).__init__(**kwargs)
        self.data_source = kwargs['data_source']
        self.id = kwargs['id']


class HealthcareTaskResult(msrest.serialization.Model):
    """HealthcareTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareResult
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'HealthcareResult'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareResult
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
        """
        super(HealthcareTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)


class HealthcareJobState(JobMetadata, Pagination, HealthcareTaskResult):
    """HealthcareJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareResult
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
    :ivar next_link:
    :vartype next_link: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'HealthcareResult'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareResult
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
        :keyword next_link:
        :paramtype next_link: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(HealthcareJobState, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)
        self.next_link = kwargs.get('next_link', None)
        self.results = kwargs.get('results', None)
        self.errors = kwargs.get('errors', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']
        self.next_link = kwargs.get('next_link', None)
        self.created_date_time = kwargs['created_date_time']
        self.expiration_date_time = kwargs.get('expiration_date_time', None)
        self.job_id = kwargs['job_id']
        self.last_update_date_time = kwargs['last_update_date_time']
        self.status = kwargs['status']


class HealthcareRelation(msrest.serialization.Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles within the relation context.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Possible values include: "Abbreviation",
     "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
     "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
     "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
     "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
     "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", "ValueOfExamination".
    :vartype relation_type: str or ~azure.ai.textanalytics.v3_2_preview_2.models.RelationType
    :ivar entities: Required. The entities in the relation.
    :vartype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareRelationEntity]
    """

    _validation = {
        'relation_type': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareRelationEntity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
         'FrequencyOfMedication', etc. Possible values include: "Abbreviation",
         "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
         "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
         "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
         "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
         "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", "ValueOfExamination".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v3_2_preview_2.models.RelationType
        :keyword entities: Required. The entities in the relation.
        :paramtype entities:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.HealthcareRelationEntity]
        """
        super(HealthcareRelation, self).__init__(**kwargs)
        self.relation_type = kwargs['relation_type']
        self.entities = kwargs['entities']


class HealthcareRelationEntity(msrest.serialization.Model):
    """HealthcareRelationEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar ref: Required. Reference link object, using a JSON pointer RFC 6901 (URI Fragment
     Identifier Representation), pointing to the entity .
    :vartype ref: str
    :ivar role: Required. Role of entity in the relationship. For example: 'CD20-positive diffuse
     large B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis).
    :vartype role: str
    """

    _validation = {
        'ref': {'required': True},
        'role': {'required': True},
    }

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword ref: Required. Reference link object, using a JSON pointer RFC 6901 (URI Fragment
         Identifier Representation), pointing to the entity .
        :paramtype ref: str
        :keyword role: Required. Role of entity in the relationship. For example: 'CD20-positive
         diffuse large B-cell lymphoma' has the following entities with their roles in parenthesis:
         CD20 (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis).
        :paramtype role: str
        """
        super(HealthcareRelationEntity, self).__init__(**kwargs)
        self.ref = kwargs['ref']
        self.role = kwargs['role']


class HealthcareResult(msrest.serialization.Model):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentHealthcareEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentHealthcareEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentHealthcareEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(HealthcareResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class InnerError(msrest.serialization.Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Possible values include: "InvalidParameterValue",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.InnerErrorCodeValue
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_2_preview_2.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Possible values include: "InvalidParameterValue",
         "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
         "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
         "InvalidCountryHint".
        :paramtype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.InnerErrorCodeValue
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_2_preview_2.models.InnerError
        """
        super(InnerError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.details = kwargs.get('details', None)
        self.target = kwargs.get('target', None)
        self.innererror = kwargs.get('innererror', None)


class JobManifestTasks(msrest.serialization.Model):
    """The set of tasks to execute on the input documents. Cannot specify the same task more than once.

    :ivar entity_recognition_tasks:
    :vartype entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesTask]
    :ivar entity_recognition_pii_tasks:
    :vartype entity_recognition_pii_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.PiiTask]
    :ivar key_phrase_extraction_tasks:
    :vartype key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhrasesTask]
    :ivar entity_linking_tasks:
    :vartype entity_linking_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingTask]
    :ivar sentiment_analysis_tasks:
    :vartype sentiment_analysis_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.SentimentAnalysisTask]
    :ivar extractive_summarization_tasks:
    :vartype extractive_summarization_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTask]
    :ivar custom_entity_recognition_tasks:
    :vartype custom_entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesTask]
    :ivar custom_single_classification_tasks:
    :vartype custom_single_classification_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationTask]
    :ivar custom_multi_classification_tasks:
    :vartype custom_multi_classification_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationTask]
    """

    _attribute_map = {
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[EntitiesTask]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[PiiTask]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[KeyPhrasesTask]'},
        'entity_linking_tasks': {'key': 'entityLinkingTasks', 'type': '[EntityLinkingTask]'},
        'sentiment_analysis_tasks': {'key': 'sentimentAnalysisTasks', 'type': '[SentimentAnalysisTask]'},
        'extractive_summarization_tasks': {'key': 'extractiveSummarizationTasks', 'type': '[ExtractiveSummarizationTask]'},
        'custom_entity_recognition_tasks': {'key': 'customEntityRecognitionTasks', 'type': '[CustomEntitiesTask]'},
        'custom_single_classification_tasks': {'key': 'customSingleClassificationTasks', 'type': '[CustomSingleClassificationTask]'},
        'custom_multi_classification_tasks': {'key': 'customMultiClassificationTasks', 'type': '[CustomMultiClassificationTask]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword entity_recognition_tasks:
        :paramtype entity_recognition_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesTask]
        :keyword entity_recognition_pii_tasks:
        :paramtype entity_recognition_pii_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.PiiTask]
        :keyword key_phrase_extraction_tasks:
        :paramtype key_phrase_extraction_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhrasesTask]
        :keyword entity_linking_tasks:
        :paramtype entity_linking_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingTask]
        :keyword sentiment_analysis_tasks:
        :paramtype sentiment_analysis_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.SentimentAnalysisTask]
        :keyword extractive_summarization_tasks:
        :paramtype extractive_summarization_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationTask]
        :keyword custom_entity_recognition_tasks:
        :paramtype custom_entity_recognition_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesTask]
        :keyword custom_single_classification_tasks:
        :paramtype custom_single_classification_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationTask]
        :keyword custom_multi_classification_tasks:
        :paramtype custom_multi_classification_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationTask]
        """
        super(JobManifestTasks, self).__init__(**kwargs)
        self.entity_recognition_tasks = kwargs.get('entity_recognition_tasks', None)
        self.entity_recognition_pii_tasks = kwargs.get('entity_recognition_pii_tasks', None)
        self.key_phrase_extraction_tasks = kwargs.get('key_phrase_extraction_tasks', None)
        self.entity_linking_tasks = kwargs.get('entity_linking_tasks', None)
        self.sentiment_analysis_tasks = kwargs.get('sentiment_analysis_tasks', None)
        self.extractive_summarization_tasks = kwargs.get('extractive_summarization_tasks', None)
        self.custom_entity_recognition_tasks = kwargs.get('custom_entity_recognition_tasks', None)
        self.custom_single_classification_tasks = kwargs.get('custom_single_classification_tasks', None)
        self.custom_multi_classification_tasks = kwargs.get('custom_multi_classification_tasks', None)


class KeyPhraseResult(msrest.serialization.Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentKeyPhrases]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentKeyPhrases]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentKeyPhrases]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(KeyPhraseResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class KeyPhrasesTask(msrest.serialization.Model):
    """KeyPhrasesTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhrasesTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'KeyPhrasesTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhrasesTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(KeyPhrasesTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class KeyPhrasesTaskParameters(msrest.serialization.Model):
    """KeyPhrasesTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super(KeyPhrasesTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)


class KeyPhraseTaskResult(msrest.serialization.Model):
    """KeyPhraseTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhraseResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhraseResult
        """
        super(KeyPhraseTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class LanguageBatchInput(msrest.serialization.Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.LanguageInput]
        """
        super(LanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs['documents']


class LanguageInput(msrest.serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required.
    :vartype text: str
    :ivar country_hint:
    :vartype country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required.
        :paramtype text: str
        :keyword country_hint:
        :paramtype country_hint: str
        """
        super(LanguageInput, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.text = kwargs['text']
        self.country_hint = kwargs.get('country_hint', None)


class LanguageResult(msrest.serialization.Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentLanguage]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLanguage]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentLanguage]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(LanguageResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class LinkedEntity(msrest.serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Entity Linking formal name.
    :vartype name: str
    :ivar matches: Required. List of instances this entity appears in the text.
    :vartype matches: list[~azure.ai.textanalytics.v3_2_preview_2.models.Match]
    :ivar language: Required. Language used in the data source.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: Required. URL for the entity's page from the data source.
    :vartype url: str
    :ivar data_source: Required. Data source used to extract entity linking, such as Wiki/Bing etc.
    :vartype data_source: str
    :ivar bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :vartype bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. Entity Linking formal name.
        :paramtype name: str
        :keyword matches: Required. List of instances this entity appears in the text.
        :paramtype matches: list[~azure.ai.textanalytics.v3_2_preview_2.models.Match]
        :keyword language: Required. Language used in the data source.
        :paramtype language: str
        :keyword id: Unique identifier of the recognized entity from the data source.
        :paramtype id: str
        :keyword url: Required. URL for the entity's page from the data source.
        :paramtype url: str
        :keyword data_source: Required. Data source used to extract entity linking, such as Wiki/Bing
         etc.
        :paramtype data_source: str
        :keyword bing_id: Bing Entity Search API unique identifier of the recognized entity.
        :paramtype bing_id: str
        """
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.matches = kwargs['matches']
        self.language = kwargs['language']
        self.id = kwargs.get('id', None)
        self.url = kwargs['url']
        self.data_source = kwargs['data_source']
        self.bing_id = kwargs.get('bing_id', None)


class Match(msrest.serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :ivar confidence_score: Required. If a well known item is recognized, a decimal number denoting
     the confidence level between 0 and 1 will be returned.
    :vartype confidence_score: float
    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar offset: Required. Start position for the entity match text.
    :vartype offset: int
    :ivar length: Required. Length for the entity match text.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword confidence_score: Required. If a well known item is recognized, a decimal number
         denoting the confidence level between 0 and 1 will be returned.
        :paramtype confidence_score: float
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword offset: Required. Start position for the entity match text.
        :paramtype offset: int
        :keyword length: Required. Length for the entity match text.
        :paramtype length: int
        """
        super(Match, self).__init__(**kwargs)
        self.confidence_score = kwargs['confidence_score']
        self.text = kwargs['text']
        self.offset = kwargs['offset']
        self.length = kwargs['length']


class MultiClassificationDocument(msrest.serialization.Model):
    """MultiClassificationDocument.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar classifications: Required. Recognized classification results in the document.
    :vartype classifications:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.ClassificationResult]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'classifications': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'classifications': {'key': 'classifications', 'type': '[ClassificationResult]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword classifications: Required. Recognized classification results in the document.
        :paramtype classifications:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.ClassificationResult]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(MultiClassificationDocument, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.classifications = kwargs['classifications']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class MultiLanguageBatchInput(msrest.serialization.Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. The set of documents to process as part of this batch.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. The set of documents to process as part of this batch.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.MultiLanguageInput]
        """
        super(MultiLanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs['documents']


class MultiLanguageInput(msrest.serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. A unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required. The input text to process.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. A unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required. The input text to process.
        :paramtype text: str
        :keyword language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
         example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.text = kwargs['text']
        self.language = kwargs.get('language', None)


class PiiDocumentEntities(msrest.serialization.Model):
    """PiiDocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar redacted_text: Required. Returns redacted text.
    :vartype redacted_text: str
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.Entity]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'redacted_text': {'key': 'redactedText', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword redacted_text: Required. Returns redacted text.
        :paramtype redacted_text: str
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v3_2_preview_2.models.Entity]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(PiiDocumentEntities, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.redacted_text = kwargs['redacted_text']
        self.entities = kwargs['entities']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class PiiResult(msrest.serialization.Model):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.PiiDocumentEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[PiiDocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.PiiDocumentEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(PiiResult, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class PiiTask(msrest.serialization.Model):
    """PiiTask.

    :ivar parameters:
    :vartype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'PiiTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(PiiTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class PiiTaskParameters(msrest.serialization.Model):
    """PiiTaskParameters.

    :ivar domain: Possible values include: "phi", "none". Default value: "none".
    :vartype domain: str or ~azure.ai.textanalytics.v3_2_preview_2.models.PiiTaskParametersDomain
    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar pii_categories: (Optional) describes the PII categories to return.
    :vartype pii_categories: list[str or ~azure.ai.textanalytics.v3_2_preview_2.models.PiiCategory]
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    """

    _validation = {
        'pii_categories': {'unique': True},
    }

    _attribute_map = {
        'domain': {'key': 'domain', 'type': 'str'},
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'pii_categories': {'key': 'piiCategories', 'type': '[str]'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword domain: Possible values include: "phi", "none". Default value: "none".
        :paramtype domain: str or ~azure.ai.textanalytics.v3_2_preview_2.models.PiiTaskParametersDomain
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword pii_categories: (Optional) describes the PII categories to return.
        :paramtype pii_categories: list[str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.PiiCategory]
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        """
        super(PiiTaskParameters, self).__init__(**kwargs)
        self.domain = kwargs.get('domain', "none")
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', True)
        self.pii_categories = kwargs.get('pii_categories', None)
        self.string_index_type = kwargs.get('string_index_type', None)


class PiiTaskResult(msrest.serialization.Model):
    """PiiTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiResult
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiResult
        """
        super(PiiTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class RequestStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar documents_count: Required. Number of documents submitted in the request.
    :vartype documents_count: int
    :ivar valid_documents_count: Required. Number of valid documents. This excludes empty,
     over-size limit or non-supported languages documents.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Required. Number of invalid documents. This includes empty,
     over-size limit or non-supported languages documents.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Required. Number of transactions for the request.
    :vartype transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents_count: Required. Number of documents submitted in the request.
        :paramtype documents_count: int
        :keyword valid_documents_count: Required. Number of valid documents. This excludes empty,
         over-size limit or non-supported languages documents.
        :paramtype valid_documents_count: int
        :keyword erroneous_documents_count: Required. Number of invalid documents. This includes empty,
         over-size limit or non-supported languages documents.
        :paramtype erroneous_documents_count: int
        :keyword transactions_count: Required. Number of transactions for the request.
        :paramtype transactions_count: long
        """
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = kwargs['documents_count']
        self.valid_documents_count = kwargs['valid_documents_count']
        self.erroneous_documents_count = kwargs['erroneous_documents_count']
        self.transactions_count = kwargs['transactions_count']


class SentenceAssessment(msrest.serialization.Model):
    """SentenceAssessment.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Required. Assessment sentiment in the sentence. Possible values include:
     "positive", "mixed", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.TokenSentimentValue
    :ivar confidence_scores: Required. Assessment sentiment confidence scores in the sentence.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_2_preview_2.models.TargetConfidenceScoreLabel
    :ivar offset: Required. The assessment offset from the start of the sentence.
    :vartype offset: int
    :ivar length: Required. The length of the assessment.
    :vartype length: int
    :ivar text: Required. The assessment text detected.
    :vartype text: str
    :ivar is_negated: Required. The indicator representing if the assessment is negated.
    :vartype is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'is_negated': {'key': 'isNegated', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sentiment: Required. Assessment sentiment in the sentence. Possible values include:
         "positive", "mixed", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.TokenSentimentValue
        :keyword confidence_scores: Required. Assessment sentiment confidence scores in the sentence.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_2_preview_2.models.TargetConfidenceScoreLabel
        :keyword offset: Required. The assessment offset from the start of the sentence.
        :paramtype offset: int
        :keyword length: Required. The length of the assessment.
        :paramtype length: int
        :keyword text: Required. The assessment text detected.
        :paramtype text: str
        :keyword is_negated: Required. The indicator representing if the assessment is negated.
        :paramtype is_negated: bool
        """
        super(SentenceAssessment, self).__init__(**kwargs)
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.text = kwargs['text']
        self.is_negated = kwargs['is_negated']


class SentenceSentiment(msrest.serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The sentence text.
    :vartype text: str
    :ivar sentiment: Required. The predicted Sentiment for the sentence. Possible values include:
     "positive", "neutral", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.SentenceSentimentValue
    :ivar confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
     sentence for all classes.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentConfidenceScorePerLabel
    :ivar offset: Required. The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: Required. The length of the sentence.
    :vartype length: int
    :ivar targets: The array of sentence targets for the sentence.
    :vartype targets: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceTarget]
    :ivar assessments: The array of assessments for the sentence.
    :vartype assessments: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceAssessment]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'targets': {'key': 'targets', 'type': '[SentenceTarget]'},
        'assessments': {'key': 'assessments', 'type': '[SentenceAssessment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The sentence text.
        :paramtype text: str
        :keyword sentiment: Required. The predicted Sentiment for the sentence. Possible values
         include: "positive", "neutral", "negative".
        :paramtype sentiment: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.SentenceSentimentValue
        :keyword confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
         sentence for all classes.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentConfidenceScorePerLabel
        :keyword offset: Required. The sentence offset from the start of the document.
        :paramtype offset: int
        :keyword length: Required. The length of the sentence.
        :paramtype length: int
        :keyword targets: The array of sentence targets for the sentence.
        :paramtype targets: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceTarget]
        :keyword assessments: The array of assessments for the sentence.
        :paramtype assessments: list[~azure.ai.textanalytics.v3_2_preview_2.models.SentenceAssessment]
        """
        super(SentenceSentiment, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.targets = kwargs.get('targets', None)
        self.assessments = kwargs.get('assessments', None)


class SentenceTarget(msrest.serialization.Model):
    """SentenceTarget.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Required. Targeted sentiment in the sentence. Possible values include:
     "positive", "mixed", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.TokenSentimentValue
    :ivar confidence_scores: Required. Target sentiment confidence scores for the target in the
     sentence.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_2_preview_2.models.TargetConfidenceScoreLabel
    :ivar offset: Required. The target offset from the start of the sentence.
    :vartype offset: int
    :ivar length: Required. The length of the target.
    :vartype length: int
    :ivar text: Required. The target text detected.
    :vartype text: str
    :ivar relations: Required. The array of either assessment or target objects which is related to
     the target.
    :vartype relations: list[~azure.ai.textanalytics.v3_2_preview_2.models.TargetRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'relations': {'key': 'relations', 'type': '[TargetRelation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sentiment: Required. Targeted sentiment in the sentence. Possible values include:
         "positive", "mixed", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_2_preview_2.models.TokenSentimentValue
        :keyword confidence_scores: Required. Target sentiment confidence scores for the target in the
         sentence.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_2_preview_2.models.TargetConfidenceScoreLabel
        :keyword offset: Required. The target offset from the start of the sentence.
        :paramtype offset: int
        :keyword length: Required. The length of the target.
        :paramtype length: int
        :keyword text: Required. The target text detected.
        :paramtype text: str
        :keyword relations: Required. The array of either assessment or target objects which is related
         to the target.
        :paramtype relations: list[~azure.ai.textanalytics.v3_2_preview_2.models.TargetRelation]
        """
        super(SentenceTarget, self).__init__(**kwargs)
        self.sentiment = kwargs['sentiment']
        self.confidence_scores = kwargs['confidence_scores']
        self.offset = kwargs['offset']
        self.length = kwargs['length']
        self.text = kwargs['text']
        self.relations = kwargs['relations']


class SentimentAnalysisTask(msrest.serialization.Model):
    """SentimentAnalysisTask.

    :ivar parameters:
    :vartype parameters:
     ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentAnalysisTaskParameters
    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'SentimentAnalysisTaskParameters'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameters:
        :paramtype parameters:
         ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentAnalysisTaskParameters
        :keyword task_name:
        :paramtype task_name: str
        """
        super(SentimentAnalysisTask, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.task_name = kwargs.get('task_name', None)


class SentimentAnalysisTaskParameters(msrest.serialization.Model):
    """SentimentAnalysisTaskParameters.

    :ivar model_version:
    :vartype model_version: str
    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar opinion_mining:
    :vartype opinion_mining: bool
    :ivar string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
     "Utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'opinion_mining': {'key': 'opinionMining', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_version:
        :paramtype model_version: str
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword opinion_mining:
        :paramtype opinion_mining: bool
        :keyword string_index_type: Possible values include: "TextElement_v8", "UnicodeCodePoint",
         "Utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.StringIndexType
        """
        super(SentimentAnalysisTaskParameters, self).__init__(**kwargs)
        self.model_version = kwargs.get('model_version', "latest")
        self.logging_opt_out = kwargs.get('logging_opt_out', False)
        self.opinion_mining = kwargs.get('opinion_mining', False)
        self.string_index_type = kwargs.get('string_index_type', None)


class SentimentConfidenceScorePerLabel(msrest.serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar neutral: Required.
    :vartype neutral: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword neutral: Required.
        :paramtype neutral: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = kwargs['positive']
        self.neutral = kwargs['neutral']
        self.negative = kwargs['negative']


class SentimentResponse(msrest.serialization.Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Sentiment analysis per document.
    :vartype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentSentiment]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentSentiment]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword documents: Required. Sentiment analysis per document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentSentiment]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_2_preview_2.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(SentimentResponse, self).__init__(**kwargs)
        self.documents = kwargs['documents']
        self.errors = kwargs['errors']
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs['model_version']


class SentimentTaskResult(msrest.serialization.Model):
    """SentimentTaskResult.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentResponse
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': 'SentimentResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentResponse
        """
        super(SentimentTaskResult, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class SingleClassificationDocument(msrest.serialization.Model):
    """SingleClassificationDocument.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar classification: Required.
    :vartype classification: ~azure.ai.textanalytics.v3_2_preview_2.models.ClassificationResult
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'classification': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'classification': {'key': 'classification', 'type': 'ClassificationResult'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword classification: Required.
        :paramtype classification: ~azure.ai.textanalytics.v3_2_preview_2.models.ClassificationResult
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_2_preview_2.models.DocumentStatistics
        """
        super(SingleClassificationDocument, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.classification = kwargs['classification']
        self.warnings = kwargs['warnings']
        self.statistics = kwargs.get('statistics', None)


class TargetConfidenceScoreLabel(msrest.serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super(TargetConfidenceScoreLabel, self).__init__(**kwargs)
        self.positive = kwargs['positive']
        self.negative = kwargs['negative']


class TargetRelation(msrest.serialization.Model):
    """TargetRelation.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Required. The type related to the target. Possible values include:
     "assessment", "target".
    :vartype relation_type: str or ~azure.ai.textanalytics.v3_2_preview_2.models.TargetRelationType
    :ivar ref: Required. The JSON pointer indicating the linked object.
    :vartype ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword relation_type: Required. The type related to the target. Possible values include:
         "assessment", "target".
        :paramtype relation_type: str or
         ~azure.ai.textanalytics.v3_2_preview_2.models.TargetRelationType
        :keyword ref: Required. The JSON pointer indicating the linked object.
        :paramtype ref: str
        """
        super(TargetRelation, self).__init__(**kwargs)
        self.relation_type = kwargs['relation_type']
        self.ref = kwargs['ref']


class TasksStateTasks(msrest.serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :ivar completed: Required.
    :vartype completed: int
    :ivar failed: Required.
    :vartype failed: int
    :ivar in_progress: Required.
    :vartype in_progress: int
    :ivar total: Required.
    :vartype total: int
    :ivar entity_recognition_tasks:
    :vartype entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityRecognitionTasksItem]
    :ivar entity_recognition_pii_tasks:
    :vartype entity_recognition_pii_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityRecognitionPiiTasksItem]
    :ivar key_phrase_extraction_tasks:
    :vartype key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksKeyPhraseExtractionTasksItem]
    :ivar entity_linking_tasks:
    :vartype entity_linking_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityLinkingTasksItem]
    :ivar sentiment_analysis_tasks:
    :vartype sentiment_analysis_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksSentimentAnalysisTasksItem]
    :ivar extractive_summarization_tasks:
    :vartype extractive_summarization_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksExtractiveSummarizationTasksItem]
    :ivar custom_entity_recognition_tasks:
    :vartype custom_entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomEntityRecognitionTasksItem]
    :ivar custom_single_classification_tasks:
    :vartype custom_single_classification_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomSingleClassificationTasksItem]
    :ivar custom_multi_classification_tasks:
    :vartype custom_multi_classification_tasks:
     list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomMultiClassificationTasksItem]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'completed': {'key': 'completed', 'type': 'int'},
        'failed': {'key': 'failed', 'type': 'int'},
        'in_progress': {'key': 'inProgress', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[TasksStateTasksEntityRecognitionTasksItem]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[TasksStateTasksEntityRecognitionPiiTasksItem]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[TasksStateTasksKeyPhraseExtractionTasksItem]'},
        'entity_linking_tasks': {'key': 'entityLinkingTasks', 'type': '[TasksStateTasksEntityLinkingTasksItem]'},
        'sentiment_analysis_tasks': {'key': 'sentimentAnalysisTasks', 'type': '[TasksStateTasksSentimentAnalysisTasksItem]'},
        'extractive_summarization_tasks': {'key': 'extractiveSummarizationTasks', 'type': '[TasksStateTasksExtractiveSummarizationTasksItem]'},
        'custom_entity_recognition_tasks': {'key': 'customEntityRecognitionTasks', 'type': '[TasksStateTasksCustomEntityRecognitionTasksItem]'},
        'custom_single_classification_tasks': {'key': 'customSingleClassificationTasks', 'type': '[TasksStateTasksCustomSingleClassificationTasksItem]'},
        'custom_multi_classification_tasks': {'key': 'customMultiClassificationTasks', 'type': '[TasksStateTasksCustomMultiClassificationTasksItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword completed: Required.
        :paramtype completed: int
        :keyword failed: Required.
        :paramtype failed: int
        :keyword in_progress: Required.
        :paramtype in_progress: int
        :keyword total: Required.
        :paramtype total: int
        :keyword entity_recognition_tasks:
        :paramtype entity_recognition_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityRecognitionTasksItem]
        :keyword entity_recognition_pii_tasks:
        :paramtype entity_recognition_pii_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityRecognitionPiiTasksItem]
        :keyword key_phrase_extraction_tasks:
        :paramtype key_phrase_extraction_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksKeyPhraseExtractionTasksItem]
        :keyword entity_linking_tasks:
        :paramtype entity_linking_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksEntityLinkingTasksItem]
        :keyword sentiment_analysis_tasks:
        :paramtype sentiment_analysis_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksSentimentAnalysisTasksItem]
        :keyword extractive_summarization_tasks:
        :paramtype extractive_summarization_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksExtractiveSummarizationTasksItem]
        :keyword custom_entity_recognition_tasks:
        :paramtype custom_entity_recognition_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomEntityRecognitionTasksItem]
        :keyword custom_single_classification_tasks:
        :paramtype custom_single_classification_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomSingleClassificationTasksItem]
        :keyword custom_multi_classification_tasks:
        :paramtype custom_multi_classification_tasks:
         list[~azure.ai.textanalytics.v3_2_preview_2.models.TasksStateTasksCustomMultiClassificationTasksItem]
        """
        super(TasksStateTasks, self).__init__(**kwargs)
        self.completed = kwargs['completed']
        self.failed = kwargs['failed']
        self.in_progress = kwargs['in_progress']
        self.total = kwargs['total']
        self.entity_recognition_tasks = kwargs.get('entity_recognition_tasks', None)
        self.entity_recognition_pii_tasks = kwargs.get('entity_recognition_pii_tasks', None)
        self.key_phrase_extraction_tasks = kwargs.get('key_phrase_extraction_tasks', None)
        self.entity_linking_tasks = kwargs.get('entity_linking_tasks', None)
        self.sentiment_analysis_tasks = kwargs.get('sentiment_analysis_tasks', None)
        self.extractive_summarization_tasks = kwargs.get('extractive_summarization_tasks', None)
        self.custom_entity_recognition_tasks = kwargs.get('custom_entity_recognition_tasks', None)
        self.custom_single_classification_tasks = kwargs.get('custom_single_classification_tasks', None)
        self.custom_multi_classification_tasks = kwargs.get('custom_multi_classification_tasks', None)


class TaskState(msrest.serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TaskState, self).__init__(**kwargs)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksCustomEntityRecognitionTasksItem(TaskState, CustomEntitiesTaskResult):
    """TasksStateTasksCustomEntityRecognitionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomEntitiesResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomEntitiesResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksCustomEntityRecognitionTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksCustomMultiClassificationTasksItem(TaskState, CustomMultiClassificationTaskResult):
    """TasksStateTasksCustomMultiClassificationTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomMultiClassificationResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomMultiClassificationResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksCustomMultiClassificationTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksCustomSingleClassificationTasksItem(TaskState, CustomSingleClassificationTaskResult):
    """TasksStateTasksCustomSingleClassificationTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results:
     ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'CustomSingleClassificationResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results:
         ~azure.ai.textanalytics.v3_2_preview_2.models.CustomSingleClassificationResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksCustomSingleClassificationTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityLinkingTasksItem(TaskState, EntityLinkingTaskResult):
    """TasksStateTasksEntityLinkingTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntityLinkingResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksEntityLinkingTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityRecognitionPiiTasksItem(TaskState, PiiTaskResult):
    """TasksStateTasksEntityRecognitionPiiTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.PiiResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksEntityRecognitionPiiTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksEntityRecognitionTasksItem(TaskState, EntitiesTaskResult):
    """TasksStateTasksEntityRecognitionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.EntitiesResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksEntityRecognitionTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksExtractiveSummarizationTasksItem(TaskState, ExtractiveSummarizationTaskResult):
    """TasksStateTasksExtractiveSummarizationTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'ExtractiveSummarizationResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.ExtractiveSummarizationResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksExtractiveSummarizationTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksKeyPhraseExtractionTasksItem(TaskState, KeyPhraseTaskResult):
    """TasksStateTasksKeyPhraseExtractionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhraseResult
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.KeyPhraseResult
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksKeyPhraseExtractionTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TasksStateTasksSentimentAnalysisTasksItem(TaskState, SentimentTaskResult):
    """TasksStateTasksSentimentAnalysisTasksItem.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentResponse
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar task_name: Required.
    :vartype task_name: str
    :ivar status: Required. Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'task_name': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'SentimentResponse'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword results:
        :paramtype results: ~azure.ai.textanalytics.v3_2_preview_2.models.SentimentResponse
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword task_name: Required.
        :paramtype task_name: str
        :keyword status: Required. Possible values include: "notStarted", "running", "succeeded",
         "failed", "rejected", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v3_2_preview_2.models.State
        """
        super(TasksStateTasksSentimentAnalysisTasksItem, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)
        self.last_update_date_time = kwargs['last_update_date_time']
        self.task_name = kwargs['task_name']
        self.status = kwargs['status']


class TextAnalyticsError(msrest.serialization.Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Possible values include: "InvalidRequest", "InvalidArgument",
     "InternalServerError", "ServiceUnavailable", "NotFound".
    :vartype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.ErrorCodeValue
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_2_preview_2.models.InnerError
    :ivar details: Details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'details': {'key': 'details', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Possible values include: "InvalidRequest",
         "InvalidArgument", "InternalServerError", "ServiceUnavailable", "NotFound".
        :paramtype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.ErrorCodeValue
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_2_preview_2.models.InnerError
        :keyword details: Details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.textanalytics.v3_2_preview_2.models.TextAnalyticsError]
        """
        super(TextAnalyticsError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.innererror = kwargs.get('innererror', None)
        self.details = kwargs.get('details', None)


class TextAnalyticsWarning(msrest.serialization.Model):
    """TextAnalyticsWarning.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Possible values include: "LongWordsInDocument",
     "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.WarningCodeValue
    :ivar message: Required. Warning message.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target_ref': {'key': 'targetRef', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Possible values include: "LongWordsInDocument",
         "DocumentTruncated".
        :paramtype code: str or ~azure.ai.textanalytics.v3_2_preview_2.models.WarningCodeValue
        :keyword message: Required. Warning message.
        :paramtype message: str
        :keyword target_ref: A JSON pointer reference indicating the target object.
        :paramtype target_ref: str
        """
        super(TextAnalyticsWarning, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target_ref = kwargs.get('target_ref', None)
