# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DataSetKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Kind of data set.
    """

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    ADLS_GEN1_FOLDER = "AdlsGen1Folder"
    ADLS_GEN1_FILE = "AdlsGen1File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"

class DataSetMappingKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Kind of data set mapping.
    """

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"

class DataSetMappingStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the status of the data set mapping.
    """

    OK = "Ok"
    BROKEN = "Broken"

class DataSetType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of data set
    """

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    ADLS_GEN1_FOLDER = "AdlsGen1Folder"
    ADLS_GEN1_FILE = "AdlsGen1File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"

class InvitationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the invitation.
    """

    PENDING = "Pending"
    ACCEPTED = "Accepted"
    REJECTED = "Rejected"
    WITHDRAWN = "Withdrawn"

class LastModifiedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that last modified the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class OutputType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of output file
    """

    CSV = "Csv"
    PARQUET = "Parquet"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the data set mapping.
    """

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    MOVING = "Moving"
    FAILED = "Failed"

class RecurrenceInterval(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Recurrence Interval
    """

    HOUR = "Hour"
    DAY = "Day"

class ShareKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Share kind.
    """

    COPY_BASED = "CopyBased"
    IN_PLACE = "InPlace"

class ShareSubscriptionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the status of share subscription
    """

    ACTIVE = "Active"
    REVOKED = "Revoked"
    SOURCE_DELETED = "SourceDeleted"
    REVOKING = "Revoking"

class SourceShareSynchronizationSettingKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Kind of synchronization setting on share.
    """

    SCHEDULE_BASED = "ScheduleBased"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation state of the long running operation.
    """

    ACCEPTED = "Accepted"
    IN_PROGRESS = "InProgress"
    TRANSIENT_FAILURE = "TransientFailure"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class SynchronizationMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Synchronization mode
    """

    INCREMENTAL = "Incremental"
    FULL_SYNC = "FullSync"

class SynchronizationSettingKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Kind of synchronization setting.
    """

    SCHEDULE_BASED = "ScheduleBased"

class TriggerKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Kind of synchronization on trigger.
    """

    SCHEDULE_BASED = "ScheduleBased"

class TriggerStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the trigger state
    """

    ACTIVE = "Active"
    INACTIVE = "Inactive"
    SOURCE_SYNCHRONIZATION_SETTING_DELETED = "SourceSynchronizationSettingDeleted"

class Type(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Identity Type
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
