# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._container_registry_management_client_enums import *


class BaseImageDependency(msrest.serialization.Model):
    """Properties that describe a base image dependency.

    :param type: The type of the base image dependency. Possible values include: "BuildTime",
     "RunTime".
    :type type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageDependencyType
    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "BaseImageDependencyType"]] = None,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs
    ):
        super(BaseImageDependency, self).__init__(**kwargs)
        self.type = type
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Build(ProxyResource):
    """Build resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param build_id: The unique identifier for the build.
    :type build_id: str
    :param status: The current status of the build. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
    :param last_updated_time: The last updated time for the build.
    :type last_updated_time: ~datetime.datetime
    :param build_type: The type of build. Possible values include: "AutoBuild", "QuickBuild".
    :type build_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
    :param create_time: The time the build was created.
    :type create_time: ~datetime.datetime
    :param start_time: The time the build started.
    :type start_time: ~datetime.datetime
    :param finish_time: The time the build finished.
    :type finish_time: ~datetime.datetime
    :param output_images: The list of all images that were generated from the build.
    :type output_images:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
    :param build_task: The build task with which the build was started.
    :type build_task: str
    :param image_update_trigger: The image update trigger that caused the build.
    :type image_update_trigger:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageUpdateTrigger
    :param git_commit_trigger: The git commit trigger that caused the build.
    :type git_commit_trigger:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.GitCommitTrigger
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    :param platform: The platform properties against which the build will happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :param provisioning_state: The provisioning state of a build. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :type provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'build_id': {'key': 'properties.buildId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'build_type': {'key': 'properties.buildType', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'properties.finishTime', 'type': 'iso-8601'},
        'output_images': {'key': 'properties.outputImages', 'type': '[ImageDescriptor]'},
        'build_task': {'key': 'properties.buildTask', 'type': 'str'},
        'image_update_trigger': {'key': 'properties.imageUpdateTrigger', 'type': 'ImageUpdateTrigger'},
        'git_commit_trigger': {'key': 'properties.gitCommitTrigger', 'type': 'GitCommitTrigger'},
        'is_archive_enabled': {'key': 'properties.isArchiveEnabled', 'type': 'bool'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        build_id: Optional[str] = None,
        status: Optional[Union[str, "BuildStatus"]] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        build_type: Optional[Union[str, "BuildType"]] = None,
        create_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_images: Optional[List["ImageDescriptor"]] = None,
        build_task: Optional[str] = None,
        image_update_trigger: Optional["ImageUpdateTrigger"] = None,
        git_commit_trigger: Optional["GitCommitTrigger"] = None,
        is_archive_enabled: Optional[bool] = False,
        platform: Optional["PlatformProperties"] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        **kwargs
    ):
        super(Build, self).__init__(**kwargs)
        self.build_id = build_id
        self.status = status
        self.last_updated_time = last_updated_time
        self.build_type = build_type
        self.create_time = create_time
        self.start_time = start_time
        self.finish_time = finish_time
        self.output_images = output_images
        self.build_task = build_task
        self.image_update_trigger = image_update_trigger
        self.git_commit_trigger = git_commit_trigger
        self.is_archive_enabled = is_archive_enabled
        self.platform = platform
        self.provisioning_state = provisioning_state


class BuildArgument(msrest.serialization.Model):
    """Properties of a build argument.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the argument. Possible values include:
     "DockerBuildArgument".
    :type type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgumentType
    :param name: Required. The name of the argument.
    :type name: str
    :param value: Required. The value of the argument.
    :type value: str
    :param is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :type is_secret: bool
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "BuildArgumentType"],
        name: str,
        value: str,
        is_secret: Optional[bool] = False,
        **kwargs
    ):
        super(BuildArgument, self).__init__(**kwargs)
        self.type = type
        self.name = name
        self.value = value
        self.is_secret = is_secret


class BuildArgumentList(msrest.serialization.Model):
    """The list of build arguments for a build step.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BuildArgument]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BuildArgument"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BuildArgumentList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildFilter(msrest.serialization.Model):
    """Properties that are enabled for Odata querying.

    :param build_id: The unique identifier for the build.
    :type build_id: str
    :param build_type: The type of build. Possible values include: "AutoBuild", "QuickBuild".
    :type build_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
    :param status: The current status of the build. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
    :param create_time: The create time for a build.
    :type create_time: ~datetime.datetime
    :param finish_time: The time the build finished.
    :type finish_time: ~datetime.datetime
    :param output_image_manifests: The list of comma-separated image manifests that were generated
     from the build.
    :type output_image_manifests: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    :param build_task_name: The name of the build task that the build corresponds to.
    :type build_task_name: str
    """

    _attribute_map = {
        'build_id': {'key': 'buildId', 'type': 'str'},
        'build_type': {'key': 'buildType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'output_image_manifests': {'key': 'outputImageManifests', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'build_task_name': {'key': 'buildTaskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        build_id: Optional[str] = None,
        build_type: Optional[Union[str, "BuildType"]] = None,
        status: Optional[Union[str, "BuildStatus"]] = None,
        create_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_image_manifests: Optional[str] = None,
        is_archive_enabled: Optional[bool] = None,
        build_task_name: Optional[str] = None,
        **kwargs
    ):
        super(BuildFilter, self).__init__(**kwargs)
        self.build_id = build_id
        self.build_type = build_type
        self.status = status
        self.create_time = create_time
        self.finish_time = finish_time
        self.output_image_manifests = output_image_manifests
        self.is_archive_enabled = is_archive_enabled
        self.build_task_name = build_task_name


class BuildGetLogResult(msrest.serialization.Model):
    """The result of get log link operation.

    :param log_link: The link to logs for a azure container registry build.
    :type log_link: str
    """

    _attribute_map = {
        'log_link': {'key': 'logLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        log_link: Optional[str] = None,
        **kwargs
    ):
        super(BuildGetLogResult, self).__init__(**kwargs)
        self.log_link = log_link


class BuildListResult(msrest.serialization.Model):
    """Collection of builds.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.Build]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Build]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Build"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BuildListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildStep(ProxyResource):
    """Build step resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: The properties of a build step.
    :type properties: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BuildStepProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["BuildStepProperties"] = None,
        **kwargs
    ):
        super(BuildStep, self).__init__(**kwargs)
        self.properties = properties


class BuildStepList(msrest.serialization.Model):
    """The collection of build items.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStep]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BuildStep]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BuildStep"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BuildStepList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildStepProperties(msrest.serialization.Model):
    """Base properties for any build step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStep.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the build step. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStep'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BuildStepProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.type = None  # type: Optional[str]


class BuildStepPropertiesUpdateParameters(msrest.serialization.Model):
    """The properties for updating a build step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStepUpdateParameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStepUpdateParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BuildStepPropertiesUpdateParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class BuildStepUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a build step.

    :param properties: The properties for updating a build step.
    :type properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepPropertiesUpdateParameters
    :param tags: A set of tags. The ARM resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'BuildStepPropertiesUpdateParameters'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: Optional["BuildStepPropertiesUpdateParameters"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(BuildStepUpdateParameters, self).__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class BuildTask(Resource):
    """The build task that has the resource properties and all build items. The build task will have all information to schedule a build against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the build task. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar creation_date: The creation date of build task.
    :vartype creation_date: ~datetime.datetime
    :param alias: The alternative updatable name for a build task.
    :type alias: str
    :param status: The current status of build task. Possible values include: "Disabled",
     "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
    :param source_repository: The properties that describes the source(code) for the build task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryProperties
    :param platform: The platform properties against which the build has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :param timeout: Build timeout in seconds.
    :type timeout: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_date': {'readonly': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'source_repository': {'key': 'properties.sourceRepository', 'type': 'SourceRepositoryProperties'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        alias: Optional[str] = None,
        status: Optional[Union[str, "BuildTaskStatus"]] = None,
        source_repository: Optional["SourceRepositoryProperties"] = None,
        platform: Optional["PlatformProperties"] = None,
        timeout: Optional[int] = 3600,
        **kwargs
    ):
        super(BuildTask, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.creation_date = None
        self.alias = alias
        self.status = status
        self.source_repository = source_repository
        self.platform = platform
        self.timeout = timeout


class QueueBuildRequest(msrest.serialization.Model):
    """The queue build request parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BuildTaskBuildRequest, QuickBuildRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the build request.Constant filled by server.
    :vartype type: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BuildTask': 'BuildTaskBuildRequest', 'QuickBuild': 'QuickBuildRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueBuildRequest, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class BuildTaskBuildRequest(QueueBuildRequest):
    """The queue build parameters based on a build task.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the build request.Constant filled by server.
    :vartype type: str
    :param build_task_name: Required. The name of build task against which build has to be queued.
    :type build_task_name: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'build_task_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'build_task_name': {'key': 'buildTaskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        build_task_name: str,
        **kwargs
    ):
        super(BuildTaskBuildRequest, self).__init__(**kwargs)
        self.type = 'BuildTask'  # type: str
        self.build_task_name = build_task_name


class BuildTaskFilter(msrest.serialization.Model):
    """The filter that can be used for listing build tasks.

    :param alias: The alternative name for build task.
    :type alias: str
    """

    _attribute_map = {
        'alias': {'key': 'alias', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alias: Optional[str] = None,
        **kwargs
    ):
        super(BuildTaskFilter, self).__init__(**kwargs)
        self.alias = alias


class BuildTaskListResult(msrest.serialization.Model):
    """The collection of build tasks.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTask]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BuildTask]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BuildTask"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BuildTaskListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildTaskUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a build task.

    :param tags: A set of tags. The ARM resource tags.
    :type tags: dict[str, str]
    :param alias: The alternative updatable name for a build task.
    :type alias: str
    :param status: The current status of build task. Possible values include: "Disabled",
     "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
    :param platform: The platform properties against which the build has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :param timeout: Build timeout in seconds.
    :type timeout: int
    :param source_repository: The properties that describes the source(code) for the build task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryUpdateParameters
    """

    _validation = {
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'source_repository': {'key': 'properties.sourceRepository', 'type': 'SourceRepositoryUpdateParameters'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        alias: Optional[str] = None,
        status: Optional[Union[str, "BuildTaskStatus"]] = None,
        platform: Optional["PlatformProperties"] = None,
        timeout: Optional[int] = None,
        source_repository: Optional["SourceRepositoryUpdateParameters"] = None,
        **kwargs
    ):
        super(BuildTaskUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.alias = alias
        self.status = status
        self.platform = platform
        self.timeout = timeout
        self.source_repository = source_repository


class BuildUpdateParameters(msrest.serialization.Model):
    """The set of build properties that can be updated.

    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    """

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_archive_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(BuildUpdateParameters, self).__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled


class DockerBuildStep(BuildStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the build step. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    :param branch: The repository branch name.
    :type branch: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: The Docker file path relative to the source control root.
    :type docker_file_path: str
    :param context_path: The relative context path for a docker build in the source.
    :type context_path: str
    :param build_arguments: The custom arguments for building this build step.
    :type build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageDependency]
    :param base_image_trigger: The type of the auto trigger for base image dependency updates.
     Possible values include: "All", "Runtime", "None".
    :type base_image_trigger: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'required': True, 'readonly': True},
        'base_image_dependencies': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'build_arguments': {'key': 'buildArguments', 'type': '[BuildArgument]'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = True,
        no_cache: Optional[bool] = False,
        docker_file_path: Optional[str] = None,
        context_path: Optional[str] = None,
        build_arguments: Optional[List["BuildArgument"]] = None,
        base_image_trigger: Optional[Union[str, "BaseImageTriggerType"]] = None,
        **kwargs
    ):
        super(DockerBuildStep, self).__init__(**kwargs)
        self.type = 'Docker'  # type: str
        self.branch = branch
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.context_path = context_path
        self.build_arguments = build_arguments
        self.base_image_dependencies = None
        self.base_image_trigger = base_image_trigger


class DockerBuildStepUpdateParameters(BuildStepPropertiesUpdateParameters):
    """The properties for updating a docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    :param branch: The repository branch name.
    :type branch: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: The Docker file path relative to the source control root.
    :type docker_file_path: str
    :param context_path: The relative context path for a docker build in the source.
    :type context_path: str
    :param build_arguments: The custom arguments for building this build step.
    :type build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :param base_image_trigger: The type of the auto trigger for base image dependency updates.
     Possible values include: "All", "Runtime", "None".
    :type base_image_trigger: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'build_arguments': {'key': 'buildArguments', 'type': '[BuildArgument]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        docker_file_path: Optional[str] = None,
        context_path: Optional[str] = None,
        build_arguments: Optional[List["BuildArgument"]] = None,
        base_image_trigger: Optional[Union[str, "BaseImageTriggerType"]] = None,
        **kwargs
    ):
        super(DockerBuildStepUpdateParameters, self).__init__(**kwargs)
        self.type = 'Docker'  # type: str
        self.branch = branch
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.context_path = context_path
        self.build_arguments = build_arguments
        self.base_image_trigger = base_image_trigger


class GitCommitTrigger(msrest.serialization.Model):
    """The git commit trigger that caused a build.

    :param id: The unique ID of the trigger.
    :type id: str
    :param commit_id: The unique ID that identifies a commit.
    :type commit_id: str
    :param repository_url: The repository URL.
    :type repository_url: str
    :param branch_name: The branch name in the repository.
    :type branch_name: str
    :param provider_type: The source control provider type.
    :type provider_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'provider_type': {'key': 'providerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        commit_id: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch_name: Optional[str] = None,
        provider_type: Optional[str] = None,
        **kwargs
    ):
        super(GitCommitTrigger, self).__init__(**kwargs)
        self.id = id
        self.commit_id = commit_id
        self.repository_url = repository_url
        self.branch_name = branch_name
        self.provider_type = provider_type


class ImageDescriptor(msrest.serialization.Model):
    """Properties for a registry image.

    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs
    ):
        super(ImageDescriptor, self).__init__(**kwargs)
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ImageUpdateTrigger(msrest.serialization.Model):
    """The image update trigger that caused a build.

    :param id: The unique ID of the trigger.
    :type id: str
    :param timestamp: The timestamp when the image update happened.
    :type timestamp: ~datetime.datetime
    :param images: The list of image updates that caused the build.
    :type images: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'images': {'key': 'images', 'type': '[ImageDescriptor]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        images: Optional[List["ImageDescriptor"]] = None,
        **kwargs
    ):
        super(ImageUpdateTrigger, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.images = images


class PlatformProperties(msrest.serialization.Model):
    """The platform properties against which the build has to happen.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The operating system type required for the build. Possible values
     include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.OsType
    :param cpu: The CPU configuration in terms of number of cores required for the build.
    :type cpu: int
    """

    _validation = {
        'os_type': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "OsType"],
        cpu: Optional[int] = None,
        **kwargs
    ):
        super(PlatformProperties, self).__init__(**kwargs)
        self.os_type = os_type
        self.cpu = cpu


class QuickBuildRequest(QueueBuildRequest):
    """The queue build request parameters for a quick build.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the build request.Constant filled by server.
    :vartype type: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param source_location: Required. The URL(absolute or relative) of the source that needs to be
     built. For Docker build, it can be an URL to a tar or github repository as supported by Docker.
     If it is relative URL, the relative path should be obtained from calling getSourceUploadUrl
     API.
    :type source_location: str
    :param build_arguments: The collection of build arguments to be used.
    :type build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param timeout: Build timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the build will happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :param docker_file_path: Required. The Docker file path relative to the source location.
    :type docker_file_path: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'source_location': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
        'docker_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'build_arguments': {'key': 'buildArguments', 'type': '[BuildArgument]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_location: str,
        platform: "PlatformProperties",
        docker_file_path: str,
        image_names: Optional[List[str]] = None,
        build_arguments: Optional[List["BuildArgument"]] = None,
        is_push_enabled: Optional[bool] = True,
        no_cache: Optional[bool] = False,
        timeout: Optional[int] = 3600,
        **kwargs
    ):
        super(QuickBuildRequest, self).__init__(**kwargs)
        self.type = 'QuickBuild'  # type: str
        self.image_names = image_names
        self.source_location = source_location
        self.build_arguments = build_arguments
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.timeout = timeout
        self.platform = platform
        self.docker_file_path = docker_file_path


class SourceControlAuthInfo(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param token_type: The type of Auth token. Possible values include: "PAT", "OAuth".
    :type token_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.TokenType
    :param token: Required. The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid.
    :type expires_in: int
    """

    _validation = {
        'token': {'required': True},
    }

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        token: str,
        token_type: Optional[Union[str, "TokenType"]] = None,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs
    ):
        super(SourceControlAuthInfo, self).__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class SourceRepositoryProperties(msrest.serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param source_control_type: Required. The type of source control service. Possible values
     include: "Github", "VisualStudioTeamService".
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlType
    :param repository_url: Required. The full URL to the source code repository.
    :type repository_url: str
    :param is_commit_trigger_enabled: The value of this property indicates whether the source
     control commit trigger is enabled or not.
    :type is_commit_trigger_enabled: bool
    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'is_commit_trigger_enabled': {'key': 'isCommitTriggerEnabled', 'type': 'bool'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'SourceControlAuthInfo'},
    }

    def __init__(
        self,
        *,
        source_control_type: Union[str, "SourceControlType"],
        repository_url: str,
        is_commit_trigger_enabled: Optional[bool] = False,
        source_control_auth_properties: Optional["SourceControlAuthInfo"] = None,
        **kwargs
    ):
        super(SourceRepositoryProperties, self).__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.is_commit_trigger_enabled = is_commit_trigger_enabled
        self.source_control_auth_properties = source_control_auth_properties


class SourceRepositoryUpdateParameters(msrest.serialization.Model):
    """The properties for updating the source code repository configuration.

    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
    :param is_commit_trigger_enabled: The value of this property indicates whether the source
     control commit trigger is enabled or not.
    :type is_commit_trigger_enabled: bool
    """

    _attribute_map = {
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'SourceControlAuthInfo'},
        'is_commit_trigger_enabled': {'key': 'isCommitTriggerEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source_control_auth_properties: Optional["SourceControlAuthInfo"] = None,
        is_commit_trigger_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(SourceRepositoryUpdateParameters, self).__init__(**kwargs)
        self.source_control_auth_properties = source_control_auth_properties
        self.is_commit_trigger_enabled = is_commit_trigger_enabled


class SourceUploadDefinition(msrest.serialization.Model):
    """The properties of a response to source upload request.

    :param upload_url: The URL where the client can upload the source.
    :type upload_url: str
    :param relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :type relative_path: str
    """

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        upload_url: Optional[str] = None,
        relative_path: Optional[str] = None,
        **kwargs
    ):
        super(SourceUploadDefinition, self).__init__(**kwargs)
        self.upload_url = upload_url
        self.relative_path = relative_path
