# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnswersFromTextOptions(msrest.serialization.Model):
    """The question and text record parameters to answer.

    All required parameters must be populated in order to send to Azure.

    :ivar question: Required. User question to query against the given text records.
    :vartype question: str
    :ivar text_documents: Required. Text records to be searched for given question.
    :vartype text_documents: list[str or ~azure.ai.language.questionanswering.models.TextDocument]
    :ivar language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        "question": {"required": True},
        "text_documents": {"required": True},
    }

    _attribute_map = {
        "question": {"key": "question", "type": "str"},
        "text_documents": {"key": "records", "type": "[TextDocument]"},
        "language": {"key": "language", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword question: Required. User question to query against the given text records.
        :paramtype question: str
        :keyword text_documents: Required. Text records to be searched for given question.
        :paramtype text_documents: list[str or ~azure.ai.language.questionanswering.models.TextDocument]
        :keyword language: Language of the text records. This is BCP-47 representation of a language.
         For example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super(AnswersFromTextOptions, self).__init__(**kwargs)
        self.question = kwargs["question"]
        self.text_documents = kwargs["text_documents"]
        self.language = kwargs.get("language", None)
        self.string_index_type = "UnicodeCodePoint"


class AnswersFromTextResult(msrest.serialization.Model):
    """Represents the answer results.

    :ivar answers: Represents the answer results.
    :vartype answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[TextAnswer]"},
    }

    def __init__(self, **kwargs):
        """
        :keyword answers: Represents the answer results.
        :paramtype answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
        """
        super(AnswersFromTextResult, self).__init__(**kwargs)
        self.answers = kwargs.get("answers", None)


class AnswersOptions(msrest.serialization.Model):
    """Parameters to query a knowledge base.

    :ivar qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :vartype qna_id: int
    :ivar question: User question to query against the knowledge base.
    :vartype question: str
    :ivar top: Max number of answers to be returned for the question.
    :vartype top: int
    :ivar user_id: Unique identifier for the user.
    :vartype user_id: str
    :ivar confidence_threshold: Minimum threshold score for answers, value ranges from 0 to 1.
    :vartype confidence_threshold: float
    :ivar answer_context: Context object with previous QnA's information.
    :vartype answer_context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerContext
    :ivar ranker_kind: Type of ranker to be used. Possible
     values include: "Default", "QuestionOnly".
    :vartype ranker_kind: str
    :ivar filters: Filter QnAs based on given metadata list and knowledge base sources.
    :vartype filters: ~azure.ai.language.questionanswering.models.QueryFilters
    :ivar short_answer_options: To configure Answer span prediction feature.
    :vartype short_answer_options: ~azure.ai.language.questionanswering.models.ShortAnswerOptions
    :ivar include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :vartype include_unstructured_sources: bool
    """

    _validation = {
        "confidence_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "qna_id": {"key": "qnaId", "type": "int"},
        "question": {"key": "question", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "user_id": {"key": "userId", "type": "str"},
        "confidence_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "answer_context": {"key": "context", "type": "KnowledgeBaseAnswerContext"},
        "ranker_kind": {"key": "rankerType", "type": "str"},
        "filters": {"key": "filters", "type": "QueryFilters"},
        "short_answer_options": {"key": "answerSpanRequest", "type": "ShortAnswerOptions"},
        "include_unstructured_sources": {"key": "includeUnstructuredSources", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """
        :keyword qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
         question.
        :paramtype qna_id: int
        :keyword question: User question to query against the knowledge base.
        :paramtype question: str
        :keyword top: Max number of answers to be returned for the question.
        :paramtype top: int
        :keyword user_id: Unique identifier for the user.
        :paramtype user_id: str
        :keyword confidence_threshold: Minimum threshold score for answers, value ranges from 0 to 1.
        :paramtype confidence_threshold: float
        :keyword answer_context: Context object with previous QnA's information.
        :paramtype answer_context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerContext
        :keyword ranker_kind: Type of ranker to be used. Possible
         values include: "Default", "QuestionOnly".
        :paramtype ranker_kind: str
        :keyword filters: Filter QnAs based on given metadata list and knowledge base sources.
        :paramtype filters: ~azure.ai.language.questionanswering.models.QueryFilters
        :keyword short_answer_options: To configure Answer span prediction feature.
        :paramtype short_answer_options: ~azure.ai.language.questionanswering.models.ShortAnswerOptions
        :keyword include_unstructured_sources: (Optional) Flag to enable Query over Unstructured
         Sources.
        :paramtype include_unstructured_sources: bool
        """
        super(AnswersOptions, self).__init__(**kwargs)
        self.qna_id = kwargs.get("qna_id", None)
        self.question = kwargs.get("question", None)
        self.top = kwargs.get("top", None)
        self.user_id = kwargs.get("user_id", None)
        self.confidence_threshold = kwargs.get("confidence_threshold", None)
        self.answer_context = kwargs.get("answer_context", None)
        self.ranker_kind = kwargs.get("ranker_kind", None)
        self.filters = kwargs.get("filters", None)
        self.short_answer_options = kwargs.get("short_answer_options", None)
        self.include_unstructured_sources = kwargs.get("include_unstructured_sources", None)


class AnswerSpan(msrest.serialization.Model):
    """Answer span object of QnA.

    :ivar text: Predicted text of answer span.
    :vartype text: str
    :ivar confidence: Predicted score of answer span, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar offset: The answer span offset from the start of answer.
    :vartype offset: int
    :ivar length: The length of the answer span.
    :vartype length: int
    """

    _validation = {
        "confidence": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "confidence": {"key": "confidenceScore", "type": "float"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(self, **kwargs):
        """
        :keyword text: Predicted text of answer span.
        :paramtype text: str
        :keyword confidence: Predicted score of answer span, value ranges from 0 to 1.
        :paramtype confidence: float
        :keyword offset: The answer span offset from the start of answer.
        :paramtype offset: int
        :keyword length: The length of the answer span.
        :paramtype length: int
        """
        super(AnswerSpan, self).__init__(**kwargs)
        self.text = kwargs.get("text", None)
        self.confidence = kwargs.get("confidence", None)
        self.offset = kwargs.get("offset", None)
        self.length = kwargs.get("length", None)


class AnswersResult(msrest.serialization.Model):
    """Represents List of Question Answers.

    :ivar answers: Represents Answer Result list.
    :vartype answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[KnowledgeBaseAnswer]"},
    }

    def __init__(self, **kwargs):
        """
        :keyword answers: Represents Answer Result list.
        :paramtype answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
        """
        super(AnswersResult, self).__init__(**kwargs)
        self.answers = kwargs.get("answers", None)


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable".
    :vartype code: str or ~azure.ai.language.questionanswering.models.ErrorCode
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.questionanswering.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(self, **kwargs):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
         "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
         "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
         "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable".
        :paramtype code: str or ~azure.ai.language.questionanswering.models.ErrorCode
        :keyword message: Required. A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.language.questionanswering.models.Error]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
        """
        super(Error, self).__init__(**kwargs)
        self.code = kwargs["code"]
        self.message = kwargs["message"]
        self.target = kwargs.get("target", None)
        self.details = kwargs.get("details", None)
        self.innererror = kwargs.get("innererror", None)


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.ai.language.questionanswering.models.Error
    """

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.ai.language.questionanswering.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get("error", None)


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
    :vartype code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(self, **kwargs):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
         "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
        :paramtype code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
        """
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = kwargs["code"]
        self.message = kwargs["message"]
        self.details = kwargs.get("details", None)
        self.target = kwargs.get("target", None)
        self.innererror = kwargs.get("innererror", None)


class KnowledgeBaseAnswer(msrest.serialization.Model):
    """Represents knowledge base answer.

    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar confidence: Answer confidence score, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar qna_id: ID of the QnA result.
    :vartype qna_id: int
    :ivar source: Source of QnA result.
    :vartype source: str
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Dialog associated with Answer.
    :vartype dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
    :ivar short_answer: Answer span object of QnA with respect to user's question.
    :vartype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
    """

    _validation = {
        "confidence": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "questions": {"key": "questions", "type": "[str]"},
        "answer": {"key": "answer", "type": "str"},
        "confidence": {"key": "confidenceScore", "type": "float"},
        "qna_id": {"key": "id", "type": "int"},
        "source": {"key": "source", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "dialog": {"key": "dialog", "type": "KnowledgeBaseAnswerDialog"},
        "short_answer": {"key": "answerSpan", "type": "AnswerSpan"},
    }

    def __init__(self, **kwargs):
        """
        :keyword questions: List of questions associated with the answer.
        :paramtype questions: list[str]
        :keyword answer: Answer text.
        :paramtype answer: str
        :keyword confidence: Answer confidence score, value ranges from 0 to 1.
        :paramtype confidence: float
        :keyword qna_id: ID of the QnA result.
        :paramtype qna_id: int
        :keyword source: Source of QnA result.
        :paramtype source: str
        :keyword metadata: Metadata associated with the answer, useful to categorize or filter question
         answers.
        :paramtype metadata: dict[str, str]
        :keyword dialog: Dialog associated with Answer.
        :paramtype dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
        :keyword short_answer: Answer span object of QnA with respect to user's question.
        :paramtype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
        """
        super(KnowledgeBaseAnswer, self).__init__(**kwargs)
        self.questions = kwargs.get("questions", None)
        self.answer = kwargs.get("answer", None)
        self.confidence = kwargs.get("confidence", None)
        self.qna_id = kwargs.get("qna_id", None)
        self.source = kwargs.get("source", None)
        self.metadata = kwargs.get("metadata", None)
        self.dialog = kwargs.get("dialog", None)
        self.short_answer = kwargs.get("short_answer", None)


class KnowledgeBaseAnswerContext(msrest.serialization.Model):
    """Context object with previous QnA's information.

    All required parameters must be populated in order to send to Azure.

    :ivar previous_qna_id: Required. Previous turn top answer result QnA ID.
    :vartype previous_qna_id: int
    :ivar previous_question: Previous user query.
    :vartype previous_question: str
    """

    _validation = {
        "previous_qna_id": {"required": True},
    }

    _attribute_map = {
        "previous_qna_id": {"key": "previousQnaId", "type": "int"},
        "previous_question": {"key": "previousUserQuery", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword previous_qna_id: Required. Previous turn top answer result QnA ID.
        :paramtype previous_qna_id: int
        :keyword previous_question: Previous user query.
        :paramtype previous_question: str
        """
        super(KnowledgeBaseAnswerContext, self).__init__(**kwargs)
        self.previous_qna_id = kwargs["previous_qna_id"]
        self.previous_question = kwargs.get("previous_question", None)


class KnowledgeBaseAnswerDialog(msrest.serialization.Model):
    """Dialog associated with Answer.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :vartype is_context_only: bool
    :ivar prompts: List of prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
    """

    _validation = {
        "prompts": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "is_context_only": {"key": "isContextOnly", "type": "bool"},
        "prompts": {"key": "prompts", "type": "[KnowledgeBaseAnswerPrompt]"},
    }

    def __init__(self, **kwargs):
        """
        :keyword is_context_only: To mark if a prompt is relevant only with a previous question or not.
         If true, do not include this QnA as search result for queries without context; otherwise, if
         false, ignores context and includes this QnA in search result.
        :paramtype is_context_only: bool
        :keyword prompts: List of prompts associated with the answer.
        :paramtype prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
        """
        super(KnowledgeBaseAnswerDialog, self).__init__(**kwargs)
        self.is_context_only = kwargs.get("is_context_only", None)
        self.prompts = kwargs.get("prompts", None)


class KnowledgeBaseAnswerPrompt(msrest.serialization.Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt - used in ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: QnA ID corresponding to the prompt.
    :vartype qna_id: int
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    _validation = {
        "display_text": {"max_length": 200, "min_length": 0},
    }

    _attribute_map = {
        "display_order": {"key": "displayOrder", "type": "int"},
        "qna_id": {"key": "qnaId", "type": "int"},
        "display_text": {"key": "displayText", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword display_order: Index of the prompt - used in ordering of the prompts.
        :paramtype display_order: int
        :keyword qna_id: QnA ID corresponding to the prompt.
        :paramtype qna_id: int
        :keyword display_text: Text displayed to represent a follow up question prompt.
        :paramtype display_text: str
        """
        super(KnowledgeBaseAnswerPrompt, self).__init__(**kwargs)
        self.display_order = kwargs.get("display_order", None)
        self.qna_id = kwargs.get("qna_id", None)
        self.display_text = kwargs.get("display_text", None)


class MetadataFilter(msrest.serialization.Model):
    """Find QnAs that are associated with the given list of metadata.

    :ivar metadata:
    :vartype metadata: list[tuple[str, str]]
    :ivar logical_operation: Operation used to join metadata filters. Possible values include:
     "AND", "OR".
    :vartype logical_operation: str
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "[object]"},
        "logical_operation": {"key": "logicalOperation", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword metadata:
        :paramtype metadata: list[tuple[str, str]]
        :keyword logical_operation: Operation used to join metadata filters. Possible values include:
         "AND", "OR".
        :paramtype logical_operation: str
        """
        super(MetadataFilter, self).__init__(**kwargs)
        self.metadata = kwargs.get("metadata", None)
        self.logical_operation = kwargs.get("logical_operation", None)


class QueryFilters(msrest.serialization.Model):
    """filters over knowledge base.

    :ivar metadata_filter: Find QnAs that are associated with the given list of metadata.
    :vartype metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
    :ivar source_filter: Find QnAs that are associated with any of the given list of sources in
     knowledge base.
    :vartype source_filter: list[str]
    :ivar logical_operation: Logical operation used to join metadata filter with source filter.
     Possible values include: "AND", "OR".
    :vartype logical_operation: str
    """

    _attribute_map = {
        "metadata_filter": {"key": "metadataFilter", "type": "MetadataFilter"},
        "source_filter": {"key": "sourceFilter", "type": "[str]"},
        "logical_operation": {"key": "logicalOperation", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword metadata_filter: Find QnAs that are associated with the given list of metadata.
        :paramtype metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
        :keyword source_filter: Find QnAs that are associated with any of the given list of sources in
         knowledge base.
        :paramtype source_filter: list[str]
        :keyword logical_operation: Logical operation used to join metadata filter with source filter.
         Possible values include: "AND", "OR".
        :paramtype logical_operation: str
        """
        super(QueryFilters, self).__init__(**kwargs)
        self.metadata_filter = kwargs.get("metadata_filter", None)
        self.source_filter = kwargs.get("source_filter", None)
        self.logical_operation = kwargs.get("logical_operation", None)


class ShortAnswerOptions(msrest.serialization.Model):
    """To configure Answer span prediction feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enable: Enable or disable Answer Span prediction. Has constant value: True.
    :vartype enable: bool
    :ivar confidence_threshold: Minimum threshold score required to include an answer span, value
     ranges from 0 to 1.
    :vartype confidence_threshold: float
    :ivar top: Number of Top answers to be considered for span prediction from 1 to 10.
    :vartype top: int
    """

    _validation = {
        "enable": {"required": True, "constant": True},
        "confidence_threshold": {"maximum": 1, "minimum": 0},
        "top": {"maximum": 10, "minimum": 1},
    }

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "confidence_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "top": {"key": "topAnswersWithSpan", "type": "int"},
    }

    enable = True

    def __init__(self, **kwargs):
        """
        :keyword confidence_threshold: Minimum threshold score required to include an answer span,
         value ranges from 0 to 1.
        :paramtype confidence_threshold: float
        :keyword top: Number of Top answers to be considered for span prediction from 1 to 10.
        :paramtype top: int
        """
        super(ShortAnswerOptions, self).__init__(**kwargs)
        self.confidence_threshold = kwargs.get("confidence_threshold", None)
        self.top = kwargs.get("top", None)


class TextAnswer(msrest.serialization.Model):
    """Represents answer result.

    :ivar answer: Answer.
    :vartype answer: str
    :ivar confidence: answer confidence score, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar id: record ID.
    :vartype id: str
    :ivar short_answer: Answer span object with respect to user's question.
    :vartype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
    :ivar offset: The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: The length of the sentence.
    :vartype length: int
    """

    _validation = {
        "confidence": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "answer": {"key": "answer", "type": "str"},
        "confidence": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "short_answer": {"key": "answerSpan", "type": "AnswerSpan"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(self, **kwargs):
        """
        :keyword answer: Answer.
        :paramtype answer: str
        :keyword confidence: answer confidence score, value ranges from 0 to 1.
        :paramtype confidence: float
        :keyword id: record ID.
        :paramtype id: str
        :keyword short_answer: Answer span object with respect to user's question.
        :paramtype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
        :keyword offset: The sentence offset from the start of the document.
        :paramtype offset: int
        :keyword length: The length of the sentence.
        :paramtype length: int
        """
        super(TextAnswer, self).__init__(**kwargs)
        self.answer = kwargs.get("answer", None)
        self.confidence = kwargs.get("confidence", None)
        self.id = kwargs.get("id", None)
        self.short_answer = kwargs.get("short_answer", None)
        self.offset = kwargs.get("offset", None)
        self.length = kwargs.get("length", None)


class TextDocument(msrest.serialization.Model):
    """Represent input text record to be queried.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique identifier for the text record.
    :vartype id: str
    :ivar text: Required. Text contents of the record.
    :vartype text: str
    """

    _validation = {
        "id": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, **kwargs):
        """
        :keyword id: Required. Unique identifier for the text record.
        :paramtype id: str
        :keyword text: Required. Text contents of the record.
        :paramtype text: str
        """
        super(TextDocument, self).__init__(**kwargs)
        self.id = kwargs["id"]
        self.text = kwargs["text"]
