# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import StorageSyncManagementClientConfiguration
from .operations import Operations
from .operations import StorageSyncServicesOperations
from .operations import SyncGroupsOperations
from .operations import CloudEndpointsOperations
from .operations import ServerEndpointsOperations
from .operations import RegisteredServersOperations
from .operations import WorkflowsOperations
from .operations import OperationStatusOperations
from . import models


class StorageSyncManagementClient(SDKClient):
    """Microsoft Storage Sync Service API

    :ivar config: Configuration for client.
    :vartype config: StorageSyncManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.storagesync.operations.Operations
    :ivar storage_sync_services: StorageSyncServices operations
    :vartype storage_sync_services: azure.mgmt.storagesync.operations.StorageSyncServicesOperations
    :ivar sync_groups: SyncGroups operations
    :vartype sync_groups: azure.mgmt.storagesync.operations.SyncGroupsOperations
    :ivar cloud_endpoints: CloudEndpoints operations
    :vartype cloud_endpoints: azure.mgmt.storagesync.operations.CloudEndpointsOperations
    :ivar server_endpoints: ServerEndpoints operations
    :vartype server_endpoints: azure.mgmt.storagesync.operations.ServerEndpointsOperations
    :ivar registered_servers: RegisteredServers operations
    :vartype registered_servers: azure.mgmt.storagesync.operations.RegisteredServersOperations
    :ivar workflows: Workflows operations
    :vartype workflows: azure.mgmt.storagesync.operations.WorkflowsOperations
    :ivar operation_status: OperationStatus operations
    :vartype operation_status: azure.mgmt.storagesync.operations.OperationStatusOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = StorageSyncManagementClientConfiguration(credentials, subscription_id, base_url)
        super(StorageSyncManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-06-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.storage_sync_services = StorageSyncServicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.sync_groups = SyncGroupsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.cloud_endpoints = CloudEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.server_endpoints = ServerEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.registered_servers = RegisteredServersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflows = WorkflowsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operation_status = OperationStatusOperations(
            self._client, self.config, self._serialize, self._deserialize)
