# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_certificate_details import ResourceCertificateDetails


class ResourceCertificateAndAadDetails(ResourceCertificateDetails):
    """Certificate details representing the Vault credentials for AAD.

    All required parameters must be populated in order to send to Azure.

    :param certificate: The base64 encoded certificate raw data string.
    :type certificate: bytearray
    :param friendly_name: Certificate friendly name.
    :type friendly_name: str
    :param issuer: Certificate issuer.
    :type issuer: str
    :param resource_id: Resource ID of the vault.
    :type resource_id: long
    :param subject: Certificate Subject Name.
    :type subject: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param valid_from: Certificate Validity start Date time.
    :type valid_from: datetime
    :param valid_to: Certificate Validity End Date time.
    :type valid_to: datetime
    :param auth_type: Required. Constant filled by server.
    :type auth_type: str
    :param aad_authority: Required. AAD tenant authority.
    :type aad_authority: str
    :param aad_tenant_id: Required. AAD tenant Id.
    :type aad_tenant_id: str
    :param service_principal_client_id: Required. AAD service principal
     clientId.
    :type service_principal_client_id: str
    :param service_principal_object_id: Required. AAD service principal
     ObjectId.
    :type service_principal_object_id: str
    :param azure_management_endpoint_audience: Required. Azure Management
     Endpoint Audience.
    :type azure_management_endpoint_audience: str
    """

    _validation = {
        'auth_type': {'required': True},
        'aad_authority': {'required': True},
        'aad_tenant_id': {'required': True},
        'service_principal_client_id': {'required': True},
        'service_principal_object_id': {'required': True},
        'azure_management_endpoint_audience': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'auth_type': {'key': 'authType', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
        'azure_management_endpoint_audience': {'key': 'azureManagementEndpointAudience', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceCertificateAndAadDetails, self).__init__(**kwargs)
        self.aad_authority = kwargs.get('aad_authority', None)
        self.aad_tenant_id = kwargs.get('aad_tenant_id', None)
        self.service_principal_client_id = kwargs.get('service_principal_client_id', None)
        self.service_principal_object_id = kwargs.get('service_principal_object_id', None)
        self.azure_management_endpoint_audience = kwargs.get('azure_management_endpoint_audience', None)
        self.auth_type = 'AzureActiveDirectory'
