# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import MonitorManagementClientConfiguration
from .operations import ActionGroupsOperations
from .operations import MetricAlertsOperations
from .operations import MetricAlertsStatusOperations
from . import models


class MonitorManagementClient(SDKClient):
    """Monitor Management Client

    :ivar config: Configuration for client.
    :vartype config: MonitorManagementClientConfiguration

    :ivar action_groups: ActionGroups operations
    :vartype action_groups: azure.mgmt.monitor.v2018_03_01.operations.ActionGroupsOperations
    :ivar metric_alerts: MetricAlerts operations
    :vartype metric_alerts: azure.mgmt.monitor.v2018_03_01.operations.MetricAlertsOperations
    :ivar metric_alerts_status: MetricAlertsStatus operations
    :vartype metric_alerts_status: azure.mgmt.monitor.v2018_03_01.operations.MetricAlertsStatusOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MonitorManagementClientConfiguration(credentials, subscription_id, base_url)
        super(MonitorManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-03-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.action_groups = ActionGroupsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.metric_alerts = MetricAlertsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.metric_alerts_status = MetricAlertsStatusOperations(
            self._client, self.config, self._serialize, self._deserialize)
