# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import MonitorManagementClientConfiguration
from .operations import AlertRuleIncidentsOperations
from .operations import AlertRulesOperations
from .operations import LogProfilesOperations
from .operations import MetricDefinitionsOperations
from . import models


class MonitorManagementClient(SDKClient):
    """Monitor Management Client

    :ivar config: Configuration for client.
    :vartype config: MonitorManagementClientConfiguration

    :ivar alert_rule_incidents: AlertRuleIncidents operations
    :vartype alert_rule_incidents: azure.mgmt.monitor.v2016_03_01.operations.AlertRuleIncidentsOperations
    :ivar alert_rules: AlertRules operations
    :vartype alert_rules: azure.mgmt.monitor.v2016_03_01.operations.AlertRulesOperations
    :ivar log_profiles: LogProfiles operations
    :vartype log_profiles: azure.mgmt.monitor.v2016_03_01.operations.LogProfilesOperations
    :ivar metric_definitions: MetricDefinitions operations
    :vartype metric_definitions: azure.mgmt.monitor.v2016_03_01.operations.MetricDefinitionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MonitorManagementClientConfiguration(credentials, subscription_id, base_url)
        super(MonitorManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2016-03-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.alert_rule_incidents = AlertRuleIncidentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.alert_rules = AlertRulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.log_profiles = LogProfilesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.metric_definitions = MetricDefinitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
