# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WebLinkedServiceTypeProperties(Model):
    """Base definition of WebLinkedServiceTypeProperties, this typeProperties is
    polymorphic based on authenticationType, so not flattened in SDK models.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebClientCertificateAuthentication,
    WebBasicAuthentication, WebAnonymousAuthentication

    All required parameters must be populated in order to send to Azure.

    :param url: Required. The URL of the web service endpoint, e.g.
     http://www.microsoft.com . Type: string (or Expression with resultType
     string).
    :type url: object
    :param authentication_type: Required. Constant filled by server.
    :type authentication_type: str
    """

    _validation = {
        'url': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'object'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
    }

    _subtype_map = {
        'authentication_type': {'ClientCertificate': 'WebClientCertificateAuthentication', 'Basic': 'WebBasicAuthentication', 'Anonymous': 'WebAnonymousAuthentication'}
    }

    def __init__(self, *, url, **kwargs) -> None:
        super(WebLinkedServiceTypeProperties, self).__init__(**kwargs)
        self.url = url
        self.authentication_type = None
