# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserAccessPolicy(Model):
    """Get Data Plane read only token request definition.

    :param permissions: The string with permissions for Data Plane access.
     Currently only 'r' is supported which grants read only access.
    :type permissions: str
    :param access_resource_path: The resource path to get access relative to
     factory. Currently only empty string is supported which corresponds to the
     factory resource.
    :type access_resource_path: str
    :param profile_name: The name of the profile. Currently only the default
     is supported. The default value is DefaultProfile.
    :type profile_name: str
    :param start_time: Start time for the token. If not specified the current
     time will be used.
    :type start_time: str
    :param expire_time: Expiration time for the token. Maximum duration for
     the token is eight hours and by default the token will expire in eight
     hours.
    :type expire_time: str
    """

    _attribute_map = {
        'permissions': {'key': 'permissions', 'type': 'str'},
        'access_resource_path': {'key': 'accessResourcePath', 'type': 'str'},
        'profile_name': {'key': 'profileName', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'expire_time': {'key': 'expireTime', 'type': 'str'},
    }

    def __init__(self, *, permissions: str=None, access_resource_path: str=None, profile_name: str=None, start_time: str=None, expire_time: str=None, **kwargs) -> None:
        super(UserAccessPolicy, self).__init__(**kwargs)
        self.permissions = permissions
        self.access_resource_path = access_resource_path
        self.profile_name = profile_name
        self.start_time = start_time
        self.expire_time = expire_time
