# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class SapTableLinkedService(LinkedService):
    """SAP Table Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param connect_via: The integration runtime reference.
    :type connect_via:
     ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the
     linked service.
    :type annotations: list[object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param server: Host name of the SAP instance where the table is located.
     Type: string (or Expression with resultType string).
    :type server: object
    :param system_number: System number of the SAP system where the table is
     located. (Usually a two-digit decimal number represented as a string.)
     Type: string (or Expression with resultType string).
    :type system_number: object
    :param client_id: Client ID of the client on the SAP system where the
     table is located. (Usually a three-digit decimal number represented as a
     string) Type: string (or Expression with resultType string).
    :type client_id: object
    :param language: Language of the SAP system where the table is located.
     The default value is EN. Type: string (or Expression with resultType
     string).
    :type language: object
    :param system_id: SystemID of the SAP system where the table is located.
     Type: string (or Expression with resultType string).
    :type system_id: object
    :param user_name: Username to access the SAP server where the table is
     located. Type: string (or Expression with resultType string).
    :type user_name: object
    :param password: Password to access the SAP server where the table is
     located.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param message_server: The hostname of the SAP Message Server. Type:
     string (or Expression with resultType string).
    :type message_server: object
    :param message_server_service: The service name or port number of the
     Message Server. Type: string (or Expression with resultType string).
    :type message_server_service: object
    :param snc_mode: SNC activation indicator to access the SAP server where
     the table is located. Must be either 0 (off) or 1 (on). Type: string (or
     Expression with resultType string).
    :type snc_mode: object
    :param snc_my_name: Initiator's SNC name to access the SAP server where
     the table is located. Type: string (or Expression with resultType string).
    :type snc_my_name: object
    :param snc_partner_name: Communication partner's SNC name to access the
     SAP server where the table is located. Type: string (or Expression with
     resultType string).
    :type snc_partner_name: object
    :param snc_library_path: External security product's library to access the
     SAP server where the table is located. Type: string (or Expression with
     resultType string).
    :type snc_library_path: object
    :param snc_qop: SNC Quality of Protection. Allowed value include: 1, 2, 3,
     8, 9. Type: string (or Expression with resultType string).
    :type snc_qop: object
    :param logon_group: The Logon Group for the SAP System. Type: string (or
     Expression with resultType string).
    :type logon_group: object
    :param encrypted_credential: The encrypted credential used for
     authentication. Credentials are encrypted using the integration runtime
     credential manager. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type': {'key': 'type', 'type': 'str'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'system_number': {'key': 'typeProperties.systemNumber', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'language': {'key': 'typeProperties.language', 'type': 'object'},
        'system_id': {'key': 'typeProperties.systemId', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'message_server': {'key': 'typeProperties.messageServer', 'type': 'object'},
        'message_server_service': {'key': 'typeProperties.messageServerService', 'type': 'object'},
        'snc_mode': {'key': 'typeProperties.sncMode', 'type': 'object'},
        'snc_my_name': {'key': 'typeProperties.sncMyName', 'type': 'object'},
        'snc_partner_name': {'key': 'typeProperties.sncPartnerName', 'type': 'object'},
        'snc_library_path': {'key': 'typeProperties.sncLibraryPath', 'type': 'object'},
        'snc_qop': {'key': 'typeProperties.sncQop', 'type': 'object'},
        'logon_group': {'key': 'typeProperties.logonGroup', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(SapTableLinkedService, self).__init__(**kwargs)
        self.server = kwargs.get('server', None)
        self.system_number = kwargs.get('system_number', None)
        self.client_id = kwargs.get('client_id', None)
        self.language = kwargs.get('language', None)
        self.system_id = kwargs.get('system_id', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.message_server = kwargs.get('message_server', None)
        self.message_server_service = kwargs.get('message_server_service', None)
        self.snc_mode = kwargs.get('snc_mode', None)
        self.snc_my_name = kwargs.get('snc_my_name', None)
        self.snc_partner_name = kwargs.get('snc_partner_name', None)
        self.snc_library_path = kwargs.get('snc_library_path', None)
        self.snc_qop = kwargs.get('snc_qop', None)
        self.logon_group = kwargs.get('logon_group', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.type = 'SapTable'
