# Records set using primecount

Below is a selection of records that have been computed using primecount. For a
more complete list [search for primecount on OEIS.org](https://oeis.org/search?q=primecount&language=english&go=Search).
There is also a [mersenneforum thread](https://www.mersenneforum.org/showthread.php?t=20473)
where we have announced important records as well as details about these computations.
If you have used primecount to compute an important new record please let me know
and I will add your record to this page.

Most of these records have been computed using the
[primecount app with backup support](https://github.com/kimwalisch/primecount/tree/v6.4-backup)
(which I stopped maintaining due to lack of time) as these record computations often take weeks or months to
complete and power outages may occur in such time frames. Since the latest primecount-7.x is significantly
faster than the last [primecount-backup-6.4](https://github.com/kimwalisch/primecount/tree/v6.4-backup)
(especially on servers with > 100 CPU cores), I suggest using the latest primecount version without backup
support if you have a good uninterruptible power supply (UPS) which prevents most power outages of your
PC/server. You can use the primecount app together with the
[Unix ```tee``` command](https://en.wikipedia.org/wiki/Tee_(command)) to store intermediate results in a
log file.

# Double checking $\pi(x)$ computations

For large $\pi(x)$ computations that run over several weeks or months, it is
important to verify such computations to protect against miscalculations due
to hardware errors and/or bugs in primecount.

To verify a $\pi(x)$ computation, you compute $\pi(x)$ twice. But for the second
run you use the `--double-check` option. The `--double-check` option enables the
use of alternative alpha tuning factors, ensuring that all internal bounds in
the second computation differ slightly from the first run. This redundancy helps
guard against potential bugs in primecount: if an error exists, it is highly
unlikely that both $\pi(x)$ computations would produce the same (incorrect)
result.

```bash
# First pi(x) computation using default alpha tuning factors
$ primecount 1e20 --status

# Second pi(x) computation using alternative alpha tuning factors
$ primecount 1e20 --status --double-check
```

# [A006880](https://oeis.org/A006880) records

<table>
  <tr align="center">
    <td><b>x</b></td>
    <td><b>Number of primes ≤ 10<sup>n</sup></b></td>
    <td><b>Date</b></td>
    <td><b>Computed by</b></td>
  </tr>
  <tr align="right">
    <td>10<sup>27</sup></td>
    <td>16,352,460,426,841,680,446,427,399</td>
    <td>2015-09-06</td>
    <td>Kim Walisch & David Baugh</td>
  </tr>
  <tr align="right">
    <td>10<sup>28</sup></td>
    <td>157,589,269,275,973,410,412,739,598</td>
    <td>2020-08-30</td>
    <td>Kim Walisch & David Baugh</td>
  </tr>
  <tr align="right">
    <td>10<sup>29</sup></td>
    <td>1,520,698,109,714,272,166,094,258,063</td>
    <td>2022-02-28</td>
    <td>Kim Walisch & David Baugh</td>
  </tr>
</table>

For verification, all results on this page have been computed twice using
different alpha tuning parameters (configuration parameters).
You can read our announcements of these results in our
[mersenne forum thread](https://mersenneforum.org/showthread.php?t=20473&page=3).

# [A006988](https://oeis.org/A006988) records

<table>
  <tr align="center">
    <td><b>x</b></td>
    <td><b>10<sup>n</sup>-th prime</b></td>
    <td><b>Date</b></td>
    <td><b>Computed by</b></td>
  </tr>
  <tr align="right">
    <td>10<sup>23</sup></td>
    <td>5,596,564,467,986,980,643,073,683</td>
    <td>2015-10-09</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>10<sup>24</sup></td>
    <td>58,310,039,994,836,584,070,534,263</td>
    <td>2015-10-20</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>10<sup>25</sup></td>
    <td>606,527,267,811,189,857,426,370,533</td>
    <td>2022-04-07</td>
    <td>David Baugh</td>
  </tr>
</table>

# [A007053](https://oeis.org/A007053) records

<table>
  <tr align="center">
    <td><b>x</b></td>
    <td><b>Number of primes ≤ 2<sup>n</sup></b></td>
    <td><b>Date</b></td>
    <td><b>Computed by</b></td>
  </tr>
  <tr align="right">
    <td>2<sup>87</sup></td>
    <td>2,610,087,356,951,889,016,077,639</td>
    <td>2018-11-28</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>2<sup>88</sup></td>
    <td>5,159,830,247,726,102,115,466,054</td>
    <td>2019-01-05</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>2<sup>89</sup></td>
    <td>10,201,730,804,263,125,133,012,340</td>
    <td>2020-05-09</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>2<sup>90</sup></td>
    <td>20,172,933,541,156,002,700,963,336</td>
    <td>2020-10-07</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>2<sup>91</sup></td>
    <td>39,895,115,987,049,029,184,882,256</td>
    <td>2020-11-14</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>2<sup>92</sup></td>
    <td>78,908,656,317,357,166,866,404,346</td>
    <td>2020-12-02</td>
    <td>David Baugh</td>
  </tr>
</table>

# [A040014](https://oeis.org/A040014) records

<table>
  <tr align="center">
    <td><b>x</b></td>
    <td><b>Number of primes < e<sup>n</sup></b></td>
    <td><b>Date</b></td>
    <td><b>Computed by</b></td>
  </tr>
  <tr align="right">
    <td>e<sup>48</sup></td>
    <td>14,936,302,130,478,888,296</td>
    <td>2015-03-07</td>
    <td>David Baugh</td>
  </tr>
    <tr align="right">
    <td>e<sup>49</sup></td>
    <td>39,754,427,477,873,197,008</td>
    <td>2015-03-07</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>50</sup></td>
    <td>105,856,368,969,311,706,141</td>
    <td>2015-03-07</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>51</sup></td>
    <td>281,987,525,487,483,629,729</td>
    <td>2015-03-07</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>52</sup></td>
    <td>751,479,276,811,434,164,860</td>
    <td>2015-03-10</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>53</sup></td>
    <td>2,003,417,881,848,387,803,588</td>
    <td>2015-03-25</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>54</sup></td>
    <td>5,343,023,851,430,824,336,740</td>
    <td>2015-04-10</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>55</sup></td>
    <td>14,254,686,649,867,417,156,723</td>
    <td>2015-05-17</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>56</sup></td>
    <td>38,043,242,922,236,683,117,535</td>
    <td>2015-08-03</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>57</sup></td>
    <td>101,564,348,447,358,891,206,901</td>
    <td>2015-09-08</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>58</sup></td>
    <td>27,123,381,893,146,940,4637,903</td>
    <td>2016-08-24</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>59</sup></td>
    <td>724,569,999,669,566,733,678,976</td>
    <td>2020-08-04</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>60</sup></td>
    <td>1,936,182,213,929,180,232,892,229</td>
    <td>2020-10-22</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>61</sup></td>
    <td>5,175,318,892,686,816,487,170,078</td>
    <td>2021-03-15</td>
    <td>David Baugh</td>
  </tr>
  <tr align="right">
    <td>e<sup>62</sup></td>
    <td>13,837,220,920,267,326,266,315,383</td>
    <td>2022-04-11</td>
    <td>David Baugh</td>
  </tr>
</table>

# [A122121](https://oeis.org/A122121) records

<table>
  <tr align="center">
    <td><b>x</b></td>
    <td><b>Number of primes ≤ 10<sup>n/2</sup></b></td>
    <td><b>Date</b></td>
    <td><b>Computed by</b></td>
  </tr>
  <tr align="right">
    <td>10<sup>47/2</sup></td>
    <td>5,956,317,545,928,249,075,039</td>
    <td>2015-02-23</td>
    <td>David Baugh</td>
  </tr>
    <tr align="right">
    <td>10<sup>49/2</sup></td>
    <td>57,086,403,558,149,290,301,868</td>
    <td>2015-04-27</td>
    <td>David Baugh</td>
  </tr>
    <tr align="right">
    <td>10<sup>51/2</sup></td>
    <td>548,074,549,053,620,897,173,483</td>
    <td>2015-06-18</td>
    <td>David Baugh</td>
  </tr>
    <tr align="right">
    <td>10<sup>53/2</sup></td>
    <td>5,270,353,162,790,246,525,701,178</td>
    <td>2016-08-31</td>
    <td>David Baugh</td>
  </tr>
</table>
