/*
 *  $Id: primax_scan.h,v 1.2 2000/10/24 19:12:52 chrordig Exp $
 */

#ifndef PRIMAX_SCAN_H
#define PRIMAX_SCAN_H

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif            

/* change this to FALSE and you get slow movements*/
#define USE_SCHEDULER TRUE

/* This is a handy macro for debugging */

extern int dbg_level;

#ifdef DEBUG
 #define DBG(level, msg, args...)  \
   do {                            \
     if ((dbg_level) & (level))    \
       printf (msg, ##args);       \
   } while (0)
#else
 #define DBG(level, msg, args...)
#endif

#define CHECK(val) \
  (((val) > 255 ) ? (255) : (val))

/* different debug level */
#define DBG_LOW                       0x01
#define DBG_MEDIUM                    0x02
#define DBG_HIGH                      0x04
#define DBG_HELPERS                   0x08
#define DBG_TIMEOUT                   0x10
#define DBG_SCAN                      0x20
#define DBG_ALL                       0xFF

/* different transfer modes */
#define REGISTER_LM9811           0x00
#define FIFO                      0x01
#define MODE_2                    0x02    /* mode ?? */ 
#define MODE_3                    0x03    /* flag for button */
#define MODE_4                    0x04
#define MODE_5                    0x05
#define MODE_6                    0x06
#define MODE_7                    0x07
#define MODE_8                    0x08
#define MODE_9                    0x09
#define X_TABLE                   0x0A
#define Y_TABLE                   0x0B
#define COLOR_TABLE               0x0C
#define CALIBRATION_TABLE         0x0D
#define MODE_E                    0x0E   /* status ?? */
#define MODE_F                    0x0F   /* status ?? */

   
/* DrvMcuSendRequest */
#define CARRIGE_RETURN            0xC0C0 /* moves lamp back, speed in first two bytes */
#define S_8000                    0x8000
#define S_40B0                    0x40B0
#define S_4000                    0x4000
#define S_2080                    0x2080
#define GO_OFFLINE                0x2040 /* go offline ?*/
#define S_2020                    0x2020
#define S_2000                    0x2000

#define RED_MODE                  0x0011
#define GREEN_MODE                0x0012
#define BLUE_MODE                 0x0014
#define RGB_MODE                  0x0007
#define GRAY_MODE                 0x0107
#define BW_MODE                   0x1107
#define BW_MODE_RED               0x1011
#define BW_MODE_GREEN             0x1012
#define BW_MODE_BLUE              0x1014

/* scan modes */
#define CALIBRATION               10
#define SCAN                      20

/* predefined timeouts */
#define LOOP_TIMEOUT         200000    // timeout-time during loops in us 
#define SCAN_LOOP_TIMEOUT    400000  // need to wait much longer for long lines

#define TIMEOUT                   -1
#define NO_TIMEOUT                0


typedef struct {
    double contrast;
    double brightness;
    double gamma;
} color_setting;

    
typedef struct {
    int width;              /* width in pixel */
    int height;             /* height in pixel */
    int resolution;         /* resolution in pixel */
    int speed;              /* speed of carriage */
    
    double from_top;        /* distance fromm top in inch*/
    double from_left;       /* distance from left side in inch*/
    
    int num_colors;         /* number of colors, 3 */
    unsigned int colormode; /* modes like RGB, Gray or BW */

    color_setting color[3];     /* b/c/g for all colors */
    
    unsigned char *color_table[3]; /* 10bit -> 8bit funtion */
    unsigned char *x_table;        /* x scanrange and resolution */
    unsigned char *y_table;        /* y scanrange, resolution and color */
    unsigned char *y_table_int;    /* y scanrange, resolution and color */
    unsigned char *LM9811_arr_PGA; /* Pixel Gain Amplifier array (PGA)
                                      One value for each cell on the CCD
                                      ((color*pixel)values) */
    unsigned char LM9811_reg_PGA; /* Pixel Gain Amplifier Register
                                      PGA-array reduced to one value
                                      (for calibration only)*/
    unsigned char LM9811_reg_VGA; /* Variable Gain Amplifier Register  */
    unsigned char LM9811_reg_DAC; /* Offset-DAC*/
   
    unsigned char *data;   /* raw data of scan */
  
    char *filename;         /* name of tiff-file */
    int lzw;                /*LZW mode / no compression */
} scan_image;

void scan (scan_image *image, int mode);                     
void init_image(scan_image **image);

#endif /* primax_scan.h */

/* This stuff is for emacs
 * Local variables:
 * c-basic-offset: 4
 * End:       
 */










