------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                        C O R B A . F O R W A R D                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2001-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

package body CORBA.Forward is

   package body Convert is

      --  Minimal implementation of conversion between forward references
      --  and complete references.

      ------------------
      -- From_Forward --
      ------------------

      function From_Forward (The_Forward : Ref) return Ref_Type is
         Res : Ref_Type;
      begin
         Set (Res, Object_Of (The_Forward));
         return Res;
      end From_Forward;

      ----------------
      -- To_Forward --
      ----------------

      function To_Forward (The_Ref : Ref_Type) return Ref is
         Res : Ref;
      begin
         Set (Res, Object_Of (The_Ref));
         return Res;
      end To_Forward;
   end Convert;

end CORBA.Forward;
