# this file is generated by tests/repositories/fixtures/pypi.org/generate.py
from __future__ import annotations

import dataclasses

from typing import TYPE_CHECKING

import pytest


if TYPE_CHECKING:
    from tests.types import DistributionHashGetter


@dataclasses.dataclass
class DistributionHash:
    sha256: str = ""
    md5: str = ""


KNOWN_DISTRIBUTION_HASHES = {
    "SQLAlchemy-1.2.12.tar.gz": DistributionHash(
        "b5a127599b3f27847fba6119de0fcb70832a8041b103701a708b7c7d044faa38",
        "4a2617b5254748828d09349fc4eff6bd",
    ),
    "Twisted-18.9.0.tar.bz2": DistributionHash(
        "4335327da58be11dd6e482ec6b85eb055bcc953a9570cd59e7840a2ce9419a8e",
        "35ff4705ea90a76bf972ff3b229546ca",
    ),
    "attrs-17.4.0-py2.py3-none-any.whl": DistributionHash(
        "1fbfc10ebc8c876dcbab17f016b80ae1a4f0c1413461a695871427960795beb4",
        "7fe37931797b16c7fa158017457a9ea9",
    ),
    "attrs-17.4.0.tar.gz": DistributionHash(
        "eb7536a1e6928190b3008c5b350bdf9850d619fff212341cd096f87a27a5e564",
        "c03e5b3608d9071fbd098850d8922668",
    ),
    "black-19.10b0-py36-none-any.whl": DistributionHash(
        "13001c5b7dbc81137164b43137320a1785e95ce84e4db849279786877ac6d7f6",
        "acc537b0f3f7ebf575616490d7cc14f4",
    ),
    "black-19.10b0.tar.gz": DistributionHash(
        "6cada614d5d2132698c6d5fff384657273d922c4fffa6a2f0de9e03e25b8913a",
        "c383543109a66a5a99113e6326db5251",
    ),
    "black-21.11b0-py3-none-any.whl": DistributionHash(
        "38f6ad54069912caf2fa2d4f25d0c5dedef4b2338a0cb545dbe2fdf54a6a8891",
        "92942a9efabf8e321a11360667ad2494",
    ),
    "black-21.11b0.tar.gz": DistributionHash(
        "f23c482185d842e2f19d506e55c004061167e3c677c063ecd721042c62086ada",
        "f01267bf2613f825dd6684629c1c829e",
    ),
    "cleo-1.0.0a5-py3-none-any.whl": DistributionHash(
        "d0cfea878b77be28be027033e6af419b705abe47278067a7c3a298f39cf825c5",
        "19ed7de77063e8f16bc459276ccbe197",
    ),
    "cleo-1.0.0a5.tar.gz": DistributionHash(
        "88f0a4275a17f2ab4d013786b8b9522d4c60bd37d8fc9b3def0fb27f4ac1e694",
        "92e181952976e09b9d1c583da6c3e2fc",
    ),
    "clikit-0.2.4-py2.py3-none-any.whl": DistributionHash(
        "27316bf6382b04be8fb2f60c85d538fd2b2b03f0f1eba5c88f7d7eddbefc2778",
        "93a51e8bf259c29692e51a7cbca6d664",
    ),
    "clikit-0.2.4.tar.gz": DistributionHash(
        "0fdd41e86e8b118a8b1e94ef2835925ada541d481c9b3b2fc635fa68713e6125",
        "f7cdbad3508038a04561f646aae68146",
    ),
    "colorama-0.3.9-py2.py3-none-any.whl": DistributionHash(
        "78a441d2e984c790526cdef1cfd8415a366979ef5b3186771a055b35886953bf",
        "8021c861015b5f590be41190bc3f8eed",
    ),
    "colorama-0.3.9.tar.gz": DistributionHash(
        "4c5a15209723ce1330a5c193465fe221098f761e9640d823a2ce7c03f983137f",
        "8323a5b84fdf7ad810804e51fc256b39",
    ),
    "demo-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "70e704135718fffbcbf61ed1fc45933cfd86951a744b681000eaaa75da31f17a",
        "15507846fd4299596661d0197bfb4f90",
    ),
    "demo-0.1.0.tar.gz": DistributionHash(
        "9fa123ad707a5c6c944743bf3e11a0e80d86cb518d3cf25320866ca3ef43e2ad",
        "d1912c917363a64e127318655f7d1fe7",
    ),
    "demo-0.1.2-py2.py3-none-any.whl": DistributionHash(
        "55dde4e6828081de7a1e429f33180459c333d9da593db62a3d75a8f5e505dde1",
        "53b4e10d2bfa81a4206221c4b87843d9",
    ),
    "demo_invalid_record-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "d1e5a3f18f24a2ad3717c6f9c55f8c26060f39b2cddf28b18c355786728cb4dd",
        "18041168d415370d5019ec7e2b1ed0b5",
    ),
    "demo_invalid_record2-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "e730fca385b52e77fc58d73812f0dc236fad489ef6026716d1a4317ab4738c3c",
        "a21ee67e833f50e9f0ecdfe1c0484b93",
    ),
    "demo_metadata_version_23-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "7592aa158137726d9579e5d4347bd03a88f9fc82e11061303215feaaf000d32c",
        "434114a36f986671d132033e130f26b7",
    ),
    "demo_metadata_version_24-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "f0d306c48d665e4a0051c660cc39f5ed7b7d51427050bfbca525e95d9fad2587",
        "c0cbc2e5f2736a487ff960a8c39defbe",
    ),
    "demo_metadata_version_299-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "9678f9e59454a281bf7780661d719122766111dc9432ad20823ce6569d10edb2",
        "2eb53ee23408e65de909e20d9575afe3",
    ),
    "demo_metadata_version_unknown-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "d716cd66546468ec3d4d40f4a4ecc813e3e4c661e155ecbc3a932f47d46d6e05",
        "749f823ff755a2f46bfb5ab25fdf9810",
    ),
    "demo_missing_dist_info-0.1.0-py2.py3-none-any.whl": DistributionHash(
        "cf8eaade81dd1db42f60c0e9c8610c1c12006baa9f7ad994b1c2bae92ea4b426",
        "da33c6088e72fbaaf873999606767353",
    ),
    "demo_no_pkg_info-0.1.0.tar.gz": DistributionHash(
        "f1e2a977c506dfb6b43495e2ffeee618b90029bac92fcb3038a53268197afa0c",
        "eeaf257d6b2c3b01def567751b21c1e8",
    ),
    "discord.py-2.0.0-py3-none-any.whl": DistributionHash(
        "25b9739ba456622655203a0925b354c0ba96ac6c740562e7c37791c2f6b594fb",
        "65394fc868632423cedb6be7259db970",
    ),
    "discord.py-2.0.0.tar.gz": DistributionHash(
        "b86fa9dd562684f7a52564e6dfe0216f6c172a009c0d86b8dea8bdd6ffa6b1f4",
        "6c0505a6032342b29f31f9979f37d277",
    ),
    "futures-3.2.0-py2-none-any.whl": DistributionHash(
        "41353b36198757a766cfc82dc9b60e88ecb28e543dd92473b2cc74fc7bf205af",
        "f81c5c27f3ba2efc008cc96363a81c5e",
    ),
    "futures-3.2.0.tar.gz": DistributionHash(
        "baf0d469c9e541b747986b7404cd63a5496955bd0c43a3cc068c449b09b7d4a4",
        "40eb168dab84e606df3fdb7e67fe27b7",
    ),
    "hbmqtt-0.9.6.tar.gz": DistributionHash(
        "379f1d9044997c69308ac2e01621c817b5394e1fbe0696e62538ae2dd0aa7e07",
        "b284e3118882f169aa618a856cd91c5f",
    ),
    "ipython-5.7.0-py2-none-any.whl": DistributionHash(
        "4608e3e0500fe8142659d149891400fc0b9fa250051814b569457ae4688943dc",
        "20da5e0b1f79dccb37f033a885d798d7",
    ),
    "ipython-5.7.0-py3-none-any.whl": DistributionHash(
        "4292c026552a77b2edc0543941516eddd6fe1a4b681a76ac40b3f585d2fca76f",
        "2844fa01618fe27ab99ad455d605b47d",
    ),
    "ipython-5.7.0.tar.gz": DistributionHash(
        "4e7fb265e0264498bd0d62c6261936a658bf3d38beb8a7b10cd2c6327c62ac2a",
        "01f2808ebe78ff2f28dc39be3aa635ca",
    ),
    "ipython-7.5.0-py3-none-any.whl": DistributionHash(
        "1b4c76bf1e8dd9067a4f5ab4695d4c5ad81c30d7d06f7592f4c069c389e37f37",
        "f40ea889fb7adf989760c5e7a38bd112",
    ),
    "ipython-7.5.0.tar.gz": DistributionHash(
        "cd2a17ac273fea8bf8953118a2d83bad94f592f0db3e83fff9129a1842e36dbe",
        "0e8c1d7c14f309f6cd2dfd4e48e75cb1",
    ),
    "isodate-0.7.0-py3-none-any.whl": DistributionHash(
        "04505f97eb100b66dff1239859e6e04ab913714c453d6ab9591adbf418285847",
        "1af9e3ee3f5669186356afd2dbe7ce81",
    ),
    "isodate-0.7.0.tar.gz": DistributionHash(
        "167c3615c0bd2e498c9bae7a1aba5863a17e52299aafd89f17a3a091187dca74",
        "5668b7b7120797f03330363000afc35a",
    ),
    "isort-4.3.4-py2-none-any.whl": DistributionHash(
        "383c39c10b5db83e8d150ac5b84d74bda96e3a1b06a30257f022dcbcd21f54b9",
        "42bccda292eca3c91eadf3eb781a224f",
    ),
    "isort-4.3.4-py3-none-any.whl": DistributionHash(
        "5668dce9fb48544c57ed626982e190c8ea99e3a612850453e9c3b193b9fa2edc",
        "6c3b582d7782633ec23917b00a97a2fe",
    ),
    "isort-4.3.4.tar.gz": DistributionHash(
        "234ad07e1e2780c27fa56364eefa734bee991b0d744337ef7e7ce3d5b1b59f39",
        "9244631852cf8bd8559f7ab78bf4ec78",
    ),
    "jupyter-1.0.0-py2.py3-none-any.whl": DistributionHash(
        "1de1f2be45629dd6f7f9558e2385ddf6901849699ef1044c52d171a9b520a420",
        "27f411f164e0878104d76d868127f76f",
    ),
    "jupyter-1.0.0.tar.gz": DistributionHash(
        "3ef1e86ba0556ea5922b846416a41acfd2625830d996c7d06d80c90bed1dc193",
        "78acaec88533ea6b6e761e7d086a1d04",
    ),
    "jupyter-1.0.0.zip": DistributionHash(
        "4a855b9717c3ea24fd8ca4fd91ab5995894aecc4d20e7f39c28786a2c1869fae",
        "7b7a957694a73ac0c19fe46c216c0ea0",
    ),
    "more-itertools-4.1.0.tar.gz": DistributionHash(
        "bab2dc6f4be8f9a4a72177842c5283e2dff57c167439a03e3d8d901e854f0f2e",
        "bf351a1050242ce3af7e475a4da1a26b",
    ),
    "more_itertools-4.1.0-py2-none-any.whl": DistributionHash(
        "0f461c2cd4ec16611396f9ee57f40433de3d59e95475d84c0c829cde02f746cd",
        "703e1e0922de1f11823da60af1488b7a",
    ),
    "more_itertools-4.1.0-py3-none-any.whl": DistributionHash(
        "580b6002d1f28feb5bcb8303278d59cf17dfbd19a63a5c2375112dae72c9bf98",
        "ae17a45d13e9dc319794c40fa739c38f",
    ),
    "pastel-0.1.0-py3-none-any.whl": DistributionHash(
        "754d192c088e256d52a3f825c3b9e14252d5adc70f53656453f6431e50a70b99",
        "cf7c53ab0a5d7e7c721425b24b486124",
    ),
    "pastel-0.1.0.tar.gz": DistributionHash(
        "22f14474c4120b37c54ac2173b49b0ac1de9283ca714be6eb3ea8b39296285a9",
        "43ea5f07660f630da18ae1827f5b4333",
    ),
    "pluggy-0.6.0-py2-none-any.whl": DistributionHash(
        "f5f767d398f18aa177976bf9c4d0c05d96487a7d8f07062251585803aaf56246",
        "095eed084713c9b2a9a01520485e20fb",
    ),
    "pluggy-0.6.0-py3-none-any.whl": DistributionHash(
        "d34798b80853ab688de1a3ca5b99ba4de91c459c19c76a555dc939979ae67eb0",
        "2b6dc266f54023dfb26726686ee6b227",
    ),
    "pluggy-0.6.0.tar.gz": DistributionHash(
        "a982e208d054867661d27c6d2a86b17ba05fbb6b1bdc01f42660732dd107f865",
        "ef8a88abcd501afd47cb22245fe4315a",
    ),
    "poetry_core-1.5.0-py3-none-any.whl": DistributionHash(
        "e216b70f013c47b82a72540d34347632c5bfe59fd54f5fe5d51f6a68b19aaf84",
        "be7589b4902793e66d7d979bd8581591",
    ),
    "poetry_core-1.5.0.tar.gz": DistributionHash(
        "0ae8d28caf5c12ec1714b16d2e7157ddd52397ea6bfdeba5a9432e449a0184da",
        "3f9b36a7a94cd235bfd5f05794828445",
    ),
    "poetry_core-2.0.1-py3-none-any.whl": DistributionHash(
        "a3c7009536522cda4eb0fb3805c9dc935b5537f8727dd01efb9c15e51a17552b",
        "a52cf4beef0de009e0a9a36c9e6962f5",
    ),
    "poetry_core-2.0.1.tar.gz": DistributionHash(
        "d2acdaec3b93dc1ab43adaeb0e9a8a6a6b3701c4535b5baab4b718ab12c8993c",
        "1b1bb959cd760ac509de9b38ae67fc3b",
    ),
    "py-1.5.3-py2.py3-none-any.whl": DistributionHash(
        "ef4a94f47156178e42ef8f2b131db420e0f4b6aa0b3936b6dbde6ad6487476a5",
        "b316b380701661cb67732ecdaef30eeb",
    ),
    "py-1.5.3.tar.gz": DistributionHash(
        "2df2c513c3af11de15f58189ba5539ddc4768c6f33816dc5c03950c8bd6180fa",
        "623e80cfc06df930414a9ce4bf0fd6c9",
    ),
    "pytest-3.5.0-py2.py3-none-any.whl": DistributionHash(
        "427b4582bda18e92ad1967e8b1e071e2c53e6cb7e3e5f090cb3ca443455be23f",
        "4a8651dec151e76f283bf59e333286f9",
    ),
    "pytest-3.5.0.tar.gz": DistributionHash(
        "677b1d6decd29c041fe64276f29f79fbe66e40c59e445eb251366b4a8ab8bf68",
        "ccd78dac54112045f561c4df86631f19",
    ),
    "pytest-3.5.1-py2.py3-none-any.whl": DistributionHash(
        "d327df3686046c5b374a9776d9e11606f7dba6fb3db5cf5d60ebc78a31e0768e",
        "1e81fba94885bef80170545d045924eb",
    ),
    "pytest-3.5.1.tar.gz": DistributionHash(
        "b8fe151f3e181801dd38583a1c03818fbc662a8fce96c9063a0af624613e78f8",
        "961104636090457187851ccb9ef0f677",
    ),
    "python-language-server-0.21.2.tar.gz": DistributionHash(
        "91b564e092f3135b2bac70dbd23d283da5ad50269766a76648787b69fe702c7e",
        "677602ec38bc1c7b72de6128d90d846b",
    ),
    "requests-2.18.4-py2.py3-none-any.whl": DistributionHash(
        "098be851f30be5bcb2c7537798d44314f576e53818ba9def25141ae4dce8b25d",
        "e770e65750c42f40b97b0ed738d0f859",
    ),
    "requests-2.18.4.tar.gz": DistributionHash(
        "ec62f7e0e9d4814656b0172dbd592fea06127c6556ff5651eb5d2c8768671fd4",
        "942a6a383dc94da90cf58f5adcf028a4",
    ),
    "setuptools-67.6.1-py3-none-any.whl": DistributionHash(
        "e728ca814a823bf7bf60162daf9db95b93d532948c4c0bea762ce62f60189078",
        "3b5b846e000da033d54eeaaf7915126e",
    ),
    "setuptools-67.6.1.tar.gz": DistributionHash(
        "a737d365c957dd3fced9ddd246118e95dce7a62c3dc49f37e7fdd9e93475d785",
        "ee2562f783544d1f95022c906dd3cf98",
    ),
    "six-1.11.0-py2.py3-none-any.whl": DistributionHash(
        "534e9875e44a507adec601c29b3cbd2ca6dae7df92bf3dd20c7289b2f99f7466",
        "9500094701f7201ddd065c60abcefef1",
    ),
    "six-1.11.0.tar.gz": DistributionHash(
        "268a4ccb159c1a2d2c79336b02e75058387b0cdbb4cea2f07846a758f48a356d",
        "25d3568604f921dd23532b88a0ce17e7",
    ),
    "tomlkit-0.5.2-py2.py3-none-any.whl": DistributionHash(
        "dea8ff39e9e2170f1b2f465520482eec71e7909cfff53dcb076b585d50f8ccc8",
        "4045c5f6848fbc93c38df2296a441f07",
    ),
    "tomlkit-0.5.2.tar.gz": DistributionHash(
        "4a226ccf11ee5a2e76bfc185747b54ee7718706aeb3aabb981327249dbe2b1d4",
        "7c31987ef6fba2cd64715cae27fade64",
    ),
    "tomlkit-0.5.3-py2.py3-none-any.whl": DistributionHash(
        "35f06da5835e85f149a4701d43e730adcc09f1b362e5fc2300d77bdd26280908",
        "3a90c70a5067d5727110838094ab8674",
    ),
    "tomlkit-0.5.3.tar.gz": DistributionHash(
        "e2f785651609492c771d9887ccb2369d891d16595d2d97972e2cbe5e8fb3439f",
        "cdbdc302a184d1f1e38d5e0810e3b212",
    ),
    "wheel-0.40.0-py3-none-any.whl": DistributionHash(
        "d236b20e7cb522daf2390fa84c55eea81c5c30190f90f29ae2ca1ad8355bf247",
        "517d39f133bd7b1ff17caf09784b7543",
    ),
    "wheel-0.40.0.tar.gz": DistributionHash(
        "5cb7e75751aa82e1b7db3fd52f5a9d59e7b06905630bed135793295931528740",
        "5f175a8d693f74878964d4fd29729ab7",
    ),
    "zipp-3.5.0-py3-none-any.whl": DistributionHash(
        "ec508cd5a3ed3d126293cafb34611469f2aef7342f575c3b6e072b995dc9da1f",
        "da62cbd850ba32ba93817aab0f03a855",
    ),
    "zipp-3.5.0.tar.gz": DistributionHash(
        "239d50954a15aa4b283023f18dc451ba811fb4d263f4dd6855642e4d1c80cc9f",
        "16bf2a24fae340052e8565c264d21092",
    ),
}


@pytest.fixture
def dist_hash_getter() -> DistributionHashGetter:
    def get_hash(name: str) -> DistributionHash:
        return KNOWN_DISTRIBUTION_HASHES.get(name, DistributionHash())

    return get_hash
