%define ver	1.6.0
%define rel	1
%define prefix	/usr

Summary:	A Command Line MIDI Player Through ALSA Sequencer.
Name:		pmidi
Version:	%{ver}
Release:	%{rel}
Copyright:	GPL
Group:		Applications/Multimedia/Audio
Source: ftp://download.sourceforge.net/pub/sourceforge/pmidi/pmidi-1.6.0.tar.gz
URL:		http://pmidi.sourceforge.net
BuildRoot:	/usr/tmp/pmidi-1.6.0-%{rel}-root
Packager:	Habibie <habibie@NetZero.net>
Docdir:		%{prefix}/doc

%description
pmidi is a command line midi player for ALSA.  It can play to any MIDI
device that is supported by ALSA.  Most external MIDI ports are supported.
The sfxload program included with the awesfx is required to load a sound
font first to using the internal synthesizer on a SB Live! or SB AWE32/64.

Authors:
	Steve Ratcliffe	<steve@parabola.demon.co.uk>


%prep
%setup -q


%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
	CFLAGS="${RPM_OPT_FLAGS}" ./autogen.sh --prefix=%prefix
else
	CFLAGS="${RPM_OPT_FLAGS}" ./configure --prefix=%prefix
fi

[ "${SMP}" != "" ] && JSMP = '-j${SMP} "MAKE=make -j${SMP}"';
make ${JSMP};


%install
[ -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

make prefix=${RPM_BUILD_ROOT}%{prefix} install-strip

#
# Strip off binary and library files, if not done so.
#
# First, gathering the binary files list.
# Process and store them as FILEB
#
find ${RPM_BUILD_ROOT}%{prefix} -type f > file-lists;
FILEB=`file -f file-lists | awk -F':' '/executable/ { print $1 }'`

#
# Second, gathering the library files list.
# Process and store them as FILEL.
#
find ${RPM_BUILD_ROOT}%{prefix} -type f > file-lists;
FILEL=`file -f file-lists | awk -F':' '/shared object/ { print $1 }'`

#
# Then,  strip both the binary and library
# files listed in FILEB and FILEL.
#
[ "${FILEB}" ] && strip ${FILEB};
[ "${FILEL}" ] && strip ${FILEL};

#
# Compressing the info files and manpages, if any.
#
if [ -d ${RPM_BUILD_ROOT}%{prefix}/info ]; then
	(cd ${RPM_BUILD_ROOT}%{prefix}/info; [ -z dir ] && rm -f dir;)
	find ${RPM_BUILD_ROOT}%{prefix}/info -type f -exec gzip -9nf {} \;
fi

if [ -d ${RPM_BUILD_ROOT}%{prefix}/man ]; then
	find ${RPM_BUILD_ROOT}%{prefix}/man -type f -exec gzip -9nf {} \;
fi

#
# Generating the package file lists and store them in file-lists
#
echo "%defattr (-, root, root)" > file-lists
find ${RPM_BUILD_ROOT}%{prefix} -type f | sed -e "s#^${RPM_BUILD_ROOT}##g" >> file-lists


%clean
(PKGDIR=`pwd`; cd ..; rm -rf ${PKGDIR} ${RPM_BUILD_ROOT})


%files -f file-lists
%defattr (-, root, root)
%doc AUTHORS
%doc ChangeLog
%doc INSTALL
%doc NEWS
%doc README

