/*	Conductor_Table_Model_Event

PIRL CVS ID: Conductor_Table_Model_Event.java,v 1.6 2012/04/16 06:04:11 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor.Maestro;

import	javax.swing.table.TableModel;
import	javax.swing.event.TableModelEvent;


/**	A <i>Conductor_Table_Model_Event</i> extends a TableModelEvent with
	Conductor processing status information.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.6
*/
public class Conductor_Table_Model_Event
	extends TableModelEvent
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Maestro.Conductor_Table_Model_Event (1.6 2012/04/16 06:04:11)";

/**	The processing state of the Conductor with which the event is associated.
*/
public int
	Processing_State	= 0;

/*==============================================================================
	Constructors: TableModelEvent
*/
public Conductor_Table_Model_Event
	(
	TableModel	source
	)
{super (source);}

public Conductor_Table_Model_Event
	(
	TableModel	source,
	int			row
	)
{super (source, row);}

public Conductor_Table_Model_Event
	(
	TableModel	source,
	int			first_row,
	int			last_row
	)
{
super (source, first_row, last_row);
Confirm_Row_Order ();
}

public Conductor_Table_Model_Event
	(
	TableModel	source,
	int			first_row,
	int			last_row,
	int			column
	)
{
super (source, first_row, last_row, column);
Confirm_Row_Order ();
}

/**	Construct a Conductor_Table_Model_Event.
*/
public Conductor_Table_Model_Event
	(
	TableModel	source,
	int			first_row,
	int			last_row,
	int			column,
	int			type
	)
{
super (source, first_row, last_row, column, type);
Confirm_Row_Order ();
}


private void Confirm_Row_Order ()
{
if (firstRow > lastRow)
	{
	int
		row = firstRow;
	firstRow = lastRow;
	lastRow = row;
	}
}

/*==============================================================================
	Accessors
*/
/**	Set the Conductor processing state of the event.
<p>
	@param	processing_state	The processing state value.
	@return	This Conductor_Table_Model_Event.
*/
public Conductor_Table_Model_Event Processing_State
	(
	int			processing_state
	)
{Processing_State = processing_state; return this;}

/**	Get the Conductor processing state of the event.
<p>
	@return	The processing state value.
*/
public int Processing_State ()
{return Processing_State;}


}
