/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package opticalraytracer;

import javax.swing.*;

/**
 *
 * @author lutusp
 */
public class ControlPanelManager {

    OpticalRayTracer parent;
    RayTraceComputer rayTraceComputer;
    int decPlaces = 4;

    public ControlPanelManager(OpticalRayTracer p, RayTraceComputer rtc) {
        parent = p;
        rayTraceComputer = rtc;
        writeLensValues(null);
    }

    public void writeLensValues(Lens p) {
        readControls(p);
        resetControls(p);
    }

    public void readLensValues(Lens p) {
        writeControls(p);
        resetControls(p);
    }

    private void writeControls(Lens p) {
        if (p != null) {
            writeCheckBox(parent.leftHypCheckBox, p.leftHyp);
            writeCheckBox(parent.rightHypCheckBox, p.rightHyp);
            writeCheckBox(parent.symmCheckBox, p.symmetrical);
            writeTextField(parent.lensRadiusTextField, p.lensRadius);
            writeTextField(parent.userThicknessTextField, p.userThickness);
            writeTextField(parent.leftRadiusTextField, p.leftSphereRadius);
            writeTextField(parent.rightRadiusTextField, p.rightSphereRadius);
            writeTextField(parent.leftCFTextField, p.lcf);
            writeTextField(parent.rightCFTextField, p.rcf);
            writeTextField(parent.iorTextField, p.ior);
            writeTextField(parent.dispersionTextField, p.dispersion);
            writeTextField(parent.xPosTextField, p.cx);
            writeTextField(parent.yPosTextField, p.cy);
        }
    }

    private void readControls(Lens p) {
        if (p != null) {
            p.symmetrical = readCheckBox(parent.symmCheckBox);
            p.leftHyp = readCheckBox(parent.leftHypCheckBox);
            p.rightHyp = readCheckBox(parent.rightHypCheckBox);
            p.lensRadius = Math.abs(readTextField(parent.lensRadiusTextField, p.lensRadius));
            p.lensRadius = Math.abs(p.lensRadius);
            writeTextField(parent.lensRadiusTextField, p.lensRadius);
            p.userThickness = readTextField(parent.userThicknessTextField, p.userThickness);
            p.userThickness = (p.userThickness < 0)?0:p.userThickness;
            writeTextField(parent.userThicknessTextField, p.userThickness);
            p.leftSphereRadius = readTextField(parent.leftRadiusTextField, p.leftSphereRadius);
            p.rightSphereRadius = readTextField(parent.rightRadiusTextField, p.rightSphereRadius);
            p.lcf = readTextField(parent.leftCFTextField, p.lcf);
            p.rcf = readTextField(parent.rightCFTextField, p.rcf);
            writeTextField(parent.leftCFTextField, p.lcf);
            writeTextField(parent.rightCFTextField, p.rcf);
            p.ior = readTextField(parent.iorTextField, p.ior);
            p.ior = (p.ior < 1) ? 1 : p.ior;
            writeTextField(parent.iorTextField, p.ior);
            p.dispersion = readTextField(parent.dispersionTextField, p.dispersion);
            p.cx = readTextField(parent.xPosTextField, p.cx);
            p.cy = readTextField(parent.yPosTextField, p.cy);
            p.leftSphereRadius = checkRadius(p.leftSphereRadius, p.lensRadius);
            p.rightSphereRadius = checkRadius(p.rightSphereRadius, p.lensRadius);
            writeTextField(parent.leftRadiusTextField, p.leftSphereRadius);
            writeTextField(parent.rightRadiusTextField, p.rightSphereRadius);
            p.setup();
        }
    }

    double checkRadius(double v, double r) {
        double sign = (v < 0) ? -1 : 1;
        v = Math.abs(v);
        v = Math.max(v, r);
        return v * sign;
    }

    void resetControls(Lens p) {
        if (p == null) {
            resetControlsCore(false, false, false, false);
        } else {
            resetControlsCore(true, p.symmetrical, p.leftHyp, p.rightHyp);
        }
    }

    void resetControlsCore(boolean global, boolean symmetrical, boolean leftHyp, boolean rightHyp) {
        String s;
        parent.symmCheckBox.setEnabled(global);
        parent.lensRadiusTextField.setEnabled(global);
        parent.userThicknessTextField.setEnabled(global);
        parent.leftRadiusTextField.setEnabled(global);
        parent.rightRadiusTextField.setEnabled(global && !symmetrical);
        parent.leftCFTextField.setEnabled(global && leftHyp);
        parent.rightCFTextField.setEnabled(global && rightHyp && !symmetrical);
        parent.leftHypCheckBox.setEnabled(global);
        parent.rightHypCheckBox.setEnabled(global && !symmetrical);
        parent.iorTextField.setEnabled(global);
        parent.dispersionTextField.setEnabled(global);
        parent.xPosTextField.setEnabled(global);
        parent.yPosTextField.setEnabled(global);
        if (!global) {
            s = "(Select a lens)";
            parent.lensRadiusTextField.setText(s);
            parent.userThicknessTextField.setText(s);
            parent.leftRadiusTextField.setText(s);
            parent.rightRadiusTextField.setText(s);
            parent.leftCFTextField.setText(s);
            parent.rightCFTextField.setText(s);
            parent.dispersionTextField.setText(s);
            parent.iorTextField.setText(s);
            parent.xPosTextField.setText(s);
            parent.yPosTextField.setText(s);
        } else {
            if (symmetrical) {
                s = "(Symmetrical)";
                parent.rightRadiusTextField.setText(s);
                parent.rightCFTextField.setText(s);

            } else {
                if (!rightHyp) {
                    parent.rightCFTextField.setText("(Spherical)");
                }
            }
            if (!leftHyp) {
                parent.leftCFTextField.setText("(Spherical)");
            }
        }

    }

    void writeCheckBox(JCheckBox cb, boolean v) {
        cb.setSelected(v);
    }

    boolean readCheckBox(JCheckBox cb) {
        return cb.isSelected();
    }

    void writeTextField(JTextField tf, double v) {
        tf.setText(parent.formatNum(v));
    }

    double readTextField(JTextField tf, double v) {
        try {
            v = parent.getDouble(tf.getText());
        } catch (Exception e) {
            //System.out.println(getClass().getName() + ": Error: " + e);
        }
        return v;
    }
}
