Minutes from 103rd OpenVDB TSC meeting, August 31st, 2021, (EDT)

Attendees: *Ken* M., *Dan* B., *Nick* A., *Jeff* L., *Andre* P.

Additional Attendees: JT Nelson (Blender), Richard Jones (DNeg),

Regrets: None 
Agenda:

1) Confirm Quorum
2) Secretary
3) Multiresolution grid
4) NanoVDB
5) Root-node offsets
6) OpenVDB Version
7) Explicit Template Instantiation
8) Next Meeting

1) Confirm Quorum 

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Multiresolution grid

Ken mentions the meeting with the Autodesk' Bifrost team to follow up on the
SIGGRAPH chat they had during the Volumes Q+A session. They are interested to
collaborate. Ken suggested them to submit suggested PRs and to produce a
write-up so that the OpenVDB project will be better-informed of their proposal.
The Bifrost team has an adaptive data structure. They also expressed an interest
to include a GPU-friendly version of it. One concrete idea mentioned is a
conversion tool from the adaptive grid data structure to OpenVDB.

We talk about the implications and the details if such a collaboration
exists. Nick mentions the concern about the amount of work that is associated
with this addition to the OpenVDB project. Ken mentions that if this goes through
he wants the new grid to be in the same file format as the current OpenVDB file
format. Ken also mentions the need to have a more cohesive ecosystem with the
rest of the OpenVDB project. 

Jeff mentions that it will be good for the Bifrost team to start attending the TSC
meeting. Ken mentions that he sees the two projects as being complimentary. Jeff
mentions how he sees it as another tool, more specifically a multi-resolution grid
that presumably needs its own primitive in Houdini. Since the resolution is adaptive,
it does not have a single resolution, which forces the API to be different from the
OpenVDB API. Jeff reiterates the need for a converter and read-write capabilities. Ken
mentions the need to do a timing comparison between the Bifrost's multiresolution
grid and the OpenVDB's LOD-multiresolution grid.

4) NanoVDB

Ken says that there are a few minor changes, but it is ready for code review and
discussions. Dan sent a reply to the build questions that Andre sent through
an email. Ken asks if we want to get rid of the GNU-make build system. Dan says
that we want to get rid of that. Nick mentions that if we don't do that, then
we need to support two different build systems.

5) Root-node offsets

The root node is changing. The internal node that is one level below the root node
is also changing. This means that the IO for OpenVDB needs to change. We want to
support old files without the offsets. The question is: do we want to be able to
write files that have offsets baked-in directly, which means that it won't be able
to be read by older versions? The answer is no. Jeff would like to be auto-convert
before doing a write and before the read. Dan and Ken mention that it may be wise to
add read-support for a grid with root-node offsets long before adding writing
capabilities.

Ken thinks about the internal nodes below the root node, because there are 32^3 of
them associated with a root node. The lowest level of internal node and the leaf nodes
is not changing. Ken said that he has more improvement. 

Nick asks how will this change affect delayed-loading? Dan and Ken say that since
delayed-loading only works at the leaf-node level, then it does not change
delayed-loading.

Ken has prototyped an implementation that is related to tree-traversal, but
not IO.

6) OpenVDB Version

Jeff mentions that he needs Version 9 ABI by September 20, 2021.
Houdini 19 needs to be compatible with OpenVDB 8.x.

7) Explicit Template Instantiation

Dan talks about the explicit template instantiation. Dan gives an overview of it.
His initial draft-PR by adding a lot of .cc files, i.e. moving a lot of the
implementations/definitions to .cc files. He is steering away from that proposal.
We will have the same header files, but adding template instantiations
at the end of the header files. CMake will then auto-generate the .cc files. 
This feature is only supported for build system that uses CMake. There is an
explicit-instantiation version and a suppression portion, which uses extern template
class.

Ken mentions that he mentioned this to TAC and Kimball Thurston mentioned that he
has a lot of experience with doing a similar task. Dan will reach out to Ken about
it.

He explains the requirement of what he's trying to tackle. He feels that it is
quite a significant change to the way that we are building the library, so he
hopes to get it to OpenVDB 9. Dan hopes that this will be the default for
building the library. Dan thinks that this change does not change ABI, but that
it will fit more naturally for a major release. Nick says that if it doesn't
fundamentally change the ABI, then there is no need to get it released in
version 9 if it is not ready by the deadline.

Ken points out that explicit template instantiation won't be done with NanoVDB
because it is header-only and does not have a long compile time.

Nick asks if the explicit option is on, then you can still define your own
custom types. Dan says that he's working on that. There are two ways of doing
that: (a) building the core library yourself and adding those types to the
cmake, so it makes more instantiation (which will make the library bigger, but
any library built against that doesn't need to regenerate those types); and
(b) you don't compile those types into the core library and you enable it for
the types you are using.

Dan thinks that the most important place to introduce this is in the tree data
structure: the tree, the root nodes, the leafs, etc. However, it can also be
introduced in all the tools, which Dan suspects will give the most compile time
improvement. Dan thinks that if we have a mechanism that we are happy with,
then we can improve upon it. Dan will start to work on the tree and grid first
before moving to tools.

Jeff is excited about this because it can remove duplicate copies of the same
exact code in multiple object files.

Dan has two variables: OPENVDB_EXPLICIT and OPENVDB_SUPPRESS. OPENVDB_EXPLICIT
will create a template-class and will instantiate that template class. If
OPENVDB_EXPLICIT is not defined, then it will define OPENVDB_SUPPRESS that will
suppress instantiation of all of the types: it will create extern template
declaration for each of those types that are baked into the core
library.

Dan says that it doesn't change client code because we will build the suppression
to the auto-generated header files.

Dan wants us to take a look at PR-1153.

8) Next Meeting

Next meeting is September 7th, 2021. 12pm-1pm EST (GMT-5).