##############################################################################
#
#  phpMyAdmin 'server_databases.php' Remote Command Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/17
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0252
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900130);
 script_cve_id("CVE-2008-4096");
 script_bugtraq_id(31188);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"6.0");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("phpMyAdmin 'server_databases.php' Remote Command Execution Vulnerability");
 script_summary("Check for vulnerable version of phpMyAdmin");
 desc = "
 Overview : phpMyAdmin is prone to Remote Command Execution vulnerability.

 Vulnerability Insight :

        This issue is caused by, sort_by parameter in server_databases.php
        which is not properly sanitised before being used.

        Impact : Successful exploitation allows execution of arbitrary 
        commands, and possibly compromise the affected application.

 Impact Level : Application

 Affected Software/OS :
        phpMyAdmin versions prior to 2.11.9.1 on all platform
 
 Fix : Upgrade to phpMyAdmin 2.11.9.1 or newer
 http://www.phpmyadmin.net/home_page/downloads.php#2.11.9.1

 References :
 http://comments.gmane.org/gmane.comp.security.oss.general/947?set_lines=100000
 http://fd.the-wildcat.de/pma_e36a091q11.php
 http://www.phpmyadmin.net/home_page/security.php?issue=PMASA-2008-7
 http://www.securityfocus.com/bid/31188/exploit

 CVSS Score :
        CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
        CVSS Temporal Score : 4.7 
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
 exit(0);
}


 include("http_func.inc");
 
 if(egrep(pattern:"^([01]\..*|2\.(([0-9]|10)(\..*)|11\.([0-8](\..*)?|9\.0)))",
                   string:get_kb_item("www/" + port + "/phpMyAdmin"))){
        security_hole(0);
 }
