###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_info_disc_vuln_feb10_lin.nasl 7335 2010-02-19 16:21:47Z feb $
#
# Opera Information Disclosure Vulnerability - (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902123);
  script_version("$Revision: 7618 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0653");
  script_name("Opera Information Disclosure Vulnerability - (Linux)");
  desc = "
  Overview: The host is installed with Opera Web Browser and is prone to
  Information Disclosure vulnerability.

  Vulnerability Insight:
  - Opera permits cross-origin loading of CSS stylesheets even when the
    stylesheet download has an incorrect MIME type and the stylesheet document
    is malformed.

  Impact:
  Successful exploitation will allow remote attackers to obtain sensitive
  information via a crafted document.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 10.50b1 on Linux.

  Fix: No solution/patch is available as on 19th February, 2010. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.opera.com/download/?custom=yes

  References:
  http://en.securitylab.ru/nvd/390938.php
  http://code.google.com/p/chromium/issues/detail?id=9877

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(!operaVer){
  exit(0);
}

# Check if version is lesser than 10.50b1 => (10.50)
if(version_is_less_equal(version:operaVer, test_version:"10.50")){
  security_warning(0);
}
