###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for cups, cupsys vulnerabilities USN-906-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840396);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "906-1");
  script_cve_id("CVE-2009-3553", "CVE-2010-0302", "CVE-2010-0393");
  script_name("Ubuntu Update for cups, cupsys vulnerabilities USN-906-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the CUPS scheduler did not properly handle certain
  network operations. A remote attacker could exploit this flaw and cause the
  CUPS server to crash, resulting in a denial of service. This issue only
  affected Ubuntu 8.04 LTS, 8.10, 9.04 and 9.10. (CVE-2009-3553,
  CVE-2010-0302)
  
  Ronald Volgers discovered that the CUPS lppasswd tool could be made to load
  localized message strings from arbitrary files by setting an environment
  variable. A local attacker could exploit this with a format-string
  vulnerability leading to a root privilege escalation. The default compiler
  options for Ubuntu 8.10, 9.04 and 9.10 should reduce this vulnerability to
  a denial of service. (CVE-2010-0393)

  Affected Software/OS:
  cups, cupsys vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-March/001054.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cups, cupsys vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"cups-bsd", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-client", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-dbg", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-common", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.9-17ubuntu3.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-client", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2-gnutls10", ver:"1.2.2-0ubuntu0.6.06.17", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"cups-bsd", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-client", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-dbg", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-common", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.9-2ubuntu9.5", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.7-1ubuntu3.8", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"cups-bsd", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-client", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-dbg", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcups2", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupscgi1-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupscgi1", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsdriver1-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsdriver1", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsmime1-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsmime1", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsppdc1-dev", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcupsppdc1", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-ppdc", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cups-common", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsddk", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-client", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys-common", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cupsys", ver:"1.4.1-5ubuntu2.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}