###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for sort HPSBUX00237
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835051);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00237");
  script_name( "HP-UX Update for sort HPSBUX00237");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  sort. The vulnerability could be exploited to allow remote unauthorized 
  access or a Denial of Service (DoS) 

  Impact:
  Remote unauthorized access
  Denial of Service (DoS)

  Affected Software/OS:
  sort on
  HP9000 Series 700/800 running HP-UX HP-UX B.10.01, B.10.10, B.10.20, 
  B.11.04, B.11.11 only. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00965470-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sort");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.01")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_28142'], rls:"HPUX10.01"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_27940'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_27565'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_28467'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_27564'], rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.UX-CORE", patch_list:['PHCO_25918'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}