###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_mult_dos_vuln_aug09_lin.nasl 3759 2009-08-05 13:53:34Z aug $
#
# Adobe Flash Player/Air Multiple DoS Vulnerabilities - Aug09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800854);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1863", "CVE-2009-1864", "CVE-2009-1865", "CVE-2009-1866",
                "CVE-2009-1867", "CVE-2009-1868", "CVE-2009-1869", "CVE-2009-1870");
  script_bugtraq_id(35900, 35904, 35906, 35901, 35905, 35902, 35907, 35908);
  script_name("Adobe Flash Player/Air Multiple DoS Vulnerabilities - Aug09 (Linux)");
  desc = "

  Overview: This host is installed with Adobe Flash Player/Air and is prone to
  multiple Denial of Service vulnerabilities.

  Vulnerability Insight:
  Multiple vulnerabilities which can be to exploited to cause memory
  corruption, null pointer, privilege escalation, heap-based buffer overflow,
  local sandbox bypass, and input validation errors when processing specially
  crafted web pages.

  Impact:
  Successful exploitation will let the remote attackers to execute arbitrary code,
  gain elevated privileges, gain knowledge of certain information and conduct
  clickjacking attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Adobe AIR version prior to 1.5.2
  Adobe Flash Player 9 version prior to 9.0.246.0
  Adobe Flash Player 10 version prior to 10.0.32.18 on Linux.

  Fix: Update to Adobe Air 1.5.2 or Adobe Flash Player 9.0.246.0 or 10.0.32.18
  http://get.adobe.com/air
  http://www.adobe.com/support/flashplayer/downloads.html

  References:
  http://secunia.com/advisories/35948/
  http://www.vupen.com/english/advisories/2009/2086
  http://www.adobe.com/support/security/bulletins/apsb09-10.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player/Air");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_adobe_flash_player_detect_lin.nasl");
  script_require_keys("AdobeFlashPlayer/Linux/Ver", "Adobe/Air/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Check for Adobe Flash Player
playerVer = get_kb_item("AdobeFlashPlayer/Linux/Ver");
if(playerVer != NULL)
{
  # Grep for version < 9.0.246.0 or 10.x < 10.0.32.18
  if(version_is_less(version:playerVer, test_version:"9.0.246.0") ||
     version_in_range(version:playerVer, test_version:"10.0",
                                        test_version2:"10.0.32.17"))
  {
    security_hole(0);
    exit(0);
  }
}

# Check for Adobe Air
airVer = get_kb_item("Adobe/Air/Linux/Ver");
if(airVer != NULL)
{
  # Grep for version < 1.5.2
  if(version_is_less(version:airVer, test_version:"1.5.2")){
    security_hole(0);
  }
}
