#
#VID 96ba2dae-4ab0-11d8-96f2-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52530);
 script_cve_id("CVE-2003-0989", "CVE-2003-1029", "CVE-2004-0057");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: tcpdump";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: tcpdump

CVE-2003-0989
tcpdump before 3.8.1 allows remote attackers to cause a denial of
service (infinite loop) via certain ISAKMP packets, a different
vulnerability than CVE-2004-0057.

CVE-2003-1029
The L2TP protocol parser in tcpdump 3.8.1 and earlier allows remote
attackers to cause a denial of service (infinite loop and memory
consumption) via a packet with invalid data to UDP port 1701, which
causes l2tp_avp_print to use a bad length value when calling
print_octets.

CVE-2004-0057
The rawprint function in the ISAKMP decoding routines (print-isakmp.c)
for tcpdump 3.8.1 and earlier allows remote attackers to cause a
denial of service (segmentation fault) via malformed ISAKMP packets
that cause invalid 'len' or 'loc' values to be used in a loop, a
different vulnerability than CVE-2003-0989.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.tcpdump.org/lists/workers/2003/12/msg00083.html
http://marc.theaimsgroup.com/?l=tcpdump-workers&m=107325073018070&w=2
http://www.vuxml.org/freebsd/96ba2dae-4ab0-11d8-96f2-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: tcpdump";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"tcpdump");
if(!isnull(bver) && revcomp(a:bver, b:"3.8.1_351")<0) {
    security_note(0, data:"Package tcpdump version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
