# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 554-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53242);
 script_bugtraq_id(11262);
 script_cve_id("CVE-2004-0833");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 554-1 (sendmail)";
 script_name(name);

 desc = "The remote host is missing an update to sendmail
announced via advisory DSA 554-1.

Hugo Espuny discovered a problem in sendmail, a commonly used program
to deliver electronic mail.  When installing sasl-bin to use sasl in
connection with sendmail, the sendmail configuration script use fixed
user/pass information to initialise the sasl database.  Any spammer
with Debian systems knowledge could utilise such a sendmail
installation to relay spam.

For the stable distribution (woody) this problem has been fixed in
version 8.12.3-7.1.

For the unstable distribution (sid) this problem has been fixed in
version 8.13.1-13.

We recommend that you upgrade your sendmail package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20554-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 554-1 (sendmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sendmail-doc", ver:"8.12.3-7.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmilter-dev", ver:"8.12.3-7.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sendmail", ver:"8.12.3-7.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
