# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1821-1 (amule)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64309);
 script_cve_id("CVE-2009-1440");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1821-1 (amule)";
 script_name(name);

 desc = "The remote host is missing an update to amule
announced via advisory DSA 1821-1.


Sam Hocevar discovered that amule, a client for the eD2k and Kad
networks, does not properly sanitise the filename, when using the
preview function. This could lead to the injection of arbitrary commands
passed to the video player.

For the stable distribution (lenny), this problem has been fixed in
version 2.2.1-1+lenny2.

The oldstable distribution (etch) is not affected by this issue.

For the testing distribution (squeeze) this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2.2.5-1.1.


We recommend that you upgrade your amule packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201821-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1821-1 (amule)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"amule-common", ver:"2.2.1-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"amule-utils", ver:"2.2.1-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"amule-utils-gui", ver:"2.2.1-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"amule-daemon", ver:"2.2.1-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"amule", ver:"2.2.1-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
